      REM:  QBWINFNT.BAS, Unregistered Version 1.0
      REM:  Routines to use windows fonts in DOS QBasic/QuickBasic.

      DECLARE FUNCTION WidthString% (Text$, FontArray%())
     
      DECLARE SUB BLOADFont (FlName$, FontArray%(), RetCode%)
      DECLARE SUB BSAVEFont (FlName$, FontArray%())
      DECLARE SUB DispChar (Char%, FClr%, BClr%, X%, Y%, FontArray%())
      DECLARE SUB DispString (Text$, FClr%, BClr%, X%, Y%, FontArray%())
      DECLARE SUB FastChar (Char%, FClr%, X%, Y%, FontArray%())
      DECLARE SUB FastString (Text$, FClr%, X%, Y%, FontArray%())
      DECLARE SUB LoadFontFile (FlName$, FontArray%(), RetCode%, RetMsg$)
      DECLARE SUB LoadRsrcFileFont (FlName$, FontNum%, FontArray%(), RetCode%, RetMsg$)

      CONST NumHdrElem = 11            '...number of elements in font header
    
      TYPE FontType
        Version        AS INTEGER      '...version
        Size           AS LONG         '...size of font in bytes
        Copyright      AS STRING * 60  '...copyright string
        FType          AS INTEGER      '...font type
        Pnt            AS INTEGER      '...point size for optimum display
        VertRes        AS INTEGER      '...vertical resolution in pixels per inch
        HorizRes       AS INTEGER      '...horizontal resolution in pixels per inch
        Ascent         AS INTEGER      '...distance from top of char cell to baseline
        IntLeading     AS INTEGER      '...distance above tops of char's to top of cell
        ExtLeading     AS INTEGER      '...recommended distance above top of cell
        Italic         AS STRING * 1   '...italic font if equal to 1
        Underline      AS STRING * 1   '...underlined font if equal to 1
        StrikeOut      AS STRING * 1   '...strike-out font if equal to 1
        Weight         AS INTEGER      '...relative weight
        CharSet        AS STRING * 1   '...character set
        PixWidth       AS INTEGER      '...width of character grid in pixels
        PixHeight      AS INTEGER      '...height of character grid in pixels
        PitchandFamily AS STRING * 1   '...description of pitch and family
        AvgWidth       AS INTEGER      '...average width
        MaxWidth       AS INTEGER      '...width of widest character
        FirstChar      AS STRING * 1   '...ASCII value of first char
        LastChar       AS STRING * 1   '...ASCII value of last char
        DefaultChar    AS STRING * 1   '...relative char value for out of range chars
        BreakChar      AS STRING * 1   '...relative char value for word seperator char
        WidthBytes     AS INTEGER      '...number of bytes in each row
        Device         AS LONG         '...offset in bytes to font's device name string
        Face           AS LONG         '...offset in bytes to face name
        BitsPointer    AS LONG         '...unused and set to zero
        BitsOffset     AS LONG         '...offset in bytes to start of bitmap or stroke data
        Reserved1      AS STRING * 1   '...reserved
      END TYPE

      TYPE ExeHdrType
        Signature      AS STRING * 2   '...MZ for valid EXE code file
        ExtraBytes     AS INTEGER      '...number bytes in last page
        Pages          AS INTEGER      '...number whole & partial pages (512 bytes)
        RelocItems     AS INTEGER      '...number relocation table pointers
        HeaderSize     AS INTEGER      '...number 16 byte paragraphs in header
        UnusedHere     AS STRING * 50  '...values not needed by this program
        WinInfoOffset  AS INTEGER      '...offset in bytes to WinInfo structure
      END TYPE
    
      TYPE WinInfoType
        Signature      AS STRING * 2   '...NE if valid
        UnusedHere1    AS STRING * 34  '...values not needed by this program
        ResTabOffset   AS INTEGER      '...offset to resource table (in bytes relative to WinInfo)
        UnusedHere2    AS STRING * 26  '...values not needed by this program
      END TYPE
 
      TYPE ResInfoType
        TypeID         AS INTEGER      '...resource type
        ResCount       AS INTEGER      '...number of resources of this type
        Reserved       AS LONG         '...unused
      END TYPE

      TYPE NameInfoType
        Offset         AS INTEGER      '...offset in alignment units
        Length         AS INTEGER      '...length in bytes of resource
        Flags          AS INTEGER      '...resource flags
        ID             AS INTEGER      '...identifier
        Reserved1      AS INTEGER      '...unused or reserved
        Reserved2      AS INTEGER      '...unused or reserved
      END TYPE
    
      TYPE GlyphType
        PWidth         AS INTEGER      '...character width in pixels
        Offset         AS INTEGER      '...offset to character bitmap
      END TYPE


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' FONT Structure:
'     Font Height  --  0  --  2 bytes  -- Char height in pixels
'     Number Chars --  1  --  2 bytes  -- Total number of characters
'     First Char   --  2  --  2 bytes  -- First character in set
'     Last Char    --  3  --  2 bytes  -- Last character in set
'     Default Char --  4  --  2 bytes  -- Default character
'     Break Char   --  5  --  2 bytes  -- Break character
'     Max Width    --  6  --  2 bytes  -- Max char width
'     Vert Spacing --  7  --  2 bytes  -- Vertical spacing
'     Ascent       --  8  --  2 bytes  -- Distance from char top to baseline
'     Pad Width    --  9  --  2 bytes  -- Extra pixels to add between chars
'     Pad Height   -- 10  --  2 bytes  -- Extra pixels to add between lines
'     Char Width   --  2 bytes/char    -- Char width in pixels
'     Char Offset  --  2 bytes/char    -- Char offset into bitmap
'
' Notes: (1) The total number of characters N = LastChar - FirstChar + 1
'        (2) Char width consists of 2 bytes per character.  The width of
'            a given character c% is given by: FontArray%(10+c%)
'        (3) Char offset consists of 2 bytes per character.  The offset of
'            a given character c% is given by: FontArray%(10+N+c%)
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'     ************************************************************************
      SUB BLOADFont (FlName$, FontArray%(), RetCode%)
'     ************************************************************************
     
      '...be nice - use the next available file number...
      FileNum% = FREEFILE
     
      '...open file for binary, get size, and close...
      OPEN FlName$ FOR BINARY AS FileNum%
        SizeInBytes& = LOF(FileNum%)
      CLOSE FileNum%
     
      '...size is zero if the file doesn't exist...
      IF (SizeInBytes& = 0) THEN RetCode% = -1: RETURN

      '...subtract 7 bytes of the BSAVE/BLOAD header...
      SizeInBytes& = SizeInBytes& - 7

      '...redimension the font array (2 bytes per integer element)...
      REDIM FontArray%((SizeInBytes& - 1) \ 2)
     
      '...set to segment of the font array...
      DEF SEG = VARSEG(FontArray%(0))

      '...save the array to a file...
      BLOAD FlName$, VARPTR(FontArray%(0))

      '...restore default segment...
      DEF SEG

      '...clear the return code for everything OK...
      RetCode% = 0

      END SUB

'     ************************************************************************
      SUB BSAVEFont (FlName$, FontArray%())
'     ************************************************************************
     
      '...compute the number of bytes to save...
      NumBytes& = 2& * (UBOUND(FontArray%) - LBOUND(FontArray%) + 1)

      '...set to segment of the font array...
      DEF SEG = VARSEG(FontArray%(0))

      '...save the array to a file...
      BSAVE FlName$, VARPTR(FontArray%(0)), NumBytes&

      '...restore default segment...
      DEF SEG
     
      END SUB

'     ************************************************************************
      SUB DispChar (Char%, FClr%, BClr%, X%, Y%, FontArray%())
'     ************************************************************************
     
      CONST NumHdrElem = 11            '...number of elements in font header
     
      '...get the character number relative to the start char...
      RelChar% = Char% - FontArray%(2)

      '...get the number of characters in font array...
      NumChars% = FontArray%(1)

      '...if character is out of bounds, use the default char...
      IF ((Char% < FontArray%(2)) OR (Char% > FontArray%(3))) THEN RelChar% = FontArray%(4)
    
      '...get the pixel width of the character...
      PWidth% = FontArray%(NumHdrElem + RelChar%)
    
      '...get offset to the actual bitmap for the char...
      Ptr& = FontArray%(NumHdrElem + NumChars% + RelChar%)
   
      '...convert to unsigned integer...
      IF (Ptr& < 0) THEN Ptr& = 65536 + Ptr&

      '...now that sign is OK, add offset of start of array...
      Ptr& = Ptr& + VARPTR(FontArray%(0))

      '...compute number of bytes in each row of character's definition...
      BytesPerRow% = 1 + (PWidth% - 1) \ 8

      '...set the current x location, then we can just increment it...
      XLocn% = X%
   
      '...loop over number of bytes per row in character...
      FOR j% = 1 TO BytesPerRow%
 
        '...set the y location...
        YLocn% = Y%

        '...set the row length (needed for background)...
        IF (j% < BytesPerRow%) THEN
          RowLength% = 7
        ELSE
          RowLength% = (PWidth% - 1) MOD 8
        END IF

        '...loop over height (number of rows) of the character...
        FOR i% = 1 TO FontArray%(0)

          '...pull the current byte definition...
          DEF SEG = VARSEG(FontArray%(0)): Pattern% = PEEK(Ptr&): DEF SEG

          '...shift the current row pattern into upper byte of integer...
          '...simply multiplying by 256 won't work because of overflow...
          Pattern% = CVI(CHR$(0) + CHR$(Pattern%))

          '...draw the character background - NOT the pattern...
          IF (BClr% > 0) THEN
            LINE (XLocn%, YLocn%)-STEP(RowLength%, 0), BClr%, , NOT Pattern%
          END IF

          '...draw row in char using line with the current pattern...
          IF (FClr% > 0) THEN
            LINE (XLocn%, YLocn%)-STEP(RowLength%, 0), FClr%, , Pattern%
          END IF
         
          '...advance pointer to the next byte of data...
          Ptr& = Ptr& + 1

          '...increment the y location...
          YLocn% = YLocn% + 1

        NEXT i%

        '...increment the x location by a byte...
        XLocn% = XLocn% + 8

      NEXT j%
     
      '...leave X% pointing to the start of the next character...
      '...add the width of the character displayed + padding width...
      X% = X% + PWidth% + FontArray%(9)
  
      END SUB

'     ************************************************************************
      SUB DispString (Text$, FClr%, BClr%, X%, Y%, FontArray%())
'     ************************************************************************

      CONST NumHdrElem = 11            '...number of elements in font header

      '...save x coord in temp variable for incrementing...
      XChar% = X%
     
      '...get the number of characters in font array...
      NumChars% = FontArray%(1)

      '...get the font height into a scalar...
      FontHeight% = FontArray%(0)
     
      '...loop through all the characters in the string...
      FOR k% = 1 TO LEN(Text$)
  
        '...get the character number relative to the start char...
        RelChar% = ASC(MID$(Text$, k%, 1)) - FontArray%(2)

        '...if character is out of bounds, use the default char...
        IF ((RelChar% < 0) OR (RelChar% > NumChars% - 1)) THEN RelChar% = FontArray%(4)
       
        '...get the pixel width of the character...
        PWidth% = FontArray%(NumHdrElem + RelChar%)

        '...set offset to the actual bitmap for the char...
        Ptr& = FontArray%(NumHdrElem + NumChars% + RelChar%)
       
        '...convert to unsigned integer...
        IF (Ptr& < 0) THEN Ptr& = 65536 + Ptr&
       
        '...now that sign is OK, add offset of start of array...
        Ptr& = Ptr& + VARPTR(FontArray%(0))
       
        '...compute number of bytes in each row of character's definition...
        BytesPerRow% = 1 + (PWidth% - 1) \ 8

        '...set the current x location, then we can just increment it...
        XLocn% = XChar%

        '...loop over number of bytes per row in character...
        FOR j% = 1 TO BytesPerRow%

          '...set the y location...
          YLocn% = Y%
         
          '...set the row length (needed for background)...
          IF (j% < BytesPerRow%) THEN
            RowLength% = 7
          ELSE
            RowLength% = (PWidth% - 1) MOD 8
          END IF

          '...loop over height (number of rows) of the character...
          FOR i% = 1 TO FontHeight%

            '...pull the current byte definition...
            DEF SEG = VARSEG(FontArray%(0)): Pattern% = PEEK(Ptr&): DEF SEG
           
            '...shift the pattern into upper byte...
            Pattern% = CVI(CHR$(0) + CHR$(Pattern%))

            '...draw the character background - NOT the pattern...
            IF (BClr% > 0) THEN
              LINE (XLocn%, YLocn%)-STEP(RowLength%, 0), BClr%, , NOT Pattern%
            END IF
           
            '...draw row in char using line with the current pattern...
            IF (FClr% > 0) THEN
              LINE (XLocn%, YLocn%)-STEP(RowLength%, 0), FClr%, , Pattern%
            END IF
         
            '...advance pointer to the next byte of data...
            Ptr& = Ptr& + 1

            '...increment the y location...
            YLocn% = YLocn% + 1

          NEXT i%

          '...increment the x location by a byte...
          XLocn% = XLocn% + 8

        NEXT j%
   
        '...increment to the next char - width + any padding...
        XChar% = XChar% + PWidth% + FontArray%(9)
   
      NEXT k%

      '...leave X% pointing to the start of the next character...
      X% = XChar%
  
      END SUB

'     ************************************************************************
      SUB FastChar (Char%, FClr%, X%, Y%, FontArray%())
'     ************************************************************************

      CONST NumHdrElem = 11            '...number of elements in font header

      '...get the character number relative to the start char...
      RelChar% = Char% - FontArray%(2)

      '...get the number of characters in font array...
      NumChars% = FontArray%(1)
     
      '...if character is out of bounds, use the default char...
      IF ((Char% < FontArray%(2)) OR (Char% > FontArray%(3))) THEN RelChar% = FontArray%(4)
     
      '...get the pixel width of the character...
      PWidth% = FontArray%(NumHdrElem + RelChar%)
   
      '...set offset to the actual bitmap for the char...
      Ptr& = FontArray%(NumHdrElem + NumChars% + RelChar%)
       
      '...convert to unsigned integer...
      IF (Ptr& < 0) THEN Ptr& = 65536 + Ptr&
     
      '...now that sign is OK, add offset of start of array...
      Ptr& = Ptr& + VARPTR(FontArray%(0))
     
      '...compute number of bytes in each row of character's definition...
      BytesPerRow% = 1 + (PWidth% - 1) \ 8

      '...set the current x location, then we can just increment it...
      '...we'll start a byte left of character so pattern is in posn...
      XLocn% = X% - 8
  
      '...set segment to font data for peek below...
      DEF SEG = VARSEG(FontArray%(0))
     
      '...loop over number of bytes per row in character...
      FOR j% = 1 TO BytesPerRow%

        '...set the y location...
        YLocn% = Y%
       
        '...loop over height (number of rows) of the character...
        FOR i% = 1 TO FontArray%(0)

          '...draw row in char using line with the current pattern...
          LINE (XLocn%, YLocn%)-STEP(15, 0), FClr%, , PEEK(Ptr&)
         
          '...advance pointer to the next byte of data...
          Ptr& = Ptr& + 1

          '...increment the y location...
          YLocn% = YLocn% + 1

        NEXT i%

        '...increment the x location by a byte...
        XLocn% = XLocn% + 8

      NEXT j%

      '...restore default data segment...
      DEF SEG
    
      '...leave X% pointing to the start of the next character...
      '...add the width of the character displayed + padding width...
      X% = X% + PWidth% + FontArray%(9)
     
      END SUB

'     ************************************************************************
      SUB FastString (Text$, FClr%, X%, Y%, FontArray%())
'     ************************************************************************

      CONST NumHdrElem = 11            '...number of elements in font header

      '...save x coord in temp variable for incrementing...
      XChar% = X%
    
      '...get the number of characters in font array...
      NumChars% = FontArray%(1)

      '...get the font height into a scalar...
      FontHeight% = FontArray%(0)
    
      '...set segment to font data for peek below...
      DEF SEG = VARSEG(FontArray%(0))
     
      '...loop through all the characters in the string...
      FOR k% = 1 TO LEN(Text$)
 
        '...get the character number relative to the start char...
        RelChar% = ASC(MID$(Text$, k%, 1)) - FontArray%(2)

        '...if character is out of bounds, use the default char...
        IF ((RelChar% < 0) OR (RelChar% > NumChars% - 1)) THEN RelChar% = FontArray%(4)
       
        '...get the pixel width of the character...
        PWidth% = FontArray%(NumHdrElem + RelChar%)
  
        '...set pointer to the actual bitmap for the char...
        Ptr& = FontArray%(NumHdrElem + NumChars% + RelChar%)
      
        '...convert to unsigned integer...
        IF (Ptr& < 0) THEN Ptr& = 65536 + Ptr&
     
        '...now that sign is OK, add offset of start of array...
        Ptr& = Ptr& + VARPTR(FontArray%(0))

        '...compute number of bytes in each row of character's definition...
        BytesPerRow% = 1 + (PWidth% - 1) \ 8

        '...set the current x location, then we can just increment it...
        XLocn% = XChar% - 8

        '...loop over number of bytes per row in character...
        FOR j% = 1 TO BytesPerRow%

          '...set the y location...
          YLocn% = Y%
        
          '...loop over height (number of rows) of the character...
          FOR i% = 1 TO FontHeight%

            '...draw row in char using line with the current pattern...
            LINE (XLocn%, YLocn%)-STEP(15, 0), FClr%, , PEEK(Ptr&)
           
            '...advance pointer to the next byte of data...
            Ptr& = Ptr& + 1

            '...increment the y location...
            YLocn% = YLocn% + 1

          NEXT i%

          '...increment the x location by a byte...
          XLocn% = XLocn% + 8

        NEXT j%
  
        '...increment to the next char - width + any padding...
        XChar% = XChar% + PWidth% + FontArray%(9)
  
      NEXT k%
     
      '...restore default data segment...
      DEF SEG

      '...leave X% pointing to the start of the next character...
      X% = XChar%

      END SUB

'     ************************************************************************
      SUB LoadFontFile (FlName$, FontArray%(), RetCode%, RetMsg$)
'     ************************************************************************
     
      CONST NumHdrElem = 11            '...number of elements in font header
     
      DIM FontEntry AS FontType
     
      '...clear the return code and error message...
      RetCode% = 0: RetMsg$ = ""
     
      '...be nice - use the next available file number...
      FileNum% = FREEFILE

      '...open file for binary input using supplied filename...
      OPEN FlName$ FOR BINARY AS FileNum%
 
      '...file has to be at least big enough to hold font header...
      IF (LOF(FileNum%) < 118) THEN
        RetCode% = 1
        RetMsg$ = "Invalid font file, file too short or not present"
        GOTO FlErrExit
      END IF

'     ...set the file pointer and offset to the start of the file...
      FilePtr& = 1: FOffset& = 1

      '...get the font resource...
      GET FileNum%, FilePtr&, FontEntry

      '...convert these to integers, we use them a lot...
      FirstChar% = ASC(FontEntry.FirstChar)
      LastChar% = ASC(FontEntry.LastChar)

      '...check for bad values of first/char char...
      IF (LastChar% < FirstChar%) THEN
        RetCode% = 5
        RetMsg$ = "Bad value of first and/or last font character."
        GOTO FlErrExit
      END IF
    
      '...compute the number of characters...
      NumChars% = LastChar% - FirstChar% + 1

      '...calculate number of glyph structures...
      NumGlyphs% = LastChar% - FirstChar% + 2

      REDIM Glyph(0 TO NumGlyphs% - 1) AS GlyphType
    
      '...read in the glyph data...
      FOR i% = 0 TO NumGlyphs% - 1
        GET FileNum%, , Glyph(i%)
      NEXT i%

      '...check for desired font a vector font...
      IF (FontEntry.FType AND 1) THEN
        RetCode% = 6
        RetMsg$ = "Font is a vector font, not a bitmap font."
        GOTO FlErrExit
      END IF
    
      '...don't support version 3 bitmaps (size > 64k)...
      IF (FontEntry.Version >= &H300) THEN
        RetCode% = 7
        RetMsg$ = "Font is version number 3, not supported."
        GOTO FlErrExit
      END IF
    
      '...calculate the number of bytes needed for font...
      NumBytes& = FontEntry.Size - LEN(FontEntry)
    
      '...check for negative number of bytes or > 64K...
      IF ((NumBytes& < 0) OR (NumBytes& > 65536)) THEN
        RetCode% = 8
        RetMsg$ = "Number of bytes needed negative or greater than 64K."
        GOTO FlErrExit
      END IF

      '...add the numbe of bytes needed for font array header (the size...
      '...of font data from file already bytes for char width and offset)...
      NumBytes& = NumBytes& + 2& * NumHdrElem

      '...dimension array for font data...
      REDIM FontArray%((NumBytes& - 1) \ 2)
    
      '...store the character height in pixels...
      FontArray%(0) = FontEntry.PixHeight
   
      '...store the number of characters...
      FontArray%(1) = NumChars%

      '...store the first, last, default, and break characters...
      FontArray%(2) = FirstChar%
      FontArray%(3) = LastChar%
      FontArray%(4) = ASC(FontEntry.DefaultChar)
      FontArray%(5) = ASC(FontEntry.BreakChar)

      '...store the max character width...
      FontArray%(6) = FontEntry.MaxWidth

      '...store the vertical spacing - for now set to char height...
      FontArray%(7) = FontEntry.PixHeight

      '...store char ascent (distance from top of char cell to baseline)...
      FontArray%(8) = FontEntry.Ascent

      '...zero the pad width and pad height...
      FontArray%(9) = 0
      FontArray%(10) = 0

      '...calculate the offset of the bitmap data in FontArray%, it's...
      '...after the header, the char widths, and the char data offsets...
      BitmapDataPtr& = 2& * (NumHdrElem + 2& * NumChars%)
   
      '...compute adjustment if offset in moving from file to array...
      OffAdj& = BitmapDataPtr& - Glyph(0).Offset
    
      '...loop over all the characters...
      FOR i% = 0 TO NumChars% - 1
     
        '...store each of the character widths...
        FontArray%(NumHdrElem + i%) = Glyph(i%).PWidth
   
        '...set the offset to char bitmap...
        CharOffset& = Glyph(i%).Offset
      
        '...convert to unsigned integer...
        IF (CharOffset& < 0) THEN CharOffset& = 65536 + CharOffset&
      
        '...adjust for offset in moving from file to array...
        DestOffset& = CharOffset& + OffAdj&
      
        '...store as integer (if > 32,767, store as negative)...
        IF (DestOffset& > 32767) THEN DestOffset& = DestOffset& - 65536
      
        '...store each of the character offsets to bitmap data...
        FontArray%(NumHdrElem + NumChars% + i%) = DestOffset&

      NEXT i%

      '...set in file to start of the bitmap data for the font...
      SEEK FileNum%, Glyph(0).Offset + FOffset&
    
      '...fill remainder of array with bitmap data from the file...
      FOR i% = NumHdrElem + 2 * NumChars% TO UBOUND(FontArray%)
        GET FileNum%, , FontArray%(i%)
      NEXT i%

FlErrExit:

      '...close the file on the way out...
      CLOSE FileNum%
     
      END SUB

'     ************************************************************************
      SUB LoadRsrcFileFont (FlName$, FontNum%, FontArray%(), RetCode%, RetMsg$)
'     ************************************************************************
  
      CONST NumHdrElem = 11            '...number of elements in font header
     
      DIM ExeHdr AS ExeHdrType, WinInfo AS WinInfoType
      DIM ResInfo AS ResInfoType, NameInfo AS NameInfoType
      DIM FontEntry AS FontType
     
      '...clear the return code and error message...
      RetCode% = 0: RetMsg$ = ""
     
      '...be nice - use the next available file number...
      FileNum% = FREEFILE

      '...open file for binary input using supplied filename...
      OPEN FlName$ FOR BINARY AS FileNum%
  
      '...file has to be at least big enough to hold hdr and info block...
      IF (LOF(FileNum%) < LEN(ExeHdr) + LEN(WinInfo)) THEN
        RetCode% = 1
        RetMsg$ = "Invalid rsrc file, file too short or not present"
        GOTO ErrExit
      END IF
   
      '...get the executable header...
      GET FileNum%, 1, ExeHdr
    
      '...for valid rsrc files, the exehdr has signature "MZ"...
      IF (ExeHdr.Signature <> "MZ") THEN
        RetCode% = 2
        RetMsg$ = "Invalid rsrc file, ExeHdr signature (MZ) not present"
        GOTO ErrExit
      END IF

      '...using offset in executable header, pull the wininfo block...
      GET FileNum%, 1 + ExeHdr.WinInfoOffset, WinInfo
    
      '...for valid rsrc files, the win info blk has signature "NE"...
      IF (WinInfo.Signature <> "NE") THEN
        RetCode% = 3
        RetMsg$ = "Invalid rsrc file, WinInfo signature (NE) not present"
        GOTO ErrExit
      END IF
  
      '...initialize our font number counter...
      CurrFontNum% = 1
     
      '...compute the location of start of resource table...
      ResTable& = 1& + ExeHdr.WinInfoOffset + WinInfo.ResTabOffset
 
      '...read the alignment shift count (first item in resource table)...
      GET FileNum%, ResTable&, ResAlignShift%

      '...convert to something meaningful, i.e. alignment unit...
      AlignmentUnit& = 2& ^ ResAlignShift%

      '...keep count of the number of res types and file ptr...
      NumResTypes% = 0: FilePtr& = ResTable& + 2
 
      '...keep reading them until we hit a zero for end of list...
      DO
 
        '...read the next type...
        GET FileNum%, FilePtr&, ResInfo

        '...a zero in TypeID slot means reached end of list...
        IF (ResInfo.TypeID <> 0) THEN
   
          '...increment the number of res types and file pointer...
          NumResTypes% = NumResTypes% + 1
          FilePtr& = FilePtr& + LEN(ResInfo)

          '...loop over the count of this type of resource...
          FOR j% = 1 TO ResInfo.ResCount
     
            '...read in each of name info blocks (from where we left off)...
            GET FileNum%, FilePtr&, NameInfo

            '...increment the file pointer...
            FilePtr& = FilePtr& + LEN(NameInfo)
       
            '...set the location of start of resource data...
            Locn& = NameInfo.Offset * AlignmentUnit& + 1
           
            '...if this is a font resource RT_FONT, then check it...
            IF (ResInfo.TypeID = &H8008) THEN

              '...have we reached the desired font number...
              IF (CurrFontNum% = FontNum%) THEN GOTO LoadFont
             
              '...increment the current font number...
              CurrFontNum% = CurrFontNum% + 1

            END IF
         
          NEXT j%
       
        END IF

      LOOP UNTIL (ResInfo.TypeID = 0)

      '...if we reached here, we never found the desired font...
      RetCode% = 4
      RetMsg$ = "Desired font number (" + LTRIM$(STR$(FontNum%)) + ") not found"
      GOTO ErrExit

LoadFont:

'     ...set the file pointer to the start of the font resource data...
      FilePtr& = Locn&

      '...get the font resource...
      GET FileNum%, FilePtr&, FontEntry
 
      '...save the offset from start of file for this font...
      FOffset& = FilePtr&
 
      '...convert these to integers, we use them a lot...
      FirstChar% = ASC(FontEntry.FirstChar)
      LastChar% = ASC(FontEntry.LastChar)

      '...check for bad values of first/char char...
      IF (LastChar% < FirstChar%) THEN
        RetCode% = 5
        RetMsg$ = "Bad value of first and/or last font character."
        GOTO ErrExit
      END IF
     
      '...compute the number of characters...
      NumChars% = LastChar% - FirstChar% + 1

      '...calculate number of glyph structures...
      NumGlyphs% = LastChar% - FirstChar% + 2

      REDIM Glyph(0 TO NumGlyphs% - 1) AS GlyphType
     
      '...read in the glyph data...
      FOR i% = 0 TO NumGlyphs% - 1
        GET FileNum%, , Glyph(i%)
      NEXT i%

      '...increment the file pointer to next set...
      FilePtr& = FilePtr& + AlignmentUnit& * (1& + (FontEntry.Size - 1&) \ AlignmentUnit&)
       
      '...check for desired font a vector font...
      IF (FontEntry.FType AND 1) THEN
        RetCode% = 6
        RetMsg$ = "Desired font number is a vector font, not a bitmap font."
        GOTO ErrExit
      END IF
     
      '...don't support version 3 bitmaps (size > 64k)...
      IF (FontEntry.Version >= &H300) THEN
        RetCode% = 7
        RetMsg$ = "Desired font is version number 3, not supported."
        GOTO ErrExit
      END IF
     
      '...calculate the number of bytes needed for font...
      NumBytes& = FontEntry.Size - LEN(FontEntry)
     
      '...check for negative number of bytes or > 64K...
      IF ((NumBytes& < 0) OR (NumBytes& > 65536)) THEN
        RetCode% = 8
        RetMsg$ = "Number of bytes needed negative or greater than 64K."
        GOTO ErrExit
      END IF

      '...add the numbe of bytes needed for font array header (the size...
      '...of font data from file already bytes for char width and offset)...
      NumBytes& = NumBytes& + 2& * NumHdrElem

      '...dimension array for font data...
      REDIM FontArray%((NumBytes& - 1) \ 2)
     
      '...store the character height in pixels...
      FontArray%(0) = FontEntry.PixHeight
    
      '...store the number of characters...
      FontArray%(1) = NumChars%

      '...store the first, last, default, and break characters...
      FontArray%(2) = FirstChar%
      FontArray%(3) = LastChar%
      FontArray%(4) = ASC(FontEntry.DefaultChar)
      FontArray%(5) = ASC(FontEntry.BreakChar)

      '...store the max character width...
      FontArray%(6) = FontEntry.MaxWidth

      '...store the vertical spacing - for now set to char height...
      FontArray%(7) = FontEntry.PixHeight

      '...store char ascent (distance from top of char cell to baseline)...
      FontArray%(8) = FontEntry.Ascent

      '...zero the pad width and pad height...
      FontArray%(9) = 0
      FontArray%(10) = 0

      '...calculate the offset of the bitmap data in FontArray%, it's...
      '...after the header, the char widths, and the char data offsets...
      BitmapDataPtr& = 2& * (NumHdrElem + 2& * NumChars%)
    
      '...compute adjustment if offset in moving from file to array...
      OffAdj& = BitmapDataPtr& - Glyph(0).Offset
     
      '...loop over all the characters...
      FOR i% = 0 TO NumChars% - 1
      
        '...store each of the character widths...
        FontArray%(NumHdrElem + i%) = Glyph(i%).PWidth
    
        '...set the offset to char bitmap...
        CharOffset& = Glyph(i%).Offset
       
        '...convert to unsigned integer...
        IF (CharOffset& < 0) THEN CharOffset& = 65536 + CharOffset&
       
        '...adjust for offset in moving from file to array...
        DestOffset& = CharOffset& + OffAdj&
       
        '...store as integer (if > 32,767, store as negative)...
        IF (DestOffset& > 32767) THEN DestOffset& = DestOffset& - 65536
       
        '...store each of the character offsets to bitmap data...
        FontArray%(NumHdrElem + NumChars% + i%) = DestOffset&

      NEXT i%

      '...set in file to start of the bitmap data for the font...
      SEEK FileNum%, Glyph(0).Offset + FOffset&
     
      '...fill remainder of array with bitmap data from the file...
      FOR i% = NumHdrElem + 2 * NumChars% TO UBOUND(FontArray%)
        GET FileNum%, , FontArray%(i%)
      NEXT i%

ErrExit:

      '...close the file on the way out...
      CLOSE FileNum%
 
      END SUB

'     ************************************************************************
      FUNCTION WidthString% (Text$, FontArray%())
'     ************************************************************************

      '...initialize the width to zero...
      TotalWidth% = 0
   
      '...loop through all the characters in the string...
      FOR k% = 1 TO LEN(Text$)

        '...get the character number relative to the start char...
        RelChar% = ASC(MID$(Text$, k%, 1)) - FontArray%(2)

        '...increment the total width by the pixel width of the char...
        TotalWidth% = TotalWidth% + FontArray%(NumHdrElem + RelChar%)

      NEXT k%

      '...return the total width...
      WidthString% = TotalWidth%
 
      END FUNCTION

