      REM:  FNTSTRUC.BI, Unregistered Version 1.0
      REM:  Include file for QBWINFNT.BAS
     
      TYPE FontDirEntryType
        FontOrdinal    AS INTEGER      '...unique ordinal value identifying font
        Version        AS INTEGER      '...version
        Size           AS LONG         '...size of font in bytes
        Copyright      AS STRING * 60  '...copyright string
        FType          AS INTEGER      '...font type
        Pnt            AS INTEGER      '...point size for optimum display
        VertRes        AS INTEGER      '...vertical resolution in pixels per inch
        HorizRes       AS INTEGER      '...horizontal resolution in pixels per inch
        Ascent         AS INTEGER      '...distance from top of char cell to baseline
        IntLeading     AS INTEGER      '...distance above tops of char's to top of cell
        ExtLeading     AS INTEGER      '...recommended distance above top of cell
        Italic         AS STRING * 1   '...italic font if equal to 1
        Underline      AS STRING * 1   '...underlined font if equal to 1
        StrikeOut      AS STRING * 1   '...strike-out font if equal to 1
        Weight         AS INTEGER      '...relative weight
        CharSet        AS STRING * 1   '...character set
        PixWidth       AS INTEGER      '...width of character grid in pixels
        PixHeight      AS INTEGER      '...height of character grid in pixels
        PitchandFamily AS STRING * 1   '...description of pitch and family
        AvgWidth       AS INTEGER      '...average width
        MaxWidth       AS INTEGER      '...width of widest character
        FirstChar      AS STRING * 1   '...ASCII value of first char
        LastChar       AS STRING * 1   '...ASCII value of last char
        DefaultChar    AS STRING * 1   '...relative char value for out of range chars
        BreakChar      AS STRING * 1   '...relative char value for word seperator char
        WidthBytes     AS INTEGER      '...number of bytes in each row
        Device         AS LONG         '...offset in bytes to font's device name string
        Face           AS LONG         '...offset in bytes to face name
        Reserved       AS LONG         '...reserved
      END TYPE
     
      TYPE FontType
        Version        AS INTEGER      '...version
        Size           AS LONG         '...size of font in bytes
        Copyright      AS STRING * 60  '...copyright string
        FType          AS INTEGER      '...font type
        Pnt            AS INTEGER      '...point size for optimum display
        VertRes        AS INTEGER      '...vertical resolution in pixels per inch
        HorizRes       AS INTEGER      '...horizontal resolution in pixels per inch
        Ascent         AS INTEGER      '...distance from top of char cell to baseline
        IntLeading     AS INTEGER      '...distance above tops of char's to top of cell
        ExtLeading     AS INTEGER      '...recommended distance above top of cell
        Italic         AS STRING * 1   '...italic font if equal to 1
        Underline      AS STRING * 1   '...underlined font if equal to 1
        StrikeOut      AS STRING * 1   '...strike-out font if equal to 1
        Weight         AS INTEGER      '...relative weight
        CharSet        AS STRING * 1   '...character set
        PixWidth       AS INTEGER      '...width of character grid in pixels
        PixHeight      AS INTEGER      '...height of character grid in pixels
        PitchandFamily AS STRING * 1   '...description of pitch and family
        AvgWidth       AS INTEGER      '...average width
        MaxWidth       AS INTEGER      '...width of widest character
        FirstChar      AS STRING * 1   '...ASCII value of first char
        LastChar       AS STRING * 1   '...ASCII value of last char
        DefaultChar    AS STRING * 1   '...relative char value for out of range chars
        BreakChar      AS STRING * 1   '...relative char value for word seperator char
        WidthBytes     AS INTEGER      '...number of bytes in each row
        Device         AS LONG         '...offset in bytes to font's device name string
        Face           AS LONG         '...offset in bytes to face name
        BitsPointer    AS LONG         '...unused and set to zero
        BitsOffset     AS LONG         '...offset in bytes to start of bitmap or stroke data
        Reserved1      AS STRING * 1   '...reserved
      END TYPE
     
      TYPE ExeHdrType
        Signature      AS STRING * 2   '...MZ for valid EXE code file
        ExtraBytes     AS INTEGER      '...number bytes in last page
        Pages          AS INTEGER      '...number whole & partial pages (512 bytes)
        RelocItems     AS INTEGER      '...number relocation table pointers
        HeaderSize     AS INTEGER      '...number 16 byte paragraphs in header
        UnusedHere     AS STRING * 50  '...values not needed by this program
        WinInfoOffset  AS INTEGER      '...offset in bytes to WinInfo structure
      END TYPE
  
      TYPE WinInfoType
        Signature      AS STRING * 2   '...NE if valid
        UnusedHere1    AS STRING * 34  '...values not needed by this program
        ResTabOffset   AS INTEGER      '...offset to resource table (in bytes relative to WinInfo)
        UnusedHere2    AS STRING * 26  '...values not needed by this program
      END TYPE

      TYPE ResInfoType
        TypeID         AS INTEGER      '...resource type
        ResCount       AS INTEGER      '...number of resources of this type
        Reserved       AS LONG         '...unused
      END TYPE

      TYPE NameInfoType
        Offset         AS INTEGER      '...offset in alignment units
        Length         AS INTEGER      '...length in bytes of resource
        Flags          AS INTEGER      '...resource flags
        ID             AS INTEGER      '...identifier
        Reserved1      AS INTEGER      '...unused or reserved
        Reserved2      AS INTEGER      '...unused or reserved
      END TYPE
   
      TYPE GlyphType
        PWidth         AS INTEGER      '...character width in pixels
        Offset         AS INTEGER      '...offset to character bitmap
      END TYPE


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' FONT Structure:
'     Font Height  --  0  --  2 bytes  -- Char height in pixels
'     Number Chars --  1  --  2 bytes  -- Total number of characters
'     First Char   --  2  --  2 bytes  -- First character in set
'     Last Char    --  3  --  2 bytes  -- Last character in set
'     Default Char --  4  --  2 bytes  -- Default character
'     Break Char   --  5  --  2 bytes  -- Break character
'     Max Width    --  6  --  2 bytes  -- Max char width
'     Vert Spacing --  7  --  2 bytes  -- Vertical spacing
'     Ascent       --  8  --  2 bytes  -- Distance from char top to baseline
'     Pad Width    --  9  --  2 bytes  -- Extra pixels to add between chars
'     Pad Height   -- 10  --  2 bytes  -- Extra pixels to add between lines
'     Char Width   --  2 bytes/char    -- Char width in pixels
'     Char Offset  --  2 bytes/char    -- Char offset into bitmap
'
' Notes: (1) The total number of characters N = LastChar - FirstChar + 1
'        (2) Char width consists of 2 bytes per character.  The width of
'            a given character c% is given by: FontArray%(10+c%)
'        (3) Char offset consists of 2 bytes per character.  The offset of
'            a given character c% is given by: FontArray%(10+N+c%)
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''


