      REM:  FILEINFO.BAS, Unregistered Version 1.0
      REM:  Routines to display info on FNT files or resource files.
   
      DECLARE SUB FontFileInfo (FlName$, RetCode%, RetMsg$)
      DECLARE SUB FontDirRsrcInfo (FileNum%, FileOffset&)
      DECLARE SUB FontRsrcInfo (FileNum%, FilePtr&)
      DECLARE SUB RsrcFileInfo (FlName$, RetCode%, RetMsg$)

      TYPE FontDirEntryType
        FontOrdinal    AS INTEGER      '...unique ordinal value identifying font
        Version        AS INTEGER      '...version
        Size           AS LONG         '...size of font in bytes
        Copyright      AS STRING * 60  '...copyright string
        FType          AS INTEGER      '...font type
        Pnt            AS INTEGER      '...point size for optimum display
        VertRes        AS INTEGER      '...vertical resolution in pixels per inch
        HorizRes       AS INTEGER      '...horizontal resolution in pixels per inch
        Ascent         AS INTEGER      '...distance from top of char cell to baseline
        IntLeading     AS INTEGER      '...distance above tops of char's to top of cell
        ExtLeading     AS INTEGER      '...recommended distance above top of cell
        Italic         AS STRING * 1   '...italic font if equal to 1
        Underline      AS STRING * 1   '...underlined font if equal to 1
        StrikeOut      AS STRING * 1   '...strike-out font if equal to 1
        Weight         AS INTEGER      '...relative weight
        CharSet        AS STRING * 1   '...character set
        PixWidth       AS INTEGER      '...width of character grid in pixels
        PixHeight      AS INTEGER      '...height of character grid in pixels
        PitchandFamily AS STRING * 1   '...description of pitch and family
        AvgWidth       AS INTEGER      '...average width
        MaxWidth       AS INTEGER      '...width of widest character
        FirstChar      AS STRING * 1   '...ASCII value of first char
        LastChar       AS STRING * 1   '...ASCII value of last char
        DefaultChar    AS STRING * 1   '...relative char value for out of range chars
        BreakChar      AS STRING * 1   '...relative char value for word seperator char
        WidthBytes     AS INTEGER      '...number of bytes in each row
        Device         AS LONG         '...offset in bytes to font's device name string
        Face           AS LONG         '...offset in bytes to face name
        Reserved       AS LONG         '...reserved
      END TYPE
    
      TYPE FontType
        Version        AS INTEGER      '...version
        Size           AS LONG         '...size of font in bytes
        Copyright      AS STRING * 60  '...copyright string
        FType          AS INTEGER      '...font type
        Pnt            AS INTEGER      '...point size for optimum display
        VertRes        AS INTEGER      '...vertical resolution in pixels per inch
        HorizRes       AS INTEGER      '...horizontal resolution in pixels per inch
        Ascent         AS INTEGER      '...distance from top of char cell to baseline
        IntLeading     AS INTEGER      '...distance above tops of char's to top of cell
        ExtLeading     AS INTEGER      '...recommended distance above top of cell
        Italic         AS STRING * 1   '...italic font if equal to 1
        Underline      AS STRING * 1   '...underlined font if equal to 1
        StrikeOut      AS STRING * 1   '...strike-out font if equal to 1
        Weight         AS INTEGER      '...relative weight
        CharSet        AS STRING * 1   '...character set
        PixWidth       AS INTEGER      '...width of character grid in pixels
        PixHeight      AS INTEGER      '...height of character grid in pixels
        PitchandFamily AS STRING * 1   '...description of pitch and family
        AvgWidth       AS INTEGER      '...average width
        MaxWidth       AS INTEGER      '...width of widest character
        FirstChar      AS STRING * 1   '...ASCII value of first char
        LastChar       AS STRING * 1   '...ASCII value of last char
        DefaultChar    AS STRING * 1   '...relative char value for out of range chars
        BreakChar      AS STRING * 1   '...relative char value for word seperator char
        WidthBytes     AS INTEGER      '...number of bytes in each row
        Device         AS LONG         '...offset in bytes to font's device name string
        Face           AS LONG         '...offset in bytes to face name
        BitsPointer    AS LONG         '...unused and set to zero
        BitsOffset     AS LONG         '...offset in bytes to start of bitmap or stroke data
        Reserved1      AS STRING * 1   '...reserved
      END TYPE
    
      TYPE ExeHdrType
        Signature      AS STRING * 2   '...MZ for valid EXE code file
        ExtraBytes     AS INTEGER      '...number bytes in last page
        Pages          AS INTEGER      '...number whole & partial pages (512 bytes)
        RelocItems     AS INTEGER      '...number relocation table pointers
        HeaderSize     AS INTEGER      '...number 16 byte paragraphs in header
        UnusedHere     AS STRING * 50  '...values not needed by this program
        WinInfoOffset  AS INTEGER      '...offset in bytes to WinInfo structure
      END TYPE
   
      TYPE WinInfoType
        Signature      AS STRING * 2   '...NE if valid
        UnusedHere1    AS STRING * 34  '...values not needed by this program
        ResTabOffset   AS INTEGER      '...offset to resource table (in bytes relative to WinInfo)
        UnusedHere2    AS STRING * 26  '...values not needed by this program
      END TYPE
     
      TYPE ResInfoType
        TypeID         AS INTEGER      '...resource type
        ResCount       AS INTEGER      '...number of resources of this type
        Reserved       AS LONG         '...unused
      END TYPE

      TYPE NameInfoType
        Offset         AS INTEGER      '...offset in alignment units
        Length         AS INTEGER      '...length in bytes of resource
        Flags          AS INTEGER      '...resource flags
        ID             AS INTEGER      '...identifier
        Reserved1      AS INTEGER      '...unused or reserved
        Reserved2      AS INTEGER      '...unused or reserved
      END TYPE

      '...setup a text mode and clear the screen...
      SCREEN 0: WIDTH , 50: CLS
     
      PRINT "RSRCINFO.BAS, Unregistered Version 1.0"
      PRINT "Routines to display info on resources in a resource file."
      PRINT
     
      '...let user enter a resource file name...
      INPUT "Enter file type: 1=font (FNT), 2=resource (FON, EXE, DLL)"; FileType%
      PRINT
     
      IF (FileType% = 2) THEN

        '...let user enter a resource file name...
        INPUT "Enter name of resource file (FON, EXE, DLL)"; FlName$
     
        '...get the info from the resource file...
        CALL RsrcFileInfo(FlName$, RetCode%, RetMsg$)

      ELSE

        '...let user enter a resource file name...
        INPUT "Enter name of font file (FNT)"; FlName$
       
        '...get the info from the font (FNT) file...
        CALL FontFileInfo(FlName$, RetCode%, RetMsg$)

      END IF

      '...check the return code for a bad resource file...
      IF (RetCode% <> 0) THEN
        PRINT "***** ERROR: RetCode% = "; RetCode%
        PRINT "***** "; RetMsg$
      END IF

      END

'     ************************************************************************
      SUB FontDirRsrcInfo (FileNum%, FileOffset&)
'     ************************************************************************
    
      DIM FontDirEntry AS FontDirEntryType, OneByte AS STRING * 1

'     ...move the file offset into a variable we can destroy...
      FilePtr& = FileOffset&

'     ...pull the font resource count and increment file ptr...
      GET FileNum%, FilePtr&, FrCount%
      FilePtr& = FilePtr& + 2
 
      PRINT "Font Dir Resource Count (FrCount): "; FrCount%
  
      FOR i% = 1 TO FrCount%

        '...get the next font resource entry...
        GET FileNum%, FilePtr&, FontDirEntry

        DeviceName$ = "": FaceName$ = ""

        DO
          GET FileNum%, , OneByte
          DeviceName$ = DeviceName$ + OneByte
        LOOP UNTIL (OneByte = CHR$(0))
 
        DO
          GET FileNum%, , OneByte
          FaceName$ = FaceName$ + OneByte
        LOOP UNTIL (OneByte = CHR$(0))
    
        '...increment file pointer...
        FilePtr& = FilePtr& + LEN(FontDirEntry) + LEN(DeviceName$) + LEN(FaceName$)
    
        PRINT
        PRINT "  FONT DIRECTORY ENTRY:"; i%
        PRINT "    Font Ordinal:"; FontDirEntry.FontOrdinal,
        PRINT "         Version: &h0"; HEX$(FontDirEntry.Version)
        PRINT "            Size:"; FontDirEntry.Size
        PRINT "       Copyright: "; FontDirEntry.Copyright
        PRINT "            Type: &h"; HEX$(FontDirEntry.FType);
        IF (FontDirEntry.FType AND 1) THEN
          PRINT " (VECTOR)";
        ELSE
          PRINT " (BITMAP)";
        END IF
        PRINT "         Point:"; FontDirEntry.Pnt
        PRINT "         VertRes:"; FontDirEntry.VertRes,
        PRINT "        HorizRes:"; FontDirEntry.HorizRes
        PRINT "          Ascent:"; FontDirEntry.Ascent,
        PRINT "      IntLeading:"; FontDirEntry.IntLeading
        PRINT "      ExtLeading:"; FontDirEntry.ExtLeading,
        PRINT "          Italic:"; ASC(FontDirEntry.Italic)
        PRINT "       Underline:"; ASC(FontDirEntry.Underline),
        PRINT "       StrikeOut:"; ASC(FontDirEntry.StrikeOut)
        PRINT "          Weight:"; FontDirEntry.Weight,
        PRINT "         CharSet:"; ASC(FontDirEntry.CharSet); "  ";
        SELECT CASE ASC(FontDirEntry.CharSet)
          CASE 0:  PRINT "(ANSI_CHARSET)"
          CASE 2:  PRINT "(SYMBOL_CHARSET)"
          CASE 255:  PRINT "(OEM_CHARSET)"
          CASE ELSE: PRINT "(UNKNOWN)"
        END SELECT
        PRINT "        PixWidth:"; FontDirEntry.PixWidth,
        PRINT "       PixHeight:"; FontDirEntry.PixHeight
        PRINT "    Pitch&Family: &h"; HEX$(ASC(FontDirEntry.PitchandFamily)),
        PRINT "        AvgWidth:"; FontDirEntry.AvgWidth
        PRINT "        MaxWidth:"; FontDirEntry.MaxWidth,
        PRINT "       FirstChar:"; ASC(FontDirEntry.FirstChar)
        PRINT "        LastChar:"; ASC(FontDirEntry.LastChar),
        PRINT "     DefaultChar:"; ASC(FontDirEntry.DefaultChar)
        PRINT "       BreakChar:"; ASC(FontDirEntry.BreakChar),
        PRINT "      WidthBytes:"; FontDirEntry.WidthBytes
        PRINT "     Device Name: "; DeviceName$
        PRINT "       Face Name: "; FaceName$
        PRINT
  
        IF ((FrCount% > 1) AND (i% < FrCount%)) THEN
          PRINT "------- Press Any Key To Continue -------"
          DO: LOOP UNTIL (INKEY$ <> "")
        END IF

      NEXT i%
    
      END SUB

'     ************************************************************************
      SUB FontFileInfo (FlName$, RetCode%, RetMsg$)
'     ************************************************************************
     
      '...clear the return code and error message...
      RetCode% = 0: RetMsg$ = ""
     
      '...be nice - use the next available file number...
      FileNum% = FREEFILE

      PRINT "Font File Info: "; FlName$: PRINT
   
      '...open file for binary input using supplied filename...
      OPEN FlName$ FOR BINARY AS FileNum%

      '...file has to be at least big enough to hold font header...
      IF (LOF(FileNum%) < 118) THEN
        RetCode% = 1
        RetMsg$ = "Invalid font file, file too short or not present"
        GOTO ErrExit
      END IF

      '...print info from font resource, starting at first byte...
      CALL FontRsrcInfo(FileNum%, 1)

ErrExit:

      '...close the file...
      CLOSE FileNum%

      END SUB

'     ************************************************************************
      SUB FontRsrcInfo (FileNum%, FilePtr&)
'     ************************************************************************
    
      DIM FontEntry AS FontType
   
      '...get the font resource entry...
      GET FileNum%, FilePtr&, FontEntry

      '...increment file pointer...
      FilePtr& = FilePtr& + LEN(FontEntry) + LEN(DeviceName$) + LEN(FaceName$)
   
      PRINT "    FONT ENTRY:"
      PRINT "           Version: &h0"; HEX$(FontEntry.Version),
      PRINT "              Size:"; FontEntry.Size
      PRINT "         Copyright: "; FontEntry.Copyright
      PRINT "              Type: &h"; HEX$(FontEntry.FType);
      IF (FontEntry.FType AND 1) THEN PRINT " (VECTOR)";  ELSE PRINT " (BITMAP)";
      PRINT "         Point:"; FontEntry.Pnt
      PRINT "           VertRes:"; FontEntry.VertRes,
      PRINT "          HorizRes:"; FontEntry.HorizRes
      PRINT "            Ascent:"; FontEntry.Ascent,
      PRINT "        IntLeading:"; FontEntry.IntLeading
      PRINT "        ExtLeading:"; FontEntry.ExtLeading,
      PRINT "            Italic:"; ASC(FontEntry.Italic)
      PRINT "         Underline:"; ASC(FontEntry.Underline),
      PRINT "         StrikeOut:"; ASC(FontEntry.StrikeOut)
      PRINT "            Weight:"; FontEntry.Weight,
      PRINT "           CharSet:"; ASC(FontEntry.CharSet); "  ";
      SELECT CASE ASC(FontEntry.CharSet)
        CASE 0:  PRINT "(ANSI_CHARSET)"
        CASE 2:  PRINT "(SYMBOL_CHARSET)"
        CASE 255:  PRINT "(OEM_CHARSET)"
        CASE ELSE: PRINT "(UNKNOWN)"
      END SELECT
      PRINT "          PixWidth:"; FontEntry.PixWidth,
      PRINT "         PixHeight:"; FontEntry.PixHeight
      PRINT "      Pitch&Family: &h"; HEX$(ASC(FontEntry.PitchandFamily)),
      PRINT "          AvgWidth:"; FontEntry.AvgWidth
      PRINT "          MaxWidth:"; FontEntry.MaxWidth,
      PRINT "         FirstChar:"; ASC(FontEntry.FirstChar)
      PRINT "          LastChar:"; ASC(FontEntry.LastChar),
      PRINT "       DefaultChar:"; ASC(FontEntry.DefaultChar)
      PRINT "         BreakChar:"; ASC(FontEntry.BreakChar),
      PRINT "        WidthBytes:"; FontEntry.WidthBytes
      PRINT
      
      END SUB

'     ************************************************************************
      SUB RsrcFileInfo (FlName$, RetCode%, RetMsg$)
'     ************************************************************************

      DIM ExeHdr AS ExeHdrType, WinInfo AS WinInfoType
      DIM ResInfo AS ResInfoType, NameInfo AS NameInfoType
      DIM OneByte AS STRING * 1

      '...clear the return code and error message...
      RetCode% = 0: RetMsg$ = ""
     
      '...be nice - use the next available file number...
      FileNum% = FREEFILE

      PRINT "Resource File Info: "; FlName$
      PRINT
    
      '...open file for binary input using supplied filename...
      OPEN FlName$ FOR BINARY AS FileNum%

      '...file has to be at least big enough to hold hdr and info block...
      IF (LOF(FileNum%) < LEN(ExeHdr) + LEN(WinInfo)) THEN
        RetCode% = 1
        RetMsg$ = "Invalid rsrc file, file too short or not present"
        GOTO InfoExt
      END IF
 
      PRINT "Reading executable header...": PRINT
    
      '...get the executable header...
      GET FileNum%, 1, ExeHdr
  
      '...for valid rsrc files, the exehdr has signature "MZ"...
      IF (ExeHdr.Signature <> "MZ") THEN
        RetCode% = 2
        RetMsg$ = "Invalid rsrc file, ExeHdr signature (MZ) not present"
        GOTO InfoExt
      END IF

      PRINT "EXEHDR"
      PRINT "       Signature:"; ExeHdr.Signature,
      PRINT "      ExtraBytes:"; ExeHdr.ExtraBytes
      PRINT "           Pages:"; ExeHdr.Pages,
      PRINT "      RelocItems:"; ExeHdr.RelocItems
      PRINT "      HeaderSize:"; ExeHdr.HeaderSize,
      PRINT "   WinInfoOffset:"; ExeHdr.WinInfoOffset
      PRINT

      PRINT "Reading win info header...": PRINT
    
      '...using offset in executable header, pull the wininfo block...
      GET FileNum%, 1 + ExeHdr.WinInfoOffset, WinInfo
  
      PRINT "WININFO (Partial)"
      PRINT "       Signature: "; WinInfo.Signature,
      PRINT "    ResTabOffset:"; WinInfo.ResTabOffset
      PRINT
     
      PRINT "------- Press Any Key To Continue -------"
      DO: LOOP UNTIL (INKEY$ <> "")
     
      '...for valid rsrc files, the win info blk has signature "NE"...
      IF (WinInfo.Signature <> "NE") THEN
        RetCode% = 3
        RetMsg$ = "Invalid rsrc file, WinInfo signature (NE) not present"
        GOTO InfoExt
      END IF

      '...compute the location of start of resource table...
      ResTable& = 1& + ExeHdr.WinInfoOffset + WinInfo.ResTabOffset

      PRINT
      PRINT "Reading resource table...": PRINT
    
      '...read the alignment shift count (first item in resource table)...
      GET FileNum%, ResTable&, ResAlignShift%

      '...convert to something meaningful, i.e. alignment unit...
      AlignmentUnit& = 2& ^ ResAlignShift%

      PRINT "ResAlignShift: "; ResAlignShift%
   
      '...keep count of the number of res types and file ptr...
      NumResTypes% = 0: FilePtr& = ResTable& + 2

      '...keep reading them until we hit a zero for end of list...
      DO

        '...read the next type...
        GET FileNum%, FilePtr&, ResInfo

        '...a zero in TypeID slot means reached end of list...
        IF (ResInfo.TypeID <> 0) THEN
 
          '...increment the number of res types and file pointer...
          NumResTypes% = NumResTypes% + 1
          FilePtr& = FilePtr& + LEN(ResInfo)

          '...if the high order bit is set, we can look up the type...
          IF ((ResInfo.TypeID AND &H8000) = &H8000) THEN
            SELECT CASE (ResInfo.TypeID AND (NOT &H8000))
              CASE 1: lbl$ = "Cursor rsrc: RT_CURSOR"
              CASE 2: lbl$ = "Bitmap rsrc: RT_BITMAP"
              CASE 3: lbl$ = "Icon rsrc: RT_ICON"
              CASE 4: lbl$ = "Menu rsrc: RT_MENU"
              CASE 5: lbl$ = "Dialog and Control rsrc: RT_DIALOG"
              CASE 6: lbl$ = "String table rsrc: RT_STRING"
              CASE 7: lbl$ = "Font directory rsrc: RT_FONTDIR"
              CASE 8: lbl$ = "Font rsrc: RT_FONT"
              CASE 9: lbl$ = "Accelerator table rsrc: RT_ACCELERATOR"
              CASE 10: lbl$ = "User defined rsrc data: RT_RCDATA"
              CASE 12: lbl$ = "Cursor directory rsrc: RT_GROUP_CURSOR"
              CASE 14: lbl$ = "Icon directory rsrc: RT_GROUP_ICON"
              CASE ELSE:  lbl$ = "Unrecognized rsrc type"
            END SELECT
          ELSE
            lbl$ = ""
          END IF
         
          PRINT
          PRINT "RESRC TABLE ENTRY:"; NumResTypes%
          PRINT "      TypeID: &h"; HEX$(ResInfo.TypeID); "  ("; lbl$; ")"
          PRINT "    ResCount:"; ResInfo.ResCount
        
          '...loop over the count of this type of resource...
          FOR j% = 1 TO ResInfo.ResCount
   
            '...read in each of name info blocks (from where we left off)...
            GET FileNum%, FilePtr&, NameInfo

            PRINT
            PRINT "    RESOURCE NO:" + STR$(j%)
            PRINT "           Offset:" + STR$(NameInfo.Offset),
            PRINT "           Length:" + STR$(NameInfo.Length)
            PRINT "            Flags: &h" + HEX$(NameInfo.Flags),
            PRINT "               ID: &h" + HEX$(NameInfo.ID)

            IF ((NameInfo.ID AND &H8000) = 0) THEN
              SEEK FileNum%, FilePtr& + NameInfo.ID - 1
              DO
                GET FileNum%, , OneByte
                ResName$ = ResName$ + OneByte
              LOOP UNTIL (OneByte = CHR$(0))
              PRINT "    Resource name: "; ResName$
            END IF

            PRINT
          
            '...increment the file pointer...
            FilePtr& = FilePtr& + LEN(NameInfo)
          
            '...set the location of start of resource data...
            Locn& = NameInfo.Offset * AlignmentUnit& + 1&

            '...if this is a font directory RT_FONTDIR, we can expand it...
            IF (ResInfo.TypeID = &H8007) THEN
              CALL FontDirRsrcInfo(FileNum%, Locn&)
            END IF
          
            '...if this is a font resource RT_FONT, we can expand it...
            IF (ResInfo.TypeID = &H8008) THEN
              CALL FontRsrcInfo(FileNum%, Locn&)
            END IF

            PRINT "------- Press Any Key To Continue -------"
            DO: LOOP UNTIL (INKEY$ <> "")

          NEXT j%
        
        END IF

      LOOP UNTIL (ResInfo.TypeID = 0)

      '...read the end types flag (better be zero)...
      GET FileNum%, FilePtr&, EndTypes%

      PRINT
      PRINT "Total Number resource types: "; NumResTypes%
      PRINT "EndTypes% (zero): "; EndTypes%
      PRINT

      PRINT "------- Press Any Key To Continue -------"
      DO: LOOP UNTIL (INKEY$ <> "")

      '...if EndTypes% is zero, there is no resource name data...
      IF (EndTypes% <> 0) THEN

        DO

          '...get byte which is the length of the next resource name...
          GET FileNum%, , OneByte

          '...convert the byte to an integer...
          StrLength% = ASC(OneByte)

          IF (StrLength% > 0) THEN

            '...build a string that long...
            ResrcName$ = SPACE$(StrLength%)

            '...read in the string...
            GET FileNum%, , ResrcName$
        
          END IF

        LOOP UNTIL (StrLength% = 0)
      END IF

InfoExt:

      '...close the file on the way out...
      CLOSE FileNum%

      END SUB

