DECLARE SUB AutoCreateData (recs%)
DECLARE SUB BumpCurrRecLineUp ()
DECLARE SUB DoFunctions ()
DECLARE SUB TitleScreen ()
DECLARE SUB UpdateScreen ()
DECLARE SUB ShowFKeys (OnOff%)
DECLARE SUB OpenFiles ()
DECLARE SUB CreateFiles ()
DECLARE SUB ClearMsgArea ()
DECLARE SUB CloseFiles ()
DECLARE FUNCTION GetKey% ()

'{BTREE42 TEST PROGRAM v1.10 by Cornel Huth 09/27/89}

REM $INCLUDE: 'QBTREE42.BI'
               
DEFINT A-Z

TYPE RegType
   ax AS INTEGER
   bx AS INTEGER
   cx AS INTEGER
   dx AS INTEGER
   BP AS INTEGER
   SI AS INTEGER
   DI AS INTEGER
   FLAGS AS INTEGER
END TYPE

CONST PROGID = "QBTREE42 TEST PROGRAM"

CLS

DIM SHARED fk$(1 TO 10)
fk$(1) = "Help   "
fk$(2) = "AddRec "
fk$(3) = "Update "
fk$(4) = "GetEQU "
fk$(5) = "GetPOS "
fk$(6) = "GetRNO "
fk$(7) = "DelKey "
fk$(8) = "DelRec "
fk$(9) = "StatKY  "
fk$(10) = "StatDT "

DIM SHARED StatError$(200 TO 230)
StatError$(200) = "Key not found"
StatError$(201) = "Key already exists"
StatError$(202) = "End of file"
StatError$(203) = "Top of file"
StatError$(204) = "Empty file"
StatError$(205) = "Disk full"
StatError$(206) = "Data pointer invalid"
StatError$(207) = "Key pointer invalid"
StatError$(208) = "File not BTREE40"

StatError$(210) = "Stack overflow"
StatError$(211) = "Function not implemented"
StatError$(220) = "Record length invalid"
StatError$(221) = "Key length invalid"
StatError$(222) = "File not open"
StatError$(223) = "Invalid null key assignment"
StatError$(224) = "Invalid record number"
StatError$(225) = "No more handles"
StatError$(226) = "File not found"
StatError$(227) = "File needs to be converted"
StatError$(228) = "File not QBTREE"
StatError$(229) = "Lock already in force"
StatError$(230) = "File already exists"

DIM SHARED kf$(0 TO 2)
DIM SHARED df$
DIM SHARED CurrKey
DIM SHARED stat
DIM SHARED CurrRecLine
DIM SHARED iregs AS RegType
DIM SHARED oregs AS RegType
DIM SHARED pstack(1 TO 10, 1 TO 3)
DIM SHARED DEBUG AS INTEGER

kf$(0) = ""
df$ = ""
CurrRecLine = 3
IF INSTR(COMMAND$, "/D") THEN DEBUG = -1 ELSE DEBUG = 0
TitleScreen
kf$(1) = "TESTTREE.NX1"
kf$(2) = "TESTTREE.NX2"
df$ = "TESTTREE.DAT"
CreateFiles
CurrKey = 1
UpdateScreen
ShowFKeys 1
DoFunctions
ShowFKeys 0
CloseFiles
LOCATE 24, 1

SUB AutoCreateData (recs)

DataHdr$ = "DATA ..."
CurrKey = 1
UpdateScreen

FOR i = 1 TO recs
   ThisKey$ = "KEY" + LTRIM$(STR$(i))
   ThisData$ = ThisKey$ + "\" + DataHdr$

   ClearMsgArea
   LOCATE 22, 2
   PRINT "Adding record  stat:";
   stat = AddRecord(CurrKey, 1, ThisKey$, ThisData$)
   PRINT stat
   IF stat = 0 THEN
      LOCATE CurrRecLine, 1
      PRINT ">"; ThisKey$; "<"
      LOCATE CurrRecLine, 20
      PRINT ">"; ThisData$; "<"
      BumpCurrRecLineUp
   ELSE
      BEEP
      SLEEP 2
   END IF
   a$ = INKEY$
   IF a$ <> "" THEN EXIT FOR
NEXT

END SUB

SUB BumpCurrRecLineUp
                     
CurrRecLine = CurrRecLine + 1
IF CurrRecLine > 19 THEN
   CurrRecLine = 19
   iregs.ax = &H601             '{video func 6, scroll up 1 line}
   iregs.bx = &H700             '{normal attribute}
   iregs.cx = &H200             '{row 3 column 0}
   iregs.dx = 19 * 256 + 68     '{row 20 column 69}
   CALL INTERRUPT(&H10, iregs, oregs)
END IF

END SUB

SUB ClearMsgArea

LOCATE 22, 2
PRINT SPACE$(39)

END SUB

SUB CloseFiles

ClearMsgArea
LOCATE 22, 2
PRINT "Closing "; kf$(1); " stat:";
stat = CloseKeyFile(1)
PRINT stat
IF stat THEN BEEP: SLEEP 2 ELSE SLEEP 1

ClearMsgArea
LOCATE 22, 2
PRINT "Closing "; kf$(2); " stat:";
stat = CloseKeyFile(2)
PRINT stat
IF stat THEN BEEP: SLEEP 2

CurrKey = 1
kf$(1) = SPACE$(12)
UpdateScreen

ClearMsgArea
LOCATE 22, 2
PRINT "Closing "; df$; " stat:";
stat = CloseDataFile(1)
PRINT stat
IF stat THEN BEEP: SLEEP 2

df$ = SPACE$(12)
UpdateScreen

ClearMsgArea

END SUB

SUB CreateFiles

ClearMsgArea
LOCATE 22, 2
INPUT "Create new test files? (y/n) ", a$
IF UCASE$(a$) = "Y" THEN
   ClearMsgArea
   LOCATE 22, 2
   a$ = ""
   INPUT "Auto-create test data? (y/n) ", a$
ELSE
   OpenFiles
   EXIT SUB
END IF

ClearMsgArea
CurrKey = 1
LOCATE 22, 2
PRINT "Creating kfile "; kf$(CurrKey); " stat:";
stat = CreateKeyFile(kf$(CurrKey), 9)
PRINT stat
IF stat THEN BEEP: SLEEP 2
IF stat = 205 THEN LOCATE 24, 1: SYSTEM

ClearMsgArea
CurrKey = 2
LOCATE 22, 2
PRINT "Creating kfile "; kf$(CurrKey); " stat:";
stat = CreateKeyFile(kf$(CurrKey), 15)
PRINT stat
IF stat THEN BEEP: SLEEP 2
IF stat = 205 THEN LOCATE 24, 1: SYSTEM

ClearMsgArea
LOCATE 22, 2
PRINT "Creating dfile "; df$; " stat:";
stat = CreateDataFile(df$, 20)
PRINT stat
IF stat THEN BEEP: SLEEP 2
IF stat = 205 THEN LOCATE 24, 1: SYSTEM

ClearMsgArea

OpenFiles

IF UCASE$(a$) = "Y" THEN
   DO
      ClearMsgArea
      LOCATE 22, 2
      a$ = ""
      INPUT "How many records? (0-32000) ", a$
      recs = VAL(a$)
      IF recs = 0 THEN EXIT SUB
      IF recs <= 32000 THEN EXIT DO
   LOOP
   AutoCreateData recs
END IF

END SUB

SUB DoFunctions

DO
   UpdateScreen
   k = GetKey
   SELECT CASE k
   CASE 27              '{Esc}
      EXIT DO
  
   CASE 60              '{F2 Add record}
      ClearMsgArea
      LOCATE 22, 2
      INPUT "key:", ke$
      ke$ = UCASE$(ke$)
      IF LEN(ke$) > 0 AND LEFT$(ke$, 1) <> " " THEN
         ClearMsgArea
         LOCATE 22, 2
         INPUT "data:", rec$
         ClearMsgArea
         LOCATE 22, 2
         PRINT "Adding record  stat:";
         stat = AddRecord(CurrKey, 1, ke$, rec$)
         PRINT stat
         IF stat THEN
            BEEP
            SLEEP 2
         ELSE
            ClearMsgArea
            LOCATE 22, 2
            stat = GetEqual(CurrKey, 1, ke$, rec$)
            IF stat = 0 THEN
               BumpCurrRecLineUp
               LOCATE CurrRecLine, 1
               PRINT ">"; ke$; "<"
               LOCATE CurrRecLine, 20
               PRINT ">"; rec$; "<"
            ELSE
               BEEP
               SLEEP 2
            END IF
         END IF
     
      END IF
  
   CASE 61              '{F3 Update record}
      ClearMsgArea
      LOCATE 22, 2
      INPUT "data:", rec$
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Updating record  stat:";
      stat = UpdateRecord(1, rec$)
      PRINT stat
      IF stat THEN
         BEEP
         SLEEP 2
      ELSE
         ClearMsgArea
         LOCATE 22, 2
         PRINT "Validating update  stat:";
         stat = GetEqual(CurrKey, 1, ke$, rec$)
         PRINT stat
         IF stat = 0 THEN
            BumpCurrRecLineUp
            LOCATE CurrRecLine, 1
            PRINT ">"; ke$; "<"
            LOCATE CurrRecLine, 20
            PRINT ">"; rec$; "<"
         ELSE
            BEEP
            SLEEP 2
         END IF
      END IF
  
   CASE 62              '{F4 Get equal}
      ClearMsgArea
      LOCATE 22, 2
      INPUT "key:", ke$
      ke$ = UCASE$(ke$)
      IF LEN(ke$) > 0 AND LEFT$(ke$, 1) <> " " THEN
         ClearMsgArea
         LOCATE 22, 2
         PRINT "Getting equal  stat:";
         stat = GetEqual(CurrKey, 1, ke$, rec$)
         PRINT stat
         IF stat = 0 THEN
            BumpCurrRecLineUp
            LOCATE CurrRecLine, 1
            PRINT ">"; ke$; "<"
            LOCATE CurrRecLine, 20
            PRINT ">"; rec$; "<"
         ELSE
            BEEP
            SLEEP 2
         END IF
      ELSE
         ClearMsgArea
      END IF
  
   CASE 80, 116         '{down arrow  Get next   ctrl right arrow Auto next}
      DO
         ClearMsgArea
         LOCATE 22, 2
         PRINT "Getting next  stat:";
         stat = GetNext(CurrKey, 1, ke$, rec$)
         PRINT stat
         IF stat = 0 THEN
            BumpCurrRecLineUp
            LOCATE CurrRecLine, 1
            PRINT ">"; ke$; "<"
            LOCATE CurrRecLine, 20
            PRINT ">"; rec$; "<"
         ELSE
            BEEP
            SLEEP 2
            EXIT DO
         END IF
         a$ = INKEY$
         IF a$ = CHR$(27) THEN EXIT DO
         UpdateScreen
      LOOP UNTIL k = 80

   CASE 72, 115         '{up arrow  Get prev   ctrl left arrow  Auto prev}
      DO
         ClearMsgArea
         LOCATE 22, 2
         PRINT "Getting prev  stat:";
         stat = GetPrev(CurrKey, 1, ke$, rec$)
         PRINT stat
         IF stat = 0 THEN
            BumpCurrRecLineUp
            LOCATE CurrRecLine, 1
            PRINT ">"; ke$; "<"
            LOCATE CurrRecLine, 20
            PRINT ">"; rec$; "<"
         ELSE
            BEEP
            SLEEP 2
            EXIT DO
         END IF
         a$ = INKEY$
         IF a$ = CHR$(27) THEN EXIT DO
         UpdateScreen
      LOOP UNTIL k = 72

   CASE 63              '{F5 Get position}
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Get current record  stat:";
      stat = GetPosition(CurrKey, recno&)
      PRINT stat
      IF stat = 0 THEN
         ClearMsgArea
         LOCATE 22, 2
         PRINT "Record#:"; recno&
      ELSE
         BEEP
         SLEEP 2
      END IF

   CASE 64              '{F6 Get direct}
      ClearMsgArea
      LOCATE 22, 2
      INPUT "Record#:", recno&
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Get direct  stat:";
      stat = GetDirect(1, recno&, rec$)
      PRINT stat
      IF stat = 0 THEN
         BumpCurrRecLineUp
         LOCATE CurrRecLine, 20
         PRINT "["; rec$; "]"
      ELSE
         BEEP
         SLEEP 2
      END IF
  
   CASE 65              '{F7 Delete key}
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Delete key  stat:";
      stat = DeleteKey(CurrKey, ke$)
      PRINT stat
      IF stat = 0 THEN
         x = StatKeyFile(CurrKey, kl, k&, bf)
         LOCATE CurrRecLine, 1
         PRINT ">"; SPACE$(kl); "<"
      ELSE
         BEEP
         SLEEP 2
      END IF
   CASE 66              '{F8 Delete record}
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Delete record  stat:";
      stat = DeleteRecord(CurrKey, 1, ke$)
      PRINT stat
      IF stat = 0 THEN
         x = StatKeyFile(CurrKey, kl, k&, bf)
         x = StatDataFile(1, rl, r&, bf)
         LOCATE CurrRecLine, 1
         PRINT ">"; SPACE$(kl); "<"
         LOCATE CurrRecLine, 20
         PRINT ">"; SPACE$(rl); "<"
      ELSE
         BEEP
         SLEEP 2
      END IF
  
   CASE 67              '{F9 Status key file}
      ClearMsgArea
      LOCATE 22, 2
      stat = StatKeyFile(CurrKey, keylen, keys&, bfile)
      IF stat = 0 THEN
         PRINT "Keylen="; keylen; " keys="; keys&; " QB#="; bfile
      ELSE
         BEEP
         PRINT "stat:"; stat
         SLEEP 2
      END IF

   CASE 68              '{F10 Status data file}
      ClearMsgArea
      LOCATE 22, 2
      stat = StatDataFile(1, reclen, recs&, bfile)
      IF stat = 0 THEN
         PRINT "Reclen="; reclen; " recs="; recs&; " QB#="; bfile
      ELSE
         BEEP
         PRINT "stat:"; stat
         SLEEP 2
      END IF
  
   CASE 59              '{F1 Help last error code}
      ClearMsgArea
      LOCATE 22, 2
      IF stat THEN
         PRINT stat; "="; StatError$(stat)
      ELSE
         PRINT stat; "="; "No error"
      END IF
 
   CASE 4               '{^D toggle DEBUG}
      DEBUG = NOT DEBUG
      TitleScreen

   CASE 5               '{^E Erase (Delete) range of keys and records}
      ClearMsgArea
      LOCATE 22, 2
      INPUT "Lower range to DEL:", lr$
      lr$ = UCASE$(lr$)
      ClearMsgArea
      LOCATE 22, 2
      INPUT "Upper range to DEL:", ur$
      ur$ = UCASE$(ur$)
      x = StatKeyFile(CurrKey, kl, k&, bf)
      ur$ = ur$ + SPACE$(kl - LEN(ur$))
      x = StatDataFile(1, rl, r&, bf)
      stat = GetEqual(CurrKey, 1, lr$, rec$)
      DO WHILE (lr$ <= ur$ AND stat = 0)
         IF stat = 0 THEN
            BumpCurrRecLineUp
            LOCATE CurrRecLine, 1
            PRINT ">"; lr$; "<"
            LOCATE CurrRecLine, 20
            PRINT ">"; rec$; "<"
            stat = DeleteRecord(CurrKey, 1, lr$)
            IF stat = 0 THEN
               LOCATE CurrRecLine, 1
               PRINT ">"; SPACE$(kl); "<"
               LOCATE CurrRecLine, 20
               PRINT ">"; SPACE$(rl); "<"
               stat = GetNext(CurrKey, 1, lr$, rec$)
            ELSE
               ClearMsgArea
               LOCATE 22, 2
               PRINT "Error in deleting this key/rec"
               EXIT DO
            END IF
         ELSE
            stat = GetNext(CurrKey, 1, lr$, rec$)
         END IF
      LOOP
      BumpCurrRecLineUp
      LOCATE CurrRecLine, 1
      PRINT ">"; lr$; "<"
      LOCATE CurrRecLine, 20
      PRINT ">"; rec$; "<"
       
   CASE 6               '{^F Get first key}
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Getting first key  stat:";
      stat = GetFirst(CurrKey, 1, ke$, rec$)
      PRINT stat
      IF stat = 0 THEN
         BumpCurrRecLineUp
         LOCATE CurrRecLine, 1
         PRINT ">"; ke$; "<"
         LOCATE CurrRecLine, 20
         PRINT ">"; rec$; "<"
      ELSE
         BEEP
         SLEEP 2
      END IF

   CASE 12              '{^L Get last key}
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Getting last key  stat:";
      stat = GetLast(CurrKey, 1, ke$, rec$)
      PRINT stat
      IF stat = 0 THEN
         BumpCurrRecLineUp
         LOCATE CurrRecLine, 1
         PRINT ">"; ke$; "<"
         LOCATE CurrRecLine, 20
         PRINT ">"; rec$; "<"
      ELSE
         BEEP
         SLEEP
      END IF

   CASE 14              '{^N Next kfile}
      CurrKey = CurrKey + 1
      IF CurrKey > 2 THEN CurrKey = 1
  
   CASE 16              '{^P Put key}
      ClearMsgArea
      LOCATE 22, 2
      INPUT "key:", ke$
      ke$ = UCASE$(ke$)
      IF LEN(ke$) > 0 AND LEFT$(ke$, 1) <> " " THEN
         ClearMsgArea
         LOCATE 22, 2
         PRINT "Putting key  stat:";
         stat = PutKey(CurrKey, 1, ke$)
         PRINT stat
         IF stat = 0 THEN
            BumpCurrRecLineUp
            LOCATE CurrRecLine, 1
            PRINT ">"; ke$; "<"
            stat = GetEqual(CurrKey, 1, ke$, rec$)
            LOCATE CurrRecLine, 20
            IF stat = 0 THEN
               PRINT ">"; rec$; "<"
            ELSE
               PRINT ">ERROR"; stat; "<"
            END IF
         ELSE
            BEEP
            SLEEP 2
         END IF
      ELSE
         ClearMsgArea
      END IF
  
   CASE 18              '{^R Rewind key file}
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Rewind key file  stat:";
      stat = RewindKeyFile(CurrKey)
      PRINT stat
      IF stat <> 0 THEN
         BEEP
         SLEEP 2
      END IF
 
   CASE 22              '{^V Get BTree version}
      ClearMsgArea
      LOCATE 22, 2
      PRINT "BTREE version:";
      stat = QBTreeVer(ver)
      PRINT (1! * ver / 100)

   CASE 26              '{^Z Flush key files and data file}
      FOR k = 1 TO 2
         ClearMsgArea
         LOCATE 22, 2
         PRINT "Flushing key"; k; " stat:";
         st = FlushKeyFile(k, 1)
         PRINT st
         IF st <> 0 THEN
            BEEP
            SLEEP 2
            stat = st
         END IF
      NEXT
      ClearMsgArea
      LOCATE 22, 2
      PRINT "Flushing data 1  stat:";
      st = FlushDataFile(1, 1)
      PRINT st
      IF st THEN stat = st
      
   CASE ELSE
   END SELECT
LOOP

END SUB

SUB fil

fx = FREEFILE
FOR i = 1 TO 12
OPEN "a" + CHR$(65 + i) FOR OUTPUT AS #fx
fx = fx + 1
NEXT

END SUB

FUNCTION GetKey

DO
   a$ = INKEY$
   xit = 0
   IF LEN(a$) = 1 THEN
      fk = ASC(a$)
   ELSEIF LEN(a$) = 2 THEN
      fk = ASC(RIGHT$(a$, 1))
      xit = 1
   END IF
'LOCATE 1, 1: PRINT fk
   SELECT CASE fk
      CASE 4, 5, 6, 8, 12, 14, 16, 18, 22, 26, 27
         EXIT DO
      CASE 59 TO 68, 72, 80, 115, 116
         IF xit THEN EXIT DO
      CASE ELSE
   END SELECT
LOOP

GetKey = fk

END FUNCTION

SUB OpenFiles

ClearMsgArea
LOCATE 22, 2
PRINT "Opening "; kf$(1); " stat:";
stat = OpenKeyFile(kf$(1), 1)
PRINT stat
IF stat THEN BEEP: LOCATE 24, 1: SYSTEM

ClearMsgArea
LOCATE 22, 2
PRINT "Opening "; kf$(2); " stat:";
stat = OpenKeyFile(kf$(2), 2)
PRINT stat
IF stat THEN BEEP: LOCATE 24, 1: SYSTEM

ClearMsgArea
LOCATE 22, 2
PRINT "Opening "; df$; " stat:";
stat = OpenDataFile(df$, 1)
PRINT stat
IF stat THEN BEEP: LOCATE 24, 1: SYSTEM

ClearMsgArea

END SUB

SUB ShowFKeys (OnOff)

IF OnOff THEN
   LOCATE 24, 1
   FOR i = 1 TO 9 STEP 2
      COLOR 15, 0
      PRINT "F" + LTRIM$(STR$(i));
      COLOR 7, 0
      PRINT fk$(i);
   NEXT
   COLOR 15, 0
   PRINT CHR$(24);
   COLOR 7, 0
   PRINT "prev ";
   COLOR 15, 0
   PRINT "^F";
   COLOR 7, 0
   PRINT "irst ";
   COLOR 15, 0
   PRINT "^N";
   COLOR 7, 0
   PRINT "XT Kf ";
   COLOR 15, 0
   PRINT "^E";
   COLOR 7, 0
   PRINT "raRng";
   COLOR 15, 0
   PRINT "^V";
   COLOR 7, 0
   PRINT "er";
   LOCATE 25, 1
   FOR i = 2 TO 10 STEP 2
      COLOR 15, 0
      PRINT "F" + LTRIM$(STR$(i));
      COLOR 7, 0
      PRINT fk$(i);
   NEXT
   COLOR 15, 0
   PRINT CHR$(25);
   COLOR 7, 0
   PRINT "next ";
   COLOR 15, 0
   PRINT "^L";
   COLOR 7, 0
   PRINT "ast  ";
   COLOR 15, 0
   PRINT "^P";
   COLOR 7, 0
   PRINT "utKey ";
   COLOR 15, 0
   PRINT "^R";
   COLOR 7, 0
   PRINT "ewind";
   COLOR 15, 0
   PRINT "^Z";
   COLOR 7, 0
   PRINT "fl";
ELSE
   LOCATE 24, 1
   PRINT SPACE$(80);
   LOCATE 25, 1
   PRINT SPACE$(80);
END IF

END SUB

SUB TitleScreen

LOCATE 1, 1
PRINT PROGID
LOCATE 1, 38
IF DEBUG THEN PRINT "DEBUG" ELSE PRINT SPACE$(5)
LOCATE 1, 73
COLOR 15, 0
PRINT "Esc";
COLOR 7, 0
PRINT "=quit"
LOCATE 2, 1
PRINT STRING$(70, 196);
LOCATE 2, 70
PRINT CHR$(194); STRING$(5, 196); CHR$(194); CHR$(196); CHR$(196); CHR$(194); CHR$(196)
FOR i = 1 TO 10
   LOCATE i + 2, 70
   PRINT CHR$(179); SPACE$(5); CHR$(179); SPACE$(2); CHR$(179); CHR$(32)
NEXT
LOCATE i + 2, 70
PRINT CHR$(195); STRING$(5, 196); CHR$(197); CHR$(196); CHR$(196); CHR$(197); CHR$(196)
LOCATE i + 3, 70
PRINT CHR$(179);
PRINT " SEC "; CHR$(179); "OF"; CHR$(179); "I"
LOCATE i + 4, 70
PRINT CHR$(195); STRING$(5, 196); CHR$(197); CHR$(196); CHR$(196); CHR$(197); CHR$(196)
LOCATE i + 5, 70
PRINT CHR$(179); SPACE$(5); CHR$(179); SPACE$(2); CHR$(179); CHR$(32)
LOCATE i + 6, 70
PRINT CHR$(192); STRING$(5, 196); CHR$(193); CHR$(196); CHR$(196); CHR$(193); CHR$(196)

LOCATE 21, 1
PRINT CHR$(218) + STRING$(78, 196) + CHR$(191)
LOCATE 22, 1
PRINT CHR$(179); TAB(80); CHR$(179)
LOCATE 23, 1
PRINT CHR$(192) + STRING$(78, 196) + CHR$(217)

LOCATE 22, 41
PRINT "kfile:"
LOCATE 22, 62
PRINT "dfile:"
      
END SUB

SUB UpdateScreen


COLOR 15, 0
LOCATE 22, 47
PRINT kf$(CurrKey)
LOCATE 22, 68
PRINT df$
COLOR 7, 0
IF DEBUG THEN
   a = 1
   x = GetDebugInfo(CurrKey, cukysc, cukyof, iflag, stkcnt, pstack())
   FOR i = 1 TO (stkcnt \ 4)
      LOCATE i + 2, 71
      s$ = LTRIM$(STR$(pstack(i, 1)))
      PRINT SPACE$(5 - LEN(s$)); s$
      LOCATE i + 2, 77
      t = pstack(i, 2)
      o$ = LTRIM$(STR$(t))
      PRINT SPACE$(2 - LEN(o$)); o$
      LOCATE i + 2, 80
      i$ = LTRIM$(STR$(pstack(i, 3)))
      PRINT i$
   NEXT
   r = i - 1 + 3
   t = 10 - (i - 1)
   FOR i = 1 TO t
      LOCATE r, 71
      PRINT SPACE$(5)
      LOCATE r, 77
      PRINT SPACE$(2)
      LOCATE r, 80
      PRINT " "
      r = r + 1
   NEXT
   r = r + 3
   s$ = LTRIM$(STR$(cukysc))
   o$ = LTRIM$(STR$(cukyof))
   i$ = LTRIM$(STR$(iflag))
   LOCATE r, 71
   PRINT SPACE$(5 - LEN(s$)); s$
   LOCATE r, 77
   PRINT SPACE$(2 - LEN(o$)); o$
   LOCATE r, 80
   PRINT i$
END IF

END SUB

