DECLARE FUNCTION ConvertLFpts$ (pts%)
DECLARE FUNCTION Convert2ASCII$ (strg$)
DECLARE SUB PrintLabel ()
DECLARE SUB ParsePC ()
DECLARE SUB ShowEsc (onoff%)
DECLARE SUB ShowLabelInches ()
DECLARE SUB GetMoveKey (NumberOpts%, ulr%, ulc%, lrr%, lrc%, code%, lastkey%, lastptr%, ptr%)
DECLARE SUB ClearMsgArea ()
DECLARE SUB DropPrintWindow (lastkey%)
DECLARE SUB DropEditWindow (lastkey%)
DECLARE SUB SaveWindow (WindowSave%(), ulr%, ulc%, lrr%, lrc%)
DECLARE SUB BackWindow (WindowSave%(), ulr%, ulc%, lrr%, lrc%)
DECLARE SUB ShowTitleScreen ()
DECLARE FUNCTION GetKeyCode% (xcode%)
DECLARE SUB DropFileWindow (lastkey%)
DECLARE SUB ChangeAttr (ulr%, ulc%, lrr%, lrc%, fg%, bg%)
DECLARE SUB XPrint (strg$, row%, col%, fg%, bg%)
DECLARE FUNCTION Edit% (lb%, ub%, prompt$(), fg%, bg%, exitkey%, flag%)
DECLARE SUB WEdit (lb%, ub%, prompt$(), fg%, bg%, xitkey%, flag%)
DECLARE SUB WPrint (lb%, ub%, prompt$(), fg%, bg%)
DECLARE SUB DropTypeWindow (lastkey%)
DECLARE SUB DropPitchWindow (lastkey%)
DECLARE SUB MoveRec2Prompt (rec$)
DECLARE SUB GetCommandLineFile ()

DECLARE FUNCTION FileExists% (filename$)  '{must be a ready drive}

CONST BackSpace = 8, TabRight = 9, EnterKey = 13, TabLeft = 15
CONST EscKey = 27, HomeKey = 71, PgUpKey = 73, CursorLeft = 75
CONST CursorRight = 77, EndKey = 79, PgDnKey = 81, InsertKey = 82
CONST DeleteKe = 83, DeleteToEOLKey = 25
CONST CursorUp = 72, CursorDown = 80
CONST DropFile = 33, DropEdit = 18, DropPrint = 25
CONST DropPitch = 25, DropType = 20
                                   
CONST TRUE = -1, FALSE = NOT TRUE

DEFINT A-Z
'{10/19/89 by Cornel Huth}
'{A useful label generating program using QBTREE42}
'{the system is self-contained (with QBTREE42)}
'{for speedier screens, use optimized SAVE/BACKWINDOW() & XPRINT()}
'{the printer codes have been set for an IBM PC Graphics Printer}
'{others will most probably have a different LFn/72 setup}

REM $INCLUDE: 'qbtree42.bi'
               
REDIM SHARED StatError$(200 TO 232)
StatError$(200) = "Key not found"
StatError$(201) = "Key already exists"
StatError$(202) = "End of file"
StatError$(203) = "Top of file"
StatError$(204) = "Empty file"
StatError$(205) = "Disk full"
StatError$(206) = "Data pointer invalid"
StatError$(207) = "Key pointer invalid"
StatError$(208) = "File not QBTREE40"
StatError$(210) = "Stack overflow"
StatError$(211) = "Function not implemented"
StatError$(220) = "Record length invalid"
StatError$(221) = "Key length invalid"
StatError$(222) = "File not open"
StatError$(223) = "Invalid null key assignment"
StatError$(224) = "Invalid record number"
StatError$(225) = "No more handles"
StatError$(226) = "File not found"
StatError$(227) = "File needs to be converted"
StatError$(228) = "File not QBTREE"
StatError$(229) = "Lock already in force"
StatError$(230) = "File already exists"
StatError$(231) = "File not found"
StatError$(232) = "General lock failure"

REDIM SHARED prompt$(1 TO 50, 1 TO 3)
prompt$(1, 1) = "10/01/60/a/L0:"
prompt$(2, 1) = "10/65/03/n/"
prompt$(3, 1) = "10/69/03/n/"
prompt$(4, 1) = "10/73/03/n/"
prompt$(5, 1) = "10/77/03/n/"
prompt$(6, 1) = "11/01/60/a/L1:"
prompt$(7, 1) = "11/65/03/n/"
prompt$(8, 1) = "11/69/03/n/"
prompt$(9, 1) = "11/73/03/n/"
prompt$(10, 1) = "11/77/03/n/"
prompt$(11, 1) = "12/01/60/a/L2:"
prompt$(12, 1) = "12/65/03/n/"
prompt$(13, 1) = "12/69/03/n/"
prompt$(14, 1) = "12/73/03/n/"
prompt$(15, 1) = "12/77/03/n/"
prompt$(16, 1) = "13/01/60/a/L3:"
prompt$(17, 1) = "13/65/03/n/"
prompt$(18, 1) = "13/69/03/n/"
prompt$(19, 1) = "13/73/03/n/"
prompt$(20, 1) = "13/77/03/n/"
prompt$(21, 1) = "14/01/60/a/L4:"
prompt$(22, 1) = "14/65/03/n/"
prompt$(23, 1) = "14/69/03/n/"
prompt$(24, 1) = "14/73/03/n/"
prompt$(25, 1) = "14/77/03/n/"
prompt$(26, 1) = "15/01/60/a/L5:"
prompt$(27, 1) = "15/65/03/n/"
prompt$(28, 1) = "15/69/03/n/"
prompt$(29, 1) = "15/73/03/n/"
prompt$(30, 1) = "15/77/03/n/"
prompt$(31, 1) = "16/01/60/a/L6:"
prompt$(32, 1) = "16/65/03/n/"
prompt$(33, 1) = "16/69/03/n/"
prompt$(34, 1) = "16/73/03/n/"
prompt$(35, 1) = "16/77/03/n/"
prompt$(36, 1) = "17/01/60/a/L7:"
prompt$(37, 1) = "17/65/03/n/"
prompt$(38, 1) = "17/69/03/n/"
prompt$(39, 1) = "17/73/03/n/"
prompt$(40, 1) = "17/77/03/n/"
prompt$(41, 1) = "18/01/60/a/L8:"
prompt$(42, 1) = "18/65/03/n/"
prompt$(43, 1) = "18/69/03/n/"
prompt$(44, 1) = "18/73/03/n/"
prompt$(45, 1) = "18/77/03/n/"
prompt$(46, 1) = "19/01/60/a/L9:"
prompt$(47, 1) = "19/65/03/n/"
prompt$(48, 1) = "19/69/03/n/"
prompt$(49, 1) = "19/73/03/n/"
prompt$(50, 1) = "19/77/03/n/"

NumberFileOpts = 4
REDIM FileOpts$(1 TO NumberFileOpts)
FileOpts$(1) = " Select data file  "
FileOpts$(2) = " Select index file "
FileOpts$(3) = " Show files        "
FileOpts$(4) = " Exit to DOS       "

NumberEditOpts = 6
REDIM EditOpts$(1 TO NumberEditOpts)
EditOpts$(1) = " Select key     "
EditOpts$(2) = " Add key/record "
EditOpts$(3) = " Update record  "
EditOpts$(4) = " Next key       "
EditOpts$(5) = " Previous key   "
EditOpts$(6) = " Delete key/rec "

NumberPrintOpts = 2
REDIM PrintOpts$(1 TO NumberPrintOpts)
PrintOpts$(1) = " Print label        "
PrintOpts$(2) = " Edit printer codes "

NumberPitchOpts = 7
REDIM PitchOpts$(1 TO NumberPitchOpts)
PitchOpts$(1) = "     Reset      1 "
PitchOpts$(2) = "     Normal     2 "
PitchOpts$(3) = "     Compressed 4 "
PitchOpts$(4) = "     Expanded   8 "
PitchOpts$(5) = "     Pitch 4   16 "
PitchOpts$(6) = "     Pitch 5   32 "
PitchOpts$(7) = "     Pitch 6   64 "

NumberTypeOpts = 8
REDIM TypeOpts$(1 TO NumberTypeOpts)
TypeOpts$(1) = "     Emphasized  1 "
TypeOpts$(2) = "     Bold        2 "
TypeOpts$(3) = "     Superscript 4 "
TypeOpts$(4) = "     Subscript   8 "
TypeOpts$(5) = "     Type 5     16 "
TypeOpts$(6) = "     Type 6     32 "
TypeOpts$(7) = "     Type 7     64 "
TypeOpts$(8) = "     Type 8    128 "

REDIM prePC$(1 TO 16)
REDIM postPC$(1 TO 16)
REDIM PC$(1 TO 16, 1 TO 3)
PC$(1, 1) = "03/40/30/a/  RESET:"
PC$(2, 1) = "04/40/30/a/ NORMAL:"
PC$(3, 1) = "05/40/30/a/ COMPRE:"
PC$(4, 1) = "06/40/30/a/ EXPAND:"
PC$(5, 1) = "07/40/30/a/ PITCH4:"
PC$(6, 1) = "08/40/30/a/ PITCH5:"
PC$(7, 1) = "09/40/30/a/ PITCH6:"
PC$(8, 1) = "10/40/30/a/ LFn/72:"
PC$(1, 2) = ""                    '{reset printer}
PC$(2, 2) = "27,16"               '{normal pitch}
PC$(3, 2) = "15\18"               '{compressed\undo}
PC$(4, 2) = "14\19"               '{expanded\undo}
PC$(5, 2) = ""                    '{pitch4}
PC$(6, 2) = ""                    '{pitch5}
PC$(7, 2) = "0"                   '{pitch6}
PC$(8, 2) = "27,65,n,27,50"       '{variable line feed (n/72)}
                                  '{ n above will be taken from LFpt}

PC$(9, 1) = "11/40/30/a/ EMPHAS:"
PC$(10, 1) = "12/40/30/a/   BOLD:"
PC$(11, 1) = "13/40/30/a/  SUPER:"
PC$(12, 1) = "14/40/30/a/    SUB:"
PC$(13, 1) = "15/40/30/a/  TYPE5:"
PC$(14, 1) = "16/40/30/a/  TYPE6:"
PC$(15, 1) = "17/40/30/a/  TYPE7:"
PC$(16, 1) = "18/40/30/a/  TYPE8:"

PC$(9, 2) = "27,69\27,70"         '{emphasized\undo}
PC$(10, 2) = "27,71\27,72"        '{bold\undo}
PC$(11, 2) = "27,83,0\27,84"      '{superscript\undo}
PC$(12, 2) = "27,83,1\27,84"      '{subscript\undo}
PC$(13, 2) = ""                   '{type5}
PC$(14, 2) = ""                   '{type6}
PC$(15, 2) = ""                   '{type7}
PC$(16, 2) = ""                   '{type8}

DIM SHARED sysfg
DIM SHARED sysbg
DIM SHARED sysdata$
DIM SHARED sysindex$

CLS
sysfg = 7
sysbg = 0
ShowTitleScreen

GetCommandLineFile

code = 0
lptfile = FREEFILE
OPEN "LPT1:BIN" FOR OUTPUT AS #lptfile
DO
   IF code = 0 THEN code = GetKeyCode(xcode)

   SELECT CASE code
   CASE DropFile
      IF xcode THEN
         ShowEsc 1
         DropFileWindow lastkey
         IF lastkey = CursorLeft THEN
            code = DropPrint
         ELSEIF lastkey = CursorRight THEN
            code = DropEdit
         END IF
     END IF

   CASE DropEdit
      IF xcode THEN
         ShowEsc 1
         DropEditWindow lastkey
         IF lastkey = CursorLeft THEN
            code = DropFile
         ELSEIF lastkey = CursorRight THEN
            code = DropPrint
         END IF
      END IF

   CASE DropPrint
      IF xcode THEN
         ShowEsc 1
         DropPrintWindow lastkey
         IF lastkey = CursorLeft THEN
            code = DropEdit
         ELSEIF lastkey = CursorRight THEN
            code = DropFile
         END IF
      END IF

   CASE ELSE
      code = 0

   END SELECT
   ShowEsc 0
   IF lastkey = EscKey THEN code = 0
LOOP

'{exit to system in DropFileWindow}

SUB BackWindow (WindowSave(), ulr, ulc, lrr, lrc)

'{restore the window}
LOCATE , , 0
ptr = 0
FOR row = ulr TO lrr
   LOCATE row, ulc
   FOR col = ulc TO lrc
      ptr = ptr + 1
      char$ = CHR$(WindowSave(ptr) AND 255)
      attr = WindowSave(ptr) \ 255
      fg = attr AND 15
      bg = attr \ 16
      COLOR fg, bg
      PRINT char$;
   NEXT
   PRINT
NEXT

END SUB

SUB ChangeAttr (ulr, ulc, lrr, lrc, fg, bg)

oldrow = CSRLIN
oldcol = POS(0)
COLOR fg, bg
LOCATE , , 0
FOR row = ulr TO lrr
   FOR col = ulc TO lrc
      CurrentChar = SCREEN(row, col)
      LOCATE row, col
      PRINT CHR$(CurrentChar);
   NEXT
NEXT
COLOR sysfg, sysbg
LOCATE oldrow, oldcol

END SUB

SUB ClearMsgArea

LOCATE 25, 1
PRINT SPACE$(80);
LOCATE 25, 1

END SUB

FUNCTION Convert2ASCII$ (strg$)

t$ = ""
IF strg$ = "" THEN
   '{it's got no numbers}
ELSE
   ptr = 1
   t$ = strg$
   flag = FALSE
   DO
      DO WHILE LEFT$(t$, 1) = ","
         t$ = MID$(t$, 2)
      LOOP                              '{remove leading commas}
      commaptr = INSTR(ptr, t$, ",")    '{find the next comma}
      IF commaptr = 0 THEN              '{no more commas, must be at last}
         commaptr = LEN(t$) + 1
         flag = TRUE
      END IF
      t2$ = t2$ + CHR$(VAL(t$))
      t$ = MID$(t$, commaptr + 1)
   LOOP UNTIL flag
   Convert2ASCII$ = t2$
END IF
      
END FUNCTION

FUNCTION ConvertLFpts$ (pts)

SHARED PC$()

strg$ = PC$(8, 2)
t$ = ""
nptr = INSTR(strg$, "n")
IF strg$ = "" OR ASC(strg$) = 44 THEN
   '{it's got no numbers}
ELSE
   ptr = 1
   DO
      commaptr = INSTR(ptr, strg$, ",")
      IF commaptr = 0 THEN commaptr = LEN(strg$) + 1
      t$ = t$ + CHR$(VAL(MID$(strg$, ptr, commaptr - ptr)))
      ptr = commaptr + 1
      IF ptr = nptr THEN
         t$ = t$ + CHR$(pts)
         commaptr = INSTR(ptr, strg$, ",")
         ptr = commaptr + 1
      END IF
   LOOP UNTIL ptr >= LEN(strg$)
   ConvertLFpts$ = t$
END IF

END FUNCTION

SUB DropEditWindow (lastkey)

SHARED NumberEditOpts
SHARED EditOpts$()

STATIC ke$

lastkey = 0
ulr = 1
ulc = 10
lrr = ulr + NumberEditOpts
lrc = ulc + LEN(EditOpts$(1)) - 1
REDIM WindowSave(1 TO (lrc - ulc + 1) * (lrr - ulr + 1)) AS INTEGER
REDIM MiscSave(1 TO (80 * 25)) AS INTEGER

SaveWindow WindowSave(), ulr, ulc, lrr, lrc

'{show the selections}
ChangeAttr ulr, ulc + 1, ulr, ulc + 4, sysfg, sysbg
LOCATE ulr + 1, ulc
COLOR sysbg, sysfg
FOR i = 1 TO NumberEditOpts
   LOCATE , ulc
   PRINT EditOpts$(i)
NEXT

ptr = 0
lastptr = ptr
DO
   COLOR sysbg, sysfg
   ShowLabelInches
   COLOR sysfg, sysbg
   GetMoveKey NumberEditOpts, ulr, ulc, lrr, lrc, code, lastkey, lastptr, ptr
   IF sysdata$ = "" OR sysindex$ = "" THEN ptr = 0: code = -1
  
   SELECT CASE ptr
   CASE 0
   '{must have hit Esc}

   CASE 1  '{select a key}
      ClearMsgArea
      SaveWindow MiscSave(), 2, 28, 2, 70
      LOCATE 2, 28
      COLOR sysbg, sysfg
      PRINT SPACE$(28);
      LOCATE 2, 28
      INPUT ; "key:", ke$
      ke$ = RTRIM$(LTRIM$(ke$))
      BackWindow MiscSave(), 2, 28, 2, 70
      IF ke$ <> "" THEN
        COLOR sysfg, sysbg
        ke$ = UCASE$(ke$)
        stat = GetEqual(0, 0, ke$, rec$)
        ClearMsgArea
        SELECT CASE stat
        CASE 0
           PRINT "Key='"; RTRIM$(ke$); "'";
           MoveRec2Prompt rec$
           WPrint 1, 50, prompt$(), sysfg, sysbg
        CASE 200
           PRINT "'"; RTRIM$(ke$); "' not found.  Get next (y/n)? ";
           yn$ = ""
           INPUT ; "", yn$
           IF UCASE$(yn$) = "Y" THEN
              stat = GetNext(0, 0, ke$, rec$)
              IF stat THEN
                 ClearMsgArea
                 PRINT StatError$(stat); " <ERROR:"; stat;
              ELSE
                 ClearMsgArea
                 PRINT "Key="; RTRIM$(ke$);
                 MoveRec2Prompt rec$
                 WPrint 1, 50, prompt$(), sysfg, sysbg
              END IF
           END IF
        CASE ELSE
           PRINT StatError$(stat); " <ERROR:"; stat;
        END SELECT
      ELSE
         '{just an Enter key}
      END IF
      
   CASE 2  '{add key and data to index and data files}
      ClearMsgArea
      SaveWindow MiscSave(), 3, 28, 3, 70
      FOR i = 1 TO 50
         prompt$(i, 2) = ""
      NEXT
      LOCATE 3, 28
      COLOR sysbg, sysfg
      PRINT SPACE$(28)
      LOCATE 3, 28
      INPUT ; "key:", ke$
      ke$ = RTRIM$(LTRIM$(ke$))
      IF ke$ <> "" THEN
         COLOR sysfg, sysbg
         ke$ = UCASE$(ke$)
         stat = GetEqual(0, 0, ke$, rec$)
         ClearMsgArea
         IF stat = 200 OR stat = 204 THEN
            lastkey = Edit(1, 50, prompt$(), sysfg, sysbg, 27, -1)
            rec$ = ""
            FOR i = 1 TO 50
               rec$ = rec$ + prompt$(i, 2)
            NEXT
            stat = AddRecord(0, 0, ke$, rec$)
            SELECT CASE stat
            CASE 0
               PRINT "Added '"; RTRIM$(ke$); "'";
            CASE ELSE
               PRINT StatError$(stat); " <ERROR:"; stat;
            END SELECT
         ELSEIF stat = 0 THEN
            PRINT StatError$(201); " <ERROR:"; 201;
         END IF
      ELSE
         '{just an Enter key}
      END IF
      BackWindow MiscSave(), 3, 28, 3, 70
    
   CASE 3  '{update the current data record}
      ClearMsgArea
      stat = GetEqual(0, 0, ke$, rec$)
      IF stat = 0 THEN
         PRINT "Key="; RTRIM$(ke$);
         lastkey = Edit(1, 50, prompt$(), sysfg, sysbg, EscKey, -1)
         ClearMsgArea
         PRINT "Update key '"; RTRIM$(ke$); "' with this data (y/n)? ";
         yn$ = ""
         INPUT ; "", yn$
         IF UCASE$(yn$) = "Y" THEN
            rec$ = ""
            FOR i = 1 TO 50
               rec$ = rec$ + prompt$(i, 2)
            NEXT
            stat = UpdateRecord(0, rec$)
            ClearMsgArea
            IF stat THEN
               PRINT StatError$(stat); " <ERROR:"; stat;
            ELSE
               PRINT "Updated '"; RTRIM$(ke$); "'";
            END IF
         ELSE
            ClearMsgArea
         END IF
      ELSE
         ClearMsgArea
         PRINT StatError$(stat); " <ERROR:"; stat;
      END IF

   CASE 4  '{next key and data}
      ClearMsgArea
      stat = GetNext(0, 0, ke$, rec$)
      IF stat = 0 THEN
         PRINT "Key='"; RTRIM$(ke$); "'";
         MoveRec2Prompt rec$
         WPrint 1, 50, prompt$(), sysfg, sysbg
      ELSE
         PRINT StatError$(stat); " <ERROR:"; stat;
      END IF

   CASE 5  '{prev key and data}
      ClearMsgArea
      stat = GetPrev(0, 0, ke$, rec$)
      IF stat = 0 THEN
         PRINT "Key='"; RTRIM$(ke$); "'";
         MoveRec2Prompt rec$
         WPrint 1, 50, prompt$(), sysfg, sysbg
      ELSE
         PRINT StatError$(stat); " <ERROR:"; stat;
      END IF

   CASE 6  '{delete key/rec}
      ClearMsgArea
      PRINT "Delete '"; RTRIM$(ke$); "' (y/n)? ";
      yn$ = ""
      INPUT ; "", yn$
      ClearMsgArea
      IF UCASE$(yn$) = "Y" THEN
         stat = DeleteRecord(0, 0, ke$)
         IF stat THEN
            PRINT StatError$(stat); " <ERROR:"; stat;
         ELSE
            PRINT "Deleted '"; RTRIM$(ke$); "'";
         END IF
      END IF

   CASE ELSE
   END SELECT

LOOP UNTIL code = EscKey OR code = -1
ClearMsgArea
BackWindow WindowSave(), ulr, ulc, lrr, lrc
ERASE WindowSave
ERASE MiscSave

END SUB

SUB DropFileWindow (lastkey)

SHARED NumberFileOpts
SHARED FileOpts$()
SHARED lptfile          '{LPT1 BASIC handle}

lastkey = 0

ulr = 1
ulc = 2
lrr = ulr + NumberFileOpts
lrc = ulc + LEN(FileOpts$(1)) - 1
REDIM WindowSave(1 TO (lrc - ulc + 1) * (lrr - ulr + 1)) AS INTEGER
REDIM MiscSave(1 TO (80 * 25)) AS INTEGER

SaveWindow WindowSave(), ulr, ulc, lrr, lrc

'{show the selections}
ChangeAttr ulr, ulc + 1, ulr, ulc + 4, sysfg, sysbg
LOCATE ulr + 1, ulc
COLOR sysbg, sysfg
FOR i = 1 TO NumberFileOpts
   LOCATE , ulc
   PRINT FileOpts$(i)
NEXT

ptr = 0
lastptr = ptr
DO
   GetMoveKey NumberFileOpts, ulr, ulc, lrr, lrc, code, lastkey, lastptr, ptr
  
   SELECT CASE ptr
   CASE 0
   '{must have hit Esc}

   CASE 1  '{select the data file}
      ok = FALSE
      SaveWindow MiscSave(), 10, 10, 10, 70
      DO
         LOCATE 10, 10
         COLOR sysbg, sysfg
         PRINT SPACE$(60);
         LOCATE 10, 10
         INPUT ; "Data file:", sysd$
         sysd$ = UCASE$(sysd$)
         stat = OpenDataFile(sysd$, 0)
         IF stat = 0 THEN
            ok = TRUE
            sysdata$ = sysd$
            ClearMsgArea
         ELSEIF stat = 231 AND sysd$ <> "" THEN
            ClearMsgArea
            PRINT "'"; sysd$; "' does not exists.  Create (y/n)? ";
            yn$ = ""
            INPUT ; " ", yn$
            IF UCASE$(yn$) = "Y" THEN
               stat = CreateDataFile(sysd$, 720)
               IF stat THEN
                  ClearMsgArea
                  PRINT StatError$(stat); " <ERROR:"; stat; "creating data file '"; sysd$; "'";
               ELSE
                  stat = OpenDataFile(sysd$, 0)
                  IF stat = 0 THEN
                     ok = TRUE
                     sysdata$ = sysd$
                     ClearMsgArea
                  ELSE
                     ClearMsgArea
                     PRINT StatError$(stat); " <ERROR:"; stat; "opening data file '"; sysd$; "'";
                  END IF
               END IF
            END IF
         ELSEIF sysd$ <> "" THEN
            ClearMsgArea
            PRINT StatError$(stat); " with '"; sysd$; "' <ERROR:"; stat;
         END IF
         COLOR sysfg, sysbg
         BackWindow MiscSave(), 10, 10, 10, 70
      LOOP UNTIL ok OR sysd$ = ""
      ClearMsgArea
     
   CASE 2  '{select the index file}
      ok = FALSE
      SaveWindow MiscSave(), 10, 10, 10, 70
      DO
         LOCATE 10, 10
         COLOR sysbg, sysfg
         PRINT SPACE$(60);
         LOCATE 10, 10
         INPUT ; "Index file:", sysi$
         sysi$ = UCASE$(sysi$)
         stat = OpenKeyFile(sysi$, 0)
         IF stat = 0 THEN
            ok = TRUE
            sysindex$ = sysi$
            ClearMsgArea
         ELSEIF stat = 231 AND sysi$ <> "" THEN
            ClearMsgArea
            PRINT "'"; sysi$; "' does not exists.  Create (y/n)? ";
            INPUT ; " ", yn$
            IF UCASE$(yn$) = "Y" THEN
               stat = CreateKeyFile(sysi$, 24)
               IF stat THEN
                  ClearMsgArea
                  PRINT StatError$(stat); " <ERROR:"; stat; "creating key file '"; sysi$; "'";
               ELSE
                  stat = OpenKeyFile(sysi$, 0)
                  IF stat = 0 THEN
                     ok = TRUE
                     sysindex$ = sysi$
                     ClearMsgArea
                  ELSE
                     ClearMsgArea
                     PRINT StatError$(stat); " <ERROR:"; stat; "opening key file '"; sysi$; "'";
                  END IF
               END IF
            END IF
         ELSEIF sysi$ <> "" THEN
            ClearMsgArea
            PRINT StatError$(stat); " with '"; sysi$; "' <ERROR:"; stat;
         END IF
         COLOR sysfg, sysbg
         BackWindow MiscSave(), 10, 10, 10, 70
      LOOP UNTIL ok OR sysi$ = ""
      ClearMsgArea
     
   CASE 3  '{show the data and index files being used}
      SaveWindow MiscSave(), 8, 5, 11, 75
      LOCATE 8, 10
      COLOR sysbg, sysfg
      FOR row = 8 TO 11
         LOCATE row, 5
         PRINT SPACE$(70)
      NEXT
      stat = StatDataFile(0, reclen, recs&, bf)
      LOCATE 9, 8
      IF stat = 0 THEN PRINT "data: "; RIGHT$(sysdata$, 28);
      LOCATE , 42
      PRINT " reclen:"; reclen, " records:"; recs&;
      stat = StatKeyFile(0, keylen, keys&, bf)
      LOCATE 10, 7
      IF stat = 0 THEN PRINT "index: "; RIGHT$(sysindex$, 28);
      LOCATE , 42
      PRINT " keylen:"; keylen, "    keys:"; keys&
      SLEEP 5
      BackWindow MiscSave(), 8, 5, 11, 75

   CASE 4  '{exit to DOS}
     stat = StatDataFile(0, reclen, recs&, bf)
     IF bf THEN stat = CloseDataFile(0)
     stat = StatKeyFile(0, keylen, keys&, bf)
     IF bf THEN stat = CloseKeyFile(0)
     CLOSE #lptfile                     '{close LPT1}
     LOCATE 24, 1
     SYSTEM

   CASE ELSE
   END SELECT
LOOP UNTIL code = EscKey OR code = -1

BackWindow WindowSave(), ulr, ulc, lrr, lrc
ERASE WindowSave
ERASE MiscSave

END SUB

SUB DropPitchWindow (lastkey)

SHARED NumberPitchOpts
SHARED PitchOpts$()

STATIC pp()
REDIM pp(1 TO 7)

lastkey = 0

ulr = 1
ulc = 29
lrr = ulr + NumberPitchOpts + 1         '{total line}
lrc = ulc + LEN(PitchOpts$(1)) - 1

REDIM WindowSave(1 TO (lrc - ulc + 1) * (lrr - ulr + 1)) AS INTEGER
SaveWindow WindowSave(), ulr, ulc, lrr, lrc

'{show the selections}
ChangeAttr ulr, ulc + 1, ulr, ulc + 6, sysfg, sysbg
LOCATE ulr + 1, ulc
COLOR sysbg, sysfg
FOR i = 1 TO NumberPitchOpts
   LOCATE , ulc
   PRINT PitchOpts$(i);
   LOCATE , ulc
   IF pp(i) THEN PRINT "  ON" ELSE PRINT " OFF"
NEXT
LOCATE , ulc
t$ = "VALUE:     "
t$ = SPACE$((LEN(PitchOpts$(1)) - LEN(t$))) + t$
PRINT t$
value = 0
FOR i = 1 TO 7
   value = value + (2 ^ (i - 1) * pp(i) * -1)
NEXT
LOCATE ulr + NumberPitchOpts + 1, ulc + LEN(PitchOpts$(1)) - 5
PRINT value;
COLOR sysfg, sysbg

ptr = 0
lastptr = ptr
DO
   GetMoveKey NumberPitchOpts, ulr, ulc + 4, lrr, lrc, code, lastkey, lastptr, ptr
   IF ptr > 0 AND ptr <= NumberPitchOpts THEN
      pp(ptr) = NOT pp(ptr)
      LOCATE ulr + 1, ulc
      COLOR sysbg, sysfg
      LOCATE ulr + ptr, ulc
      IF pp(ptr) THEN PRINT "  ON" ELSE PRINT " OFF"
      LOCATE ulr + NumberPitchOpts + 1, ulc + LEN(PitchOpts$(1)) - 5
      value = 0
      FOR i = 1 TO 7
         value = value + (2 ^ (i - 1) * pp(i) * -1)
      NEXT
      PRINT value;
      COLOR sysfg, sysbg
   END IF
LOOP UNTIL code = EscKey OR code = -1
                                
BackWindow WindowSave(), ulr, ulc, lrr, lrc
ERASE WindowSave

END SUB

SUB DropPrintWindow (lastkey)

SHARED NumberPrintOpts
SHARED PrintOpts$()
SHARED PC$()

lastkey = 0

ulr = 1
ulc = 19
lrr = ulr + NumberPrintOpts
lrc = ulc + LEN(PrintOpts$(1)) - 1
REDIM WindowSave(1 TO (lrc - ulc + 1) * (lrr - ulr + 1)) AS INTEGER
REDIM MiscSave(1 TO (80 * 25)) AS INTEGER

SaveWindow WindowSave(), ulr, ulc, lrr, lrc

'{show the selections}
ChangeAttr ulr, ulc + 1, ulr, ulc + 5, sysfg, sysbg
LOCATE ulr + 1, ulc
COLOR sysbg, sysfg
FOR i = 1 TO NumberPrintOpts
   LOCATE , ulc
   PRINT PrintOpts$(i)
NEXT

ptr = 0
lastptr = ptr
DO
   GetMoveKey NumberPrintOpts, ulr, ulc, lrr, lrc, code, lastkey, lastptr, ptr
  
   SELECT CASE ptr
   CASE 0
   '{must have hit Esc}
   
   CASE 1  '{print label}
      ClearMsgArea
      PRINT "Printing label";
      PrintLabel
      ClearMsgArea

   CASE 2  '{edit printer codes}
      ClearMsgArea
      ulr2 = 3
      ulc2 = 40
      lrr2 = ulr2 + 15
      lrc2 = ulc2 + 37
      SaveWindow MiscSave(), ulr2, ulc2, lrr2, lrc2
      COLOR sysbg, sysfg
      lastkey = Edit(1, 16, PC$(), sysbg, sysfg, 27, 0)
      BackWindow MiscSave(), ulr2, ulc2, lrr2, lrc2
  
   CASE ELSE
   END SELECT

LOOP UNTIL code = EscKey OR code = -1
                                 
BackWindow WindowSave(), ulr, ulc, lrr, lrc
ERASE WindowSave
ERASE MiscSave

END SUB

SUB DropTypeWindow (lastkey)

SHARED NumberTypeOpts
SHARED TypeOpts$()

STATIC pt()
REDIM pt(1 TO 8)

lastkey = 0

ulr = 1
ulc = 39
lrr = ulr + NumberTypeOpts + 1         '{total line}
lrc = ulc + LEN(TypeOpts$(1)) - 1

REDIM WindowSave(1 TO (lrc - ulc + 1) * (lrr - ulr + 1)) AS INTEGER
SaveWindow WindowSave(), ulr, ulc, lrr, lrc

'{show the selections}
ChangeAttr ulr, ulc + 1, ulr, ulc + 4, sysfg, sysbg
LOCATE ulr + 1, ulc
COLOR sysbg, sysfg
FOR i = 1 TO NumberTypeOpts
   LOCATE , ulc
   PRINT TypeOpts$(i);
   LOCATE , ulc
   IF pt(i) THEN PRINT "  ON" ELSE PRINT " OFF"
NEXT
LOCATE , ulc
t$ = "VALUE:     "
t$ = SPACE$((LEN(TypeOpts$(1)) - LEN(t$))) + t$
PRINT t$
value = 0
FOR i = 1 TO 8
   value = value + (2 ^ (i - 1) * pt(i) * -1)
NEXT
LOCATE ulr + NumberTypeOpts + 1, ulc + LEN(TypeOpts$(1)) - 5
PRINT value
COLOR sysfg, sysbg

ptr = 0
lastptr = ptr
DO
   GetMoveKey NumberTypeOpts, ulr, ulc + 4, lrr, lrc, code, lastkey, lastptr, ptr
   IF ptr > 0 AND ptr <= NumberTypeOpts THEN
      pt(ptr) = NOT pt(ptr)
      LOCATE ulr + 1, ulc
      COLOR sysbg, sysfg
      LOCATE ulr + ptr, ulc
      IF pt(ptr) THEN PRINT "  ON" ELSE PRINT " OFF"
      LOCATE ulr + NumberTypeOpts + 1, ulc + LEN(TypeOpts$(1)) - 5
      value = 0
      FOR i = 1 TO 8
         value = value + (2 ^ (i - 1) * pt(i) * -1)
      NEXT
      PRINT value
      COLOR sysfg, sysbg
   END IF
LOOP UNTIL code = EscKey OR code = -1
                               
BackWindow WindowSave(), ulr, ulc, lrr, lrc
ERASE WindowSave

END SUB

FUNCTION Edit (lb, ub, prompt$(), fg, bg, exitkey, flag)

xitkey = exitkey
cr = CSRLIN
cl = POS(0)

WPrint lb, ub, prompt$(), fg, bg
WEdit lb, ub, prompt$(), fg, bg, xitkey, flag '{xitkey = last key in Wedit}

LOCATE cr, cl
Edit = xitkey

END FUNCTION

SUB GetCommandLineFile

c$ = COMMAND$
IF c$ <> "" THEN
   sysd$ = c$ + ".DAT"
   sysi$ = c$ + ".IND"
   stat = OpenDataFile(sysd$, 0)
   IF stat = 0 THEN
      sysdata$ = sysd$
   ELSE
      ClearMsgArea
      PRINT StatError$(stat); " with '"; sysd$; "' <ERROR:"; stat;
      SLEEP 2
      ClearMsgArea
      SLEEP 1
   END IF
   stat = OpenKeyFile(sysi$, 0)
   IF stat = 0 THEN
      sysindex$ = sysi$
   ELSE
      ClearMsgArea
      PRINT StatError$(stat); " with '"; sysi$; "' <ERROR:"; stat;
      SLEEP 2
   END IF
END IF

END SUB

FUNCTION GetKeyCode (xcode)

DO
   i$ = INKEY$
LOOP WHILE i$ = ""
code = ASC(i$)
xcode = FALSE
IF code = 0 THEN code = ASC(RIGHT$(i$, 1)): xcode = TRUE
GetKeyCode = code

END FUNCTION

SUB GetMoveKey (NumberOpts, ulr, ulc, lrr, lrc, code, lastkey, lastptr, ptr)

sel = FALSE
DO
   code = GetKeyCode(xcode)
   SELECT CASE code
   CASE CursorDown
      IF xcode THEN
         lastptr = ptr
         ptr = ptr + 1
         IF ptr > NumberOpts THEN ptr = 1
      END IF

   CASE CursorUp
      IF xcode THEN
         lastptr = ptr
         ptr = ptr - 1
         IF ptr < 1 THEN ptr = NumberOpts
      END IF

   CASE CursorRight
      lastkey = CursorRight
      ptr = 0
      code = -1

   CASE CursorLeft
      lastkey = CursorLeft
      ptr = 0
      code = -1

   CASE EnterKey
      IF ptr <> 0 THEN sel = TRUE

   CASE EscKey
      ptr = 0
      lastkey = EscKey

   CASE ELSE
   END SELECT

   IF ptr <> lastptr THEN
      IF lastptr <> 0 THEN ChangeAttr ulr + lastptr, ulc + 1, ulr + lastptr, lrc - 1, sysbg, sysfg
      ChangeAttr ulr + ptr, ulc + 1, ulr + ptr, lrc - 1, sysfg, sysbg
      lastptr = ptr
   END IF
LOOP UNTIL sel = TRUE OR code = EscKey OR code = -1

END SUB

SUB MoveRec2Prompt (rec$)

SHARED prompt$()

sp = 1
FOR i = 1 TO 50 STEP 5
   prompt$(i, 2) = MID$(rec$, sp, 60)
   sp = sp + 60
   prompt$(i + 1, 2) = MID$(rec$, sp, 3)
   sp = sp + 3
   prompt$(i + 2, 2) = MID$(rec$, sp, 3)
   sp = sp + 3
   prompt$(i + 3, 2) = MID$(rec$, sp, 3)
   sp = sp + 3
   prompt$(i + 4, 2) = MID$(rec$, sp, 3)
   sp = sp + 3
NEXT

END SUB

SUB ParsePC

SHARED PC$()
SHARED prePC$()
SHARED postPC$()

FOR i = 1 TO 16
   t$ = PC$(i, 2)
   IF RTRIM$(t$) <> "" THEN
      backslash = INSTR(t$, "\")
      IF backslash THEN
         prePC$(i) = LEFT$(t$, backslash - 1)
         postPC$(i) = MID$(t$, backslash + 1)
      ELSE
         prePC$(i) = t$
         postPC$(i) = ""
      END IF
   END IF
NEXT

END SUB

SUB PrintLabel

SHARED prompt$()
SHARED prePC$()
SHARED postPC$()
SHARED PC$()
SHARED lptfile

ParsePC

FOR i = 1 TO 50 STEP 5
   ln$ = prompt$(i, 2)
   cnt = 0
   ln$ = LTRIM$(RTRIM$(ln$))
   IF LEN(ln$) THEN
      prepitch$ = ""
      postpitch$ = ""
      pretype$ = ""
      posttype$ = ""
      of = VAL(prompt$(i + 1, 2))
      pp = VAL(prompt$(i + 2, 2))
      pt = VAL(prompt$(i + 3, 2))
      pf = VAL(prompt$(i + 4, 2))
    
      IF pp AND 1 THEN prepitch$ = prepitch$ + prePC$(1) + ","
      IF pp AND 2 THEN prepitch$ = prepitch$ + prePC$(2) + ","
      IF pp AND 4 THEN prepitch$ = prepitch$ + prePC$(3) + ","
      IF pp AND 8 THEN prepitch$ = prepitch$ + prePC$(4) + ","
      IF pp AND 16 THEN prepitch$ = prepitch$ + prePC$(5) + ","
      IF pp AND 32 THEN prepitch$ = prepitch$ + prePC$(6) + ","
      IF pp AND 64 THEN prepitch$ = prepitch$ + prePC$(7)
   
      IF pp AND 1 THEN postpitch$ = postpitch$ + postPC$(1) + ","
      IF pp AND 2 THEN postpitch$ = postpitch$ + postPC$(2) + ","
      IF pp AND 4 THEN postpitch$ = postpitch$ + postPC$(3) + ","
      IF pp AND 8 THEN postpitch$ = postpitch$ + postPC$(4) + ","
      IF pp AND 16 THEN postpitch$ = postpitch$ + postPC$(5) + ","
      IF pp AND 32 THEN postpitch$ = postpitch$ + postPC$(6) + ","
      IF pp AND 64 THEN postpitch$ = postpitch$ + postPC$(7)

      IF pt AND 1 THEN pretype$ = pretype$ + prePC$(9) + ","
      IF pt AND 2 THEN pretype$ = pretype$ + prePC$(10) + ","
      IF pt AND 4 THEN pretype$ = pretype$ + prePC$(11) + ","
      IF pt AND 8 THEN pretype$ = pretype$ + prePC$(12) + ","
      IF pt AND 16 THEN pretype$ = pretype$ + prePC$(13) + ","
      IF pt AND 32 THEN pretype$ = pretype$ + prePC$(14) + ","
      IF pt AND 64 THEN pretype$ = pretype$ + prePC$(15) + ","
      IF pt AND 128 THEN pretype$ = pretype$ + prePC$(16)

      IF pt AND 1 THEN posttype$ = posttype$ + postPC$(9) + ","
      IF pt AND 2 THEN posttype$ = posttype$ + postPC$(10) + ","
      IF pt AND 4 THEN posttype$ = posttype$ + postPC$(11) + ","
      IF pt AND 8 THEN posttype$ = posttype$ + postPC$(12) + ","
      IF pt AND 16 THEN posttype$ = posttype$ + postPC$(13) + ","
      IF pt AND 32 THEN posttype$ = posttype$ + postPC$(14) + ","
      IF pt AND 64 THEN posttype$ = posttype$ + postPC$(15) + ","
      IF pt AND 128 THEN posttype$ = posttype$ + postPC$(16)

      pprec$ = Convert2ASCII$(prepitch$)
      ppostc$ = Convert2ASCII$(postpitch$)
      tprec$ = Convert2ASCII$(pretype$)
      tpostc$ = Convert2ASCII$(posttype$)
      offsetc$ = Convert2ASCII$(PC$(2, 2))
      ffc$ = ConvertLFpts$(pf)
      t$ = pprec$ + tprec$ + ffc$ + ln$ + ppostc$ + tpostc$
      IF of THEN PRINT #lptfile, offsetc$; SPACE$(of);
      PRINT #lptfile, t$
   END IF
NEXT

END SUB

SUB SaveWindow (WindowSave(), ulr, ulc, lrr, lrc)

'{save current window contents}
LOCATE , , 0                    '{cursor off}
ptr = 0
FOR row = ulr TO lrr
   FOR col = ulc TO lrc
      ptr = ptr + 1
      WindowSave(ptr) = SCREEN(row, col, 0) + SCREEN(row, col, 1) * 256
   NEXT
NEXT


END SUB

SUB ShowEsc (onoff)

COLOR sysbg, sysfg
LOCATE 1, 72
IF onoff THEN
   PRINT "Esc=back";
ELSE
   PRINT "        ";
END IF
COLOR sysfg, sysbg

END SUB

SUB ShowLabelInches

totalpts = 0
FOR i = 5 TO 50 STEP 5
   totalpts = totalpts + VAL(prompt$(i, 2))
NEXT
LOCATE 1, 60
PRINT USING "###.###"; totalpts / 72

END SUB

SUB ShowTitleScreen

CLS
COLOR sysbg, sysfg
t1$ = "  File    Edit     Print  "
t1$ = t1$ + SPACE$(80 - LEN(t1$))
PRINT t1$
LOCATE 1, 53
PRINT "Inches:"
ShowLabelInches
t1$ = "use <Alt><first letter>    MAILAB  Mail Label Generator "
'{make sure that t1$ is even in len}
pad$ = SPACE$((80 - LEN(t1$)) \ 2)
t1$ = pad$ + t1$ + pad$
LOCATE 25, 1
PRINT t1$;
COLOR sysfg, sysbg
t1$ = " Contents "
pad$ = STRING$(((60 - LEN(t1$)) \ 2), 196)
t1$ = pad$ + t1$ + pad$
LOCATE 9, 4
PRINT t1$;

LOCATE 9, 65
PRINT "Ofs"
LOCATE 9, 69
PRINT "Pit"
LOCATE 9, 73
PRINT "Typ"
LOCATE 9, 77
PRINT "LFpt";
WPrint 1, 50, prompt$(), sysfg, sysbg

END SUB

SUB WEdit (lb, ub, prompt$(), fg, bg, xitkey, flag)
   
REDIM LineSave(1 TO 80 * 2)
REDIM MiscSave(1 TO 80 * 25)

IF flag THEN                            'flag=TRUE if in editwindow
   SaveWindow LineSave(), 1, 1, 1, 80
   COLOR sysbg, sysfg
   LOCATE 1, 1
   PRINT SPACE$(50);
   LOCATE 1, 30
   PRINT "Pitch"
   LOCATE 1, 40
   PRINT "Type"
   COLOR sysfg, sysbg
END IF

done = FALSE
fld = lb
LastField = fld - 1   'must be unequal to fld at first
r = VAL(MID$(prompt$(fld, 1), 1))
c = VAL(MID$(prompt$(fld, 1), 4)) + LEN(prompt$(fld, 1)) - 11
col = c
DO
   GOSUB RevField
   r = VAL(MID$(prompt$(fld, 1), 1))
   XPrint prompt$(fld, 2), r, col, bg, fg
   IF prompt$(fld, 3) <> "" THEN        '{print help info}
      XPrint prompt$(fld, 3) + SPACE$(80 - LEN(prompt$(fld, 3))), 25, 1, bg, fg
   END IF
   LOCATE r, c, 1
   DO
      i$ = INKEY$
   LOOP WHILE i$ = ""
   code = ASC(i$)
   xcode = 0
   IF code > 31 AND code < 127 THEN
      GOSUB CheckFormat
      IF ValidKey THEN
         MID$(prompt$(fld, 2), c - col + 1, 1) = i$
         XPrint i$, r, c, bg, fg
         GOSUB RIGHT
      ELSE
         SOUND 999, 1
      END IF
   ELSE
      IF code = EnterKey THEN
         IF EndOfFld THEN
            'all characters valid
         ELSEIF c > col THEN
            IF typ$ = "N" OR typ$ = "M" OR typ$ = "D" THEN
               prompt$(fld, 2) = LEFT$(prompt$(fld, 2), c - col)
            END IF
         ELSE
            prompt$(fld, 2) = prompt$(fld, 2)
         END IF
         WPrint fld, fld, prompt$(), fg, bg
         
         IF flag THEN
            COLOR sysbg, sysfg
            ShowLabelInches
            COLOR sysfg, sysbg
         END IF

         IF fld < ub THEN
            fld = fld + 1
            r = VAL(MID$(prompt$(fld, 1), 1))
            c = VAL(MID$(prompt$(fld, 1), 4)) + LEN(prompt$(fld, 1)) - 11
            col = c
         ELSE
            done = TRUE
         END IF
         GOSUB NormField
      END IF
         
      xcode = FALSE
      IF code = 0 THEN code = ASC(RIGHT$(i$, 1)): xcode = TRUE
      IF xcode AND code = DropPitch THEN
         DropPitchWindow lastkey
      ELSEIF xcode AND code = DropType THEN
         DropTypeWindow lastkey
      ELSE
         SELECT CASE code
            CASE BackSpace
               IF c > col THEN c = c - 1: GOSUB ZapChar: EndOfFld = FALSE
            CASE CursorRight
               IF xcode THEN GOSUB RIGHT
            CASE CursorLeft
               IF xcode THEN IF c > col THEN c = c - 1: EndOfFld = FALSE
            CASE EndKey
               IF xcode THEN c = col + VAL(MID$(prompt$(fld, 1), 7)) - 1: EndOfFld = TRUE
            CASE HomeKey
               IF xcode THEN c = col: EndOfFld = FALSE
            CASE TabRight
               IF fld < ub THEN fld = fld + 1 ELSE fld = lb
               GOSUB NormField: GOSUB CheckRC
            CASE CursorDown
               IF xcode THEN
                  IF fld < ub THEN fld = fld + 1 ELSE fld = lb
                  GOSUB NormField: GOSUB CheckRC
                  EndOfFld = FALSE
               END IF
            CASE TabLeft
               IF xcode THEN
                  IF fld > lb THEN fld = fld - 1 ELSE fld = ub
                  GOSUB NormField: GOSUB CheckRC
                  EndOfFld = FALSE
               END IF
            CASE CursorUp
               IF xcode THEN
                  IF fld > lb THEN fld = fld - 1 ELSE fld = ub
                  GOSUB NormField: GOSUB CheckRC
                  EndOfFld = FALSE
               END IF
            CASE DeleteKe          '...ke so we don't clash with DeleteKey()
               IF xcode THEN GOSUB ZapChar
            CASE InsertKey
               IF xcode THEN GOSUB Insert
            CASE PgUpKey
               IF xcode THEN GOSUB NormField: GOSUB FirstFld
            CASE PgDnKey
               IF xcode THEN GOSUB NormField: GOSUB LastFld
            CASE DeleteToEOLKey
               GOSUB DeleteToEOL
            CASE EscKey
               GOSUB NormField
               done = TRUE
            CASE HelpKey
               IF xcode THEN
               END IF

            CASE ELSE
         END SELECT
      END IF
   END IF
LOOP UNTIL done
LOCATE , , 0
'{return last key code to caller}
xitkey = code
IF flag THEN BackWindow LineSave(), 1, 1, 1, 80
COLOR sysfg, sysbg

EXIT SUB

'* local SR to FSEDIT

RIGHT:
      IF c < col + VAL(MID$(prompt$(fld, 1), 7)) - 1 THEN
         c = c + 1
         EndOfFld = FALSE
      ELSE
         EndOfFld = TRUE
      END IF
      RETURN

ZapChar:
      prompt$(fld, 2) = LEFT$(prompt$(fld, 2), c - col) + MID$(prompt$(fld, 2), c - col + 2, VAL(MID$(prompt$(fld, 1), 7)) - c + col - 1) + " "
      r = VAL(MID$(prompt$(fld, 1), 1))
      XPrint prompt$(fld, 2), r, col, bg, fg
      EndOfFld = FALSE
      RETURN

Insert:
      prompt$(fld, 2) = LEFT$(LEFT$(prompt$(fld, 2), c - col) + " " + MID$(prompt$(fld, 2), c - col + 1), VAL(MID$(prompt$(fld, 1), 7)))
      r = VAL(MID$(prompt$(fld, 1), 1))
      XPrint prompt$(fld, 2), r, col, bg, fg
      EndOfFld = FALSE
      RETURN

FirstFld:
      fld = lb
      r = VAL(MID$(prompt$(fld, 1), 1))
      c = VAL(MID$(prompt$(fld, 1), 4)) + LEN(prompt$(fld, 1)) - 11
      col = c
      EndOfFld = FALSE
      RETURN

LastFld:
      fld = ub
      r = VAL(MID$(prompt$(fld, 1), 1))
      c = VAL(MID$(prompt$(fld, 1), 4)) + LEN(prompt$(fld, 1)) - 11
      col = c
      EndOfFld = FALSE
      RETURN

DeleteToEOL:
      XPrint STRING$(VAL(MID$(prompt$(fld, 1), 7)) - (c - col), " "), CSRLIN, c, bg, fg
      FOR i = (c - col + 1) TO VAL(MID$(prompt$(fld, 1), 7))
         MID$(prompt$(fld, 2), i, 1) = " "
      NEXT
      EndOfFld = FALSE
      WPrint fld, fld, prompt$(), fg, bg
      RETURN

CheckFormat:
      typ$ = UCASE$(MID$(prompt$(fld, 1), 10, 1))
      ValidKey = TRUE
      SELECT CASE typ$
         CASE "A"
            '{nothing}
         CASE "U"
            i$ = UCASE$(i$)
         CASE "L"
            i$ = UCASE$(i$)
            IF i$ <> "T" AND i$ <> "F" AND i$ <> "Y" AND i$ <> "N" THEN ValidKey = FALSE
         CASE "N", "M"
            IF INSTR("0123456789.-+ ", i$) = 0 THEN ValidKey = FALSE
         CASE "D"
            IF INSTR("0123456789 ", i$) = 0 THEN ValidKey = FALSE
         CASE ELSE
      END SELECT
      RETURN

RevField:
      LastField = fld
      LastRow = r
      LastCol = col
      LenField = VAL(MID$(prompt$(fld, 1), 7))
      LastLength = LenField
      'ChangeAttr is too slow in QB, just print the field in reverse
      'ChangeAttr r, col, r, (col + LenField - 1), bg, fg
      RETURN

CheckRC:
      r = VAL(MID$(prompt$(fld, 1), 1))
      c = VAL(MID$(prompt$(fld, 1), 4)) + LEN(prompt$(fld, 1)) - 11
      col = c
      RETURN

NormField:
      ChangeAttr LastRow, LastCol, LastRow, (LastCol + LastLength - 1), fg, bg
      RETURN

END SUB

'PROMPT$() FORMAT ----------------------------------------------------
'
'2-dimensional variable-length string array
'  for each data entry variable:
'     prompt$(i,1) = "rr/cc/al/t/prompt string"
'     - rr,cc = start of prompt string's screen position (1-25,1-80)
'     - al    = maximum length of answer response (into prompt$(i,2))
'     - t     = type of edit mask:
'               - a = alphanumeric
'               - m = decimal value (.00 minimum)
'               - n = number
'               - d = only 0-9 keys (use separate prompt for mo/da/yr)
'               - l = logical (1-character Y N T F)
'
'responses are formatted into prompt$(i,2)
'help line data is in prompt$(i,3)
'current QB cursor position preserved
'last key pressed (i.e. the Esc or ENTER) is returned by Edit()
'
SUB WPrint (lb, ub, prompt$(), fg, bg)

FOR i = lb TO ub
   CurrStr$ = prompt$(i, 1)
   row = VAL(CurrStr$)
   col = VAL(MID$(CurrStr$, 4))
   length = VAL(MID$(CurrStr$, 7))
   typ$ = UCASE$(MID$(CurrStr$, 10, 1))
      
   SELECT CASE typ$
   CASE "M"
      Number = TRUE
      temp$ = RTRIM$(LTRIM$(prompt$(i, 2)))
      xsp = INSTR(temp$, " ")
      IF xsp = 0 THEN xsp = LEN(prompt$(i, 2)) ELSE xsp = xsp - 1
      prompt$(i, 2) = LEFT$(temp$, xsp)
      temp# = VAL(prompt$(i, 2))
      prompt$(i, 2) = LTRIM$(STR$(temp#))
      DecPos = INSTR(prompt$(i, 2), ".")
      IF DecPos = 0 THEN
         prompt$(i, 2) = prompt$(i, 2) + ".00"
      ELSEIF LEN(prompt$(i, 2)) - DecPos = 1 THEN
         prompt$(i, 2) = prompt$(i, 2) + "0"
      END IF
   CASE "N"
      Number = TRUE
      temp$ = LTRIM$(prompt$(i, 2))
      xsp = INSTR(temp$, " ")
      IF xsp = 0 THEN xsp = LEN(prompt$(i, 2)) ELSE xsp = xsp - 1
      prompt$(i, 2) = LEFT$(temp$, xsp)
      temp# = VAL(prompt$(i, 2))
      prompt$(i, 2) = LTRIM$(STR$(temp#))
   CASE ELSE
      Number = FALSE
   END SELECT

   IF Number THEN
      prompt$(i, 2) = RIGHT$(prompt$(i, 2), length)     'the decimal
      prompt$(i, 2) = STRING$(length - LEN(prompt$(i, 2)), " ") + prompt$(i, 2)
   ELSE
      prompt$(i, 2) = prompt$(i, 2) + STRING$(length - LEN(prompt$(i, 2)), " ")
   END IF

   XPrint MID$(prompt$(i, 1), 12) + prompt$(i, 2), row, col, fg, bg
      
NEXT

END SUB

SUB XPrint (strg$, row, col, fg, bg)

oldrow = CSRLIN
oldcol = POS(0)
COLOR fg, bg
LOCATE row, col, 0      '{leave the cursor off}
PRINT strg$;
COLOR sysfg, sysbg
LOCATE oldrow, oldcol

END SUB

