
	''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	'                                     ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,    '
	' Robert Seace                        ; QB Mouse Support Routines ;    '
	' RFD 2  Box 229                      '''''''''''''''''''''''''''''    '
	' Littleton, NH  03561                  Feel free to distribute!       '
	'                                                                      '
	''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	'                        Filename: MOUSE.BAS                           '
	''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	  
	' Note: To use these routines, you must either link in the compiled
	'       object code (MOUSE.OBJ) and the QB.LIB library, or simply use
	'       the included MOUSE.LIB library.  At the linker's prompt for
	'       libraries, type "mouse.lib" (actually, I would probably type
	'       "bcom45.lib+mouse.lib", which would also link in the compile
	'       time library to produce a stand-alone executable file, as well).
	'       Using this MOUSE.LIB method, you need not bother to link in the
	'       MOUSE.OBJ object code along with your own compiled object code,
	'       nor do you need to link in the QB.LIB library, as it is already
	'       contained within the MOUSE.LIB library.  Simply include MOUSE.BI
	'       at the top of your code (use the "'$include: 'mouse.bi'"
	'       metacommand; note that it must be within a comment, and there
	'       should be only spaces/tabs next to the dollar sign, unless it
	'       is put directly next to the FIRST single-quote (apostrophe)
	'       marking the comment), then compile your code, and link it with
	'       the MOUSE.LIB library, and you'll be all set.
	'       If you want to use the mouse functions within the QB environment,
	'       use the MOUSE.QLB QuickLibrary (start QB using the /L parameter:
	'       "qb /L mouse").
	
	'$INCLUDE: 'mouse.bi'

	DIM SHARED inreg AS RegType   ' Input Registers; used in CALL INTERRUPT
	DIM SHARED outreg AS RegType  ' Output Registers; used in CALL INTERRUPT
	DIM SHARED inregx AS RegTypeX  ' Extended Input Registers w/ segment
	DIM SHARED outregx AS RegTypeX ' Extended Output Registers w/ segment

	' Internal variables used by various mouse functions
	DIM SHARED mINIT AS INTEGER, mGRAPHICS AS INTEGER
	DIM SHARED mXlast AS INTEGER, mYlast AS INTEGER
	mINIT = 0
	mGRAPHICS = 0
	mXlast = 0
	mYlast = 0

	FUNCTION MouseButton (event AS MouseEvent, debounce AS INTEGER)
	' ---------------------------=< MouseButton >=-------------------------
	' Detects whether or not a mouse button has been pressed.  Works the
	' same way as MouseMove (returns TRUE and updates passed MouseEvent
	' structure if button pressed, else returns FALSE).  The second
	' parameter of the function determines whether or not the buttons will
	' be "debounced" after reading a press.  Debouncing means that the
	' function will wait until the button is no longer pressed anymore
	' before it returns to the caller.  This is a good thing to use,
	' because a single click of a mouse button can often produce several
	' button-press events, due to the sensitivity of the mouse buttons.
	' Using the debounce option (passing TRUE, or any non-zero value, as
	' the second parameter) eliminates these extra button-press events and
	' prevents possible problems with thinking the user has clicked more
	' than he has.  However, I left the option of not debouncing because
	' it is possible you may want to keep track of held-down buttons (for
	' dragging the mouse through pull-down menus, or other such things
	' where the user must hold down the button); in this case, simply pass
	' FALSE (0) as the second parameter.

		IF mINIT = 0 THEN           ' Not initialized/available
			MouseButton = 0
			EXIT FUNCTION
		END IF

		inreg.ax = 3
		CALL INTERRUPT(&H33, inreg, outreg)     ' Get pos/button info
		IF outreg.bx > 0 THEN           ' a button(s) is pressed
			event.buttons = outreg.bx
			IF mGRAPHICS = 0 THEN       ' text mode
				outreg.cx = INT(outreg.cx / 8) + 1
				outreg.dx = INT(outreg.dx / 8) + 1
			ELSEIF mGRAPHICS = 1 THEN   ' graphics mode 1
				outreg.cx = INT(outreg.cx / 2)
			END IF
			event.x = outreg.cx
			event.y = outreg.dx
			mXlast = outreg.cx
			mYlast = outreg.dx
			IF debounce <> 0 THEN       ' User wants to debounce buttons
				WHILE outreg.bx > 0     ' While a button(s) is pressed...
					CALL INTERRUPT(&H33, inreg, outreg) ' get pos/button info
				WEND
			END IF
			MouseButton = NOT 0
		ELSE
			MouseButton = 0
		END IF
	END FUNCTION

	SUB MouseGetInfo (event AS MouseEvent)
	' --------------------------=< MouseGetInfo >=--------------------------
	' This subroutine gets the position of mouse pointer (actual screen
	' position, dependent upon screen mode), and the button info, whether
	' or not there is a new event (position has changed or button pressed).
	' The info is returned through the event parameter passed to it.
	' Note: Calling this subroutine updates the last known values for the
	' position of the mouse pointer, so that even if the position IS new
	' (it has moved), then calling MouseMove after calling this will NOT
	' reveal the change in position, as you've chosen to ignore the move
	' by calling this subroutine.
	' Note: No debouncing at all is done in this subroutine.  It simply
	' gives you the current status of the buttons, without caring whether
	' any of them are pressed or not.

		IF mINIT = 0 THEN           ' Not initialized/available
			EXIT SUB
		END IF
	   
		inreg.ax = 3
		CALL INTERRUPT(&H33, inreg, outreg)     ' Get position/button info
		IF mGRAPHICS = 0 THEN       ' Text mode
			outreg.cx = INT(outreg.cx / 8) + 1
			outreg.dx = INT(outreg.dx / 8) + 1
		ELSEIF mGRAPHICS = 1 THEN   ' Graphics mode 1
			outreg.cx = INT(outreg.cx / 2)
		END IF
		event.x = outreg.cx
		event.y = outreg.dx
		event.buttons = outreg.bx
		mXlast = outreg.cx
		mYlast = outreg.dx
	END SUB

	SUB MouseGraphicsPtr (hotx AS INTEGER, hoty AS INTEGER, map AS BitMap)
	' ----------------------=< MouseGraphicsPtr >=------------------------
	' The graphics-mode version of MouseTextPrt.  You pass it the position
	' of the cursor hot-spot within the bitmap, and the actual 16 bit X
	' 16 bit bitmap you want to use as the new pointer shape, as well as a
	' similar such bitmap for the screen mask (this first gets ANDed with
	' what is on the screen where the pointer is, then the pointer's bitmap
	' gets XORed with the result of that).  There is a type defined (BitMap)
	' which contains the 32 integers (each 16 bits) necessary to hold both
	' of these bitmaps.

		IF mINIT = 0 OR mGRAPHICS = 0 THEN ' Not init., or in text mode
			EXIT SUB
		END IF

		inregx.ax = 9
		inregx.bx = hotx
		inregx.cx = hoty
		inregx.dx = VARPTR(map)   ' location of variable; offset from segment
		inregx.es = VARSEG(map)   ' location of variable's segment
		CALL INTERRUPTX(&H33, inregx, outregx)  ' define graphics cursor
	END SUB

	SUB MouseHide
	' ----------------------------=< MouseHide >=--------------------------
	' Hides the mouse pointer (shuts it off).  I advise hiding before every
	' CLS, then turning it back on with MouseShow after screen is fully
	' drawn (especially if changing screen color).  Otherwise, the pointer
	' may interfere with stuff being drawn on the screen.

		IF mINIT = 0 THEN           ' Not initialized/available
			EXIT SUB
		END IF

		inreg.ax = 2
		CALL INTERRUPT(&H33, inreg, outreg)     ' Hide the pointer
	END SUB

	FUNCTION MouseInit (mode AS INTEGER)
	' ---------------------------=< MouseInit >=---------------------------
	' Function which initializes the mouse for use.  The argument passed
	' should be 0 for normal text-mode (80 columns X 25 rows) screen, or
	' 1 for graphics-mode resolution 1 (320 X 200), or 2 for graphics-mode
	' resolution 2 (640 X 200; same as mouse's own virtual screen).  The
	' return value is 0 if no mouse is available for use, otherwise it is
	' the number of buttons available on the mouse.

		mGRAPHICS = mode
		inreg.ax = 0
		CALL INTERRUPT(&H33, inreg, outreg)     ' Reset mouse
		mINIT = outreg.ax
		IF mINIT <> 0 THEN           ' If a mouse is available...
			IF outreg.bx <> 0 THEN
				mINIT = outreg.bx   ' set # of buttons
			END IF
			inreg.ax = 7
			inreg.cx = 0            ' min column
			inreg.dx = 639          ' max column
			CALL INTERRUPT(&H33, inreg, outreg) ' Set min/max column
			inreg.ax = 8
			inreg.cx = 0            ' min row
			inreg.dx = 199          ' max row
			CALL INTERRUPT(&H33, inreg, outreg) ' Set min/max row
			inreg.ax = 1
			CALL INTERRUPT(&H33, inreg, outreg) ' Turn on pointer
			inreg.ax = 3
			CALL INTERRUPT(&H33, inreg, outreg) ' Get init pos & button info
			IF mGRAPHICS = 0 THEN       ' Text mode; convert virtual pos
				mXlast = INT(outreg.cx / 8) + 1
				mYlast = INT(outreg.dx / 8) + 1
			ELSEIF mGRAPHICS = 1 THEN   ' Graphics mode 1; convert virtual X
				mXlast = INT(outreg.cx / 2)
				mYlast = outreg.dx
			ELSE                        ' Grpahics mode 2; no conversion
				mXlast = outreg.cx
				mYlast = outreg.dx
			END IF
		END IF
		MouseInit = mINIT
	END FUNCTION

	FUNCTION MouseMove (event AS MouseEvent)
	' ---------------------------=< MouseMove >=---------------------------
	' Detects whether or not the mouse has moved from its last position
	' (actual screen position, which is dependent upon screen mode).  If a
	' movement has occured, -1 (TRUE) is returned and the passed MouseEvent
	' structure is filled in with the appropriate info.  If no movement has
	' occured, then 0 (FALSE) is returned, and nothing is filled in on the
	' passed MouseEvent structure.  (Note: Even though the button info is
	' returned along with the position info if a movement has occurred, no
	' debouncing of buttons is done.)

		IF mINIT = 0 THEN           ' Not initialized/available
			MouseMove = 0
			EXIT FUNCTION
		END IF

		inreg.ax = 3
		CALL INTERRUPT(&H33, inreg, outreg)     ' Get position/button info
		IF mGRAPHICS = 0 THEN       ' Text mode
			outreg.cx = INT(outreg.cx / 8) + 1
			outreg.dx = INT(outreg.dx / 8) + 1
		ELSEIF mGRAPHICS = 1 THEN   ' Graphics mode 1
			outreg.cx = INT(outreg.cx / 2)
		END IF
		IF mXlast <> outreg.cx OR mYlast <> outreg.dx THEN  ' mouse has moved
			event.x = outreg.cx
			event.y = outreg.dx
			event.buttons = outreg.bx
			mXlast = outreg.cx
			mYlast = outreg.dx
			MouseMove = NOT 0
		ELSE
			MouseMove = 0
		END IF
	END FUNCTION

	FUNCTION MouseNewEvent (event AS MouseEvent)
	' --------------------------=< MouseNewEvent >=-------------------------
	' This is sort of a combination of MouseMove and MouseButton.  It will
	' return TRUE if either the mouse pointer has moved from its last
	' position, or if a button has been pressed.  (Note: Debouncing is not
	' optional in this function; it always debounces.  If you need no
	' debouncing, then you'll have to use MouseButton and MouseMove
	' individually.)  A call to this function is essentially equivalent to
	' "MouseButton(event, TRUE) OR MouseMove(event)".

		IF mINIT = 0 THEN           ' Not initialized/available
			MouseNewEvent = 0
			EXIT FUNCTION
		END IF

		inreg.ax = 3
		CALL INTERRUPT(&H33, inreg, outreg)     ' Get position/button info
		IF mGRAPHICS = 0 THEN       ' Text mode
			outreg.cx = INT(outreg.cx / 8) + 1
			outreg.dx = INT(outreg.dx / 8) + 1
		ELSEIF mGRAPHICS = 1 THEN   ' Graphics mode 1
			outreg.cx = INT(outreg.cx / 2)
		END IF
		IF mXlast <> outreg.cx OR mYlast <> outreg.dx OR outreg.bx > 0 THEN
			event.x = outreg.cx
			event.y = outreg.dx
			event.buttons = outreg.bx
			mXlast = outreg.cx
			mYlast = outreg.dx
			WHILE outreg.bx > 0 ' debounce; While a button(s) is pressed...
				CALL INTERRUPT(&H33, inreg, outreg) ' get pos/button info
			WEND
			MouseNewEvent = NOT 0
		ELSE
			MouseNewEvent = 0
		END IF
	END FUNCTION

	SUB MouseSetPos (x AS INTEGER, y AS INTEGER)
	' ---------------------------=< MouseSetPos >=-------------------------
	' Sets the position of the mouse pointer.  The x argument is the column
	' to move to, and the y argument is the row to move to.  (Range of
	' legal values determined by screen mode, as set by MouseInit.  For
	' text-mode 0: x is 1 - 80, y is 1 - 25.  For graphics-mode 1: x is
	' 0 - 319, y is 0 - 199.  For graphics-mode 2: x is 0 - 639, y is
	' 0 - 199.)

		IF mINIT = 0 THEN           ' Not initialized/available
			EXIT SUB
		END IF

		IF mGRAPHICS = 0 THEN       ' Text mode
			IF x >= 1 AND x <= 25 AND y >= 1 AND y <= 80 THEN   ' Legal pos
				inreg.ax = 4
				inreg.cx = (x - 1) * 8
				inreg.dx = (y - 1) * 8
				CALL INTERRUPT(&H33, inreg, outreg)     ' Set position
				mXlast = x
				mYlast = y
			END IF
		ELSEIF mGRAPHICS = 1 THEN   ' Graphics mode 1
			IF x >= 0 AND x <= 319 AND y >= 0 AND y <= 199 THEN ' Legal pos
				inreg.ax = 4
				inreg.cx = x * 2
				inreg.dx = y
				CALL INTERRUPT(&H33, inreg, outreg)     ' Set position
				mXlast = x
				mYlast = y
			END IF
		ELSE                        ' Graphics mode 2
			IF x >= 0 AND x <= 639 AND y >= 0 AND y <= 199 THEN ' Legal pos
				inreg.ax = 4
				inreg.cx = x
				inreg.dx = y
				CALL INTERRUPT(&H33, inreg, outreg)     ' Set position
				mXlast = x
				mYlast = y
			END IF
		END IF
	END SUB

	SUB MouseShow
	' ----------------------------=< MouseShow >=--------------------------
	' Shows the mouse pointer (turns it on).  See comments for MouseHide.
	' Pointer is automatically turned on initially by MouseInit.

		IF mINIT = 0 THEN           ' Not initialized/available
			EXIT SUB
		END IF

		inreg.ax = 1
		CALL INTERRUPT(&H33, inreg, outreg)     ' Show pointer
	END SUB

	SUB MouseTextPtr (scl AS INTEGER, sch AS STRING, cl AS INTEGER, ch AS STRING)
	' --------------------------=< MouseTextPtr >=----------------------------
	' This subroutine sets the color and shape of the text-mode mouse
	' pointer.  It normally defaults to simply a white block-cursor, but
	' you can change that with this subroutine.  The new pointer
	' attributes (cl, color of the pointer, and ch, character to use for the
	' pointer) will be XORed with the result of ANDing the screen attributes
	' (scl, screen color, and sch, screen character) with whatever is on the
	' screen where the pointer is to be, which will produce the color/shape
	' you see on the screen at that spot.  If you don't want the screen mask
	' to have any effect, just pass in an integer with all 1 bits (-1, TRUE,
	' or NOT 0 in Basic's two's complement method of storing integers).  The
	' colors and characters you pass in will be converted into bit masks.
	' Note: If you pass more than a single-character string as the char,
	' only the first character will be used.

		IF mINIT = 0 OR mGRAPHICS <> 0 THEN ' Not init., or not in text mode
			EXIT SUB
		END IF

		inreg.ax = &HA
		inreg.bx = 0
		inreg.cx = scl AND 127      ' ensure only 7-bit number
		inreg.dx = cl AND 127       ' ensure only 7-bit number
		inreg.cx = inreg.cx * 256   ' shift left by 8
		inreg.dx = inreg.dx * 256   ' shift left by 8
		inreg.cx = inreg.cx + ASC(LEFT$(sch, 1))    ' add char to bit mask
		inreg.dx = inreg.dx + ASC(LEFT$(ch, 1))     ' add char to bit mask
		CALL INTERRUPT(&H33, inreg, outreg)     ' define text cursor
	END SUB

