;;PC Pursuit: VERSAdial, Version 1.3, by Allen Brunson, David Rhoten, and Gizmo
;;(C) 1988, Allen Brunson

; ===== VARIABLE TABLE =======
;VERSA is consistent about its use of variables.  Here is a table describing
;how they are used, including the macros stored in VERSA.KEY.

;S0  PCP level (1 is offline, 2 is local, 3 is remote city)
;S1  City code
;S2  BBS phone number
;S3  Unused in this version
;S4  Unused in this version
;S5  Unused in this version
;S6  Unused in this version
;S7  Command file to execute upon connection with a BBS
;S8  RGETs
;S9  Secondary RGETs, user input, parameter passing from .MNU files

;MACROS IN VERSA.KEY:
;M7  Local Telenet number <CR>
;M8  PCP baud rate (format: /##,)
;M9  User ID <CR>
;M0  User password <CR>

;Macros M1 through M6 in VERSA.KEY can be set to whatever you wish.


; ===== RE_ENTRY =============
;This section of the command file handles re-entry from the .MNU files, if
;this has occurred.  If a .MNU file executes VERSA.CMD, it will assign some
;value to S9.  If S9 is empty, RE_ENTRY will branch to BEGIN, the start of
;the command file.  If S9 equals "D", "E", or "G", RE_ENTRY will branch to
;PCPOFF, VERSAOFF, or DISC3 and then CITYCHOICE, respectively.  If a .MNU
;file has set S9 to "ACTIVE", then dialing will begin at LEVEL1, LEVEL2, or
;LEVEL3, depending on the current value of S0.  Any other value of S9 is
;assumed to be an error, so RE_ENTRY displays an error message and goes to
;VERSAOFF.

SWITCH S9            ;Decision based on S9 (information from an .MNU file)
  CASE "_NULL"       ;If S9 not set by .MNU file,
    GOTO BEGIN       ; begin execution normally
  ENDCASE
  CASE "D"           ;If S9 equals "D" (Disconnect),
    GOTO PCPOFF      ; PCPOFF will take care of the disconnection
  ENDCASE
  CASE "E"           ;If S9 equals "E" (Exit),
    CLEAR            ; clear the screen,
    GOTO VERSAOFF    ; and exit
  ENDCASE
  CASE "G"           ;If S9 equals "G" (Go back to city menu),
    FIND S0 "3"      ; look for "3" in S0 (connected to a remote city)
    IF FOUND         ;If found,
      GOSUB DISC3    ; disconnect from remote city
    ENDIF
    GOTO CITYCHOICE  ;Then select a new city
  ENDCASE
  CASE "ACTIVE"      ;If S9 equals "ACTIVE",
    SWITCH S0        ;Decision based on S0 (level information)
      CASE "1"       ;If S0 equals "1" (modem offline),
        GOTO LEVEL1  ; start dialing at LEVEL1
      ENDCASE
      CASE "2"       ;If S0 equals "2" (Local Telenet),
        CLEAR        ; clear screen (LEVEL2 does not do this),
        GOTO LEVEL2  ; and start dialing at LEVEL2
      ENDCASE
      CASE "3"       ;If S0 equals "3" (Remote city),
        CLEAR        ; clear screen (LEVEL3 does not do this),
        GOTO LEVEL3  ; and start dialing at LEVEL3
      ENDCASE
    ENDSWITCH        ;End of decision based on level information
  ENDCASE
  DEFAULT            ;Erroneous information
    CLEAR            ;Clear the screen and
    LOCATE 11,20     ; locate cursor for message
    MESSAGE "Parameter error from menu command file."
    LOCATE 14,0      ; locate cursor for VERSAOFF message
    GOTO VERSAOFF    ; and terminate
  ENDCASE
ENDSWITCH            ;End of decision based on information from a .MNU file



; ===== BEGIN ================
;This section of the command file is branched to from RE_ENTRY if VERSA is
;starting normally.  It sets up some defaults, loads in user information in
;VERSA.KEY, and always goes to TITLE.

BEGIN:
SET CR_IN CR       ;Make sure LFs aren't added to incoming
SET CR_OUT CR      ; or outgoing <CR>s
SET PARITY EVEN    ;Parity and databits must be set to
SET DATABITS 7     ; even and 7 for communicating with Telenet
SET DUPLEX FULL    ;Make sure duplex is FULL
MLOAD "VERSA.KEY"  ;Load in user information
GOTO TITLE         ;Go to beginning of code



; ===== SUBROUTINES ==========
;The following routines are called "subroutines," but only two, DISC3 and
;R/V_MODE, actually end in a RETURN.  They are placed here at the top of the
;file so that ProComm will find them quickly as it searches for their labels.


;CITYREDIAL is branched to from LEVEL2 if the user elects to redial a busy
;city.  It redials the city, looping continually until it connects, and then
;goes to PORTSET.

CITYREDIAL:
CLEAR                ;Clear screen
TRANSMIT "C D/"      ;Send beginning of city dial command
TRANSMIT S1          ;Send city code
MACRO 8              ;Send PCP baud rate
MACRO 9              ;Send user ID
WAITFOR "="          ;Wait for "PASSWORD ="
MACRO 0              ;Send user password
RGET S8              ;Get first <CR>
RGET S8              ;Get second <CR>
RGET S8              ;Get message
FIND S8 "CONNECTED"  ;Look for "CONNECTED" in S8
IF FOUND             ;If found, city is connected, so
  MESSAGE "^G"       ; beep,
  GOTO PORTSET       ; go to PORTSET
ENDIF
GOTO CITYREDIAL      ;If "CONNECTED" not found, loop and try again


;BBSREDIAL is branched to from LEVEL3 if the user elects to redial a busy
;BBS.  It redials the BBS, looping continually until a connection is made.
;It then branches to BBSCONNECT.

BBSREDIAL:
CLEAR              ;Clear screen -- only done once
LABEL1:            ;Beginning of redial loop
TRANSMIT "A/!"     ;Send Hayes command for "repeat last command"
RGET S8 80 40      ;Wait a maximum of 40 seconds to get first <CR> back
RGET S8            ;Get string from remote modem
FIND S8 "CONNECT"  ;Look for "CONNECT" in modem string
IF FOUND           ;If found, BBS has been connected,
  GOTO BBSCONNECT  ; go to BBSCONNECT
ENDIF
GOTO LABEL1        ;If "CONNECTED" not found, loop and try again


;BBSCONNECT is branched to from BBSREDIAL, LEVEL3, NETDIAL, or NETREDIAL
;whenever a BBS is connected with.  It resets the databits and parity to
;8 and none, sounds ProComm's alarm, and executes the "linked command file,"
;if there is one, or exits if there isn't.

BBSCONNECT:
SET PARITY NONE          ;Reset parameters
SET DATABITS 8           ; for use with BBSs
ALARM 2                  ;Inform user of connection
MLOAD "PROCOMM.KEY"      ;Reload PROCOMM.KEY
SWITCH S7                ;Decision based on S7 (linked command file)
  CASE "_NULL"           ;If S7 is empty (no linked command file),
    EXIT                 ; then exit
  ENDCASE
  CASE "*"               ;or if S7 is "*" (cleared linked command file),
    EXIT                 ; then exit
  ENDCASE
  DEFAULT                ;Otherwise,
    EXECUTE S7           ; perform the linked command file
  ENDCASE
ENDSWITCH                ;End of decision based on linked command file


;PCPOFF can be called from nearly anywhere in the program.  It is executed
;whenever the user wishes to disconnect from PCP entirely and end VERSA.  It
;looks at the level information and branches to DISC3, DISC2, and VERSAOFF
;as needed.

PCPOFF:
CLEAR              ;Clear the screen
IF NOT CONNECTED   ;If PCP has disconnected or level is 1 (offline),
  GOTO VERSAOFF    ; go directly to VERSAOFF
ENDIF
SWITCH S0          ;Decision based on S0 (level information)
  CASE "2"         ;If S0 equals "2" (local Telenet level),
    GOTO DISC2     ; disconnect from level 2, VERSAOFF will follow
  ENDCASE
  CASE "3"         ;If S0 equals "3" (Remote city level),
    GOSUB DISC3    ; disconnect from level 3,
    GOTO DISC2     ; disconnect from level 2, VERSAOFF will follow
  ENDCASE
ENDSWITCH          ;End of decision based on level information


;DISC3 (DISConnect from level 3) is a true subroutine that is called whenever
;the user wishes to disconnect from level 3 (connection to a remote city)
;back to level 2 (connection to local Telenet).  It first makes sure Telenet
;is still connected before doing anything.  It attempts to get back to the
;Telenet prompt by issuing a break, but will try a <CR>@<CR> if that doesn't
;work.  Once at the Telenet prompt, it issues D <CR>, the disconnect command,
;then RETURNs to caller.

DISC3:
CLEAR               ;Clear screen
MESSAGE "Disconnecting from remote city . . ."
IF NOT CONNECTED    ;If Telenet has dropped carrier,
  MESSAGE "^M^JTelenet has disconnected.^M^J"
  ASSIGN S0 "1"     ; level is now 1,
  PAUSE 1           ; allow user to see message,
  RETURN            ; no need to disconnect
ENDIF
BREAK 10            ;Send a break, 10 ms, to return to Telenet prompt
WAITFOR "@" 5       ;Wait for Telenet prompt
TRANSMIT "!"        ;Get fresh prompt, in case of garbage characters
IF NOT WAITFOR      ;If that didn't work,
  TRANSMIT "!@!"    ; transmit <CR>@<CR> to return to Telenet prompt
ENDIF
WAITFOR "@" 5       ;Wait for Telenet prompt
TRANSMIT "D!"       ;Send D<CR> (disconnect from city command)
WAITFOR "@" 5       ;Wait for Telenet prompt
MESSAGE "^M^J^M^J"  ;Send <CR>/<LF>s, in case of DISC2 messages following
PAUSE 1             ;Allow user to see results
ASSIGN S0 "2"       ;Level is now 2 (local Telenet level)
RETURN              ;RETURN to caller


;DISC2 (DISConnect from level 2) is called whenever the user wants to
;disconnect from PCP entirely.  It issues the HANGUP <CR> command and then
;always "falls through" to VERSAOFF.

DISC2:
MESSAGE "Disconnecting from local Telenet . . .^M^J"
TRANSMIT "HANGUP!"  ;Send "HANGUP"<CR> (disconnect from local command)
PAUSE 1             ;Causes "garbage" character to go behind HANGUP
MESSAGE "^M^J"      ;<CR>/<LF> sent to make next message further down


;VERSAOFF is always the last routine done (unless a BBS is connected).  It
;reloads PROCOMM.KEY, since VERSA.KEY was loaded for VERSA use, and then
;exits.

VERSAOFF:
MLOAD "PROCOMM.KEY"        ;Reload PROCOMM.KEY
MESSAGE "VERSA finished."  ;Inform the user of completion
EXIT                       ;End the command file


;NETREDIAL is branched to from NETDIAL if the Net Exchange is busy and the
;user elects to redial.  It redials the Net Exchange using the C PURSUIT
;command, continually looping until a connection is made.  It then goes to
;BBSCONNECT.

NETREDIAL:
CLEAR                  ;Clear screen
TRANSMIT "C PURSUIT,"  ;Send beginning of Net Exchange dial command
MACRO 9                ;Send user ID
WAITFOR "="            ;Wait for "PASSWORD ="
MACRO 0                ;Send password
RGET S8                ;Get first <CR>
RGET S8                ;Get second <CR>
RGET S8                ;Get message
FIND S8 "CONNECTED"    ;Look for "CONNECTED" in S8
IF FOUND               ;If found,
  GOTO BBSCONNECT      ; go to BBSCONNECT
ENDIF
GOTO NETREDIAL         ;If "CONNECTED" not found, loop and try again


;NETDIAL is called from LEVEL2 if it discovers that the current city code is
;set to NETEX.  NETDIAL calls the Net Exchange using the C PURSUIT command.
;If the Net Exchange connects, it branches to BBSCONNECT.  If the Net
;Exchange doesn't connect, NETDIAL asks the user to decide whether or not to
;redial; it then branches to either NETREDIAL or CITYCHOICE.  Since user
;input is obtained, "D" and "E" are valid options, meaning NETDIAL might
;branch to PCPOFF or VERSAOFF, respectively.

NETDIAL:
TRANSMIT "C PURSUIT,"  ;Send beginning of Net Exchange dial command
MACRO 9                ;Send user ID
WAITFOR "="            ;Wait for "PASSWORD ="
MACRO 0                ;Send password
RGET S8                ;Get first <CR>
RGET S8                ;Get second <CR>
RGET S8                ;Get message
FIND S8 "CONNECTED"    ;Look for "CONNECTED" in S8
IF FOUND               ;If found,
  GOTO BBSCONNECT      ; go to BBSCONNECT
ENDIF
CLEAR                  ;Otherwise, clear screen
LOCATE 11,16           ;Locate cursor for message
MESSAGE "The Net Exchange is busy.  Begin redial <Y/N>?"
LABEL2:                ;Loop to here in case of erroneous input
LOCATE 11,63           ;Locate cursor for user input
GET S9 1               ;Get user input (1 character)
SWITCH S9              ;Decision based on S9 (user input)
  CASE "Y"             ;If the user enters "Y",
    GOTO NETREDIAL     ; begin redialing
  ENDCASE
  CASE "N"             ;If the user enters "N",
    ASSIGN S7 "*"      ; clear name of Net Exchange linked command file,
    GOTO CITYCHOICE    ; and select another city
  ENDCASE
  CASE "D"             ;If the user enters "D",
    GOTO PCPOFF        ; PCPOFF will take care of the disconnection
  ENDCASE
  CASE "E"             ;If the user enters "E",
    CLEAR              ; clear screen,
    GOTO VERSAOFF      ; exit VERSA
  ENDCASE
  DEFAULT              ;Erroneous input
    LOCATE 11,63       ;Locate cursor,
    MESSAGE "^G "      ; beep and erase erroneous input,
    GOTO LABEL2        ; and redo the GET
  ENDCASE
ENDSWITCH              ;End of decision based on user input


;R/V_MODE is a true subroutine that is called from either TITLE or LEVEL3
;when those routines run into a modem that has been left in Racal/Vadic mode.
;This routine resets the modem to Hayes mode and then RETURNs.

R/V_MODE:
PAUSE 1                ;Wait, in case of INVALID COMMAND response
TRANSMIT "!"           ;Send a <CR>
WAITFOR "*" 2          ;Wait for R/V prompt
IF NOT WAITFOR         ;If R/V prompt doesn't show up,
  GOTO R/V_MODE        ; loop and try again
ENDIF
TRANSMIT "I!"          ;Send "I" command (return to Hayes mode)
WAITFOR "IDLE" 10      ;Wait for confirmation
PAUSE 1                ;Wait for modem to "settle"
TRANSMIT "ATZ!"        ;Reset in Hayes mode
WAITFOR "OK"           ;Wait for "OK"
RETURN                 ;RETURN to caller



; ===== TITLE ================
;TITLE is branched to from BEGIN if VERSA is starting normally (no re-entry
;from a .MNU file).  It draws the title screen and sends an ATZ to determine
;the current level.  If a modem in Racal/Vadic mode is encountered, it will
;call R/V_MODE to reset it.  Once the level is discovered, it is stored in S0
;as a 1, 2, or 3 (for offline, local Telenet level, or remote city level,
;respectively).  If TITLE can't determine the level, it terminates by calling
;VERSAOFF.

TITLE:
CLEAR                    ;Clear screen
LOCATE 2,0               ;Locate cursor for credit drawing
MESSAGE "                       ͻ"
MESSAGE "                                                      "
MESSAGE "                            PC Pursuit: VERSAdial     "
MESSAGE "                                 Version 1.3          "
MESSAGE "                          Written by Allen Brunson,   "
MESSAGE "                           David Rhoten, and Gizmo    "
MESSAGE "                                                      "
MESSAGE "                              `"D`" - Disconnect        "
MESSAGE "                              `"E`" - Exit VERSA        "
MESSAGE "                                                      "
MESSAGE "                       ͼ"
LOCATE 15,0              ;Locate cursor for next message
MESSAGE "Determining PC Pursuit level . . .^M^J"
IF NOT CONNECTED         ;If local modem is offline,
  MESSAGE "Modem is currently offline."
  ASSIGN S0 "1"          ; then the level is 1
  PAUSE 1                ;Allow user to see message
  GOTO CITYCHOICE        ;Go to city selection
ENDIF
TRANSMIT "ATZ!"          ;Test for a remote modem
RGET S8 80 3             ;Get first <CR>
RGET S8 80 3             ;This is where "?" will come back, if local Telenet
RGET S9 80 3             ;This is where "OK" will come back, if remote city
FIND S8 "?"              ;Look for "?" in S8
IF FOUND                 ;If "?" is found in S8, we're at local Telenet,
  MESSAGE "^M^J^M^JLocal Telenet level determined."
  ASSIGN S0 "2"          ; therefore, the level is 2
  PAUSE 1                ;Allow user to see message
  GOTO CITYCHOICE        ;Go to city selection
ENDIF
FIND S9 "OK"             ;Look for "OK" in S9
IF FOUND                 ;If "OK" is found in S9, we're at remote level,
  MESSAGE "^M^JRemote city level determined."
  ASSIGN S0 "3"          ; therefore, the level is 3
  PAUSE 1                ;Allow user to see message
  GOTO CITYCHOICE        ;User must enter the current city code
ENDIF
FIND S9 "MANUAL ANSWER"  ;Look for R/V mode response
IF FOUND                 ; If modem is in R/V mode,
  GOSUB R/V_MODE         ; go to R/V mode handling
  MESSAGE "^M^JRemote city level determined."
  ASSIGN S0 "3"          ; Level is determined to be 3
  PAUSE 1                ; Allow user to see message
  GOTO CITYCHOICE        ; User must enter the current city code
ENDIF                    ;If none of that worked,
MESSAGE "^M^JUnable to determine level.^M^J"
GOTO VERSAOFF            ; something is wrong, VERSA will not proceed



; ===== CITYCHOICE ===========
;CITYCHOICE is called either when the user must select a city code to dial,
;in case of level 1 or 2 starts, or when the user must enter the current
;city code, in the case of level 3 starts.  It displays the city code menu
;and the current level, then asks for a city code.  If a city code is entered,
;it goes to MENUBRANCH.  It can also go to PCPOFF if "D" is entered, VERSAOFF
;if "E" is entered, or to DISC3 if "G" is entered.

CITYCHOICE:
CLEAR                         ;Clear screen for menu drawing
MESS"  ͵ PC Pursuit City Menu ͸"
MESS"                                                                            "
MESS"    E GAATL *Atlanta       E DCWAS *Washington DC   P CALAN *Los Angeles    "
MESS"    E MABOS *Boston        C ILCHI *Chicago         P CAPAL +Palo Alto      "
MESS"    E OHCLV  Cleveland     C TXDAL *Dallas          P ORPOR  Portland       "
MESS"    E MIDET *Detroit       C TXHOU *Houston         P CARIV +Riverside      "
MESS"    E CTHAR +Hartford      C MOKAN *Kansas City     P CASAC +Sacramento     "
MESS"    E FLMIA  Miami         C WIMIL +Milwaukee       P CASAD +San Diego      "
MESS"    E NETEX  Net Exchange  C MNMIN  Minneapolis     P CASFA *San Francisco  "
MESS"    E NJNEW *Newark        C MOSLO +St. Louis       P CASJO +San Jose       "
MESS"    E NYNYO *New York      M CODEN *Denver          P CASAN +Santa Ana      "
MESS"    E PAPHI *Philadelphia  M AZPHO  Phoenix         P WASEA *Seattle        "
MESS"    E NCRTP  Res Tri Park  M UTSLC  Salt Lake City  * 2400 baud available   "
MESS"    E FLTAM  Tampa         P CAGLE +Glendale        + 300 baud unavailable  "
MESS"                                                                            "
MESS"    Time   E - Eastern                  Options:  <D>isconnect              "
MESS"    Zones  C - Central                            <E>xit                    "
MESS"           M - Mountain                                                     "
MESS"           P - Pacific     Status:                                          "
MESS"                                                                            "
MESS"  Ĵ"
MESS"                                                                            "
MESS"  ;"
LOCATE 18,36                  ;Locate for status message
SWITCH S0                     ;Decision based on current level
  CASE "1"                    ;If off line,
    MESSAGE "Off line"        ; put message in menu,
    LOCATE 21,21              ; locate for input message
    MESSAGE "Enter city code of desired city:"
  ENDCASE
  CASE "2"                    ;If local Telenet level,
    MESSAGE "Local Telenet"   ; put message in menu,
    LOCATE 21,21              ; locate for input message
    MESSAGE "Enter city code of desired city:"
  ENDCASE
  CASE "3"                    ;If remote city level,
    MESSAGE "Remote city"     ; put message in menu,
    LOCATE 17,51              ; locate for second message,
    MESSAGE "<G>o to local level"
    LOCATE 21,21              ; locate for input message
    MESSAGE "Enter city code of CURRENT city:"
  ENDCASE
ENDSWITCH
LOCATE 21,54                  ;Locate for user input
GET S9 5                      ;Get user input (5 characters)
SWITCH S9                     ;Decision based on S9 (user input)
  CASE "D"                    ;If the user enters "D",
    GOTO PCPOFF               ; then PCPOFF will take care of disconnection
  ENDCASE
  CASE "E"                    ;If the user enters "E",
    CLEAR                     ; clear screen,
    GOTO VERSAOFF             ; and exit
  ENDCASE
  CASE "G"                    ;If the user enters "G",
    CLEAR                     ; clear the screen
    FIND S0 "3"               ;Look in S0 for "3" (remote city level)
    IF FOUND                  ;If level is 3,
      GOSUB DISC3             ; disconnect from remote city
    ELSE                      ;If at some other level,
      LOCATE 11,19            ; locate, beep, and print message
      MESSAGE "^GNot currently connected to a remote city."
      LOCATE 0,0              ; locate cursor out of the way,
      PAUSE 1                 ; allow user to see message
    ENDIF
    GOTO CITYCHOICE           ;Start over at CITYCHOICE
  ENDCASE
  CASE "_NULL"                ;If the user entered nothing,
    CLEAR                     ; clear screen,
    LOCATE 11,18              ; locate, beep, and print message
    MESSAGE "^GMust enter a city code or displayed option."
    LOCATE 0,0                ; locate cursor out of the way,
    PAUSE 1                   ; allow user to see message,
    GOTO CITYCHOICE           ; and start over at CITYCHOICE
  ENDCASE
  DEFAULT                     ;Anything else is assumed to be a city code,
    ASSIGN S1 S9              ; so assign the input to S1,
    GOTO MENUBRANCH           ; and go to MENUBRANCH
  ENDCASE
ENDSWITCH                     ;End of decision based on user input



; ===== MENUBRANCH ===========
;MENUBRANCH is used to determine which .MNU file should be called for a given
;city code.  It can be called from CITYCHOICE, if the user has just entered
;a city code, or from LEVEL3 if a user elects not to redial a BBS.  If the
;user enters an unknown city code, MENUBRANCH notes the fact and asks if the
;user wants to continue or go back to CITYCHOICE to select another city code.
;If the user elects to continue, the spare menu in VERSA5.MNU is called.
;Since user input is obtained, the user might enter "D" or "E", which would
;cause MENUBRANCH to go to PCPOFF or VERSAOFF, respectively.

MENUBRANCH:
SWITCH S1                     ;Decision based on S1 (city code)
  CASE "GAATL"                ;All of the following 34 cases are identical
    ASSIGN S1 "GAATL"         ; (except for the Net Exchange case).  They
    EXECUTE "VERSA1.MNU"      ; simply assure that the string in S1 is all
  ENDCASE                     ; uppercase and then execute the correct .MNU
  CASE "MABOS"                ; file for the selected city.
    ASSIGN S1 "MABOS"
    EXECUTE "VERSA1.MNU"
  ENDCASE
  CASE "OHCLV"
    ASSIGN S1 "OHCLV"
    EXECUTE "VERSA1.MNU"
  ENDCASE
  CASE "MIDET"
    ASSIGN S1 "MIDET"
    EXECUTE "VERSA1.MNU"
  ENDCASE
  CASE "CTHAR"
    ASSIGN S1 "CTHAR"
    EXECUTE "VERSA1.MNU"
  ENDCASE
  CASE "FLMIA"
    ASSIGN S1 "FLMIA"
    EXECUTE "VERSA1.MNU"
  ENDCASE
  CASE "NETEX"                ;If the user wishes to dial the Net Exchange,
    FIND S0 "3"               ; find out if level is 3
    IF FOUND                  ;If it is,
      GOSUB DISC3             ; disconnect from remote city
    ENDIF
    ASSIGN S1 "NETEX"
    EXECUTE "VERSA5.MNU"
  ENDCASE
  CASE "NJNEW"
    ASSIGN S1 "NJNEW"
    EXECUTE "VERSA1.MNU"
  ENDCASE
  CASE "NYNYO"
    ASSIGN S1 "NYNYO"
    EXECUTE "VERSA2.MNU"
  ENDCASE
  CASE "PAPHI"
    ASSIGN S1 "PAPHI"
    EXECUTE "VERSA2.MNU"
  ENDCASE
  CASE "NCRTP"
    ASSIGN S1 "NCRTP"
    EXECUTE "VERSA2.MNU"
  ENDCASE
  CASE "FLTAM"
    ASSIGN S1 "FLTAM"
    EXECUTE "VERSA2.MNU"
  ENDCASE
  CASE "DCWAS"
    ASSIGN S1 "DCWAS"
    EXECUTE "VERSA2.MNU"
  ENDCASE
  CASE "ILCHI"
    ASSIGN S1 "ILCHI"
    EXECUTE "VERSA2.MNU"
  ENDCASE
  CASE "TXDAL"
    ASSIGN S1 "TXDAL"
    EXECUTE "VERSA2.MNU"
  ENDCASE
  CASE "TXHOU"
    ASSIGN S1 "TXHOU"
    EXECUTE "VERSA3.MNU"
  ENDCASE
  CASE "MOKAN"
    ASSIGN S1 "MOKAN"
    EXECUTE "VERSA3.MNU"
  ENDCASE
  CASE "WIMIL"
    ASSIGN S1 "WIMIL"
    EXECUTE "VERSA3.MNU"
  ENDCASE
  CASE "MNMIN"
    ASSIGN S1 "MNMIN"
    EXECUTE "VERSA3.MNU"
  ENDCASE
  CASE "MOSLO"
    ASSIGN S1 "MOSLO"
    EXECUTE "VERSA3.MNU"
  ENDCASE
  CASE "CODEN"
    ASSIGN S1 "CODEN"
    EXECUTE "VERSA3.MNU"
  ENDCASE
  CASE "AZPHO"
    ASSIGN S1 "AZPHO"
    EXECUTE "VERSA3.MNU"
  ENDCASE
  CASE "UTSLC"
    ASSIGN S1 "UTSLC"
    EXECUTE "VERSA4.MNU"
  ENDCASE
  CASE "CAGLE"
    ASSIGN S1 "CAGLE"
    EXECUTE "VERSA4.MNU"
  ENDCASE
  CASE "CALAN"
    ASSIGN S1 "CALAN"
    EXECUTE "VERSA4.MNU"
  ENDCASE
  CASE "CAPAL"
    ASSIGN S1 "CAPAL"
    EXECUTE "VERSA4.MNU"
  ENDCASE
  CASE "ORPOR"
    ASSIGN S1 "ORPOR"
    EXECUTE "VERSA4.MNU"
  ENDCASE
  CASE "CARIV"
    ASSIGN S1 "CARIV"
    EXECUTE "VERSA4.MNU"
  ENDCASE
  CASE "CASAC"
    ASSIGN S1 "CASAC"
    EXECUTE "VERSA4.MNU"
  ENDCASE
  CASE "CASAD"
    ASSIGN S1 "CASAD"
    EXECUTE "VERSA5.MNU"
  ENDCASE
  CASE "CASFA"
    ASSIGN S1 "CASFA"
    EXECUTE "VERSA5.MNU"
  ENDCASE
  CASE "CASJO"
    ASSIGN S1 "CASJO"
    EXECUTE "VERSA5.MNU"
  ENDCASE
  CASE "CASAN"
    ASSIGN S1 "CASAN"
    EXECUTE "VERSA5.MNU"
  ENDCASE
  CASE "WASEA"
    ASSIGN S1 "WASEA"
    EXECUTE "VERSA5.MNU"
  ENDCASE
  DEFAULT                     ;This occurs if user enters unknown city code
    LOCATE 21,7               ;Locate for message, beep
    MESSAGE "^GUnknown city code.  Continue or Go back to city selection <C/G>?"
    LABEL3:                   ;Loop to here in case of erroneous input
    LOCATE 21,72              ;Locate for user input
    GET S9 1                  ;Get user input (1 character)
    SWITCH S9                 ;Decision based on S9 (user input)
      CASE "C"                ;User wants to continue,
        EXECUTE "VERSA5.MNU"  ; so go ahead and display spare menu
      ENDCASE
      CASE "G"                ;User wants to go back,
        GOTO CITYCHOICE       ; so go to CITYCHOICE
      ENDCASE
      CASE "D"                ;User wants to disconnect,
        GOTO PCPOFF           ; so go to PCPOFF
      ENDCASE
      CASE "E"                ;User wants to exit,
        CLEAR                 ; so clear the screen,
        GOTO VERSAOFF         ; and go to VERSAOFF
      ENDCASE
      DEFAULT                 ;Erroneous input
        LOCATE 21,72          ; locate cursor,
        MESSAGE "^G "         ; beep and erase erroneous input,
        GOTO LABEL3           ; and redo the GET
      ENDCASE
    ENDSWITCH                 ;End of decision based on user input
  ENDCASE
ENDSWITCH                     ;End of decision based on city code



; ===== LEVEL1 ===============
;LEVEL1 is used to dial the local Telenet number and make a connection.  If
;for some reason the local Telenet number does not connect, LEVEL1 will
;display a message and automatically redial.  Once Telenet connects, LEVEL1
;sends two slow <CR>s for auto baud detection and issues D1 at the terminal
;type prompt.  LEVEL1 always "falls through" to LEVEL2.

LEVEL1:
CLEAR                    ;Clear screen
TRANSMIT "AT S2=42 DT "  ;Send command to dial local modem, reset escape char
MACRO 7                  ;Send local Telenet phone number
WAITFOR "CONNECT" 20     ;Wait 20 seconds for modem to send "CONNECT"
IF NOT WAITFOR           ;If modem does not connect,
  HANGUP                 ; hang up the phone line,
  CLEAR                  ; clear screen,
  LOCATE 11,19           ; locate the cursor for message,
  MESSAGE "Local Telenet did not connect.  Redialing."
  LOCATE 0,0             ; locate cursor out of the way,
  PAUSE 1                ; allow user to see message,
  GOTO LEVEL1            ; loop to beginning to dial again
ENDIF                    ;When Local Telenet is connected with,
PAUSE 2                  ; wait for connection to be properly made,
TRANSMIT "!"             ; send first <CR>,
PAUSE 1                  ; pause to allow auto baud detection to work,
TRANSMIT "!"             ; send second <CR>,
WAITFOR "="              ; wait for "TERMINAL TYPE =" prompt,
TRANSMIT "D1!"           ; terminal type D1 is for PCs,
WAITFOR "@"              ; wait for Telenet prompt



;========== LEVEL2 ==========
;Once local Telenet is connected with, LEVEL2 is used to connect with a remote
;city.  LEVEL2 first makes sure that Telenet hasn't dropped carrier (if it
;has, LEVEL2 will go back to LEVEL1).  LEVEL2 will branch to NETDIAL if the
;current city code is NETEX.  LEVEL2 will dial a city, and if connected, will
;go to PORTSET.  If not connected, LEVEL2 will go to CITYREDIAL if the user
;wishes to redial or to CITYCHOICE if the user doesn't.  Since user input is
;obtained, LEVEL2 will branch to PCPOFF if the user enters "D" or to VERSAOFF
;if the user enters "E".

LEVEL2:
IF NOT CONNECTED     ;If Telenet has dropped carrier,
  CLEAR              ; clear screen,
  LOCATE 11,7        ; locate the cursor for message,
  MESSAGE "Telenet has disconnected.  Dialing will begin at the local level."
  LOCATE 0,0         ; locate the cursor out of the way,
  PAUSE 1            ; allow user to see the message,
  ASSIGN S0 "1"      ; level is now 1
  GOTO LEVEL1        ; start dialing from the beginning
ENDIF
ASSIGN S0 "2"        ;Otherwise, level is now 2
FIND S1 "NETEX"      ;Check to see if user is calling the Net Exchange
IF FOUND             ;If so,
  GOTO NETDIAL       ; go to NETDIAL
ENDIF
TRANSMIT "C D/"      ;Send beginning of city dial command
TRANSMIT S1          ;Send city code to be dialed
MACRO 8              ;Send PCP baud rate
MACRO 9              ;Send user ID
WAITFOR "="          ;Wait for "PASSWORD ="
MACRO 0              ;Send user password
RGET S8              ;Get first <CR>
RGET S8              ;Get second <CR>
RGET S8              ;Get message
FIND S8 "CONNECTED"  ;Look for "CONNECTED" in S8
IF FOUND             ;If found city is connected so
  MESSAGE "^G"       ; beep,
  GOTO PORTSET       ; go to PORTSET
ENDIF
CLEAR                ;Otherwise, clear screen
LOCATE 11,11         ;Locate cursor for message
MESSAGE "No modems available in remote city.  Begin redial <Y/N>?"
LABEL4:              ;Loop to here in case of erroneous input
LOCATE 11,68         ;Locate cursor for user input
GET S9 1             ;Get user input (1 character)
SWITCH S9            ;Decision based on S9 (user input)
  CASE "Y"           ;If the user enters "Y",
    GOTO CITYREDIAL  ; redial the city
  ENDCASE
  CASE "N"           ;If the user enters "N",
    GOTO CITYCHOICE  ; another city must be selected
  ENDCASE
  CASE "D"           ;If the user enters "D",
    GOTO PCPOFF      ; PCPOFF will take care of the disconnection
  ENDCASE
  CASE "E"           ;If the user enters "E",
    CLEAR            ; clear screen,
    GOTO VERSAOFF    ; exit VERSA
  ENDCASE
  DEFAULT            ;Erroneous input
    LOCATE 11,68     ;Locate the cursor,
    MESSAGE "^G "    ; beep and erase the erroneous input,
    GOTO LABEL4      ; redo the GET
  ENDCASE
ENDSWITCH            ;End of decision based on user input



; ===== PORTSET ==============
;PORTSET is done once after a remote city has been connected with.  It
;always "falls through" to LEVEL3 when it is finished.  It is used to set
;three of Telenet's SET commands.  The three SETs are as follows:
;SET 1:0 disables escaping to command mode with <CR> @ <CR>
;SET 4:2 forces Telenet to send unfilled packets after .1 second
;SET 7:8 enables escaping to command mode with a break
;To learn why these SETs are advantageous, consult your PCP documentation.

PORTSET:
TRANSMIT "!@!"                ;Get back to Telenet prompt
WAITFOR "@"                   ;When it appears,
TRANSMIT "SET? 1:0,4:2,7:8!"  ; do the SETs
WAITFOR "@" 3                 ;Wait for Telenet prompt
TRANSMIT "CONT!"              ;Go back to Hayes mode



; ===== LEVEL3 ===============
;LEVEL3 is the level of dialing done once a remote city has been connected
;with and the SETs have been done.  It first tests to make sure PCP is still
;connected; if it is not, it starts over at CITYCHOICE if the selected city
;is unknown, or at LEVEL1 if the selected city is known.  If a modem is in
;Racal/Vadic mode, LEVEL3 will call R/V_MODE to reset it.  LEVEL3 dials the
;selected BBS number, and if it connects, branches to BBSCONNECT.  If the BBS
;does not connect, it branches to BBSREDIAL if the user wishes to redial or
;to MENUBRANCH if the user doesn't.  Since user input is accepted, "D" and
;"E" are also options, which branch to PCPOFF and VERSAOFF, respectively.

LEVEL3:
IF NOT CONNECTED           ;If Telenet has dropped carrier,
  CLEAR                    ; clear screen
  LOCATE 11,7              ; locate cursor for message,
  MESSAGE "Telenet has disconnected.  Dialing will begin at the local level."
  LOCATE 0,0               ; locate cursor out of the way,
  PAUSE 1                  ; allow user to see message
  ASSIGN S0 "1"            ; level is now 1
  GOTO LEVEL1              ; start dialing
ENDIF                      ;End of IF NOT CONNECTED routine
ASSIGN S0 "3"              ;Otherwise, level is now 3
TRANSMIT "ATZ!"            ;Reset remote modem
RGET S8 80 3               ;Get first <CR>
RGET S8 80 3               ;Get second <CR>
RGET S8 80 3               ;Get message
FIND S8 "OK"               ;Look for "OK" in S8
IF NOT FOUND               ;If no "OK" is found, assume R/V mode response
  GOSUB R/V_MODE           ; so go to R/V_MODE
ENDIF
TRANSMIT "ATDT "           ;Send beginning of Hayes dialing command
TRANSMIT S2                ;Send telephone number to dial
TRANSMIT "!"               ;Send <CR> to complete command
RGET S8                    ;Get first <CR>
RGET S8 80 50              ;Wait a maximum of 50 seconds for second <CR>
RGET S8                    ;Get message
FIND S8 "CONNECT"          ;Look for "CONNECT" in S8
IF FOUND                   ;If found, BBS has been connected,
  GOTO BBSCONNECT          ; go to BBSCONNECT
ENDIF
CLEAR                      ;Otherwise, clear screen,
LOCATE 11,20               ; locate the cursor for message
MESSAGE "The BBS is busy.  Begin redial <Y/N>?"
LABEL5:                    ;Loop to here in case of erroneous input
LOCATE 11,58               ;Locate the cursor for user input
GET S9 1                   ;Get user input (1 character)
SWITCH S9                  ;Decision based on S9 (user input)
  CASE "Y"                 ;If the user enters "Y",
    GOTO BBSREDIAL         ; redial the BBS
  ENDCASE
  CASE "N"                 ;If the user enters "N",
    ASSIGN S7 "*"          ; clear the old linked command file,
    GOTO MENUBRANCH        ; and go to MENUBRANCH
  ENDCASE
  CASE "D"                 ;If the user enters "D",
    GOTO PCPOFF            ; PCPOFF will take care of the disconnection
  ENDCASE
  CASE "E"                 ;If the user enters "E",
    CLEAR                  ; clear the screen,
    GOTO VERSAOFF          ; exit VERSA
  ENDCASE
  DEFAULT                  ;Erroneous input
    LOCATE 11,58           ;Locate the cursor,
    MESSAGE "^G "          ; beep and erase the erroneous input,
    GOTO LABEL5            ; and redo the GET
  ENDCASE
ENDSWITCH                  ;End of decision based on user input
