;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                       ;;
;;   PSEND.ASM    Last modified: 09/29/87    R. Trevithick    MASM 4.0   ;;
;;-----------------------------------------------------------------------;;
;;           Send printer codes from ascii control code files.           ;;
;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BSIZE   equ     07fffh                          ; 32K buffer should do it!



PRT     SEGMENT PARA PUBLIC 'CODE'              ; some info for the assembler
        ASSUME  CS:PRT, DS:PRT
        ORG     0100h


start:  cmp     byte ptr ds:[80h], 1            ; any parameters?
        jg      parm
        mov     al, 1
        jmp     exit

parm:   mov     si, 82h
parm2:  cmp     byte ptr ds:[si], 0dh
        jne     parm3
        mov     byte ptr ds:[si], 0             ; insert zero byte for DOS
        jmp     short open
parm3:  inc     si
        jmp     short parm2

open:   mov     dx, 82h                         ; point to filespec in PSP
        mov     ax, 3d00h                       ; try to open for read-only
        int     21h
        jnc     read
        mov     al, 1
        jmp     exit

read:   mov     bx, ax                          ; get handle into bx
        mov     dx, offset ds:buffer            ; point to the buffer
        mov     ah, 03fh                        ; read service
        mov     cx, BSIZE                       ; size of read buffer
        int     21h
        jnc     read2
        mov     al, 1
        jmp     exit

read2:  cmp     ax, 0                           ; special case, 0 byte file
        jne     read3
        mov     al, 1
        jmp     exit

read3:  cmp     ax, BSIZE                       ; see if too large a file
        jb      disp
        mov     al, 1
        jmp     exit

;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; here's where the work get's done
;
; bh = parser flag, bl = strlen
;

disp:   mov     cx, ax                          ; bytes read into loop counter

        call    pr_chk                          ; check the printer

        xor     bx, bx                          ; zero out our flags
        mov     si, offset buffer               ; pointer into file buffer
        mov     di, offset pr_buff              ; pointer into printer string

disp2:  mov     al, byte ptr ds:[si]
        cmp     al, '<'                         ; is it a start char?
        jne     disp3                           ; no, process it further
        mov     bh, 1                           ; yes, set flag
        jmp     short disp6                     ; get another

disp3:  cmp     bh, 0                           ; is flag set?
        je      disp6                           ; no, skip this one
        cmp     al, '>'                         ; is it an end char?
        jne     disp4                           ; no, see if length ok

        xor     bh, bh                          ; yes, turn off parser flag
        cmp     bl, 0                           ; any valid chars?
        je      abort                           ; no, flag it as error

        call    print                           ; try to send it to printer
        xor     bl, bl                          ;  reset length counter
        mov     di, offset pr_buff              ;   reset pointer to output
        jmp     short disp6                     ;    and back for more

disp4:  inc     bl                              ; bump up length counter
        cmp     bl, 3                           ; max length allowed
        ja      abort                           ; no good, skip num test

        cmp     al, '0'                         ; check for valid numeric
        jb      abort
        cmp     al, '9'
        ja      abort                           ; not numeric, abort

        jmp     short disp5                     ; ok, let this one through

abort:  mov     al, 1                           ; no good, abort
        jmp     short exit                      ; and back to DOS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; build up printer output string
;
disp5:  mov     dl, al                          ; got a live one here
        sub     dl, '0'                         ; convert to binary
        mov     byte ptr ds:[di], dl            ; stick it in print buffer
        inc     di                              ; bump up print buffer pointer

disp6:  inc     si                              ; point to next byte
        dec     cx                              ; unless end of buffer
        jz      done                            ; end, done
        jmp     disp2                           ; more, go get next byte


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
done:   xor     al, al                          ; clear error, fall through


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; general exit routine
;
exit:   mov     ah, 4ch                         ; error code passed in al
        int     21h


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; send codes to printer
;
print:  push    dx
        push    cx

        xor     dx, dx                          ; zero out output byte
        dec     di                              ; last digit found

        mov     dl, byte ptr ds:[di]            ; get ones digit
        dec     di
        dec     bl
        jz      pr_out

        mov     al, byte ptr ds:[di]            ; this is tens digit
        mov     cl, 10
        mul     cl
        add     dl, al
        dec     di                              ; back up again
        dec     bl
        jz      pr_out

        mov     al, byte ptr ds:[di]            ; this is hundreds digit
        mov     cl, 100
        mul     cl
        jc      pr_val                          ; carry flag, error
        add     dl, al
        jc      pr_val                          ; check again after add

pr_out: mov     ah, 05h                         ; get ready to send
        int     21h                             ; send out the value
        jmp     short prexit                    ; and skip error routine

pr_val: mov     al, 1                           ; value-error handler
        jmp     short exit                      ; abort to DOS

prexit: pop     cx
        pop     dx
        ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; see if printer is ready
;
pr_chk: xor     dx, dx                          ; default printer
        mov     ah, 2                           ; printer status function
        int     17h                             ; of bios printer services
        cmp     ah, 10010000b                   ; printer on-line?
        je      ck_ret                          ; yes, just return
        mov     al, 1
        jmp     short exit                      ; no, abort
ck_ret: ret


;
;----------------------------------------------------------------------------
; data storage area

pr_buff db      3 dup(?)                        ; output to printer
buffer  db      BSIZE dup (?)                   ; file i/o buffer

PRT     ENDS
        END     START

