/*

              Printfile Utility - by Mark J. Quarles

            Copyright (c) 1985, 1986 by Mark J. Quarles

         All Commercial and non-commercial rights reserved.


   ************************* NOTICE *********************************
   *                                                                *
   *  This program is protected under Title 17 of the United States *
   *  Legal Code.  All commercial and non-commercial rights and     *
   *  uses of this program product are regulated by and the property*
   *  of the author.                                                *
   *                                                                *
   *  DISCLOSURE of the source code for this program to third       *
   *  parties is EXPRESSLY PROHIBITED unless permission in writing  *
   *  is obtained from the author.                                  *
   *                                                                *
   ******************************************************************


   ************************ Modification Notes ***************************

   June 1986 - Added default handling on all inputs in the modification
               mode.  Added environment handling and printer configuration
               file.  Developed companion program PINSTALL.

   **********************************************************************


  This program will output a sourcefile to the printer, with headings
and page numbers.  Page breaks are supplied by the program at the
end of the page.

Invoke with:     PRINT <filespec> <m>

          where <filespec> is the file (text or doc) to print, and
                <m> indicates whether or not you desire to modify
                the printer control data.

*/

#include <stdlib.h>
#include <dos.h>
#include <process.h>
#include <conio.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>

/*************************************************************************
   Procedure to allow the user to set the left margin.  The current value
   of the left margin is passed to this procedure.  If they select to
   change the margin, the new value is returned.  Otherwise, the original
   value is returned.
**************************************************************************/

int margin_set(left_margin)
int left_margin;
{
int c;

/************************************************************************
      left_margin  - value of the left margin
      c            - scratchpad
*************************************************************************/

cls();

printf("Current left margin is set for %d\n",left_margin);
printf("Do you wish to set the left margin (y/N): ");
c=getche();
if ((c=='y') || (c=='Y')) {
  printf("\nEnter new left margin: ");
  scanf("%d",&left_margin);
  }


return (left_margin);
}

/************************************************************************
*************************    Main Program Code   ************************
************************************************************************/

main(argc,argv)
int argc;
char *argv[];
{
int code0[10],code1[10],code2[10],code3[10]; /* printer configuration control codes */
int notice,linecount,pagelength,bottommargin,linelimit,c;
int code_on,file_count,code_count,max_len,code0t,code1t,code2t,code3t;
int j,row,header,left_margin,i,marg,linenum,page,escape,pause;
char file[80],*cpyrte_name[80],*cpyrte_date[80];
char subdir[20],*sub_dir,temp[30],data[26],label[80];
FILE *f1,*f2;

/**************************************************************************

   code0[]      - First printer control code
   code1[]      - second printer control code
   code2[]      - third printer control code
   code3[]      - fourth printer control code
   notice       - Flag for copyright notice [1=>yes, 0=>no]
   linecount    - count of current lines printed on the page
   pagelength   - length (in lines) of a page (form length)
   bottommargin - bottom margin (in lines)
   linelimit    - maximum characters to print per line
   c            - scratchpad
   code_on      - flag to indicate that they are using control codes
                  other than the default
   file_count   - scratchpad used in counting chars for longest line in file
   code_count   - total number of control codes in the configuration file
   max_len      - maximum characters per line in the sourcefile
   code0t       - temporary input storage during configuration file read
   code1t       -     ditto
   code2t       -       ditto
   code3t       -         ditto
   j            - scratchpad
   row          - current cursor position
   header       - flag on whether or not to print the filename as a header
   left_margin  - value of the left margin
   i            - scratchpad
   marg         - counter for spacing the printout to the margin setting
   linenum      - count (in lines) of linecount + header lines
   page         - current page counter
   escape       - flag for escape codes [ 1= on, 0 => off]
   pause        - flag for end-of-page pause [1 => on, 0=> off]
   file         - filename to print
   cpyrte_name  - name of program for copyrite procedure
   cpyrte_date  - date of copyright for copyrite procedure
   subdir       - string containing the path to the configuration file
   sub_dir      - address of the environment variable PRINT
   temp         - character array for use in reading the configuration file
   data         - character array for third command line parameter
   label        - printer name from configuration file
   f1           - stream pointer to sourcefile
   f2           - stream pointer to printer

***************************************************************************

   Look for the printer configuration file.  If it doesn't exist, then
   tell them and abort.  Get the subdirectory for the configuration
   file from the environment table.

**************************************************************************/


strncpy(file,"printer.cnf\0",13); /* set up the config file name */
sub_dir = getenv("PRINT");  /* find the environmnet variable for print */
strncpy(subdir,sub_dir,20);
i=strlen(subdir);
if ((subdir[i-1] !=92) && (i>0)) {
  subdir[i] = 92;   /* put in a backslash */
  ++i;
  }

for (j=0; j<12; j++)
  subdir[i++] = file[j]; /* copy the rest of the name to it */


if ((f1=fopen(subdir,"r")) == NULL) { /* open the configuration file */
 printf("\n\n");
 cprint("Error: Printer configuration file not found ",131);
 printf("\nConfiguration file is %s",subdir);
 printf("\n\nYou must run the PINSTALL procedure first.\n\n");
 exit(1);
 }

/*********************************************************************
   Display a menu of configuration codes from the configuration file.
**********************************************************************/

code_on = -1; /* code selection disabled */
i=0;
fgets(label,80,f1); /* get the printer name */
printf("Loading configuration for %s\n\n",label);

while ((c=getc(f1)) != EOF) {
 ungetc(c,f1);
 fgets(temp,20,f1); /* get the code label */
if (argc == 3)
 printf("%2d. %s",i,temp);

 fscanf(f1,"%d %d %d %d",&code0t,&code1t,&code2t,&code3t);
 code0[i]=code0t;
 if (code0[i] == 1)
  code0[i] = 27;
 code1[i]=code1t;
 code2[i]=code2t;
 code3[i]=code3t;
 ++i;
 }
code_count =i-1;
fclose(f1);

header = 1; /* default to printing sourcefile name as a header */

/**************************************************************************
  If they supplied the third parameter on the command line, let them
  select the configuration code they want to print with.
***************************************************************************/

if (argc == 3) {
 printf("[Note: Option 0 corresponds to NO CHANGE in default printer code]\n");
 printf("\nWhich printer option should be used (0, or 3 to %d )? ",code_count);
row=get_position(0);
code_on = -1;
while (((code_on <3) || (code_on >code_count)) && (code_on != 0)) {
    scanf("%d",&code_on);
    if ((code_on <2) || (code_on > code_count)) {
         set_position(row,0);
         printf("Which printer option should be used (0, or 3 to %d)? ",code_count);
         }
    }
if (code_on != 0)
 header = 0; /* turn the header off */
 printf("\n");
 }

left_margin = 3; /* set the left margin to 3 */
marg = 0;
 if (code0 == 0)
   escape = 0; /* turn off escape code mode */
  else
   escape = 1;
notice = 1; /* turn on the copyright footnote */
pause = 0; /* default to no pause */


/**************************************************************************
  If they didn't supply the sourcefile name on the command line, give them
  an informational message and abort.
***************************************************************************/

if (argc == 1) {
  copyrite("PRINT\0","December 1985\0");
  cls();
  cprint("Error: Sourcefile not specified",140);
  printf("\n\nThis program will print a file in formatted, paged,\n");
  printf("format.  You must invoke this procedure as:\n\n");
  printf("PRINT <sourcefile>  Where <sourcefile> is the name\n");
  printf("                    of the file you wish to print\n\n");
  printf("\nOptionally, you may invoke this program as follows:\n\n");
  printf("PRINT <sourcefile> M   Where the 'M' indicates that you\n");
  printf("                       wish to modify the printer control\n");
  printf("                       characters used to select the enhanced\n");
  printf("                       print mode, margins, lines per page\n");
  printf("                       headers, footers, or other optional\n");
  printf("                       parameters.\n\n");
  exit(0);
  }

if ((f1=fopen(argv[1],"r")) == NULL) { /* open the sourcefile */
  cls();
  cprint("Error: Cannot open file",140);
  printf(" %s\n\n",argv[1]);
  printf("This program will print a file in formatted, paged,\n");
  printf("format.  You must invoke this procedure as:\n\n");
  printf("PRINT <sourcefile>  Where <sourcefile> is the name\n");
  printf("                    of the file you wish to print\n\n");
  exit(0);
  }

file_count = max_len=0; /* get the longest line length */
cls();

/************************************************************************
   Find the length of the longest line in the sourcefile
*************************************************************************/

printf("\nEvaluating sourcefile - Please standby ");
while ((c=getc(f1)) != EOF) {
 if (c != '\n')
   ++file_count;
  if (c == '\n') {
    printf(".");
    if (file_count > max_len)
      max_len=file_count;
    file_count =0;
    }
  }

fclose(f1);
if ((f1=fopen(argv[1],"r")) == NULL) {
  printf("\nError: Unable to reopen sourcefile\n\n");
  exit(1);
  }

if ((f2=fopen("PRN","w")) == NULL) { /* open a stream to the printer */
  cls();
  cprint("Error: Printer is not available",140);
  printf("\n\n");
  fclose(f1);
  exit(0);
  }

strncpy(file,argv[1],80);
for (i=0; i<=strlen(file); i++)
 file[i]=toupper(file[i]);

linecount = linenum = 0;
page = 1;
pagelength = 66; /* number of lines per page */
bottommargin = 54; /* number of lines to print per page */

linelimit = 74;

if (argc == 3)
  strncpy(data,argv[2],1); /* fetch the modifier on the command line */

/*************************************************************************
  If they supplied the optional 'm' parameter on the command line, proceed
  to prompt them for all of the modifiable parameters.
**************************************************************************/

if ((argc == 3) && ((data[0] == 'm') || (data[0] == 'M'))) {

left_margin = margin_set(left_margin);
linelimit -=left_margin;

printf("\n\nCurrent lines per page is set for %d\n",bottommargin);
printf("Do you wish to set the number of lines to print per page (y/N)? ");
c=getche();
printf("\n");

if ((c == 'Y') || (c=='y')) {
  printf("\nEnter number of lines to print per page: ");
  scanf("%d",&bottommargin);
  }

printf("\n\nCurrent characters per line is %d (excluding margin)\n",linelimit);
printf("Longest line in the sourcefile is %d characters\n",max_len);
printf("Do you wish to set the characters per line (y/N)? ");
c=getche();
printf("\n");
if ((c == 'Y') || (c=='y')) {
  printf("\nEnter number of characters to print per line: ");
  scanf("%d",&linelimit);
  }

printf("\n\nCurrent control characters are: \n");
printf("                Enlarge print mode: %2d %2d %2d %2d\n",code0[1],code1[1],code2[1],code3[1]);
printf("                Normal print mode:  %2d %2d %2d %2d\n",code0[2],code1[2],code2[2],code3[2]);
printf("\nDo you wish to change the control characters (y/N)? ");
c=getche();
printf("\n");
if ((c =='Y') || (c=='y')) {
   printf("\nComplete reconfiguration is available via the PINSTALL command\n\n");
   printf("\nEnter a SINGLE character code for ENLARGED print mode: ");
   scanf("%d",&code1[1]);
   code2[1]=code3[1]=0;
   printf("\nEnter a SINGLE character code for NORMAL print mode:   ");
   scanf("%d",&code1[2]);
   code2[2]=code3[2]=0;
   }

if ((c=='y') || (c=='Y')) {
if (escape == 0)
 printf("\n\nCurrently set to NOT send escape code prefix.");
 else
 printf("\n\nCurrently set to send escape code prefix.");
printf("\nDo you require an ESCAPE (ASCII 27)before these codes to\n");
printf("switch print modes (y/N)? ");
c=getche();
printf("\n");
if ((c == 'Y') || (c=='y')) {
    code0[0]=code0[1]=code0[2]=code0[3]=code0[4]=code0[5]=27;
    code0[6]=code0[7]=code0[8]=code0[9]=code0[10]=27;
    escape = 1;
    }
   }
 printf("\n\nDo you want to pause after each page (y/N)? ");
 c=getche();
 printf("\n");
 if ((c =='Y') || (c=='y')) {
    pause = 1; /* turn on the pause mode */
    }

 printf("\n\nDo you want the copyright footnote (Y/n)? ");
 c=getche();
 printf("\n");
 if ((c=='n') || (c=='N')) {
   notice = 0; /* turn off the copyright notice */
   bottommargin +=3; /* increase bottom margin by 3 */
   }


if (header == 1) {
printf("\n\nDo you want the sourcefile name as a header (Y/n): ");
c=getche();
if ((c=='n') || (c=='N'))
  header = 0; /* turn off the header */
  }

  } /* end of if argc==3 */


/**************************************************************************
   Now print out the sourcefile
***************************************************************************/

cls();
printf("\nPrintfile Utility - by Mark J. Quarles \n\n");
printf("\nUsing configuration for %s\n",label);
printf("\nPrinting file: %s\n\n",file);

putc(code0[0],f2);
putc(code1[0],f2);
putc(code2[0],f2);
putc(code3[0],f2); /* send out the printer initialization string */

putc('\n',f2);

if (code_on > -1) {
  putc(code0[code_on],f2);
  putc(code1[code_on],f2);
  putc(code2[code_on],f2);
  putc(code3[code_on],f2);
  }

if (header ==1) { /* print the sourcefile name as an enlarged string */

putc(code0[1],f2);
putc(code1[1],f2);
putc(code2[1],f2);
putc(code3[1],f2); /* go to enlarged mode */
fprintf(f2,"                 %s\n",file);
putc(code0[2],f2);
putc(code1[2],f2);
putc(code2[2],f2);
putc(code3[2],f2); /* return to normal mode */
putc('\n',f2);
}
else {
 fprintf(f2,"\n\n\n\n\n");
 }

linenum = 5;

for (marg=0; marg<left_margin; marg++)
 putc(32,f2);

while (((c=getc(f1)) == '\n') || (c==10));
         /* strip off leading carriage returns in line above*/
ungetc(c,f1); /* put back the last character we got */

/*******************************
  Here is our main printing loop
********************************/

while ((c=getc(f1)) != EOF) {
  linecount +=1; /* increment the linecount */
  if ((linecount >=linelimit)&& (c==' ')) {
     putc('\n',f2); /* send a carriage return */
     for (marg=0; marg<left_margin; marg++)
      putc(32,f2);
     linecount = 0; /* reset the line count */
     linenum +=1; /* increment the line  number count */
      }
  if ((linenum >=bottommargin)|| (c==12)) {
      if (c==12) {
         c==0;
         for (marg=linenum; marg<=bottommargin; ++marg)
           putc('\n',f2); /* space down to the proper place */
         }
      putc('\n',f2);
      fprintf(f2,"                             Page %d\n",page);
    if (notice == 1)
      fprintf(f2,"\nCopyrighted material - Disclosure to third parties is prohibited.\n");
      page +=1;
      putc(12,f2); /* send a form feed */
      if (pause == 1) {
        printf("Press any key to begin printing page %d: ",page);
        c=getch();
        printf("\n");
        }
      putc('\n',f2);

    if (header == 1) {

      putc(code0[1],f2);
      putc(code1[1],f2);
      putc(code2[1],f2);
      putc(code3[1],f2); /* enlarged mode */
      fprintf(f2,"                 %s\n",file);
      putc(code0[2],f2);
      putc(code1[2],f2);
      putc(code2[2],f2);
      putc(code3[2],f2); /* normal mode */
      putc('\n',f2);
      }
      else
        fprintf(f2,"\n\n\n\n\n");
      for (marg=0; marg<left_margin; marg++)
        putc(32,f2);
      linenum = 5; /* reset the line number */
      }

  if (c == '\n') {
    putc(c,f2);
    linenum +=1;
    linecount = 0;
    for (marg=0; marg<left_margin; marg++)
      putc(32,f2);
    }
  if (c==9) {
	for (c=0; c<4; c++)
		putc(32,f2); /* tab expansion */
	c=9;
	}

  if ((c!='\n')&& (c!=9)) /* exclude carriage returns and tabs */
   putc(c,f2); /* print the character */
  }
putc('\n',f2);

for (marg=linenum; marg<=bottommargin; marg++)
 putc('\n',f2);

fprintf(f2,"                             Page %d\n",page);
putc(12,f2);
}

arg<=bottommargin; marg++)
 putc('\n',f2);

fprintf(f2,"                             Page %d\n",p