/*	A SET OF ROUTINES SPECIFIC TO THE deSMET C IMPLEMENTATION
 *	OF PCROFF.
 */

#include <stdio.h>
#define UNDERL	1
#define BOLD	2
#define ITALIC	4
#define	SCR_UL	0x01
#define SCR_BO	0x08
#define	SCR_IT	0x80
#define	NORMAL	0x07

FILE *Macwrite;
int fopen(), fclose();
long fseek();
extern unsigned _rax,_rbx,_rcx,_rdx,_rds;

/*
 *	WRITE A CHARACTER TO THE SCREEN, USING FONT CONTROL
 */

putscrn (c,font)
char c;
int font;
{
	/* FIRST PUT THE VIDEO ATTRIBUTE TO THE SCREEN */
		_rax = 0x0900;		/* VIDEO FUNCTION 9 */
					/* ATTRIBUTE IN BX */
		_rbx = (font & UNDERL)? SCR_UL : NORMAL;
		_rbx|= (font & BOLD)?   SCR_BO : 0;
		_rbx|= (font & ITALIC)? SCR_IT : 0;
		_rcx = 1;
		_rds = -1;		/* USE CURRENT DS */
		_doint (0x10);		/* VIDEO INTERRUPT */
	/* NOW USE THE SCROLL FUNCTION TO WRITE THE CHARACTER */
		_rax = 0x0E00 + c;	/* SCROLL FUNCTION 14 IN AH,
					   CHAR IN AL */
		_rbx = 0;
		_doint (0x10);
}

/* DESMET C HAS NO FTELL.  WE'LL CONSTRUCT IT HERE */

long ftell (stream)
FILE *stream;
{
	return (fseek (stream, 0L,1));	/* RETURNS CURRENT POSITION */
				/* USING SPECIAL DESMET VERSION OF FSEEK */
}

/* RETURNS THE CURRENT DATE */

char *
dtform()
{
	static char dst[9];
	dates (dst);
	return dst;
}

/* WAIT UNTIL A KEYBOARD KEYSTROKE, THEN CONTINUE */

waitawhile()
{
	int cc;
	cc = getchar();
}
