#ifndef X1123X3D_H
#define X1123X3D_H

//      Objects instantiated from this class may be used to plot z=f(x,y) in
// in three dimensions on a Panasonic 1123 printer.

//      This class uses the abstract class "plot3d" (3D plot) which in turn uses 
// the template "varray" (one dimensional virtual array) and the class
// "titillat" (to let the user know the code is running).  This class also uses
// "varray".

#include "varray.h"
#include "plot3d.h"

typedef char * char_ptr;

// graphics constants 
#define PIXELS_PER_INCH       180
#define LINE_PREFIX_2          39    // for 180 dpi in 24-pin mode 
#define WIDTH_IN_INCHES         8.0
#define LENGTH_IN_INCHES       11.0
#define NUM_LINES              82
#define NUM_X_PIXELS         1968    // 24*NUM_LINES 
#define X_DOT_MAX            1967    // NUM_X_PIXELS-1 
#define NUM_Y_PIXELS         1440
#define NUM_Y_PIXELS_MOD_256  160
#define NUM_Y_PIXELS_DIV_256    5
#define Y_DOT_MAX            1439    // NUM_Y_PIXELS-1 
#define ASPECT_RATIO            1.0  // (WIDTH_IN_INCHES/((float) NUM_Y_PIXELS))
                                   // /(LENGTH_IN_INCHES/((float) NUM_X_PIXELS)) 

typedef struct
          {
            unsigned char column [NUM_Y_PIXELS] [3];
          } row_rec;  // 3 lines of graphics to be sent to the printer

class x1123x3d : public plot3d
  {
    private:
      varray<row_rec>   *row_array;         
                         // page of graphics to be sent to the printer
      int               row_array_allocated;
                         // TRUE if and only if "row_array" allocated
    public:
      double aspect_ratio(void) {return ASPECT_RATIO;}

      int    display_initialized(void);
//      Allocate and clear the page of graphics to be sent to the printer.

      int    num_x_pixels(void) {return NUM_X_PIXELS;}

      int    num_y_pixels(void) {return NUM_Y_PIXELS;}

      void   pset(int x,int y,int color_num);
//      Use dithering to set the pixel at (x,y).

      int    write_outfile(char *file_name);
//      Write the page of graphics to a file where it can later be copied
// to the printer.  (The /B option *must* be used with the COPY command.)

             x1123x3d(void);

             ~x1123x3d(void);
  };

#endif
