#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>
#include "titillat.h"
#include "plot3d.h"
#include "x1123x3d.h"

#ifndef TRUE
#define TRUE -1
#endif
#ifndef FALSE
#define FALSE 0
#endif

static int pattern [8] [8]
            = { { 0, 32,  8, 40,  2, 34, 10, 42},
                {48, 16, 56, 24, 50, 18, 58, 26},
                {12, 44,  4, 36, 14, 46,  6, 38},
                {60, 28, 52, 20, 62, 30, 54, 22},
                { 3, 35, 11, 43,  1, 33,  9, 41},
                {51, 19, 59, 27, 49, 17, 57, 25},
                {15, 47,  7, 39, 13, 45,  5, 37},
                {63, 31, 55, 23, 61, 29, 53, 21} 
              }; // for dithering

static unsigned char black [8] = {128, 64, 32, 16, 8, 4, 2, 1};
static unsigned char white [8] = {127, 191, 223, 239, 247, 251, 253, 254};

x1123x3d::x1123x3d() : plot3d()
  {
    row_array_allocated=FALSE;
  }

x1123x3d::~x1123x3d()
  {
    if (row_array_allocated)
      delete row_array;
  }

int x1123x3d::display_initialized()
//      Allocate and clear the page of graphics to be sent to the printer.
    {
      row_rec initialized_row_rec;

      if (row_array_allocated)
        {
           delete row_array;
           row_array_allocated=FALSE;
        }
      for (int y_dot_num=0; y_dot_num < NUM_Y_PIXELS; y_dot_num++)
        {
          initialized_row_rec.column[y_dot_num][0]=(unsigned char) '\0';
          initialized_row_rec.column[y_dot_num][1]=(unsigned char) '\0';
          initialized_row_rec.column[y_dot_num][2]=(unsigned char) '\0';
        }
      row_array=new varray<row_rec>(initialized_row_rec,NUM_LINES,2);
      row_array_allocated=(row_array->allocated());
      return row_array_allocated;
    }

void x1123x3d::pset(
  int x,
  int y,
  int shading)  
//      Use dithering to set the pixel at (x,y).
    {
      int     bit_num;
      int     byte_num;
      int     column_num;
      int     on;
      row_rec *row;
      int     row_num;

      if (shading <= NUM_COLORS)
        {
          if (shading == NUM_COLORS)  // outline solution
            if (pattern[x%8][y%8] < SOLUTION_GRAY)
              on=1;
            else
              on=0;
          else
            if (pattern[x%8][y%8] < shading)
              on=1;
            else
              on=0;
          column_num=Y_DOT_MAX-y;
          row_num=x/24;
          row=row_array->vm_ptr((long) row_num);
          bit_num=x-24*row_num;
          byte_num=bit_num/8;
          bit_num=bit_num-8*byte_num;
          if (on)
            row->column[column_num][byte_num]
             =(row->column[column_num][byte_num] & white[bit_num]);
          else
            row->column[column_num][byte_num]
             =(row->column[column_num][byte_num] | black[bit_num]);
        }
      return;
    }

int x1123x3d::write_outfile(
  char *file_name)
//      Write the page of graphics to a file where it can later be copied
// to the printer.  (The /B option *must* be used with the COPY command.)
    {
      char          bidirectional [3] = {'\033', 'U', '\000'};
      char          default_lpi [2] = {'\033', '2'};
      char          formfeed = '\014';
      char          inches_per_line [3] = {'\033', '3', '\030'};
      int           line_num;
      unsigned char line_prefix [5] = {'\033', '*'};
      FILE          *maze;
      char          reset [2] = {'\033', '@'};
      row_rec       *row;
      char          space = ' ';
      int           success;
      char          unidirectional [3] = {'\033', 'U', '\001'};

      line_prefix[2]=(unsigned char) LINE_PREFIX_2;
      if ((maze=fopen(file_name,"wb")) == NULL)
        {
          success=FALSE;
          cerr << "Fatal error:  cannot open " << file_name << '\n';
        }
      else
        {
          success=(fwrite(reset,1,sizeof(reset),maze) == sizeof(reset));
          if (success)
            success=(fwrite(unidirectional,1,sizeof(unidirectional),maze)
             == sizeof(unidirectional));
          if (success)
            success=(fwrite(inches_per_line,1,sizeof(inches_per_line),maze)
             == sizeof(inches_per_line));
          line_prefix[3]=(unsigned char) NUM_Y_PIXELS_MOD_256;
          line_prefix[4]=(unsigned char) NUM_Y_PIXELS_DIV_256;
          titillator_ptr=new titillator;
          for (line_num=0; ((success) && (line_num < NUM_LINES));
           line_num++)
            {
              titillator_ptr->titillate();
              success=(fwrite(line_prefix,1,sizeof(line_prefix),maze)
               == sizeof(line_prefix));
              if (success)
                {
                  row=row_array->vm_ptr((long) line_num);
                  success
                   =(fwrite(&((*row).column[0][0]),1,3*NUM_Y_PIXELS,maze)
                   == 3*NUM_Y_PIXELS);
                }
            }
          delete titillator_ptr;
          if (success)
            success=(fwrite(default_lpi,1,sizeof(default_lpi),maze)
             == sizeof(default_lpi));
          if (success)
            success=(fwrite(bidirectional,1,sizeof(bidirectional),maze)
             == sizeof(bidirectional));
          if (success)
            success=(fwrite(&space,1,sizeof(space),maze) == sizeof(space));
          if (success)
            success=(fwrite(&formfeed,1,sizeof(formfeed),maze)
             == sizeof(formfeed));
          if (success)
            success=(fwrite(&formfeed,1,sizeof(formfeed),maze)
             == sizeof(formfeed));
          if (! success)   
            cerr << "Fatal error:  cannot write result.\n" << '\n';
          fclose(maze);
        }
      return success;
    }
