//
//       This program will generate a three dimensional maze on a Panasonic 1123
//  printer.  A different random number seed will produce a different maze.
//
//       Written by James L. Dean
//                  406 40th Street
//                  New Orleans, LA 70124-1532
//
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <iostream.h>
#include "oracle.h"
#include "cell.h"
#include "titillat.h"
#include "hexmaze.h"
#include "plot3d.h"
#include "x1123x3d.h"

#ifndef TRUE
#define TRUE -1
#endif
#ifndef FALSE
#define FALSE 0
#endif

// maze constants
#define PIXELS_PER_ROOM   80
#define RESOLUTION         4  // larger values takes more time (and virtual
                              // memory) but produce a better image

static int    external_to_plot(double,double);
static double f(double,double);
       int    main(int,char **);
static int    red(double,double);

extern unsigned _stklen=0x8000;
       maze     *maze_ptr;

int main(
  int argc,
  char *argv[])
    {
      static   double   bias;
      static   int      fatal_error;
      static   int      num_columns;
      static   int      num_rows;
      static   double   light_x;
      static   double   light_y;
      static   double   light_z;
      static   double   rotation;
               time_t   start_time;
               time_t   stop_time;
      static   double   tilt;
      static   x1123x3d *x1123x3d_ptr;

      fatal_error=FALSE;
      if ((argc == 2) || ((argc == 3) && (atof(argv[2]) > 0.0)))
        {
          time(&start_time);
          if (argc == 2)
            bias=0.3;
          else
            bias=atof(argv[2]);
          x1123x3d_ptr=new x1123x3d();
          num_columns=(2*(x1123x3d_ptr->num_x_pixels()))/(3*PIXELS_PER_ROOM)-1;
          num_columns=2*num_columns+1;
          num_rows=(int) (((2.0/sqrt(3.0))
           *(x1123x3d_ptr->aspect_ratio())
           *((double) (x1123x3d_ptr->num_y_pixels())))
           /((double) PIXELS_PER_ROOM));
          maze_ptr=new maze(num_rows,num_columns,RESOLUTION,argv[1]);
          if (maze_ptr->constructed())
            {
              rotation=(double) 0.0;
              tilt=(double) 30.0;
              light_x=(double) 1.5;
              light_y=(double) -1.0;
              light_z=(double) 2.6;
              if (x1123x3d_ptr->prepare_plot(f,
               maze_ptr->x_min(),maze_ptr->x_max(),
               maze_ptr->y_min(),maze_ptr->y_max(),external_to_plot,red,
               maze_ptr->num_x_divisions(),maze_ptr->num_y_divisions(),
               rotation,tilt,light_x,light_y,light_z))
                if (x1123x3d_ptr->plot("HEXAGON.MAZ",FALSE,TRUE,bias))
                  if (x1123x3d_ptr->plot("HEXAGON.SOL",TRUE,TRUE,bias))
                    {
                      time(&stop_time);
                      cout << '\n' << "     It took " << stop_time-start_time
                       << " seconds to generate the maze and its solution."
                       << '\n' << '\n'
                       << "     If LPT1: is your Panasonic 1123, "
                       << "\"COPY /B HEXAGON.MAZ LPT1:\"" << '\n'
                       << "and \"COPY /B HEXAGON.SOL LPT1:\"." << '\n';
                    }
                  else
                    fatal_error=TRUE;
                else
                  fatal_error=TRUE;
              else
                fatal_error=TRUE;
            }
          else 
            fatal_error=TRUE;
          delete maze_ptr;
          delete x1123x3d_ptr;
        }
      else
        cout << '\n' << "     This program will generate a three dimensional "
         << "maze suitable for " << '\n' << "printing on a Panasonic 1123 "
         << "printer.  It writes the maze to the file" << '\n'
         << "\"HEXAGON.MAZ\" and the solution to \"HEXAGON.SOL\"." << '\n' 
         << '\n'
         << "     If LPT1: is your Panasonic 1123, \"COPY /B HEXAGON.MAZ "
         << "LPT1:\" to" << '\n' << "print the maze and \"COPY /B HEXAGON.SOL "
         << "LPT1:\" to print the solution." << '\n' << '\n'
         << "     Usage:  HEXAGON <random number seed> [<bias>]" << '\n' << '\n'
         << "       A different <random number seed> will produce a different "
         << "maze." << '\n' << '\n' << "       <bias> adjusts the contrast.  "
         << "It defaults to 0.3 for a new ribbon." << '\n'
         << "       0.5 or higher should be used for a worn ribbon." << '\n'
         << '\n' << "     Example:  HEXAGON 61743076 0.5" << '\n';
      return(fatal_error);
    }

static int external_to_plot(
  double x,
  double y)
    {
       return maze_ptr->external_to_maze(x,y);
    }

static int red(
  double x,
  double y)
    {
       return maze_ptr->part_of_solution(x,y);
    }

static double f(
  double x,
  double y)
    {
       return maze_ptr->f(x,y);
    }

