program test;

type
   sbyte = set of byte;
   prt_name = string[35];
   prntr = record
             point:integer;
             pname: prt_name;
           end;
const
   copyright = 'COPYRIGHT (C) 1985, 1986, 1987, MPM ENTERPRISES, INC.    ';
   address   = '                                306 Park Avenue          ';
   city_state= '                                Wilmette, Illinois  60091';
   esc = #27;
   nul = #0;
   one = #1;
   PICA = 80;        {characters per line used for various modes}
   EXPANDED = 40;
   ELITE = 96;
   EX_ELITE = 48;
   COMPRESSED = 137;
   EX_COMPRESSED = 68;
   COM_ELITE = 158;
   MODE15 = 116;
   EX_MODE15 = 58;
   NPRINTERS = 37;
   NPRINT1 = 36;


const
   stest : array[0..28] of sbyte = (
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20,24],
                   [8,9,10,11,12,13,14,15,17,18,19,20],
                   [8,9,10,11,12,13,14,15,18,20],
                   [8,9,10,11,12,13,14,15,17,18,19,20],
                   [8,9,10,11,12,13,14,15,18,20],
                   [8,9,10,11,12,13,14,15,18,20,24],
                   [8,9,10,11,12,13,14,15,18,20,24],
                   [8,9,10,11,12,13,14,15,18,20,24],
                   [8,9,10,11,12,13,14,15,18,20,24],
                   [8,9,10,11,12,13,14,15,18,20,24] );


   etest : array [0..28] of sbyte = (
                    [33,35,37,38,42,45,47,48,49,50,51,  {0}
                     52,53,54,55,56,57,58,60,61,62,63,
                     64,65,66,67,68,69,70,71,72,73,74,
                     75,76,77,78,79,80,81,82,83,84,85,
                     87,89,90,94,98,105,106,108,112,115],
                    [33,35,37,38,42,45,47,48,49,50,51,  {1}
                     52,53,54,55,56,57,58,60,61,62,63,
                     64,65,66,67,68,69,70,71,72,73,74,
                     75,76,77,78,79,80,81,82,83,84,85,
                     87,89,90,94,98,108,112,115],
                    [33,35,37,38,42,45,47,48,49,50,51,  {2}
                     52,53,54,55,56,57,58,60,61,62,63,
                     64,65,66,67,68,69,70,71,72,73,74,
                     75,76,77,78,79,80,81,82,83,84,85,
                     86,87,89,90,92,94,98,105,106,107,108,
                     112,115,120],
                    [33,35,37,38,42,45,47,48,49,50,51,  {3}
                     52,53,54,55,56,57,58,60,61,62,63,
                     64,65,66,67,68,69,70,71,72,73,74,
                     75,76,77,78,79,80,81,82,83,84,85,
                     86,87,89,90,92,94,98,107,108,112,115,
                     120],
                    [25,33,35,37,38,42,45,47,48,49,50,  {4}
                     51,52,53,54,55,56,57,58,60,61,62,
                     63,64,65,66,67,68,69,70,71,72,73,
                     74,75,76,77,78,79,80,81,82,83,84,
                     85,87,89,90,94,98,105,106,108,112,115],
                    [25,33,35,37,38,42,45,47,48,49,50,  {5}
                     51,52,53,54,55,56,57,58,60,61,62,
                     63,64,65,66,67,68,69,70,71,72,73,
                     74,75,76,77,78,79,80,81,82,83,84,
                     85,87,89,90,94,98,108,112,115],
                    [25,33,35,37,38,42,45,47,48,49,50,  {6}
                     51,52,53,54,55,56,57,58,60,61,62,
                     63,64,65,66,67,68,69,70,71,72,73,
                     74,75,76,77,78,79,80,81,82,83,84,
                     85,86,87,89,90,92,94,98,105,106,107,
                     108,112,115,120],
                    [25,33,35,37,38,42,45,47,48,49,50,  {7}
                     51,52,53,54,55,56,57,58,60,61,62,
                     63,64,65,66,67,68,69,70,71,72,73,
                     74,75,76,77,78,79,80,81,82,83,84,
                     85,86,87,89,90,92,94,98,107,108,112,
                     115,120],
                    [14,15,18,20,25,33,35,37,38,42,45,  {8}
                     47,48,49,50,51,52,53,54,55,56,57,
                     58,60,61,62,63,64,65,66,67,68,69,
                     70,71,72,73,74,75,76,77,78,79,80,
                     81,82,83,84,85,87,89,90,94,97,98,
                     105,106,107,108,112,115,120],
                    [14,15,18,20,25,33,35,37,38,42,45,  {9}
                     47,48,49,50,51,52,53,54,55,56,57,
                     58,60,61,62,63,64,65,66,67,68,69,
                     70,71,72,73,74,75,76,77,78,79,80,
                     81,82,83,84,85,87,89,90,94,97,98,
                     107,108,112,115,120],
                    [14,15,18,20,25,32,33,35,36,37,38,  {10}
                     42,45,47,48,49,50,51,52,53,54,55,
                     56,57,58,60,61,62,63,64,65,66,67,
                     68,69,70,71,72,73,74,75,76,77,78,
                     79,80,81,82,83,84,85,87,89,90,92,
                     94,97,98,107,108,112,115,116,119,120],
                    [14,15,18,20,33,35,37,38,42,45,47,  {11}
                     48,49,50,51,52,53,54,55,56,57,58,
                     60,61,62,63,64,65,66,67,68,69,70,
                     71,72,73,74,75,76,77,78,79,80,81,
                     82,83,84,85,87,89,90,94,98,105,106,
                     108,112,114,115],
                    [14,15,18,20,33,35,37,38,42,45,47,  {12}
                     48,49,50,51,52,53,54,55,56,57,58,
                     60,61,62,63,64,65,66,67,68,69,70,
                     71,72,73,74,75,76,77,78,79,80,81,
                     82,83,84,85,86,87,89,90,92,94,98,
                     105,106,107,108,112,114,115,120],
                    [14,15,18,20,25,32,33,35,36,37,38,  {13}
                     42,45,47,48,49,50,51,52,53,54,55,
                     56,57,58,60,61,62,63,64,65,66,67,
                     68,69,70,71,72,73,74,75,76,77,78,
                     79,80,81,82,83,84,85,87,89,90,92,
                     94,97,98,105,106,107,108,112,114,115,116,
                     120],
                    [14,15,18,20,25,32,33,35,36,37,38,  {14}
                     42,45,47,48,50,51,52,53,56,57,58,
                     60,61,62,63,64,65,66,67,68,69,70,
                     71,72,74,75,76,77,78,79,80,81,82,
                     83,84,85,86,87,89,90,92,98,107,108,
                     112,115,120],
                    [14,15,18,20,25,32,33,35,36,37,38,  {15}
                     42,45,47,48,50,51,52,53,56,57,58,
                     60,61,62,63,64,65,66,67,68,69,70,
                     71,72,74,76,77,78,79,80,81,82,83,
                     84,85,86,87,89,90,92,97,98,107,108,
                     112,115,120],
                    [14,15,18,20,25,32,33,35,36,37,38,  {16}
                     42,45,47,48,50,51,52,53,54,55,58,
                     60,61,62,63,64,65,66,67,68,69,70,
                     71,72,74,75,76,77,78,79,80,81,82,
                     83,84,85,87,89,90,92,97,98,101,102,
                     103,107,108,112,115,116,120],
                    [14,15,18,20,25,32,33,35,36,37,38,  {17}
                     42,45,47,48,50,51,52,53,54,55,58,
                     60,61,62,63,64,65,66,67,68,69,70,
                     71,72,74,75,76,77,78,79,80,81,82,
                     83,84,85,87,89,90,92,97,98,103,107,
                     108,112,114,115,116,119,120],
                    [25,33,37,38,42,45,47,48,49,50,51,  {18}
                     52,53,56,57,58,60,63,64,65,66,67,
                     68,69,70,71,72,74,75,76,77,78,79,
                     80,81,82,83,84,85,87,89,90,94,97,
                     98,101,102,108,109,115],
                    [14,15,18,20,25,33,37,38,42,45,47,  {19}
                     48,49,50,51,52,53,54,55,56,57,58,
                     60,63,64,65,66,67,68,69,70,71,72,
                     74,75,76,77,78,79,80,81,82,83,84,
                     85,87,89,90,94,97,98,101,102,108,109,
                     115,116],
                    [14,15,18,20,48,49,50,51,52,53,56,  {20}
                     57,60,61,62,64,65,66,68,69,70,71,
                     72,74,75,76,80,83,84],
                    [35,45,48,49,50,51,52,53,56,57,60,  {21}
                     61,62,64,65,67,68,69,70,71,72,74,
                     75,76,78,79,81,83,84,85,87],
                    [14,15,18,20,48,50,56,57,65,67,68,  {22}
                     69,70,71,72,75,76,78,79,81,82],
                    [14,15,18,20,42,45,48,49,50,51,52,  {23}
                     53,56,57,60,64,65,67,68,69,70,71,
                     72,74,75,76,77,78,79,80,81,82,83,
                     84,85,87,89,90,101,102,108,109,115],
                    [14,15,18,20,42,45,48,49,50,51,52,  {24}
                     53,56,57,60,64,65,67,68,69,70,71,
                     72,74,75,76,77,78,79,80,81,82,83,
                     84,85,87,89,90,94,108,109,115],
                    [14,15,18,20,25,33,42,45,47,48,49,  {25}
                     50,51,52,53,56,57,60,64,65,66,67,
                     68,69,70,71,72,74,75,76,77,78,79,
                     80,81,82,83,84,85,87,89,90,94,98,
                     101,102,108,109,115],
                    [14,15,18,20,25,33,42,45,47,48,49,  {26}
                     50,51,52,53,56,57,60,64,65,66,67,
                     68,69,70,71,72,74,75,76,77,78,79,
                     80,81,82,83,84,85,87,89,90,94,98,
                     108,109,115],
                    [14,15,18,20,25,33,38,42,45,47,48,  {27}
                     49,50,51,52,53,56,57,58,60,64,65,
                     66,67,68,69,70,71,72,74,75,76,77,
                     78,79,80,81,82,83,84,85,86,87,89,
                     90,94,98,101,102,107,108,109,112,115,120],
                    [14,15,18,20,25,33,38,42,45,47,48,  {28}
                     49,50,51,52,53,56,57,58,60,64,65,
                     66,67,68,69,70,71,72,74,75,76,77,
                     78,79,80,81,82,83,84,85,86,87,89,
                     90,94,98,107,108,109,112,115,120] );

printers: array[0..NPRINT1] of prntr = (
        (point:0;  pname: 'FX-80'),
        (point:1;  pname: 'FX-100'),
        (point:2;  pname: 'FX-80 with Letter Quality ROM'),
        (point:3;  pname: 'FX-100 with Letter Quality ROM'),
        (point:4;  pname: 'FX-80+'),
        (point:5;  pname: 'FX-100+'),
        (point:6;  pname: 'FX-80+ with Letter Quality ROM'),
        (point:7;  pname: 'FX-100+ with Letter Quality ROM'),
        (point:8;  pname: 'FX-85'),
        (point:9;  pname: 'FX-185'),
        (point:9;  pname: 'FX-285'),
        (point:10; pname: 'FX-86e'),
        (point:10; pname: 'FX-286e'),
        (point:11; pname: 'JX-80'),
        (point:12; pname: 'JX-80 with Letter Quality ROM'),
        (point:13; pname: 'EX-800'),
        (point:13; pname: 'EX-1000'),
        (point:14; pname: 'LQ-1500 version 1.8'),
        (point:15; pname: 'LQ-1500 version 2.0'),
        (point:16; pname: 'LQ-800'),
        (point:16; pname: 'LQ-1000'),
        (point:17; pname: 'LQ-2500'),
        (point:18; pname: 'LX-80'),
        (point:19; pname: 'LX-86'),
        (point:20; pname: 'MX-80 with GRAFTRAX (old GRAFTRAX)'),
        (point:21; pname: 'MX-80 with GRAFTRAX+ (Type III)'),
        (point:22; pname: 'MX-100 Type II (original MX-100)'),
        (point:21; pname: 'MX-100 with GRAFTRAX+ (Type III)'),
        (point:23; pname: 'RX-80'),
        (point:23; pname: 'RX-80 F/T'),
        (point:24; pname: 'RX-100'),
        (point:25; pname: 'RX-80+'),
        (point:25; pname: 'RX-80 F/T+'),
        (point:26; pname: 'RX-100+'),
        (point:27; pname: 'RX-80+ with Letter Quality ROM'),
        (point:27; pname: 'RX-80 F/T+ with Letter Quality ROM'),
        (point:28; pname: 'RX-100+ with Letter Quality ROM') );


type
   regs = record
            case integer of
               1: (ax,bx,cx,dx,bp,si,di,ds,es,flags: integer);
               2: (al,ah,bl,bh,cl,ch,dl,dh         : byte);
            end;
var
   i,j,k,l,margin:integer;
   this_print:integer;
   ii,jj,tt  : char;
   test_escape,test_control: set of byte;

function MPM_print_installed: boolean;  {logical function, returns FALSE}
                                        { if the printer contol program }
                                        { is NOT installed; true if it is}
                                        {We test this because this program}
                                        { will cause an Epson printer to do}
                                        { some squirrely things if MPM-Print}
                                        { is not memory-resident.}
var
   tregs:regs;
begin
   MPM_print_installed:=FALSE;
   with tregs do
   begin
      ax:=$CAFE;          {hexadecimal value to test if MPM-Print is installed}
      bx:=1;              {make sure MPM-Print is turned ON}
      intr($17,tregs);    {call the printer interrupt}
      if (ax = $FEED) then
      begin
         MPM_print_installed:=TRUE;
         this_print := dx; {DX register holds the number of the printer}
                           {according to the list above}
      end;
   end;
end;

procedure print_chars;   {prints the 240 characters that can be printed}
var i,j:integer;         {by MPM-print}

begin
   j:=0;
   for i:=1 to 254 do
   begin
      if (i in [1..6,16,21..23,25,26,28..254]) then
      begin
         write(lst,char(i));
         j:=succ(j);                  {print only the number of allowed}
         if (j>=margin) then          {characters per line}
         begin
            writeln(lst);
            j:=0;
         end;
      end;
   end;
   writeln(lst);
   writeln(lst);
end;

procedure print_design;
begin
   writeln(lst,'  ͻͻͻͻͻͻ');
   writeln(lst,'  ͺȻȻߺɼɼͼ');
   writeln(lst,'    ͼͼͼͼͼ');
   writeln(lst);
end;

procedure do_bar(tt:char);
var j:integer;
begin
   write(lst,'',esc,tt,char(120),nul);
   for j:=1 to 60 do write(lst,char(127),char(42));
   writeln(lst,'');        
   write(lst,'',esc,tt,char(120),nul);
   for j:=1 to 60 do write(lst,char(127),char(42));
   writeln(lst,'');
   write(lst,'',esc,tt,char(120),nul);
   for j:=1 to 60 do write(lst,char(127),char(42));
   writeln(lst,'');
   writeln(lst);
   writeln(lst);
end;


procedure do_control_codes(i:integer);   {test the single-byte control codes}
begin
   gotoxy(1,15);
   clreol;
   write('testing control code ',i);

   case i of
     7: writeln(lst,'BELL (chr$(7))',char(7));
     8: begin
           write(lst,'BACKSPACE (chr$(8))');
           for j:=1 to 19 do write(lst,char(8));
           writeln(lst,'/\/\/\/\/');
        end;
     9: begin
           for j:=1 to 5 do write(lst,'TAB (chr$(9))',char(9));
           writeln(lst);
        end;
     10: for j:=1 to 5 do write(lst,'LINE FEED (chr$(10))',char(10));
     11: for j:=1 to 5 do write(lst,'VERTICAL TAB (chr$(11))',char(11));
     13: begin
           for j:=1 to 5 do write(lst,'CARRIAGE RETURN (chr$(13))',char(13));
           writeln(lst);
         end;
     14: begin
            writeln(lst,char(14),'ONE LINE EXPANDED MODE ON (chr$(14))');
            writeln(lst);
            margin:=EXPANDED;
            print_chars;
            writeln(lst,'ONE LINE EXPANDED MODE OFF (chr$(20))',char(20));
            margin:=PICA;
         end;
     15: begin
            writeln(lst,'SHIFT IN (COMPRESSED MODE ON) (chr$(15))',char(15));
            writeln(lst);
            margin:=COMPRESSED;
            print_chars;
            print_design;
            writeln(lst,'COMPRESSED MODE OFF',char(18),'(chr$(18))');
            margin:=PICA;
         end;
   end;  {case statement}

   if (i in [7,8,9,10,11,13,14,15]) then    {filter inadvertent control codes}
   begin
      writeln(lst);
      writeln(lst);
   end;

end;   {do_control_codes}

procedure clear_escape_codes(e_code:integer);    {reset the printer from}
begin                                            {whatever mode was set}
   tt:=char(e_code);                             {by do_escape_codes}

   case e_code of
      14: writeln(lst,char(20));
      15: begin
             writeln(lst,'COMPRESSED MODE OFF ',char(18),'(CHR$(18))');
          end;
      33: begin
             writeln(lst,'MASTER PRINT MODE SELECT');
             writeln(lst,'(choosing Pica, (ESC 33 0)',
                           esc,tt,nul);
          end;
      38: writeln(lst,'SELECTING the ROM character set (ESC 37 0 0)',
                  esc,char(37),nul,nul);
      45: writeln(lst,esc,tt,nul,'NON-UNDERLINE MODE (ESC 45 0)');
      48: writeln(lst,'RESET LINE SPACING TO DEFAULT 1/6 INCH ',
                      ' (ESC 50)',esc,char(50));
      49: writeln(lst,'RESET LINE SPACING TO DEFAULT 1/6 INCH ',
                      ' (ESC 50)',esc,char(50));
      51: writeln(lst,'RESET LINE SPACING TO DEFAULT 1/6 INCH ',
                      ' (ESC 50)',esc,char(50));
      52: writeln(lst,esc,char(53),'TURN THE ITALIC CHARACTER SET OFF',
                                   ' (ESC 53)');
      63: begin
             writeln(lst,'RESETTING THE GRAPHICS MODE (ESC 63 K 0)',
                      esc,char(63),'K',char(0) );
             writeln(lst,'printing a graphics bar',
                     ' (ESC 75 120 0 +120 character bytes)');
             do_bar(char(75));
          end;
      65: writeln(lst,'RESET LINE SPACING TO DEFAULT 1/6 INCH ',
                      ' (ESC 50)',esc,char(50));
      69: writeln(lst,'TURN EMPHASIZED MODE OFF (ESC 70)',esc,char(70));
      71: writeln(lst,'TURN DOUBLE STRIKE MODE OFF (ESC 72)',esc,char(72));
      77: writeln(lst,'TURN ELITE MODE OFF (ESC 80)',esc,char(80));
      81: begin
             writeln(lst,esc,tt,char(80),
                  'RESET THE COLUMN WIDTH TO 80 (ESC 81 80)');
          end;
      82: begin
             writeln(lst,'RESET THE INTERNATIONAL CHARACTER SET');
             writeln(lst,'to the USA set (ESC 82 0)',esc,tt,nul);
             writeln(lst);
             print_chars;
          end;
      85: writeln(lst,'TURN UNIDIRECTIONAL MODE OFF (ESC 85 0)',
                  esc,tt,nul);
      87: writeln(lst,'TURN EXPANDED MODE OFF (ESC 87 0)',
                  esc,tt,nul);
     103: writeln(lst,'TURN 15 CPI MODE OFF (ESC 80)',esc,char(80));
     108: begin
             writeln(lst,'RESET LEFT MARGIN TO 0 CHARACTERS (ESC 108 0)');
             writeln(lst,esc,tt,nul);
             writeln(lst);
          end;
     112: writeln(lst,'TURN PROPORTIONAL MODE OFF (ESC 112 0)',
                  esc,tt,nul);
     115: writeln(lst,'HALF-SPEED MODE OFF (ESC 115 0)',
                  esc,tt,nul);
     120: writeln(lst,'RESETTING TO DRAFT MODE (ESC 120 0)',esc,tt,char(0));
   end;   {case statement}

   if (e_code in [15,33,38,45,48,49,51,52,65,69,71,77,81,85,87,97,103,108,112,115]) then
   begin                       {filter inadvertent escape codes}
      writeln(lst);
      writeln(lst);
   end;

   margin:=PICA;      {all resets return the printer to the normal, PICA mode}
end;   {clear_escape_codes}

procedure do_escape_codes(e_code:integer);
begin
   gotoxy(1,15);
   clreol;
   write('testing escape code ',e_code);
   tt:=char(e_code);

   case e_code of
      14: begin
             writeln(lst,esc,tt,'ONE LINE EXPANDED MODE ON (ESC 14)');
             margin:=EXPANDED;
          end;
      15: begin
             writeln(lst,'SHIFT IN (COMPRESSED MODE ON) (ESC 15)',esc,tt);
             margin:=COMPRESSED;
          end;
      33: begin
             writeln(lst,'MASTER PRINT MODE SELECT');
             writeln(lst,'(choosing Expanded Compressed, (ESC 33 36)',
                           esc,tt,char(36));
             margin:=EX_COMPRESSED;
          end;
      36: begin
             writeln(lst,'ABSOLUTE HORIZONTAL TAB');
             writeln(lst,'(tabbing to 2 inches (ESC 36 n1 n2), where space= (n1+256*n2)/60)');
             write(lst,esc,tt,chr(120),chr(0));
             margin:=EX_ELITE;
          end;
      38: begin
             writeln(lst,'USING THE DOWNLOAD CHARACTER SET');
             writeln(lst,'*** NOTE ***');
             writeln(lst,'printer switches must be set according to ',
                         'manual instructions for the download set to work');
             writeln(lst);
             writeln(lst,'COPYING CHARACTER SET FROM ROM TO THE DOWNLOAD RAM',
                         ' (ESC 58 0 0 0)',esc,char(58),nul,nul,nul);
             writeln(lst);

             if (this_print in [17..21]) then
              begin
                writeln(lst,'REPLACING THE "A" WITH A MODIFIED CHARACTER',
                            ' (ESC 38 0 65 65 1 9 2 +27 character bytes) ',
                            esc,char(38),nul,char(65),char(65),
                            char(1),char(9),char(2),
                            char(1),char(0),char(0),
                            char(2),char(0),char(0),
                            char(4),char(0),char(0),
                            char(8),char(0),char(0),
                            char(23),char(255),char(240),
                            char(8),char(0),char(0),
                            char(4),char(0),char(0),
                            char(2),char(0),char(0),
                            char(1),char(0),char(0));
              end
             else
              begin
                writeln(lst,'REPLACING THE "A" WITH A MODIFIED CHARACTER',
                            ' (ESC 38 0 65 65 +12 character bytes) ',
                            esc,char(38),nul,char(65),char(65),char(139),
                            char(7),char(8),char(16),char(36),char(64),
                            char(36),char(16),char(8),char(7),nul,nul);
              end;
             writeln(lst);
             writeln(lst,'SELECTING the download character set (ESC 37 1)',
                     esc,char(37),one,nul);
          end;
      42: begin
             writeln(lst,'MASTER GRAPHICS MODE SELECTION');
             writeln(lst,'printing a graphics bar using quad density',
                     ' (ESC 42 3 120 0 +120 character bytes)');
             ii := char(3);
             write(lst,'',esc,tt,ii,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(42));
             writeln(lst,'');        
             write(lst,'',esc,tt,ii,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(42));
             writeln(lst,'');
             write(lst,'',esc,tt,ii,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(42));
             writeln(lst,'');
             writeln(lst);
             writeln(lst);
          end;
      45: writeln(lst,'UNDERLINE MODE (ESC 45 1)',esc,tt,one);
      48: writeln(lst,'SET LINE SPACING TO 1/8 INCH (ESC 48)',
                  esc,tt);
      49: writeln(lst,'SET LINE SPACING TO 7/72 INCH (ESC 49)',
                  esc,tt);
      51: begin
             if (this_print in [17..21]) then
                writeln(lst,'SET LINE SPACING TO N/180 INCH')
             else
                writeln(lst,'SET LINE SPACING TO N/216 INCH');
             writeln(lst,'using n=63 (ESC 51 63)',esc,tt,char(63));
          end;
      52: writeln(lst,'TURN THE ITALIC CHARACTER SET ON (ESC 52)',
                  esc,tt);
      60: writeln(lst,'TURN ON ONE-LINE UNIDIRECTIONAL MODE (ESC 60)',
                  esc,tt);
      63: begin
             writeln(lst,'REASSIGNING GRAPHICS MODE (reassigning quad density',
                         ' to single density');
             writeln(lst,'(ESC 63 K 3)',esc,tt,'K',char(3));
             writeln(lst,'printing a graphics bar',
                     ' (ESC 75 120 0 +120 character bytes)');
             do_bar(char(75));
          end;
      65: begin
             if (this_print in [17..21]) then
              begin
                writeln(lst,'SET LINE SPACING TO n/60 INCH');
                writeln(lst,'using 30 dots (ESC 65 30)',esc,tt,char(30));
              end
             else
              begin
                writeln(lst,'SET LINE SPACING TO n/72 INCH (n DOTS)');
                writeln(lst,'using 36 dots (ESC 65 36)',esc,tt,char(36));
              end;
          end;
      66: begin
             writeln(lst,'SET UP TO 16 VERTICAL TABS');
             writeln(lst,'using 4 tab settings at 5,11,18, and 26 ',
                     '(ESC 66 5 11 18 26 0)',esc,tt,char(5),char(11),
                     char(18),char(26),nul);
             writeln(lst);
             writeln(lst,'SETTING TOP OF FORM');
             write(lst,char(12));
             do_control_codes(11);
          end;
      67: begin
             write(lst,'GO TO TOP OF FORM',char(12),esc,tt,char(30));
             writeln(lst,'SET FORM LENGTH IN LINES');
             writeln(lst,'set to 30 lines (ESC 67 30)');
             writeln(lst,'go to "top of form"');
             write(lst,char(12),esc,tt,nul,char(6));
             writeln(lst,'SET FORM LENGTH IN INCHES');
             writeln(lst,'set to 6 inches (ESC 67 6)');
             writeln(lst);
             write(lst,'go to "top of form" and reset form length to 66 lines',
                   char(12),esc,tt,char(66));
          end;
      68: begin
             writeln(lst,'SET UP TO 32 HORIZONTAL TABS');
             writeln(lst,'using 6 tab settings at 18,34,48,60, and 70 ',
                     '(ESC 68 18 34 48 60 70 0)',esc,tt,char(18),char(34),
                     char(48),char(60),char(70),nul);
             writeln(lst);
             do_control_codes(9);
             writeln(lst);
          end;
      69: writeln(lst,'TURN EMPHASIZED ON MODE (ESC 69)',esc,tt);
      71: writeln(lst,'TURN DOUBLE STRIKE MODE ON (ESC 71)',esc,tt);
      74: begin
             if (this_print in [17..21]) then
              begin
                writeln(lst,'FORCE AN IMMEDIATE LINE FEED OF n/180 INCHES');
                write(lst,'use n=153 (ESC 74 153)',esc,tt,char(153));
                write(lst,'153/180 inch linefeed complete');
              end
             else
              begin
                writeln(lst,'FORCE AN IMMEDIATE LINE FEED OF n/216 INCHES');
                write(lst,'use n=188 (ESC 74 188)',esc,tt,char(188));
                write(lst,'188/216 inch linefeed complete');
              end;
             writeln(lst);
          end;
      75: begin
             writeln(lst,'NORMAL GRAPHICS MODE');
             writeln(lst,'printing a graphics bar',
                     ' (ESC 75 120 0 +120 character bytes)');
             do_bar(tt);
          end;
      76: begin
             writeln(lst,'LOW-SPEED DOUBLE-DENSITY GRAPHIC MODE');
             writeln(lst,'printing a graphics bar',
                     ' (ESC 76 120 0 +120 character bytes)');
             do_bar(tt);
          end;
      77: begin
             writeln(lst,'TURN ELITE MODE ON (ESC 77)',esc,tt);
             margin:=ELITE;
          end;
      81: begin
             writeln(lst,'SET THE COLUMN WIDTH  (RIGHT MARGIN)');
             writeln(lst,esc,tt,char(60),'set to 60 columns (ESC 81 60)');
             writeln(lst,'(Notice that lines of "special" characters that MPM-print uses are truncated');
             writeln(lst,'rather than wrapped at the right margin)');
             {don't reset the margin, to see how graphics behaves}
          end;
      82: begin
             writeln(lst,'SELECT AN INTERNATIONAL CHARACTER SET');
             writeln(lst,'use the Swedish set (ESC 82 5)',esc,tt,char(5));
          end;
      83: begin
             writeln(lst,'TURN SCRIPT MODE ON (TO SUPER- OR SUBSCRIPT)');
             writeln(lst);
             write(lst,esc,tt,nul,'SUPERSCRIPT (ESC 83 0)',esc,char(84),
                  ' NORMAL ',esc,tt,one,'SUBSCRIPT (ESC 83 1)',
                  esc,char(84));
             writeln(lst);
             writeln(lst);
          end;
      85: writeln(lst,'TURN UNIDIRECTIONAL MODE ON (ESC 85 1)',
                  esc,tt,one);
      86: begin
             writeln(lst,'REPEAT DATA 5 TIMES (ESC 86 5 data ESC 86 0)');
             write(lst,esc,tt,char(5));
             writeln(lst,'one two three four five');
             write(lst,esc,tt,char(0));
          end;
      87: begin
             writeln(lst,'TURN EXPANDED MODE ON (ESC 87 1)',esc,tt,one);
             margin:=EXPANDED;
          end;
      89: begin
             writeln(lst,'HIGH-SPEED DOUBLE-DENSITY GRAPHICS');
             writeln(lst,'printing a graphics bar',
                     ' (ESC 89 120 0 +120 character bytes)');
             do_bar(tt);
          end;
      90: begin
             writeln(lst,'QUADRUPLE DENSITY GRAPHICS MODE');
             writeln(lst,'printing a graphics bar',
                     ' (ESC 90 120 0 +120 character bytes)');
             do_bar(tt);
          end;
      92: begin
             writeln(lst,'MOVE PRINT HEAD 1.5 INCHES (ESC 92 n1 n2), where position = (n1+256*n2)/120)');
             write(lst,esc,tt,chr(180),chr(0));
             margin:=EXPANDED;
          end;
      94: begin
             writeln(lst,'9-PIN GRAPHICS MODE');
             writeln(lst,'printing a single density graphics bar',
                     ' (ESC 94 0 120 0 +120 character bytes)');
             write(lst,esc,tt,nul,char(120),nul);
             for j:=1 to 60 do write(lst,char(127),char(255),
                                     char(42),char(255));
             writeln(lst);
             writeln(lst);
          end;
      97: begin
             writeln(lst,'JUSTIFICATION ON (ESC 97 n)');
             writeln(lst,'     where n:');
             writeln(lst,'             0 = left justified (normal text)');
             writeln(lst,'             1 = centered');
             writeln(lst,'             2 = right justified');
             writeln(lst,'             3 = right and left justified');
             write(lst);
             writeln(lst,esc,tt,char(1),'One - centered');
             writeln(lst,esc,tt,char(2),'Two - right justified');
             writeln(lst,esc,tt,char(0),'Zero - left justified');
          end;
      98: begin
             writeln(lst,'SET VERTICAL TAB FOR CHANNEL n');
             writeln(lst,'setting channel 3,');
             writeln(lst,'using 4 tab settings at 7,14,28, and 56 ',
                     '(ESC 98 3 7 14 28 56 0)',esc,tt,char(3),char(7),char(14),
                     char(28),char(56),nul);
             writeln(lst);
             writeln(lst,'CHOOSING CHANNEL 3 (ESC 47 3)',esc,char(47),char(3));
             writeln(lst);
             writeln(lst,'SETTING TOP OF FORM');
             write(lst,char(12));
             do_control_codes(11);
             writeln(lst,'CHOOSING CHANNEL 0 (ESC 47 0)',esc,char(47),nul);
             writeln(lst);
          end;
     101: begin
             writeln(lst,'SET HORIZONTAL AND VERTICAL TAB INCREMENTS');
             writeln(lst,'set horizontal tabs to 13 spaces (ESC 101 0 13)',
                     esc,tt,nul,char(13));
             writeln(lst);
             do_control_codes(9);
             writeln(lst,'set vertical tabs to 11 lines (ESC 101 1 11)',
                     esc,tt,one,char(11));
             do_control_codes(11);
          end;
     102: begin
             writeln(lst,'PRINT SPACES OR LINE FEEDS W/O CARRIAGE RETURNS');
             writeln(lst,'print 5 spaces',esc,tt,nul,char(5),'(ESC 102 0 5)');
             writeln(lst,'print 13 line feeds',esc,tt,one,char(13),
                     '(ESC 102 1 13)');
             writeln(lst);
          end;
     103: begin
             writeln(lst,'TURNING 15 CPI MODE ON (ESC 103)',esc,tt);
             margin := MODE15;
          end;
     106: begin
             if (this_print in [17..21]) then
              begin
                writeln(lst,'CAUSE IMMEDIATE REVERSE LINE FEED OF n/180 INCH');
                writeln(lst,'use n=15 (half a line,',esc,tt,char(15),' ESC 106 15)');
              end
             else
              begin
                writeln(lst,'CAUSE IMMEDIATE REVERSE LINE FEED OF n/216 INCH');
                writeln(lst,'use n=18 (half a line,',esc,tt,char(18),' ESC 106 18)');
              end;
             writeln(lst);
             writeln(lst);
          end;
     108: begin
             writeln(lst,'SET LEFT MARGIN TO n CHARACTERS');
             writeln(lst,'use 10 characters (ESC 108 10)');
             writeln(lst,esc,tt,char(10));
             margin:=69;
          end;
     112: writeln(lst,'TURN PROPORTIONAL MODE ON (ESC 112 1)',
                  esc,tt,one);
     115: writeln(lst,'HALF-SPEED MODE ON (ESC 115 1)',
                  esc,tt,one);
     120: writeln(lst,'NEAR LETTER QUALITY MODE ON (ESC 120 1)',esc,tt,char(1));
   end;   {case statement}

   if (e_code in [14,15,33,38,42,45,48,49,51,52,65,68,69,71,74,75,76,77,81,
                  82,83,85,87,89,90,94,98,102,106,112,115,120]) then writeln(lst);
   {filter inadvertent escape codes}

end;


procedure combination1;
begin
   gotoxy(1,15);
   clreol;
   write('testing basic print mode combinations');

   margin:=PICA;
   writeln(lst,' 0  Pica');
   print_chars;

   if (77 in test_escape) then margin:=ELITE else margin:=PICA;
   writeln(lst,' 1  Elite');
   write(lst,chr(27),'M');
   print_chars;
   write(lst,chr(27),'P');

   margin:=COMPRESSED;
   writeln(lst,' 2  Compressed');
   write(lst,chr(15));
   print_chars;
   write(lst,chr(18));

   if (this_print in [15..23]) then margin:=COM_ELITE else margin:=ELITE;
   writeln(lst,' 3  Compressed Elite');
   write(lst,chr(27),'M',chr(15));
   print_chars;
   write(lst,chr(27),'P',chr(18));

   margin:=PICA;
   writeln(lst,' 4  Emphasized Pica');
   write(lst,chr(27),'E');
   print_chars;
   write(lst,chr(27),'F');

   if (77 in test_escape) then margin:=ELITE else margin:=PICA;
   writeln(lst,' 5  Emphasized Elite');
   write(lst,chr(27),'E',chr(27),'M');
   print_chars;
   write(lst,chr(27),'F',chr(27),'P');

   if (this_print in [15..21]) then margin:=COMPRESSED else margin:=PICA;
   writeln(lst,' 6  Emphasized Compressed');
   write(lst,chr(27),'E',chr(15));
   print_chars;
   write(lst,chr(27),'F',chr(18));

   if (this_print in [15..21]) then margin:=COM_ELITE
   else if (77 in test_escape) then margin:=ELITE
   else margin:=PICA;
   writeln(lst,' 7  Emphasized Compressed Elite');
   write(lst,chr(27),'E',chr(15),chr(27),'M');
   print_chars;
   write(lst,chr(27),'F',chr(18),chr(27),'P');

   margin:=EXPANDED;
   writeln(lst,' 8  Expanded Pica');
   write(lst,chr(27),'W',chr(1));
   print_chars;
   write(lst,chr(27),'W',chr(0));

   if (77 in test_escape) then margin:=EX_ELITE else margin:=EXPANDED;
   writeln(lst,' 9  Expanded Elite');
   write(lst,chr(27),'W',chr(1),chr(27),'M');
   print_chars;
   write(lst,chr(27),'W',chr(0),chr(27),'P');

   margin:=EX_COMPRESSED;
   writeln(lst,'10 Expanded Compressed');
   write(lst,chr(27),'W',chr(1),chr(15));
   print_chars;
   write(lst,chr(27),'W',chr(0),chr(18));

   if (this_print in [15..23]) then margin:=PICA 
   else if (77 in test_escape) then margin:=EX_ELITE
   else margin:=EXPANDED;
   writeln(lst,'11 Expanded Compressed Elite');
   write(lst,chr(27),'W',chr(1),chr(15),chr(27),'M');
   print_chars;
   write(lst,chr(27),'W',chr(0),chr(18),chr(27),'P');

   margin:=EXPANDED;
   writeln(lst,'12 Emphasized Expanded Pica');
   write(lst,chr(27),'E',chr(27),'W',chr(1));
   print_chars;
   write(lst,chr(27),'F',chr(27),'W',chr(0));

   if (77 in test_escape) then margin:=EX_ELITE else margin:=EXPANDED;
   writeln(lst,'13 Exphasized Expanded Elite');
   write(lst,chr(27),'E',chr(27),'W',chr(1),chr(27),'M');
   print_chars;
   write(lst,chr(27),'F',chr(27),'W',chr(0),chr(27),'P');

   if (this_print in [15..21]) then margin:=EX_COMPRESSED else margin:=EXPANDED;
   writeln(lst,'14 Emphasized Expanded Compressed');
   write(lst,chr(27),'E',chr(27),'W',chr(1),chr(15));
   print_chars;
   write(lst,chr(27),'F',chr(27),'W',chr(0),chr(18));

   if (this_print in [15..21]) then margin:=PICA
   else if (77 in test_escape) then margin:=EX_ELITE
   else margin:=EXPANDED;
   writeln(lst,'15 Emphasized Expanded Compressed Elite');
   write(lst,chr(27),'E',chr(27),'W',chr(1),chr(15),chr(27),'M');
   print_chars;
   write(lst,chr(27),'F',chr(27),'W',chr(0),chr(18),chr(27),'P');

   margin:=PICA;
   writeln(lst,' 0  Pica');
   print_chars;
   
end;

procedure combination2;
begin
   gotoxy(1,15);
   clreol;
   write('testing basic print mode combinations + 15 CPI pitch');

   margin:=MODE15;
   writeln(lst,'16 15 CPI');
   write(lst,chr(27),'g');
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=ELITE;
   writeln(lst,'17 15 CPI + Elite');
   write(lst,chr(27),'g',chr(27),'M');
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=MODE15;
   writeln(lst,'18 Compressed 15 CPI');
   write(lst,chr(27),'g',chr(15));
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=COM_ELITE;
   writeln(lst,'19 Compressed Elite + 15 CPI');
   write(lst,chr(27),'g',chr(27),'M',chr(15));
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=MODE15;
   writeln(lst,'20 Emphasized 15 CPI');
   write(lst,chr(27),'g',chr(27),'E');
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=ELITE;
   writeln(lst,'21 Emphasized Elite + 15 CPI');
   write(lst,chr(27),'g',chr(27),'E',chr(27),'M');
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=MODE15;
   writeln(lst,'22 Emphasized Compressed 15 CPI');
   write(lst,chr(27),'g',chr(27),'E',chr(15));
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=COM_ELITE;
   writeln(lst,'23 Emphasized Compressed Elite + 15 CPI');
   write(lst,chr(27),'g',chr(27),'E',chr(15),chr(27),'M');
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=EX_MODE15;
   writeln(lst,'24 Expanded 15 CPI');
   write(lst,chr(27),'g',chr(27),'W',chr(1));
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=EX_ELITE;
   writeln(lst,'25 Expanded Elite + 15 CPI');
   write(lst,chr(27),'g',chr(27),'W',chr(1),chr(27),'M');
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=EX_MODE15;
   writeln(lst,'26 Expanded Compressed 15 CPI');
   write(lst,chr(27),'g',chr(27),'W',chr(1),chr(15));
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=PICA;
   writeln(lst,'27 Expanded Compressed Elite + 15 CPI');
   write(lst,chr(27),'g',chr(27),'W',chr(1),chr(15),chr(27),'M');
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=EX_MODE15;
   writeln(lst,'28 Emphasized Expanded 15 CPI');
   write(lst,chr(27),'g',chr(27),'E',chr(27),'W',chr(1));
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=EX_ELITE;
   writeln(lst,'29 Exphasized Expanded Elite + 15 CPI');
   write(lst,chr(27),'g',chr(27),'E',chr(27),'W',chr(1),chr(27),'M');
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=EX_MODE15;
   writeln(lst,'30 Emphasized Expanded Compressed 15 CPI');
   write(lst,chr(27),'g',chr(27),'E',chr(27),'W',chr(1),chr(15));
   print_chars;
   write(lst,chr(27),'!',chr(0));

   margin:=PICA;
   writeln(lst,'31 Emphasized Expanded Compressed Elite + 15 CPI');
   write(lst,chr(27),'g',chr(27),'E',chr(27),'W',chr(1),chr(15),chr(27),'M');
   print_chars;
   write(lst,chr(27),'!',chr(0));
end;


procedure check_combinations;
begin
  writeln(lst,'This portion of the program tests the combinations of print pitches');
  writeln(lst,'available for EPSON printers.');
  writeln(lst);

  writeln(lst,'Not all printers support all combinations of modes -- MPM-Print should,');
  writeln(lst,'however, match whatever pitch your printer uses for any given combination');
  writeln(lst,'of print modes and pitches.');
  writeln(lst);
  writeln(lst);

  combination1;

  if (this_print in [19..21]) then combination2;
        {15 cpi is only supported by certain LQ series printers}

  write(lst,chr(12),chr(27),chr(64));   {form feed and printer reset}
  if (120 in test_escape) then write(lst,esc,char(120),char(0));
       {reset NLQ mode printers to draft mode}
end;

procedure do_control_checks;
begin

   for i:=7 to 31 do if (i in test_control) then
      do_control_codes(i);

   for i:=14 to 115 do if (i in test_escape) then
   begin
      do_escape_codes(i);
      if (i in [14,15,33,36,38,45,48,49,51,52,60,65,69,71,77,81,82,85,87,92,103,108,112,115,120])
         then print_chars;

      if (i in [33,48,49,51,65,69,77,87]) then print_design;

      clear_escape_codes(i);
   end;

   writeln(lst);
   writeln(lst);
   writeln(lst);
   write(lst,'PERFORMING FORM FEED AND MASTER RESET (CHR$(12) ESC 64)',
         char(12),esc,char(64));
end;

begin                    {main program}
   lowvideo;
   clrscr;

   if (MPM_print_installed) then
   begin
      write('The copy of MPM-Print that is memory-resident has been set up for a');
      if (this_print in [13,14]) then writeln(':') else writeln('n:');
      gotoxy(25,3);
      write(printers[this_print].pname);
      gotoxy(1,5);
      write('Is this the printer you',char(39),'re using? (Y for YES, anything else for NO) ');
      read(kbd,ii);
      margin:=PICA;                                   {set the line width}

      if not (ii in ['Y','y']) then
       begin
         writeln('NO');
         writeln;
         writeln;
         writeln('To set MPM-Print for a different printer, run the program using its');
         writeln('setup option:');
         writeln;
         writeln('                  MPMPRINT SETUP    or');
         writeln('                  MPMPRINT S        or');
         writeln('                  MPMPRINT /S');
         writeln;
         writeln('You can then choose the correct printer for MPM-Print to use.');
       end
      else
       begin
         writeln('YES');
         delay(200);
         clrscr;
         writeln('Which tests would you like to run?');
         writeln;
         writeln('   1. Print pitch combination test (tests all combinations of print');
         writeln('         sizes, such as Expanded Pica and Expanded Compressed)');
         writeln('   2. Full printer contol tests (tests virtually every control that can');
         writeln('         be sent to your printer)');
         writeln('   3. Both tests');
         writeln;
         writeln('      Test 1 (print pitch combinations) will take about 4 minutes to print;');
         writeln('      Test 2 (control tests) will take about 10 minutes to print.');
         writeln;
         writeln('(Enter the number of the test(s) to run,');
         write(' anything else to quit) .............................. ');
         read(kbd,jj);
         write(jj);

         if (jj in ['1'..'3']) then
         begin

            test_escape:=etest[printers[this_print].point];
            test_control:=stest[printers[this_print].point];

            if (120 in test_escape) then write(lst,esc,char(120),char(0));
                  {reset NLQ mode printers to draft mode}

            if (jj in ['1','3']) then check_combinations;

            if (jj in ['2','3']) then do_control_checks;
         end;
      end;
    end
   else
    begin
       writeln('MPM-Print is not memory resident; without MPM-Print installed in memory,');
       writeln('your printer cannot work properly with this program.');
       writeln;
       writeln;
       writeln('Before you try this program again, please run MPM-Print first.');
       writeln('MPM-Print will become memory resident, and will allow this program to work');
       writeln('correctly.');
    end;
end.
