{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 55520,0,655360} {40500 stack seems to work}

program LQMATRIX;

{ This program permits you to create your own characters for the
   Epson LQ-1500 ver 2 and all the successors LQ800 etc.

                               copyright by J. David Sapir
DOS version                    906 Old Farm Rd.
                               Charlottesville, VA. 22903
                               (804) 295-5496
First version: 30.xi.87        [Jimmy Paris Software]             }


Uses
  Crt, {Unit found in TURBO.TPL}
  Dos, {Unit found in TURBO.TPL}
  Printer, {Unit found in TURBO.TPL}
  LQMXINIT, {All global types, const & variables}
  LQUTIL,   {fairly simple minded utilities}
  LQCURSOR,
  KEYBOARD, {Constants to carry Alt F1.. Ctrl keys, etc.}
  WIN,     {Replaces the old QUICK. Includes Borland's pop up windows}
  LQcadre, {new version of Cadre that makes use of Borland's
            writechr, writestr procedures rather than the print porcedure
            from TUG}
  
  LQMENU,
  LQHELP,
  LQDIRECT, {directory routines}
  LQCOMMND, {read the command line routines}
  LQEDIT1,  {all disk I/O routines}
  LQEDIT2,  {convertion of bytes to booleans & viceversa}
  LQEDIT3,  {all lst (printer) routines}
  LQEDIT4,  {the matrix editor - has LQEDIT5 as an include file}
  LQSETUP,  {getting started}
  BURNIN;   {routine to write indentification string to .EXE}


var
    choice2    : char;
    reset_scr,
    scan,
    done       : boolean;

begin
 clrscr;
 done:=false;
 windowcount:=0;
 topwindow:=nil;
 holdmtx:=nil;
 start_attr:=textattr;
 currentmode:=GetCurrentMode;
 {get the allowable range & screen attributes from the LQX.DEF file}
 getSetUp;
 {set the new attributes}
 textattr:=video;
 title;
 array_loaded:=false;  {help array gets loaded up once - Cf lqhelp.pas}

 read_command(com_call,com_present,f_info,ph,mk);
   if not (IOerr in[0,2,5]) then com_call:=false;
 startingUP:=true;

 initialize(characterSet,
            workmatrix,
            micundomtx,macundomtx,
            rightmatrix,undoright,
            lastchar,mtx_show,
            rgt_show,
            chIn,saved,
            com_call,com_present,
            f_info,ph,mk);
 startingUP:=false;
 repeat
    repeat
      choice:=upCase(getkey(scan));
      until (choice in[esc,'E','M','N','P'..'S','V',F1,AltX]);
    case choice of
     F1: if scan then
	 SimpleHelp(3);
     'E':                                            { Call editor    }
        begin
          closewindow;
          Edit(workmatrix,
               micundomtx,macundomtx,
               rightmatrix,undoright,
               characterset,lastchar,
               mtx_show,
               rgt_show,
               character,f_info,
               ph,mk);
          Menu(f_info.size);
        end;
     'N':                                            { Get a new file }
       Begin
         closewindow;
         if (not Saved) and (LastChar>0) then
            if SaveQuery(f_info.name)
               then putcharfile(characterset,saved,f_info,ph,mk);
         com_call:=false; com_present:=false;
         initialize(characterSet,
                    workmatrix,
                    micundomtx,macundomtx,
                    rightmatrix,undoright,
                    lastchar,mtx_show,
                    rgt_show,
                    chIn,saved,
                    com_call,com_present,
                    f_info,ph,mk);
       end;
     'S':
        begin  { Store file on disk }
          closewindow;
          PutCharFile(CharacterSet,saved,f_info,ph,mk);
	  FileTitle(f_info.showname);
          Menu(f_info.size);

        end;
      'V': version;
      'R': if burn.regNO=baseNO then
               Prn_Reg; {Print out a registration form - routine
                        is in LQEDIT3 - with other print routines }

     {********** MISCELLANEOUS MENU ROUTINE ***********}
      'M':
         begin
           miscellaneous;
           reset_scr:=false;
           repeat
             choice2:=upCase(getkey(scan));
             if choice2 in[^I,^R,'U','C','R','S',F1,'F'] then
               case choice2 of
                  F1: simpleHelp(5);
                 'F': change_Fattr(f_info);
                 'C':  {combine two files}
                   CombineFile(characterset,lastchar,saved,
                               f_info,ph,mk);
                 'S':  {simple sort after combining files}
                   Sort;
                 'R':
                    if burn.regNO<>baseNO then
                        unRegister; {this is in BURNIN -
                                     sets burn.NOreg to baseNO}
                 'U':  {change highlighting and ASCII range}
                   SetUP(reset_scr);
                 ^I:
                   change_regNO;
                 ^R:
                   change_ID;
               end; {case}
           until choice2<>F1;
           closewindow; {C-16}
           if (choice2 in['C','R','S',^I]) or (reset_scr) then
              begin
                {you have to close the windows before you
                 can move into the default space - unless
                 we want to define Status as a window.}
                closewindow;
                if reset_scr then
                   begin
                     frames(default);
                     textattr:=video;  {since previous textattr is restored
                                      when you close a window we have to
                                      set it here rather than in the setup
                                      procedure}
                     rgt_show:=false;
                     mtx_show:=false;
                     show_matrix(workmatrix.matrix,f_info);
                   end;
		if (reset_scr) or (choice2='C') then
		    FileTitle(f_info.showname);
                status(CharacterSet,LastChar,from_bottom);
                Menu(f_info.size);
              end;
         end;
      {********** PRINT ROUTINES MENU ******************}
      'P':
         begin
           prn_routines;
           repeat
             choice2:=upCase(getkey(scan));
             if choice2 in['D','F','O','P','R','T',F1] then
               case choice2 of
                 F1: SimpleHelp(6);
                 'D','F','P','T': { Download file to printer }
                    begin
                      if okprint then
                        case choice2 of
                          'D': if lastchar>0 then
                                  DownloadFile(characterset,lastchar,
                                               f_info.size);
                          'F': if lastchar>0 then
                                  PrintFile(characterSet,f_info.name,
                                            f_info.size);
                          'P': if lastchar>0 then
                                  print_out(characterset,lastChar,
                                            f_info.size);
                          'R': begin
                                 setPrinterUp(f_info.size);
                                 reset_note;
                               end;
                          'T': if lastchar>0 then
                                  Type_KBD(characterset,lastChar,
                                           f_info.size);
                        end;
                    end;
                 end; {case}
           until choice2<>F1;
           closewindow;
         end;
       esc,'Q',AltX:
         if (scan) or (choice in['Q',esc]) then
            if ask_Exit then done:=true;

     end; { of Command case }
     GotoXY(9,4); NoCursor;
 until done;
 if (not Saved) and (lastChar>0) then
    if SaveQuery(f_info.name) then
	 putcharfile(characterset,saved,f_info,ph,mk);
 closewindow;
 time_to_go('Jimmy Paris Software',0,0);
end.

{ end of LQMATRIX.PAS  ---- copyright by J. David Sapir }
