Echo off
Cls
Echo :  Graphics Demonstration Program
Echo :
Echo :
Echo :  This demonstration will provide an overview of the graphics capabilities
Echo :  of the plotting software.
Echo :
if exist environ.par goto continue
Echo :  You must Run Install before running this demonstration.
Echo :  Hit any key to run INSTALL, Ctrl-Break to end the demo.
Pause
Install
Pause
Cls
:Continue
Echo :
Echo :  The most important thing to know is that help files are included, and
Echo :  may be viewed with the command PLOTHELP.  The help files will now be
Echo :  shown; hit ESC to exit the help files and resume the demo, or enter
Echo :  the help topic name for more information on the desired item.  Topics
Echo :  OVERVIEW and COMMAND SUMMARY are recommended for beginners.  Note that
Echo :  the entire help topic name does not need to be entered; just enough
Echo :  to distinguish the desired topic.
Echo :
Pause
PlotHelp
Cls
Echo :  The first demostration will display a simple line plot to the screen.
Echo :  The data file format is described in PLOTHELP.  In the simplest case,
Echo :  the data file contains the following information:
Echo :
Echo :     The number of 'lines' of data in the file
Echo :     The number of points in each line
Echo :     The data for the first line
Echo :     The data for the second line
Echo :     ... the data for the last line
Echo :
Echo :  For example, the plot about to be generated uses the data file TEST.DAT.
Echo :  This file contains the following data:
Echo :
Pause
Cls
Type Test.dat
Echo :
Pause
Cls
Echo :  Two commands will be used to generate the plot.  The first is TWO_D.
Echo :  This command will set up the plot program to generate a two-dimensional
Echo :  plot.  The second command is PLOT TEST, which will plot the data file
Echo :  TEST.DAT.
Echo :
Echo :  When the plot is displayed on the screen, hit any key to get a menu
Echo :  of options.  Hit S to save the plot to a disk file, then Q to quit
Echo :  the plot program.  Before quitting, you may try hitting L to produce
Echo :  a low-resolution plot, or H to produce a high-resolution plot.
Echo :
Pause
command /c two_d
command /c plot test
Cls
Echo :  The next example illustrates the use of a three-dimensional surface
Echo :  plot.  This example may take several minutes depending on the speed
Echo :  of your computer.  For this plot, a header file is used to specify
Echo :  various plot parameters.  The HEADER command provides an easy method
Echo :  of creating a header file, and HEDIT provides an easy means of editing
Echo :  a header file.  The HEDIT program will now be invoked using the
Echo :  command HEDIT SINC.HDR.  Use the cursor keys to move through the header
Echo :  file; hit function key 2 to see a description of the parameter under
Echo :  the cursor, and use Ctrl-Q to exit HEDIT without saving any changes
Echo :  you may have made.
Echo :
Pause
Hedit Sinc
Cls
Echo :  If the number of parameters is intimidating, bear in mind that default
Echo :  values are provided for each parameter so that a full understanding of
Echo :  the contents of the header files is not required.
Echo :
Echo :  A plot will now be generated using the header file Sinc.hdr and Sinc.dat.
Echo :  The command to generate the plot is PLOT /ZI 15 20 1 41 SINC.HDR SINC.DAT.
Echo :  Remember to hit S to save the plot to a disk file before hitting Q to return
Echo :  to the demo.
Echo :
Echo :  This plot may take several minutes to complete.  It will run significantly
Echo :  faster on systems using a math coprocessor and running the plot version
Echo :  which uses the coprocessor.
Echo :
Pause
If Exist Sinc.dat goto Sinc
Echo :  The file Sinc.dat must first be created.  Please be patient; this is
Echo :  computationally intesive and may take a while...
Sinc
:Sinc
Command /c Plot /zi 15 20 1 41 Sinc Sinc
Cls
Echo :  The next example illustrates the capability of the program to number
Echo :  an axis using a log scale.  The command is:
Echo :
Echo :     PLOT /LOGZ -5 /ASF LOGXYZ.ASF LOG.HDR LOG.DAT
Echo :
Echo :  This may appear cryptic.  The /LOGZ -5 specifier instructs the program
Echo :  to convert the data in the data file to log values using a minimum value
Echo :  of -5 (since the log of zero is negative infinity, a lower limit must
Echo :  be specified.) The /ASF LOGXYZ.ASF specifier indicates that the program
Echo :  should use the axis specification file LOGXYZ.ASF to define the axis
Echo :  scale.  Several example *.ASF files are included on the program disk.
Echo :  The LOG.HDR and LOG.DAT specifiers indicate that the file LOG.HDR should
Echo :  be used as the header file, and LOG.DAT should be used as the data file.
Echo :  (The .DAT and .HDR filename extensions are used by default and may be
Echo :  omitted.)  Finally, note that this plot may not look very good on a low
Echo :  resolution monitor such as CGA.  The log capability may still by useful
Echo :  on CGA systems since a high-resolution plot may be generated independent
Echo :  of screen resolution.
Echo :
Echo :  (Remember to hit S to save the plot to a disk file before returning to
Echo :  the demo.)
Echo :
Pause
Command /c Plot /logz -5 /asf logxyz.asf log log
Cls
Echo :  The final example illustrates split screen capability.  For split screens,
Echo :  a split screen specification file must be used.  Command SEDIT allows for
Echo :  the creation or editing of such a specification file.  This example makes
Echo :  use of the included file SPLIT.SPL.  SEDIT will now be invoked to display
Echo :  the contents of SEDIT.SPL.  Use Ctrl-Q to exit SEDIT.
Echo :
Pause
Command /c Sedit split
Cls
Echo :  The plot will now be generated.  Note that this example generates four
Echo :  plots on one screen, and will look bad on most monitors.  The split file
Echo :  capability is intended for use in generating high-resolution plots
Echo :  (particularly on a laser printer or a 24 pin dot-matrix printer).  Two
Echo :  plots may be generated on one screen with good results.
Echo :
Echo :  (Remember to hit S to save the plot to a disk file before returning to
Echo :  the demo.)
Echo :
Pause
Command /c Plot /Split Split
Cls
Echo :  All the plots saved to a disk file using this software may be recalled using
Echo :  the GALLERY command.
Echo :
Pause
Command /c Gallery *
Cls
Echo :  This concludes the demonstration program.  To learn more about using the
Echo :  software, read through the help files, and experiment with the examples
Echo :  explained therein.
