// =====================================================================
// util.c - Utility functions for talk
//
// (C) 1993, 1994 by Michael Ringe, Institut fuer Theoretische Physik,
// RWTH Aachen, Aachen, Germany (michael@thphys.physik.rwth-aachen.de)
//
// This program is free software; see the file COPYING for details.
// =====================================================================

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "../include/tcp.h"
#include "talk.h"



// ---------------------------------------------------------------------
// mystrncpy() - Safe strncpy
// ---------------------------------------------------------------------

char *mystrncpy(char *dest, char *src, int len)

{
    strncpy(dest,src,len);
    dest[len-1] = 0;
    return dest;
}

// ---------------------------------------------------------------------
// dostime() - Return date and time in ascii format
// ---------------------------------------------------------------------

char *dostime(void)

{
    struct dosdate_t d;
    struct dostime_t t;
    static char buf[25];
    static char dow[7][4] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
    static char mon[12][4] = {"Jan","Feb","Mar","Apr","May","Jun","Jul",
			      "Aug","Sep","Oct","Nov","Dec"};

    _dos_gettime(&t);
    _dos_getdate(&d);
    sprintf(buf,"%s %s %2.2d %2.2d:%2.2d:%2.2d %4.4d",
	dow[d.dayofweek],mon[d.month-1],d.day,t.hour,t.minute,t.second,
	d.year);
    return buf;
}


// ---------------------------------------------------------------------
// xtoi() - Convert a string of hexadecimal digits to unsigned int
// ---------------------------------------------------------------------

unsigned int xtoi(char *c)

{
    int i = 0, k;
    for (k = 0; k < 2; ++k)
    {
	i <<= 4;
	if (*c >= '0' && *c <= '9') i += *c - '0';
	else if (*c >= 'A' && *c <= 'F') i += *c - 'A' + 10;
	else if (*c >= 'a' && *c <= 'f') i += *c - 'a' + 10;
	++c;
    }
    return i;
}


// ---------------------------------------------------------------------
// setsockaddr() - Set socketaddr fields in network byte order
// ---------------------------------------------------------------------

void setsockaddr(struct sockaddr *s, word port, longword ip)

{
    s->s_type = 0x0200;		/* AF_INET */
    s->s_port = intel16(port);
    s->s_ip = intel(ip);
    memset(s->s_spares,0,sizeof(s->s_spares));
}

