#ifndef _FRAND_H_
#define _FRAND_H_

//---------------------------------------------------
/*

    An inline replacement for srand() and rand()
    it returns a number between 0 and 0xffff.

    The original code was found in "Graphic Gems II"
*/
//---------------------------------------------------

static long _FRSEED_ = 987654321l;

#define FRAND_MAX (0xffffl)

#define fsrand(seed)    (_FRSEED_ = seed)

#define frand()     ((_FRSEED_ = (((25173l * _FRSEED_) + 13849l))) & 0xffffl)


//---------------------------------------------------

#endif