//
// Written by: Robert C. Pendleton
// 
// Copyright 1993 by Robert C. Pendleton
//
// Non-commercial use by individuals
// is permitted.
// 
//

#include <time.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "vbe.h"
#include "vg.h"

FILE *result;

//---------------------------------------------------
//
// set the palette to a 332 rgb map
//

void
setPalette332()
{
    int r, g, b, c;
    vgaColor p[256];

    c = 0;
    for (r = 0; r <= 64; r += 9)
    {
        for (g = 0; g <= 64; g += 9)
        {
            for (b = 0; b < 64; b += 21)
            {
                p[c].red = r;
                p[c].green = g;
                p[c].blue = b;
                c++;
            }
        }
    }

    vgaSetPalette(0, 256, p);
}

//---------------------------------------------------
//
// Use the VBE query functions to find out about
// available VESA drawing modes 
//

void
demoQuery()
{
    vbeInfo info;
    vbeModeInfo modeInfo;

    unsigned short *mode;

    if (vbeGetInfo(&info))
    {
        vbePrintInfo(result, &info);

        mode = info.modes;
        while ((*mode) != 0xffff)
        {
            if (vbeGetModeInfo(*mode, &modeInfo))
            {
                fprintf(result, "\n\nmode=%x\n\n", *mode);

                vbePrintModeInfo(result, &modeInfo);
            }

            mode++;
        }
    }
    else
    {
        fprintf(result, "No VBE support\n");
    }
}

//---------------------------------------------------
//
// Show all the entries in the 332 color map
//

void
demo332()
{
    vg screen(g640x400c256);
    int x;
    int y;
    int oldMode;
    int color;

    int width;
    int height;

    width = screen.width / 32;
    height = screen.height / 8;

    setPalette332();

    screen.clear(0);

    color = 0;
    for (y = 0; y < screen.height; y += height)
    {
        for (x = 0; x < screen.width; x += width)
        {
            screen.fillRect(x, y, width - 2, height - 2, color);
            color++;
        }
    }

    while(!kbhit());
    getche();
}

//---------------------------------------------------
//
// Demo of pixel drawing
//

void
demoPixel()
{
    vg screen(g640x400c256);
    int count = 1000;
    int range = 10;
    int i;
    int j;
    long x;
    long y;
    int color = 0;
    int oldMode;
    int activePage = 1;

    float start_time;
    float end_time;
    float total_time;
    long frames = 0;

    setPalette332();
    screen.setVisiblePage(0);

    srand((unsigned) time(NULL));

    start_time = clock();
    while (!kbhit())
    {
        screen.setActivePage(activePage);
        screen.clear(0);

        for (i = 0; i < count; i++)
        {
            x = 0;
            y = 0;
            for (j = 0; j < range; j++)
            {
                x += rand() % screen.maxx;
                y += rand() % screen.maxy;
            }

            x /= range;
            y /= range;


            color = rand();
            screen.pixel(x, y, color);
        }

        screen.setVisiblePage(activePage);
        frames++;
        activePage++;
        activePage %= screen.getNumPages();
    }
    end_time = clock();
    total_time = (end_time - start_time) / CLOCKS_PER_SEC;

    getche();

    fprintf(result,
            "time=%8f frames=%d frames/sec=%8f\n",
            total_time,
            frames,
            frames / total_time);
}

//---------------------------------------------------
//
// Demo of rectangle fills
//

void
demoRect()
{
    vg screen(g640x400c256);
    int i;
    int oldMode;
    int activePage = 1;

    float start_time;
    float end_time;
    float total_time;
    long frames = 0;

    setPalette332();
    screen.setVisiblePage(0);

    srand((unsigned) time(NULL));

    start_time = clock();
    while (!kbhit())
    {
        screen.setActivePage(activePage);
        screen.clear(0);

        for (i = 0; i < 500; i++)
        {
            screen.fillRect(rand() % screen.maxx, rand() % screen.maxy, 
                            20, 20,
                            rand());
        }

        screen.setVisiblePage(activePage);
        frames++;
        activePage++;
        activePage %= screen.getNumPages();
    }
    end_time = clock();
    total_time = (end_time - start_time) / CLOCKS_PER_SEC;

    getche();

    fprintf(result,
            "time=%8f frames=%d frames/sec=%8f\n",
            total_time,
            frames,
            frames / total_time);
}

//---------------------------------------------------
//
//
//

void
main(int argc, char *argv[])
{
    int i;

    result = fopen("result", "w");

    if (argc < 2)
    {
        printf("I need a command \n");
        exit(0);
    }

    for (i = 1; i < argc; i++)
    {
        if (strcmp(argv[i], "332") == 0)
        {
            demo332();
        }
        else if (strcmp(argv[i], "query") == 0)
        {
            demoQuery();
        }
        else if (strcmp(argv[i], "pixel") == 0)
        {
            demoPixel();
        }
        else if (strcmp(argv[i], "rect") == 0)
        {
            demoRect();
        }
        else
        {
            printf("don't understand : %s\n", argv[i]);
        }
    }
}
