#include <windows.h>  
#include "logitech.h" 

//-------------------------------------------------------------
Logitech::Logitech(HWND owner,int port)
{
	Port=port;    
	hOwner=owner;
	hWnd=NULL;
	DataReady=FALSE;
	MouseError=FALSE; 
	Connected=OpenConnection(owner,port);
}
//-------------------------------------------------------------
Logitech::~Logitech()
{
	if (Connected)
    	CloseConnection();  
}
//-------------------------------------------------------------
void Logitech::CloseConnection()
{
   EnableCommNotification( CommDev, NULL, -1, -1 ) ;
   EscapeCommFunction( CommDev, CLRDTR ) ;
   CloseComm( CommDev) ;
   Connected= FALSE ;
   MessageBeep(MB_ICONASTERISK);
} 
//-------------------------------------------------------------
BOOL  Logitech::OpenConnection(HWND hwnd, int port)
{
	char       szPort[ 10 ];
	DCB		   dcb;
   
	if(Connected)
   		CloseConnection();
                                     
	wsprintf( szPort, "COM%d", port);

	if ((CommDev = OpenComm( szPort, 1024, 1024 )) < 0) 
	{
		MessageBox(hwnd,"Logitech 6DOF Mouse Connection Failed !",szPort,MB_ICONEXCLAMATION);   
   		return ( FALSE ) ; 
	}
   
	GetCommState(CommDev,&dcb);   
	
	dcb.BaudRate = 19200;
	dcb.ByteSize = 8;
	dcb.Parity   = NOPARITY;
	dcb.StopBits = ONESTOPBIT;
	dcb.fChEvt	 = TRUE;   
	dcb.EvtChar	 = '>';

	if(SetCommState( &dcb )<0) 
	{   
		CloseComm(CommDev);
   		MessageBox(hOwner,"Settings Failed !",szPort,MB_ICONEXCLAMATION);
    	return FALSE;
	}
	else
	{    	
        SetCommEventMask( CommDev, EV_RXFLAG ) ;
        EnableCommNotification( CommDev, hOwner, 1, 1 ) ;
      	EscapeCommFunction( CommDev, CLRDTR ) ;
		return TRUE;
	}

} // end of OpenCon
//---------------------------------------------------------------------------
int  Logitech::ReadCommStr(LPSTR lpszBlock, int nMaxLength )
{
	int 		nLength, nError ;
	COMSTAT		ComStat ;
	
	nLength = ReadComm( CommDev, lpszBlock, nMaxLength ) ;
   
   	if (nLength < 0)
   	{
    	nLength *= -1 ;
    	nError=GetCommError(CommDev,&ComStat);
	}
    lpszBlock[nLength]=NULL;
    return ( nLength ) ;
} // end of ReadCommStr()
//---------------------------------------------------------------------------
BOOL Logitech::WriteCommStr(LPCSTR string )
{
	int len=lstrlen(string);

	WriteComm( CommDev,string,len) ;   

    return ( TRUE ) ;
} 
//------------------------------------------------------
void Logitech::ProcessCommNotify()
{   
	if(!DataReady)
	{
		DataCount+=ReadCommStr(&MouseState[DataCount],16-DataCount);      
		
		if(DataCount>=16)  
			DataReady=TRUE;
	}
	if(DataReady && (hWnd!=NULL) )                  
	{
		PostMessage(hWnd,Msg,wParam,NULL);		
		hWnd=NULL;
	}
}
//------------------------------------------------------
void Logitech::Request6DOF(HWND hwnd,UINT msg, WPARAM wparam)
{
	hWnd=hwnd;
	Msg=msg;
	wParam=wparam;   
	DataCount=0;
	WriteCommStr("*d");
}
//------------------------------------------------------
BOOL Logitech::Get6DOF(int*roll,int*pitch,int*yaw,int*x,int*y,int*z,int*buttons)
{
	if(MouseError || !DataReady)
	{
		MouseError=FALSE;
		return FALSE;
	}
	
 	*x=0;
 	*x|=((MouseState[1]<<14) | (MouseState[2]<<7) | MouseState[3]);
 	if(MouseState[1] & 0x40)  *x|=POSITION_MASK;

 	*y=0;
 	*y|=(MouseState[4]<<14) | (MouseState[5]<<7) | MouseState[6];
 	if(MouseState[4] & 0x40) *y|=POSITION_MASK;

 	*z=0;
 	*z|=(MouseState[7]<<14) | (MouseState[8]<<7) | MouseState[9];
 	
 	if(MouseState[7] & 0x40) 
 		*z|=POSITION_MASK;

 	*pitch= ((MouseState[10]<<7) | MouseState[11]);
 	
 	if(MouseState[10] & 0x40) 
 	{
  		*pitch|=ROTATION_MASK;
  		*pitch+=ROTATION_OFFSET;
 	}

 	*yaw=(MouseState[12]<<7) | MouseState[13];
 
 	if(MouseState[12] & 0x40) 
 	{
   		*yaw|=ROTATION_MASK;
   		*yaw+=ROTATION_OFFSET;
 	}

 	*roll=(MouseState[14]<<7) | MouseState[15];
 	
 	if(MouseState[14] & 0x40) 
 	{
   		*roll|= ROTATION_MASK;
   		*roll+=ROTATION_OFFSET;
 	}

 	*buttons=MouseState[0];

    DataReady=FALSE;
	return TRUE;
}

 
