/* This program requires Release 4.01 of REND386 to compile */


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <dos.h>
#include <math.h>
#include <string.h>
#include "/rend4/3dstruct.h"
#include "/rend4/rend386.h"
#include "/rend4/userint.h"
#include "/rend4/plg.h"
#include "/rend4/splits.h"
#include "/rend4/tasks.h"
#include "/rend4/pointer.h"
#include "/rend4/cursor.h"
#include "/rend4/segio.h"
#include "/rend4/intmath.h"
#include "/rend4/segasupp.h"
#include "serial.h"

#define to_rad(a) ((a) * 3.14159262 / 180.0)
#define sine(x)   sin(to_rad(x/65536L))
#define cosine(x) cos(to_rad(x/65536L))

#define LEG_ANGLE_MOVE 15*65536L
#define PAN_ANGLE      5*65536L
#define MOVE_STEP      250


#define HOME      0x4700
#define END       0x4F00
#define PGUP      0x4900
#define PGDN      0x5100
#define LEFT      0x4B00
#define RIGHT     0x4D00
#define UP        0x4800
#define DOWN      0x5000
#define SHLEFT    0x4B01
#define SHRIGHT   0x4D01
#define SHUP      0x4801
#define SHDOWN    0x5001
#define SHPGUP    0x4901
#define SHPGDN    0x5101
#define CTRLLEFT  0x7300
#define CTRLRIGHT 0x7400
#define CTRLHOME  0x7700
#define CTRLEND   0x7500
#define CTRLPGUP  0x8400
#define CTRLPGDN  0x7600
#define ESC       0x001B


extern unsigned _stklen = 25000;

/* Global variables */
/* This is our main object list.
   Files used:  keyboard, world, cursors
*/
OBJLIST         *objlist;

/* This is the default values for stereo viewing.
   Files used:  keyboard, world, render
*/
STEREO          default_stereo = {1000,250,320,50, 1000000, 1*65536L};

/* This variable indicates the type of viewing.
   Declared in file: render.c
   Files used: keyboard, gloveptr, world, render
*/
int             stereo_type = MONOSCOPIC;

/* This variable declares the default startup view of the program.
   Files used: keyboard, world
*/
VIEW            default_view =  {
				0,0,0,
				0,0,0,
				9*65536L,
				1000,15000,-5000,
				0,319,0,199,
				1,100000,
				1/1.25*65535L,
				0
				};

/* This pointer points to the location of the default view
   Files used: keyboard, world, render
*/
VIEW            *current_view = &default_view;

/* This pointer in the beginning of the split tree for the program.  We
   will only one however, that is not a requirement.
   Files used: keyboard, world, render, cursors, hdmanip
*/
SPLIT           *split_tree = NULL;

/* This variable holds a palette.
   Files used: world
*/
unsigned char   palette[256*3];

/* This pointer is the start of a set of tasks.
   Files used: world
*/
TASK            *tasklist = NULL;

/* This pointer holds a handle to the current video driver installed.
   Files used: main program
*/
void            *v_driver_pointer = NULL;

/* This variable holds a loadpath specified in the configuration file or
   in a world file.
   Files used: world
*/
char            loadpath[100] = "";

/* This variable holds a temporary filename including a loadpath.
   Files used: main program
*/
static char     tempname[100];


char            framefname[100];

/* Delcares an extern function. */
extern void     *screen_data();

/* This variable is used to hold information about the current screen setup.
   File used: gloveptr, mouseptr, render, userint
*/
extern struct   Screeninfo *screeninfo;

/* This variable is used in the userint file.  Purpose ?
*/
PDRIVER         *menu_device = NULL;

/* These variable are used as the configuration settings for the glove
   pointer device, translation and rotation.
   Files used: world
*/
float           gpdo_x = 3, gpdo_y = 3, gpdo_z = 5,
		gpdo_rx = 1, gpdo_ry = 1, gpdo_rz = 1;

/* These varaiables are used as the configuration settings for the head
   tracker device, relative position to neck, and rotation. */
float           hdo_x = 0, hdo_y = 0, hdo_z = 0; /* relative pos'n to neck */
float           hdo_rx = 0, hdo_ry = 0, hdo_rz = 0;

/* These variables are used as the configuration settings for the STEREOLEFT
   command in a world file.  Check world.doc for description.
   Files used: world keyboard
*/
int             sl_xflip = 0, sl_xoff = 0;
long            sl_left = -1, sl_top, sl_right, sl_bottom;

/* These variables are used as the configuration settings for the
   STEREORIGHT command in a world file.  Check world.doc for description.
   Files used: world keyboard
*/
int             sr_xflip = 0, sr_xoff = 0;
long            sr_left = -1, sr_top, sr_right, sr_bottom;

/* These variables are used as the configuration settings for the rotation
   of the STEREORIGHT and STEREOLEFT commands in the world file.  Check
   world.doc for description.
   Files used: world keyboard.
*/
float           sl_xrot = 0, sr_xrot = 0;

/* This variable indicates whether or not a glove is being used.
   0 = false.
   Files used: cursors hdmanip
*/
int             use_glove = 1;

/* This variable indicates whether or not a head tracker is being used.
   0 = false.
   Files used: render
*/
int             use_ht = 0;

/* This variable indicates whether or not a wide-angle dual VGA
   head mounted display system is being used.
   0 = false.
   Files used: render
*/
int             use_wide = 0;

/* This variable indicates whether or not a monochrome system is being used.
   0 = false.
   Files used: render
*/
int             use_BW = 0;

/* This variable is set to 1 if the eyes are to be switched when using
   the Sega 3D glasses.
   Files used: render
*/
int             swap_eyes = 0;

/* This variable is set to display a fancy background
   Files used: keyboard render
*/
int             fancy_background = 0;

/* This variable is set to draw a reflection pool at the bottom of the
   screen.
   Files used: keybaord render
*/
int             reflection_pool = 0;

/* This variable is set to indicate we have a logo to display.
   Files used: render
*/
int             have_logo = 0;

/* This variable is set to show our logo, if we have one.
   Files used: render keyboard
*/
int             show_logo = 0;

/* This variable is set to show the current location on-screen.
   Files used: render keyboard
*/
int             show_location = 0;

/* This variable is set to show the 3D compass on-screen.
   Files used: render keyboard
*/
int             show_compass = 0;

/* This variable is set to display the frames/second rate on-screen.
   Files used: render keyboard
*/
int             show_framerate = 0;

/* This variable is set to clear the screen on each frame.
   Files used: render world keyboard
*/
int             do_screen_clear = 1;

/* This variable is set to draw a "frame".
   Files used: world render
*/
int             use_frame = 0;

/* These variabels define the location of a "frame".
   Files used: world render
*/
int             frame_x = 0, frame_y = 0, frame_w = 320, frame_h = 200;

/* This variable is set to the current display mode to use.
   Files used: render world
*/
int             vdmode = 0x14;

/* This variable is set to 1 if we need to recompute the current view.
   Files used: world keyboard
*/
int             review = 1;

/* This variable is set to 1 if we need to copy our gram back on-screen.
   Files used: keyboard world colormap render rendrep
*/
int             reframe = 0;


/* This variable is set if the shift key is used by the user.
   Files used: main program keyboard
*/
int             shifted = 0;

/* This variable is used to hold the current visual page being used.
   Files used: render userint
*/
int             v_page = 0;

/* This variable is set if a glove is available.
   Files used: world cursors
*/
int             have_glove = 1;

/* This variable is set if a pointer device is available.
   Files used: world cursors
*/
int             have_ptr = 0;

/* This variable is set if we can do mouse manipulations.
   Files used: keyboard
*/
int             manip_2D_avail = 0;

/* This variable is set to run the main execution loop.
   Files used: main
*/
int             execution = 1;

/* This variable is set to indicate a screen redraw is necessary.
   Files used: keyboard anim world cursors render hdmanip
*/
int             redraw = 1;

/* This variable is set if a horizon should be drawn.
   Files used: keyboard render colormap
*/
int             do_horizon = 0;

/* This variable is not necessary because it is define elsewhere and can
   be set with a world file.  It is the color the system paints the top
   half of the screen after it is cleared; if the do_horizon variable is
   set to 1.
   Files used: world render colormap
*/
extern          sky_color;

/* This variable is not necessary because it is define elsewhere and can
   be set with a world file.  It is the color the system paints the bottom
   half of the screen after it is cleared; if the do_horizon variable is
   set to 1.
   Files used: world render colormap
*/
extern          ground_color;

/* This variable is not necessary because it is define elsewhere and can
   be set with a world file.  It is the color the system paints the screen
   after it is cleared; if the do_horizon variable is set to 0.
   Files used: world render colormap
*/
extern int      screen_clear_color;


/* This variable holds the highest possible color value.
   Files used: render colormap
*/
extern          highest_color;

/* This variable is set to 0 if no palette is loaded and
   non-zero if a palette is loaded
   Files used: world
*/
int             npalette = 0;

/* This variable holds the name of the current switcher driver.
   Files used: world
*/
char            swdname[40] = "sega";

/* This variable holds the name of the current glove pointer driver.
   Files used: world
*/
char            gpdname[40] = "pglove";

/* This variable holds the name of the current head tracker driver.
   Files used: world
*/
char            hdname[40] = "none";

/* This variable holds the name of the glove pointer driver cursor figure.
   Files used: world
*/
char            gpcursor[40] = "handsm.fig";

/* This variable holds the name of the current video driver.
   Files used: main program and world
*/
char            vdname[40] = "vd256y.rvd";

/* This variable holds the name of the current mouse driver.
   Files used: world
*/
char            mdname[40] = "mouse";

extern SEGMENT *body_seg;
int head_device = 0;
joystick_data  joy_data;
int joy_return=0;
int joystick = 0;
int weight = 5;
int total_pieces = 0;
piece_struct pieces_places[100];
char *pieces[100];



SEGMENT *wrist_seg;
int heavy;

SEGMENT *our_hand;

PDRIVER *mouser, *manip_device;
POINTER mouse_data;

SEGMENT *hand_joints[20],
	*glove_joints[20],
	*body_seg,
	*attached_piece;

OBJECT  *palm_obj;
long ptx, pty, ptz, oldx, oldy, oldz;

FILE *debug;



void refresh_display(){

  initialize_screen_factors ( current_view );
  fast_view_factors ( current_view );
  screen_refresh ( current_view );
}



void printcenter ( char *string )
{
  int i;

  for(i=0;i<((80-strlen(string))/2); i++)
   printf (" ");
  printf ( "%s", string );
}




char  *help[] = {
		  "To exit: Press Q",
		  "",
		  "Grip hand using left mouse button",
		  "",
		  "Move UP/DOWN using right button",
		  "",
		  "Rotate hand using middle button",
		  "",
		  NULL
		};

/**************************************************************************
  This function performs the updating of the screen after any object or
  perspective movements.  The majority of the work is done in the
  function screen_refresh in the file render.c
**************************************************************************/




/**************************************************************************
   This function is used by the file render.c to display various things
   on the screen to the user.  This is not needed by any program just
   an option.  However, render.c needs access to this function
***************************************************************************/
void status_on_screen()
{
}


/**************************************************************************
   This function concatenates the loadpath to the string name IF
   name is not "\\" and not "/" and loadpath is not empty.  It is used by
   the files: world.c.
**************************************************************************/
char *fix_fname(char *name)
{

	if (loadpath[0] && !strchr(name, '\\') && !strchr(name, '/'))
		sprintf(tempname, "%s\\%s", loadpath, name);
	else
		strcpy(tempname, name);
	return tempname;
}


/**************************************************************************
  This function is called when the user ends the graphics program.  It
  shuts done the graphics system and exits the renders and finally exits
  the progam.
**************************************************************************/
void closeall(){
  exit_graphics();
  reset_render();
  exit(0);
}


void prprint(int x,int y, int color, char *t)
{
	int bk = (color>8) ? 0 : 15;

	printxyr(x,y,bk,t,0);
	printxyr(x+1,y+1,color,t,0);
}


/**************************************************************************
   This function is from Rend386 demo2.c program and is used to get
   keyboard input from the user.
***************************************************************************/
unsigned getkey(){
  unsigned c;
  union REGS regs;

  regs.h.ah = 2;
  int86(0x16, &regs,&regs );
  shifted = (regs.h.al & 3);
  if ((c=bioskey (0)) & 0xff) c &= 0xff;
  else if ( shifted ) c |= 1;
  return c;
}



int hit = 0;
long palm_x, palm_y, palm_z;
OBJECT *current_obj = NULL;
void check_list ( OBJECT *obj )
{
  char buf[25];
  unsigned flags;
  long dist;

  if ((obj->oflags & 0x0004) && (!hit))
  {
   dist = sphere_pretest ( obj, palm_x, palm_y, palm_z );
   if (( dist > 1 ) && ( dist < 1175 )) { hit = 1; current_obj = obj; }
   else current_obj = NULL;
   }
}


int yes_or_no()
{
  char ch;

  refresh_display();
  popmsg ( "Are You Sure? (y/n)" );
  ch = getkey();
  if ( (ch == 'Y') || (ch == 'y') ) ch = 1;
  else ch = 0;

  refresh_display();
  return ch;

}


SEGMENT *correct_seg;
char current_name[20];
void find_segment ( OBJECT *obj )
{

   if (strcmpi (seg_getname ((SEGMENT *)get_object_owner(obj)), current_name) == 0)
     correct_seg = (SEGMENT *)get_object_owner(obj);

}



/**************************************************************************
   This function handles keys pressed by the user.Handle any user keys.
**************************************************************************/
void handle_key ( unsigned int c ){
OBJECT *obj;
long x, y, z;
char buff[12], inbuff[80], result;
char a,b,d;
int serial;
FILE *infile;

  switch ( c )
  {
    case 'q':
    case 'Q':    popmsg ( "Do you wish to quit? (y/n)" );
		 if ( toupper(getkey())== 'Y' )
		   execution = 0;
		 else redraw = 1;
		 break;


    case 'h':
    case 'H':  poptext(help);
	       getkey();
	      break;


    case UP:    /* Forward */
	      x = 150 * sine(current_view->pan);
	      z = 150 * cosine(current_view->pan);
	      current_view->ex += x;
	      current_view->ez += z;

	      rel_move_segment ( body_seg, x, 0, z );
	      update_segment ( body_seg );

	      redraw = 1;
	      break;

    case DOWN: /* Backward */
	      x = 150 * sine(current_view->pan);
	      z = 150 * cosine(current_view->pan);
	      current_view->ex -= x;
	      current_view->ez -= z;

	      rel_move_segment ( body_seg, -x, 0, -z );
	      update_segment ( body_seg );

	      redraw = 1;

		break;


    case LEFT:
	      current_view->ex -= 150L* cosine(current_view->pan);
	      current_view->ez += 150L* sine(current_view->pan);


	      rel_move_segment ( body_seg, -150L*cosine(current_view->pan), 0, 150L*sine(current_view->pan));
	      update_segment ( body_seg );
	      redraw = 1;
	break;


    case RIGHT:
	      current_view->ex += 150L* cosine(current_view->pan);
	      current_view->ez -= 150L* sine(current_view->pan);


	      rel_move_segment ( body_seg, 150L*cosine(current_view->pan), 0,-150L*sine(current_view->pan));
	      update_segment ( body_seg );
	      redraw = 1;
		break;

    case SHLEFT: current_view->pan -= 5*65536L;
	      rel_rot_segment ( body_seg, 0, (-5*65536L), 0, RYXZ);
	      update_segment ( body_seg );
		break;

    case SHRIGHT: current_view->pan += 5*65536L;
	      rel_rot_segment ( body_seg, 0, (5*65536L), 0, RYXZ);
	      update_segment ( body_seg );

		break;


    case SHUP: current_view->tilt += ( 5 * 65536L );
	     redraw =1;
       break;

    case SHDOWN: current_view->tilt -= ( 5 * 65536L );
	     redraw =1;
	     break;

    case PGUP:	current_view->ey += 150L;
	     rel_move_segment (body_seg, 0, 150L, 0);
	     update_segment (body_seg );
	     break;

    case PGDN: 	current_view->ey -= 150L;
	     rel_move_segment (body_seg, 0, -150L, 0);
	     update_segment (body_seg );
	     break;


  }

}


void check_joystick()
{
  int x, y, chint;
  float thecos, thesin;
  long tempsin, tempcos, ax, az;



  joystick_read ( &joy_data );
  x = joy_data.x;
  y = joy_data.y;

  if ( x>10 ) x -= 10;
  else
  {
    if ( x > -10) x = 0;
    else x += 10;
  }
  if ( y > 10 ) y -= 10;
  else
  {
    if(y>-10) y = 0;
    else y+=10;
  }

  switch ( joy_data.buttons )
  {
    case 0:
	    if ( x != 0 )
	    {
	      current_view->ex += 3*x* cosine(current_view->pan);
	      current_view->ez -= 3*x* sine(current_view->pan);


	      rel_move_segment ( body_seg, 3*x*cosine(current_view->pan), 0, -3*x*sine(current_view->pan));
	      update_segment ( body_seg );
	      redraw = 1;
	    }


	    if (y!=0)
	    {
	      ax = -3*y * sine(current_view->pan);
	      az = -3*y * cosine(current_view->pan);
	      current_view->ex += ax;
	      current_view->ez += az;

	      rel_move_segment ( body_seg, ax, 0, az );
	      update_segment ( body_seg );

	      redraw = 1;

	    }

	    break;

    case 1:

	   if (x!=0)
	   {
	      current_view->pan += ( x/10 * 65536L );
	      rel_rot_segment ( body_seg, 0, (x/10*65536L), 0, RYXZ);
	      update_segment ( body_seg );
	      redraw = 1;
	   }

	   if (y!=0)
	   {
	     current_view->tilt -= ( y/10 * 65536L );
	     redraw =1;
	   }

	   break;

    case 2:
	   if (y!=0)
	   {
	     current_view->ey += y*5L;
	     rel_move_segment (body_seg, 0, y*5L, 0);
	     update_segment (body_seg );
	     redraw = 1;
	   }

	   if (x!=0)
	   {
	   }

	    break;

    }
}


int click = 0,
    palm_color = 0,
    one_attached = 0;
SEGMENT *attached_segment;
/**************************************************************************
  This function performs the functions of the program.  The loop terminates
  when execution = 1.
**************************************************************************/
void main_loop(){

  double diff;
  long diffs;
  char buf[40], collision, piece, ch;
  long x,y, z;
  unsigned b, mouse;
  OBJECT *obj;
  time_t current_time;
  int a;
  union REGS r;
  POINTER gp;


  heavy = 0;
  while ( execution )
    {

      if (bioskey(1))             handle_key (getkey());
      if (joystick)               check_joystick();

//      mouse = pointer_read (mouser, &mouse_data);

      hit = 0;
      get_object_bounds ( palm_obj, &palm_x, &palm_y, &palm_z );
      walk_split_tree ( split_tree, check_list );
      if ((hit) && (palm_color == 0)) { set_poly_color(palm_obj,  0, 3 ); palm_color = 1; }
      if ((!hit) && (palm_color == 1)) { set_poly_color(palm_obj, 0, 0x14EF ); palm_color = 0; }
/*
      if ((mouse_data.buttons & 1) && (click==0))
      {
	abs_rot_segment(hand_joints[1], 0L,30*65536L+18061L*127,0L, RYXZ);
	abs_rot_segment(hand_joints[2], -20*65536L,90*65536L,-5*65536L+38700L*127, RYZX);
	abs_rot_segment(hand_joints[3], 38700*90,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[4], 38700*90,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[5], 38700*90,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[6], 38700*90,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[7], 38700*90,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[8], 38700*90,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[9], 38700*90,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[10],38700*90,0L,0L, RYXZ);

	hit = 0;
	get_object_bounds ( palm_obj, &palm_x, &palm_y, &palm_z );
	walk_split_tree (split_tree, check_list);
	if ( hit )
	{
	  attach_segment ( (SEGMENT *)get_object_owner(current_obj), our_hand );
	  if (!strcmpi(seg_getname((SEGMENT *)get_object_owner(current_obj)), "GREENBALL")) heavy=1;
	  one_attached = 1;
	  collision = 1;
	}
	else collision = 0;

	update_segment ( our_hand );
	click = 1; redraw = 1;
      }


      if (((mouse_data.buttons & 1)==0) && (click ==1))
      {
	abs_rot_segment(hand_joints[1], 0L,30*65536L,0L, RYXZ);
	abs_rot_segment(hand_joints[2], -20*65536L,90*65536L,-5*65536L, RYZX);
	abs_rot_segment(hand_joints[3], 0,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[4], 0,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[5], 0,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[6], 0,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[7], 0,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[8], 0,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[9], 0,0L,0L, RYXZ);
	abs_rot_segment(hand_joints[10],0,0L,0L, RYXZ);

	if ( one_attached ) detach_segment ((SEGMENT *)get_object_owner ( current_obj ));

	heavy = one_attached = collision = 0;
	update_segment ( our_hand );
	click = 0; redraw = 1;
      }

      if ( mouse & PNEW_POS )
      {

	if (mouse_data.dx)
	  {
	    if ( heavy ) mouse_data.dx = mouse_data.dx / 10;
	    r.x.ax = 3; /* read button status */
/*	    int86(0x33, (union REGS *)&r, (union REGS *)&r);
	    if ( r.x.bx & 0x04 )
	    {
	      if ( mouse_data.dx > 0 )
		rel_rot_segment ( our_hand, 0,0,5*65536L, RZXY );
	      else
		rel_rot_segment ( our_hand, 0,0,-5*65536L, RZXY);
	      update_segment ( our_hand );
	    }
	    else
	    {
	      if ( mouse_data.dx > 127 ) mouse_data.dx = 127;
	      if ( mouse_data.dx < -127 ) mouse_data.dx = -127;
	      rel_move_segment ( our_hand, 5*mouse_data.dx*cosine(current_view->pan), 0, -5*mouse_data.dx*sine(current_view->pan) );
	      update_segment ( our_hand );
	    }
	  }


	if ((mouse_data.dz))
	{
	  if ( heavy ) mouse_data.dz = mouse_data.dz / 10;
	  if (mouse_data.dz > 127 ) mouse_data.dz = 127;
	  if (mouse_data.dz < -127) mouse_data.dz = -127;

	  seg_getposxyz ( our_hand, &x, &y, &z );
	  if ( (y + 5*mouse_data.dz) < 0 )
	    rel_move_segment ( our_hand, 0, -y, 0 );
	  else
	    rel_move_segment ( our_hand, 0, 5*mouse_data.dz, 0 );
	  update_segment ( our_hand );
	}

	if (mouse_data.dy)
	{
	  if ( heavy ) mouse_data.dy = mouse_data.dy / 10;
	  if ( mouse_data.dy > 127 ) mouse_data.dy = 127;
	  if ( mouse_data.dy < -127 ) mouse_data.dy = -127;
	  rel_move_segment ( our_hand, 5*mouse_data.dy*sine(current_view->pan), 0, 5*mouse_data.dy*cosine(current_view->pan) ); update_segment ( our_hand );
	}

	redraw = 1;
      }
  */

   glove_update( manip_device, &gp );
   update_segment ( body_seg );

   if ((palm_color == 1) && (gp.gesture == G_FIST))
   {
     attached_segment = (SEGMENT *)get_object_owner(current_obj);
     attach_segment ( (SEGMENT *)get_object_owner(current_obj), wrist_seg );
     if (!strcmpi(seg_getname((SEGMENT *)get_object_owner(current_obj)), "GREENBALL")) heavy=1;
     one_attached = 1;
     update_segment ( body_seg );
     click = 1; redraw = 1;
   }

   if ((click == 1) && (gp.gesture == G_FLAT))
   {
     detach_segment (attached_segment);
     heavy = 0;
     redraw = 1;
     update_segment (body_seg);
     click = 0;
   }
      if (redraw)       refresh_display();
    }
}


/**************************************************************************
  This function is called to load video drivers.  The pointer
  v_driver_pointer is set to a handle representing the video driver.
  The variable v_driver_pointer is used by the files: main only.
**************************************************************************/
void load_video_driver ( char *dfile )
{
  v_driver_pointer = load_driver ( dfile );
  if ( v_driver_pointer == NULL )
  {
	fprintf ( stderr, "Bad video driver/n" );
	exit ( 1 );
  }
}


void read_hand()
{
  FILE *in;

  if ((in = fopen ( "handsm.fig", "r" )) == NULL )
    {
      fprintf ( stderr, "Unable to open handsm file.\n" );
      exit(1);
    }

  set_readseg_objlist ( objlist );
  set_readseg_seglist ( hand_joints, 20 );
  set_readseg_scale ( 3, 3, 3 );
  our_hand = readseg (in, NULL);
  if ( readseg_err != 0 )
    {
      fprintf ( stderr, "Error loading handsm.plg file.\n" );
      exit(1);
    }

  palm_obj = seg_get_object(find_segment_by_name(our_hand, "palm"));
  update_segment(our_hand);
}



void get_glove()
{
  PDRIVER *gd;
  extern PDRIVER *gloveptr_init(char *gname, long sx, long sy,
	 long sz, long srx, long sry, long srz );

  set_readseg_scale (2,2,2);
  gd = gloveptr_init ( gpdname, gpdo_x*65536.0, gpdo_y*65536.0, gpdo_z*65536.0,
	       gpdo_rx*65536.0, gpdo_ry*65536.0, gpdo_rz*65536.0 );

  manip_device = menu_device = gd;
  if(gd) load_glove_cursor ( body_seg, manip_device, gpcursor );
  palm_obj = seg_get_object(find_segment_by_name(wrist_seg, "palm"));
//  rel_move_segment ( wrist_seg, 0, -3000, 8000);
//  update_segment ( wrist_seg);

}


void check_obj ( OBJECT *obj )
{
  unsigned flags;
  int nv, np;

  get_obj_info ( obj, &nv, &np );
//  if ( nv > 6 )
    obj->oflags = obj->oflags | 0x0004;

}


void get_floor()
{

  FILE *in;
  OBJECT *floor;
  SEGMENT *floor_seg;

  set_loadplg_offset ( 0,0,0 );
  set_loadplg_scale ( 18,18,18 );

  if ((in = fopen ( "floor2.plg", "r" )) == NULL )
    {
      fprintf ( stderr, "Unable to open chess file.\n" );
      exit(1);
    }
  floor = load_plg ( in );
  if ( load_err != 0 )
    {
      fprintf ( stderr, "Error loading chess.plg file.\n" );
      exit(1);
    }
  fclose ( in );


  add_obj_to_split ( &split_tree, floor );
  floor_seg = new_seg ( NULL );
  seg_set_object (floor_seg, floor);
  set_object_owner ( floor, floor_seg );
  abs_rot_segment ( floor_seg, 90*65536L,0,0,RXYZ);
  update_segment ( floor_seg );

}



void main(int argc, char *argv[])
{

  char *fname, *in_filename;
  FILE *in;
  OBJECT *obj;
  int i;


  setup_render(50,2000);
  atexit(closeall);
  set_global_split_root ( &split_tree );
  initial_world_split ( &split_tree );
  set_move_handler ( split_move_handler );
  objlist = new_objlist();


  heavy = 1;
  load_video_driver ( vdname );
  screeninfo = screen_data();
  highest_color = screeninfo->colors-1;
  preset_default_colors();

  frame_x = screeninfo->xmin;
  frame_y = screeninfo->ymin;
  frame_w = screeninfo->xmax - screeninfo->xmin+1;
  frame_h = screeninfo->ymax - screeninfo->ymin+1;

  default_view.left = screeninfo->xmin;
  default_view.top = screeninfo->ymin;
  default_view.right = screeninfo->xmax;
  default_view.bottom = screeninfo->ymax;
  default_view.aspect = screeninfo->aspect;


  for (i=1; i < argc; ++i)
  {
    if (argv[i][0] == '/' || argv[i][0] == '-')
    {
      switch(toupper(argv[i][1]))
      {
	case '1': weight = 1; break;
	case '2': weight = 2; break;
	case '3': weight = 3; break;
	case '4': weight = 4; break;
	case '5': weight = 5; break;
	case '6': weight = 6; break;
	case '7': weight = 7; break;
	case '8': weight = 8; break;
	case '9': weight = 9; break;
    }}}

  if (enter_graphics())
  {
    fprintf ( stderr, "could not enter graphics mode\n\n");
    exit(1);
  }

  screen_clear_color = 0;

  sky_color  = 0; ground_color = 0;

  if ((in = fopen ( "weight.wld", "r" )) == NULL )
  {
	  fprintf ( stderr, "Error opening world file.\n" );
	  exit(1);
  }


  if (read_world(in))
   {
     fprintf ( stderr, "Error reading world file.\n");
     exit(1);
   }
  fclose(in);

  walk_split_tree ( split_tree, check_obj );
  body_seg = new_seg(NULL);

  sega_address = 0x2e8;
  sega_mask = 3;
  sega_left = 3;
  sega_right = 1;
  sega_doff = 0;
  sega_port_image = 0;

//  stereo_type = SWITCHED;

   current_view->ex = 500;
   current_view->ey = 1500;
   current_view->ez = -1500;
   abs_move_segment ( body_seg, 500, 1500, -1500 );
   update_segment ( body_seg );
   current_view->pan = 0;
   current_view->tilt = 30*65536L;

//   read_hand();
get_glove();
   rel_move_segment ( wrist_seg, 6000*sine(current_view->pan), 1500, 6000*cosine(current_view->pan) );
   update_segment ( wrist_seg );


  initialize_screen_factors ( current_view );
  fast_view_factors ( current_view );
  update_segment ( body_seg );

/*   if(stereo_type != MONOSCOPIC)
	{
		init_switch_driver(swdname);

		if(sl_left<0)
		{
			sl_left = default_view.left;
			sl_right = default_view.right;
			sl_top = default_view.top;
			sl_bottom = default_view.bottom;
		}
		compute_stereo_data(&default_stereo, 0, sl_xflip, sl_xoff, 65536.0*sl_xrot,
		sl_left, sl_top, sl_right, sl_bottom);

		if(sr_left<0)
		{
			sr_left = default_view.left;
			sr_right = default_view.right;
			sr_top = default_view.top;
			sr_bottom = default_view.bottom;
		}
		compute_stereo_data(&default_stereo, 1, sr_xflip, sr_xoff, 65536.0*sr_xrot,
		sr_left, sr_top, sr_right, sr_bottom);
    }*/

//  init_SG_interrupt (switch_sega, NULL, 6500 );

  if ((joy_return = joystick_check()) == 0 )
  {
    popmsg ( "Joystick was not found" );
    delay ( 1000 );
  }
  else
  {
    if ( joy_return & 1 ) joystick_init ( &joy_data, 0 );
    if ( joy_return & 2 ) joystick_init ( &joy_data, 1 );
    joystick_setscale ( &joy_data, 100 );
    joystick = 1;
  }

  get_floor();


//  menu_device = mouser = mouseptr_init(mdname);
//  pointer_reset ( mouser );

  main_loop();
}
