#include <windows.h>
#include "regini.h"

char mfg[128];  /* your name here */
char verno[16]; /* version number */


BOOL RProfileInit(char *name,char *vers)
  {
/* Validate parameters and save */
  if (!name || strlen(name)>sizeof(mfg)-1)
    return FALSE;
  if (!vers || strlen(vers)>sizeof(verno)-1)
    return FALSE;
  strcpy(mfg,name);
  strcpy(verno,vers);
  return TRUE;
  }

/* private routine to build up root key */
void build_key(LPSTR buf,LPCSTR fn,LPCSTR sec)
  {
  strcpy(buf,"Software\\");
  strcat(buf,mfg);
  strcat(buf,"\\");
  strcat(buf,fn);
  strcat(buf,"\\");
  strcat(buf,verno);
  strcat(buf,"\\");
  strcat(buf,sec);
  }

DWORD GetPrivateRProfileString(LPCSTR sec,LPCSTR item,
  LPCSTR def,LPSTR ubuf,DWORD siz,LPCSTR fn)
  {
  HKEY key;
/* should be on heap but then not thread safe! */
  char buf[1024];
  DWORD type;
  build_key(buf,fn,sec);
  if (RegOpenKeyEx(HKEY_CURRENT_USER,buf,0,
    KEY_ALL_ACCESS,&key)!=ERROR_SUCCESS)
    {  /* return default */
    strcpy(ubuf,def);
    return strlen(ubuf);
    }
  if (RegQueryValueEx(key,(LPSTR)item,0,
    &type,ubuf,&siz)!=ERROR_SUCCESS)
    {  /* return default */
    RegCloseKey(key);
    strcpy(ubuf,def);
    return strlen(ubuf);
    }
  RegCloseKey(key);
/* type must be string */
  if (type!=REG_SZ) return (DWORD)-1;
  return siz-1;
  }


BOOL WritePrivateRProfileString(LPCSTR sec,LPCSTR item,LPCSTR val,
  LPCSTR fn)
  {
  HKEY key;
  char buf[1024];
  BOOL rv=TRUE;
  build_key(buf,fn,sec);
  if (RegCreateKeyEx(HKEY_CURRENT_USER,buf,0,NULL,
    REG_OPTION_NON_VOLATILE,
    KEY_ALL_ACCESS,NULL,&key,NULL)!=ERROR_SUCCESS)
      return FALSE;
  if (val)
    {
    if (RegSetValueEx(key,item,0,REG_SZ,
      val,strlen(val)+1)!=ERROR_SUCCESS)
        rv=FALSE;
    }
  else
    if (RegDeleteKey(key,item)!=ERROR_SUCCESS)
          rv=FALSE;
  RegCloseKey(key);
  return rv;
  }
