/* Checksum shell extension -- Williams */

#include <windows.h>

int WINAPI WinMain(HANDLE hInst,
  HANDLE hPrev, LPSTR cmd,
  int shw)
  {
  unsigned sum=0;
  char buf[256];
  int ct;
/* Open file */
  HANDLE file=CreateFile(cmd,
    GENERIC_READ,FILE_SHARE_READ,
        NULL,OPEN_EXISTING,0,NULL);

/* error if can't open */
  if (file==INVALID_HANDLE_VALUE)
    {
    MessageBox(NULL,cmd,"Can't open file",MB_OK);
    return 1;
    }

/* Read blocks of 256 or less */
  do {
     int i;
     ReadFile(file,buf,sizeof(buf),&ct,NULL);
     for (i=0;i<ct;i++)
       {
       sum+=buf[i];
/* wrap around if top bit set */
       if (sum&0x80000000)
         {
         sum++;
         sum&=0x7FFFFFFF;
         }
       }
/* if ct<buf then eof */
     } while (ct==sizeof(buf));

/* Display */
  wsprintf(buf,"Checksum for %s=%d",cmd,sum);
  MessageBox(NULL,buf,"File Checksum",MB_OK);
  CloseHandle(file);
  return 0;
  }
