uses WinCrt;

const
	STEPPER_DEV_ID=$1684;

var
	DevAddr:Pointer;

procedure GetDevAddr;assembler;
asm
	xor di,di
	mov es,di
	mov bx,$7FED
	mov ax,STEPPER_DEV_ID
	int $2F
	mov DevAddr.Word[0],di
	mov DevAddr.Word[2],es
end;

procedure Start_Stepper(Number:Word;Destination:LongInt;
	Rate:Word);assembler;
asm
	mov bx,Number
	mov dx,Rate
	mov si,Destination.Word[2]
	mov cx,Destination.Word[0]
	mov ax,0
	call DevAddr
end;

procedure Stop_Stepper(Number:Word);assembler;
asm
	mov bx,Number
	mov ax,1
	call DevAddr
end;



function Get_Stepper_Position(Number:Word):LongInt;assembler;
asm
	mov bx,Number
	mov ax,2
	call DevAddr
end;

procedure Zero_Stepper(Number:Word);assembler;
asm
	mov bx,Number
	mov ax,3
	call DevAddr
end;

function Is_Stepper_Running(Number:Word):Boolean;assembler;
asm
	mov bx,Number
	mov ax,4
	call DevAddr
end;


var
	c:char;
	Rate,Number:Word;
	Distance:LongInt;
	i:Word;
begin
	GetDevAddr;
	if DevAddr=nil then
	begin
		writeln('Sorry, the VxD driver has not been loaded.'#10#13+
		'Please add the line:'#13#10#13'device=stepper.386'#10#13#13+
		'to the [386Enh] section of your SYSTEM.INI file and reboot'+
		' your computer.'#10#13#10#13'Press any key to exit.');
		ReadKey;
		DoneWinCrt;
		exit;
	end;
	repeat
		writeln;
		writeln('1=set motor paramaters');
		writeln('2=read motor positions');
		writeln('3=stop all motors');
		writeln('4=Zero motor');
		writeln('5=Motor status');
		writeln('0=Quit');
		writeln;
		c:=ReadKey;
		case c of
			'1':
			begin
				write('Enter motor number (0-2): ');
				readln(Number);
				writeln('This motor is currently positioned at ',
					Get_Stepper_Position(Number));
				write('Enter position: ');
				readln(Distance);
				write('Enter step rate (1-1000): ');
				readln(Rate);
				Start_Stepper(Number,Distance,Rate);
			end;
			'2':
			begin
				for i:=0 to 2 do
					writeln('Motor ',i,' at ',Get_Stepper_Position(i));
			end;
			'3':
			begin
				for i:=0 to 2 do
					Stop_Stepper(i)
			end;
			'4':
			begin
				write('Enter motor number (0-2): ');
				readln(Number);
				Zero_Stepper(Number);
			end;
			'5':
			begin
				for i:=0 to 2 do
				begin
					if Is_Stepper_Running(i) then
						writeln('Motor ',i,' is running.')
					else
						writeln('Motor ',i,' is stopped.');
				end;
			end;
		end;
	until c='0';
	DoneWinCrt;
end.