TITLE STEPPER
.386p

;******************************************************************
;                            E Q U A T E S
;******************************************************************

STEPPER_DEV_ID equ 7FEDh      

LPT_BASE_PORT equ 378h       
LPT_STATUS_PORT equ LPT_BASE_PORT+1
LPT_CONTROL_PORT equ LPT_BASE_PORT+2


;******************************************************************
;                         S T R U C T U R E S
;******************************************************************

STEPPER_STRUC struc
     Step_Delay dw (?)
     Extra_Wait_At dw (?)
     Extra_Wait_Count dw (?)
     Sequence_Index db 0
     Time_Remaining dw 0
     Starting_Position dd 0
     Current_Position dd 0
     Destination_Position dd 0
     Is_Running db 0
     Winding_A_Port dw (?)
     Winding_A_Mask db (?)
     Winding_A_Not_Mask db (?)    
     Winding_B_Port dw (?)
     Winding_B_Mask db (?)
     Winding_B_Not_Mask db (?)    
     Winding_C_Port dw (?)
     Winding_C_Mask db (?)
     Winding_C_Not_Mask db (?)    
     Winding_D_Port dw (?)
     Winding_D_Mask db (?)
     Winding_D_Not_Mask db (?)    
     Limit_Switch_Port dw (?)
     Limit_Switch_Mask db (?)
     Limit_Switch_Not_Mask db (?)
STEPPER_STRUC ends


;******************************************************************
;                            I N C L U D E S 
;******************************************************************

.XLIST
 INCLUDE VMM.Inc
 INCLUDE VTD.Inc
 INCLUDE Debug.Inc
 INCLUDE VPICD.Inc
 INCLUDE Shell.Inc
.LIST

;******************************************************************
;          V I R T U A L  D E V I C E   D E C L A R A T I O N 
;******************************************************************

Declare_Virtual_Device STEPPER, 3, 0Ah, Stepper_Control,\
		       STEPPER_DEV_ID,,Stepper_API_Proc,\
		       Stepper_API_Proc


;******************************************************************
;                         L O C A L   D A T A 
;******************************************************************

VxD_LOCKED_DATA_SEG

Stepper1 STEPPER_STRUC <,,,,,,,,,\
			    LPT_BASE_PORT,00000001b,00000000b,\
			    LPT_BASE_PORT,00000010b,00000000b,\
			    LPT_BASE_PORT,00000100b,00000000b,\
			    LPT_BASE_PORT,00001000b,00000000b,\
			    LPT_STATUS_PORT,00001000b,00000000b> ;pin 15

Stepper2 STEPPER_STRUC <,,,,,,,,,\
				 LPT_BASE_PORT,00010000b,00000000b,\
				 LPT_BASE_PORT,00100000b,00000000b,\
				 LPT_BASE_PORT,01000000b,00000000b,\
				 LPT_BASE_PORT,10000000b,00000000b,\
				 LPT_STATUS_PORT,00010000b,00000000b>  ;pin 13

Stepper3 STEPPER_STRUC <,,,,,,,,,\
				 LPT_CONTROL_PORT,00000001b,00000001b,\
				 LPT_CONTROL_PORT,00000010b,00000010b,\
				 LPT_CONTROL_PORT,00000100b,00000000b,\
				 LPT_CONTROL_PORT,00001000b,00001000b,\
				 LPT_STATUS_PORT,00100000b,00000000b>  ;pin 12

Stepper_Count = ($-Stepper1)/(TYPE STEPPER_STRUC)

Stepper_Table dd OFFSET32 Stepper1
		 dd OFFSET32 Stepper2
		 dd OFFSET32 Stepper3

Step_Sequence db 1010b
		 db 0110b
		 db 0101b
		 db 1001b

TimeoutHandle dd (?)

;API jump table
Stepper_API_Table LABEL DWORD
	dd OFFSET32 Start_Stepper
	dd OFFSET32 Stop_Stepper
	dd OFFSET32 Get_Stepper_Pos
	dd OFFSET32 Zero_Stepper
	dd OFFSET32 Is_Stepper_Running
Stepper_Max_API = ($-Stepper_API_Table)/4-1

VxD_LOCKED_DATA_ENDS


;*****************************************************************
;                    I N I T I A L I Z A T I O N
;*****************************************************************
VxD_ICODE_SEG

BeginProc Stepper_Device_Init
	mov eax,1
	VxDCall VTD_Begin_Min_Int_Period

	mov TimeoutHandle,0

	mov ecx,STEPPER_COUNT
	mov esi,OFFSET32 Stepper1
SDI01:
	call Output_Step_Pattern
	add esi,TYPE STEPPER_STRUC
	loop short SDI01

	clc
	ret
EndProc Stepper_Device_Init

VxD_ICODE_ENDS


VxD_CODE_SEG

BeginProc Stepper_System_Exit
	mov eax,1
	VxDCall VTD_End_Min_Int_Period

	mov esi,TimeoutHandle
	VMMCall Cancel_Time_Out

	clc
	ret
EndProc Stepper_System_Exit

BeginProc Stepper_API_Proc
	movzx eax,[ebp.CLIENT_AX]
	cmp eax,Stepper_Max_API
	ja short SAP01
	call Stepper_API_Table[eax*4]
SAP01:
	ret
EndProc Stepper_API_PROC

BeginProc TimeoutProc
	;update Time_Remaining for each running motor and determine 
	;smallest Time_Remaining.
	mov esi,OFFSET32 Stepper1
	mov ecx,STEPPER_COUNT
	mov bx,0FFFFh
TOP01:
	cmp [esi.Is_Running],0
	je short TOP04

	sub [esi.Time_Remaining],dx
	ja short TOP02

	call Advance_Position

	call Output_Step_Pattern

	call Check_Limit_Switch
        jz short TOP03

	mov eax,[esi.Current_Position]
	cmp eax,[esi.Destination_Position]
	je short TOP03
	
	mov ax,[esi.Step_Delay]
	call Do_Start_Stop_Correction
	call Do_Speed_Correction
	mov [esi.Time_Remaining],ax
TOP02:
	
	cmp [esi.Time_Remaining],bx
	ja short TOP04
	mov bx,[esi.Time_Remaining]
	jmp short TOP04
TOP03:
	mov [esi.Is_Running],0
TOP04:
	add esi,TYPE STEPPER_STRUC
	loop TOP01

	xor esi,esi
	cmp bx,0FFFFh
	je short TOP05

	movzx eax,bx
	mov edx,eax
	mov esi,OFFSET32 TimeoutProc
	VMMCall Set_Global_Time_Out
TOP05:
	mov TimeoutHandle,esi
	ret       
EndProc TimeoutProc

;esi=Stepper motor structure
BeginProc Output_Step_Pattern
	push eax
	push ebx
	push ecx
	push edx
	push esi

	movzx eax,[esi.Sequence_Index]
	mov bl,[Step_Sequence+eax]
	add esi,Winding_A_Port
	mov ecx,4
OSP01:
	mov dx,[esi]
	in al,dx
	mov ah,[esi+2]
	not ah
	and al,ah
	shr bl,1
	jnc short OSP02
	or al,[esi+2]
OSP02:
	xor al,[esi+3]
	out dx,al
	add esi,4
	loop OSP01

	pop esi
	pop edx
	pop ecx
	pop ebx
	pop eax
	ret
EndProc Output_Step_Pattern

;esi=Stepper motor structure
;returns zero flag set to status of switch
BeginProc Check_Limit_Switch
	push eax
	push edx
	mov dx,[esi.Limit_Switch_Port]
	in al,dx
	and al,[esi.Limit_Switch_Mask]
	xor al,[esi.Limit_Switch_Not_Mask]
	pop edx
	pop eax
	ret
EndProc Check_Limit_Switch

;ax=speed in
;esi=Stepper motor structure
BeginProc Do_Start_Stop_Correction
	push ebx
	push ecx
	mov ebx,[esi.Current_Position]
	sub ebx,[esi.Starting_Position]
	jge short DSSC01
	neg ebx
DSSC01:
	mov ecx,[esi.Destination_Position]
	sub ecx,[esi.Current_Position]
	jge short DSSC02
	neg ecx
DSSC02:
	cmp ebx,ecx
	jl short DSSC03
	mov ebx,ecx
DSSC03:
	cmp ebx,30
	jg short DSSC06
	cmp ebx,20
	jl short DSSC04
	mov cx,ax
	shl ax,1
	add ax,cx
	shr ax,1             ;*3/2
	jmp short DSSC06
DSSC04:
	cmp ebx,10
	jl short DSSC05
	shl ax,1              ;*2
	jmp short DSSC06
DSSC05:
	shl ax,2              ;*4
	jmp short DSSC06
DSSC06:        
	pop ecx
	pop ebx
	ret
EndProc Do_Start_Stop_Correction

;ax=speed in
;esi=Stepper motor structure
BeginProc Do_Speed_Correction
	push ebx
	cmp [esi.Extra_Wait_At],0FFFFh
	je short DSC01
	inc [esi.Extra_Wait_Count]
	mov bx,[esi.Extra_Wait_Count]
	cmp bx,[esi.Extra_Wait_At]
	jne short DSC01
	mov [esi.Extra_Wait_Count],0
	inc ax
DSC01:
	pop ebx
	ret
EndProc Do_Speed_Correction

BeginProc Advance_Position
	mov eax,[esi.Current_Position]
	cmp eax,[esi.Destination_Position]
	jg short AP01

	inc [esi.Current_Position]
	inc [esi.Sequence_Index]
	cmp [esi.Sequence_Index],3
	jle short AP02
	mov [esi.Sequence_Index],0
	jmp short AP02
AP01:
	dec [esi.Current_Position]
	dec [esi.Sequence_Index]
	jge short AP02
	mov [esi.Sequence_Index],3
AP02:
	ret
EndProc Advance_Position

;bx=motor number
;si:cx=new position
;dx=maximum step frequency
BeginProc Start_Stepper
	call Get_Table_Pointer
	jc short STS01

	;load info from client
	movzx ecx,[ebp.Client_SI]   
	shl ecx,16
	mov cx,[ebp.Client_CX]      ;ecx contains new position
	movzx edx,[ebp.Client_DX]   ;edx contains maximum step freq

	;ensure step frequency is in range (1-1000)
	cmp edx,1
	jl short STS01
	cmp edx,1000
	jg short STS01        

	;save starting position
	mov eax,[esi.Current_Position]
	mov [esi.Starting_Position],eax

	mov [esi.Destination_Position],ecx

	call Calculate_Delay
	jc short STS01

	call Schedule_Movement

	mov [esi.Time_Remaining],bx
	mov [esi.Is_Running],1
STS01:
	ret
EndProc Start_Stepper

;ecx=number of steps to travel
;edx=maximum step frequency
;esi=Stepper motor structure
;carry set if error
BeginProc Calculate_Delay
	;calculate number of steps to travel
	sub ecx,[esi.Current_Position]
	jz short CD04
	jg short CD01
	neg ecx  
CD01:
	;calculate interval and correction
	mov ebx,edx

	;calculate number of time counts to travel
	mov eax,ecx
	mov edi,1000
	mul edi
	xor edx,edx
	div ebx

	;calculate number of time counts in one step and the number
	;of remaining steps
	xor edx,edx
	div ecx
	mov ebx,edx
	mov [esi.Step_Delay],ax

	;make sure that if there are no remaining steps then there is 
	;no need to calculate how often to add one.
	
	cmp edx,0
	jne short CD02
	mov ax,0FFFFh
	jmp short CD03
CD02:
	;calculate how often to wait one extra mS
	mul ecx
	xor edx,edx
	div ebx
CD03:
	mov [esi.Extra_Wait_At],ax
	mov [esi.Extra_Wait_Count],0
	clc
	jmp short CD05
CD04:
	stc
CD05:
	ret
EndProc Calculate_Delay

;esi=Stepper motor structure
BeginProc Schedule_Movement
	;schedule first movement
	mov bx,0FFFFh
	mov ecx,STEPPER_COUNT
	mov edi,OFFSET32 Stepper1
SM01:
	cmp [edi.Is_Running],0
	je short SM02
	cmp edi,esi
	je short SM02
	cmp [edi.Time_Remaining],bx
	jae short SM02
	mov bx,[edi.Time_Remaining]
SM02:
	add edi,TYPE STEPPER_STRUC
	loop short SM01

	cmp bx,0FFFFh
	jne short SM04

	push esi
	movzx eax,[esi.Step_Delay]
	mov edx,eax
	mov ebx,eax
	cmp TimeoutHandle,0
	je short SM03
	mov esi,TimeoutHandle
	VMMCall Cancel_Time_Out
SM03:
	mov esi,OFFSET32 TimeoutProc
	VMMCall Set_Global_Time_Out
	mov TimeoutHandle,esi
	pop esi
SM04:
	ret
EndProc Schedule_Movement

;bx=motor number
BeginProc Stop_Stepper
	call Get_Table_Pointer
	jc short SPS01
	mov [esi.Is_Running],0
SPS01:
	ret
EndProc Stop_Stepper

;bx=motor number
;returns dx:ax=position
BeginProc Get_Stepper_Pos
	call Get_Table_Pointer
	jc short GSP01
	mov eax,[esi.Current_Position]
	mov [ebp.Client_AX],ax
	shr eax,16
	mov [ebp.Client_DX],ax
GSP01:
	ret
EndProc Get_Stepper_Pos

;bx=motor number
BeginProc Zero_Stepper
	call Get_Table_Pointer
	jc short ZS01
	mov eax,[esi.Current_Position]
	sub [esi.Current_Position],eax
	sub [esi.Starting_Position],eax
	sub [esi.Destination_Position],eax
ZS01:
	ret
EndProc Zero_Stepper

;bx=motor number
BeginProc Is_Stepper_Running
	call Get_Table_Pointer
	jc short ISR01     
	mov al,[esi.Is_Running]
	mov [ebp.Client_AL],al
ISR01:
	ret
EndProc Is_Stepper_Running

;IN ebp.Client_BX = Motor number
;OUT esi=pointer to stepper table for motor
BeginProc Get_Table_Pointer
	push ebx
	movzx ebx,[ebp.Client_BX]   ;ebx contains motor number
	;ensure motor number is valid
	cmp ebx,STEPPER_COUNT
	jge short GTP01
	;determine our structure
	mov esi,[OFFSET32 Stepper_Table+ebx*4]
	clc
	jmp short GTP02
GTP01:
	stc
GTP02:     
	pop ebx
	ret
EndProc Get_Table_Pointer

VxD_CODE_ENDS


VxD_LOCKED_CODE_SEG

BeginProc Stepper_Control
	Control_Dispatch Device_Init, Stepper_Device_Init
	Control_Dispatch System_Exit, Stepper_System_Exit
	clc
	ret
EndProc Stepper_Control

VxD_LOCKED_CODE_ENDS

END









