// FREVERSE.C -- M. Covington 1995
// Reads a file (up to 2 megabytes)
// and writes it out backward.

#include <stdio.h>
#include <io.h>
#include <windows.h>

#define MAXSIZE 2000000
char c[MAXSIZE];
int  i;
long b;

FILE *infile, *outfile;            /* Files */
char infname[256], outfname[256];  /* File names */
OPENFILENAME ofn;                  /* File dialog data */

main(int argc, char* argv[]) {

  /* Bail out if running under Win32 */
  if ((GetVersion() & 0x80000000) &&          /* not Win NT */
      (LOBYTE(LOWORD(GetVersion())) < 4))     /* nor Win 95 */
  {
    MessageBox(NULL,"Needs Windows 95 or NT.",argv[0],MB_OK);
    return 1;
  }

  /* Open input file */
  if (! isatty(fileno(stdin)))      /* stdin was redirected */
    infile = stdin;
  else {
    if (argc >= 2)               /* grab name from cmd line */
      strcpy(infname,argv[1]);
    else {                      /* use a common file dialog */
	memset(&ofn,0,sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = GetActiveWindow();
	ofn.lpstrFile = infname;
	ofn.nMaxFile = sizeof(infname);
	ofn.lpstrTitle = "FILE TO READ";
	ofn.Flags =
	OFN_FILEMUSTEXIST + OFN_PATHMUSTEXIST + OFN_READONLY;
	GetOpenFileName(&ofn);
	  }
    infile = fopen(infname,"rb");
    if (infile == NULL) {
      fprintf(stderr,"Can't read file '%s'.\n",infname);
      return 1;
      }
  }

  /* Open output file */
  if (! isatty(fileno(stdout)))    /* stdout was redirected */
    outfile = stdout;
  else {
    if (argc >= 3)               /* grab name from cmd line */
      strcpy(outfname,argv[2]);
    else {                      /* use a common file dialog */
	memset(&ofn,0,sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = GetActiveWindow();
	ofn.lpstrFile = outfname;
	ofn.nMaxFile = sizeof(outfname);
	ofn.lpstrTitle = "FILE TO WRITE";
	ofn.Flags =
		OFN_PATHMUSTEXIST + OFN_NOREADONLYRETURN +
		OFN_HIDEREADONLY + OFN_OVERWRITEPROMPT;
	GetSaveFileName(&ofn);
	  }
    outfile = fopen(outfname,"wb");
    if (outfile == NULL) {
      fprintf(stderr,"Can't write file '%s'.\n",outfname);
      return 1;
	  }
  }

  /* Read input data into array */
  fprintf(stderr,"Reading file '%s'\n",infname);
  /* all status msgs go onto stderr */
  for (b=0; b<MAXSIZE; b++) {
    i = fgetc(infile);
    if (i==EOF) break;
    c[b] = (char)i;
  }
  fprintf(stderr,"%ld bytes read\n",b);
  if (b == MAXSIZE) {
    MessageBox(NULL,"Input file is too large!",argv[0],MB_OK);
    return(2);
  }

  /* Write out the same bytes in reverse order */
  fprintf(stderr,"Writing file '%s'\n",outfname);
  for (b--; b>=0; b--) fputc(c[b],outfile);

  /* All done */
  fclose(infile);
  fclose(outfile);
  return 0;
}
