unit Dynctrl;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, VBXCtrl, Pict;

type
  TForm1 = class(TForm)
    BiPict0: TBiPict;
    Button1: TButton;
{Delphi created procedures}
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
{Hand Crafted procedures}
    procedure My_DblClick(Sender: TObject);
    procedure My_MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure My_MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure My_MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);

  private
    { Private declarations }
    BiPictCount: Integer;
    PointA, PointOrigin: Tpoint;
    Drawing: Boolean;

  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   BiPictCount := 0;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
   BiPictNew, BiPictOld: TBiPict;
begin
   BiPictNew := TBiPict.Create(Form1);

   Inc(BiPictCount);   {Increment the index counter}
   BiPictNew.Name := 'BiPict' + InttoStr(BiPictCount);

   BiPictNew.Parent := Form1;

   BiPictNew.Visible := TRUE;
   BiPictNew.Top := 50;
   BiPictNew.Left := 50;

   BiPictOld := TBiPict(FindComponent('BiPict0'));
   BiPictNew.Height := BiPictOld.Height;
   BiPictNew.Width := BiPictOld.Width;
   BiPictNew.Picture := BiPictOld.Picture;
   BiPictNew.StretchBlt := BiPictOld.StretchBlt;
   BiPictNew.BorderStyle := BiPictOld.BorderStyle;
   BiPictNew.BevelStyle := BiPictOld.BevelStyle;
   BiPictNew.BevelSize := BiPictOld.BevelSize;
   BiPictNew.Cursor := BiPictOld.Cursor;
   BiPictNew.DragMode := BiPictOld.DragMode;
   BiPictNew.OnDblClick := My_DblClick;
   BiPictNew.OnMouseDown := My_MouseDown;
   BiPictNew.OnMouseUp := My_MouseUp;
   BiPictNew.OnMouseMove := My_MouseMove;
end;

{Hand Crafted procedures}
procedure TForm1.My_DblClick(Sender: TObject);
var
   tb: TBiPict;
begin
   tb := TBiPict(Sender);
   MessageDlg('Button ' + tb.Name + ' Double-Clicked.', mtInformation,[mbOk], 0);
end;

procedure TForm1.My_MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   Drawing := TRUE;
   PointOrigin.X := X;
   PointOrigin.Y := Y;
end;

procedure TForm1.My_MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
   tb: TBiPict;
begin
   tb := TBiPict(Sender);
   PointA.X := X;
   PointA.Y := Y;
   PointA := Form1.ScreenToClient(tb.ClientToScreen(PointA));
   tb.Top := PointA.Y - PointOrigin.Y;
   tb.Left := PointA.X - PointOrigin.X;
   tb.Refresh;
   Drawing := False;
end;

procedure TForm1.My_MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
   tb: TBiPict;
begin
   if Drawing then
   begin
      tb := TBiPict(Sender);
      PointA.X := X;
      PointA.Y := Y;
      PointA := Form1.ScreenToClient(tb.ClientToScreen(PointA));
      tb.Top := PointA.Y - PointOrigin.Y;
      tb.Left := PointA.X - PointOrigin.X;
      tb.Refresh;
   end;
end;

end.


