// CommDoc.cpp : implementation of the CCommDoc class
//

#define BUFSIZ 2048

#include "stdafx.h"
#include "pkt95.h"

#include "CommDoc.h"
#include "dcbdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCommDoc

IMPLEMENT_DYNCREATE(CCommDoc, CDocument)

BEGIN_MESSAGE_MAP(CCommDoc, CDocument)
	//{{AFX_MSG_MAP(CCommDoc)
	ON_COMMAND(IDM_PROP, OnProp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCommDoc construction/destruction

CCommDoc::CCommDoc()
{
	comport=NULL;
	iotask=NULL;

}

CCommDoc::~CCommDoc()
{
if (comport) CloseHandle(comport);
if (iotask) 
  {
  TerminateThread(iotask->m_hThread,0);
  delete iotask;
  }
}

BOOL CCommDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	if (comport) CloseHandle(comport);
	comport=NULL;
	if (iotask) 
	  {
	  TerminateThread(iotask->m_hThread,0);
	  delete iotask;
	  }
	iotask=NULL;

	if (!Init(NULL)) return FALSE;
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CCommDoc serialization

void CCommDoc::Serialize(CArchive& ar)
{
CDocument::Serialize(ar);
// write port, dcb, and flags
if (ar.IsStoring())
  {
  ar<<port;
  ar.Write(&dcb,sizeof(dcb));
  ar<<(WORD)fullduplex;
  }
else
  {
  WORD flag;
  ar>>port;
  ar.Read(&dcb,sizeof(dcb));
  ar>>flag;
  fullduplex=flag;
  if (!Init(port,&dcb))
     AfxMessageBox("Can't open specified port");  
  }
}

/////////////////////////////////////////////////////////////////////////////
// CCommDoc diagnostics

#ifdef _DEBUG
void CCommDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CCommDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCommDoc commands

// Setup everything
BOOL CCommDoc::Init(LPCSTR nport,DCB *idcb)
  {
// Open port and set up	
  if (!nport)
    {
	/* New */
	memset(&dcb,0,sizeof(DCB));
	port="Com1";
	fullduplex=0;
	nulls=0;
	dcb.BaudRate=9600;
	dcb.StopBits=ONESTOPBIT;
	dcb.Parity=NOPARITY;
	dcb.ByteSize=8;
	if (SetProps()==IDCANCEL) return FALSE;
	}
  else
    port=nport;
  comport=CreateFile(port,GENERIC_READ|GENERIC_WRITE,0,NULL,
    OPEN_EXISTING,0,NULL);
  if (!comport) return FALSE;
  SetupComm(comport,BUFSIZ,BUFSIZ);
  if (idcb)
    dcb=*idcb;
  else
    if (nport)
	  {
      GetCommState(comport,&dcb);
	  }
  if (!SetCommState(comport,&dcb)) return FALSE;
  // start I/O task
  commargs.com=comport;
  commargs.docptr=this;;
  iotask=AfxBeginThread(CCommDoc::CommThread,&commargs);
  if (!iotask) return FALSE;
  return TRUE;
  }					   


/* Separate thread to do I/O */  
UINT CCommDoc::CommThread(LPVOID _args)
  {
  CommThreadArg *arg=(CommThreadArg *)_args;
  int err;
  unsigned long bytes;
  char buf[128];
  // Go ahead and block -- doesn't matter since we are an
  // independant thread
  COMMTIMEOUTS cto={2,0,0,0,0};
  SetCommTimeouts(arg->com,&cto);
  while (1)
    {
	err=ReadFile(arg->com,buf,sizeof(buf),&bytes,NULL);
	if (err)
	  {
	  char *ubuf=(char *)malloc(bytes+1);  // copy input to heap
	  if (ubuf)
	    {
		memcpy(ubuf,buf,bytes);
		ubuf[bytes]='\0'; // null terminate
		if (!arg->docptr->nulls)
		  {
		  for (unsigned int i=0;i<bytes;i++)
		    if (!ubuf[i])
			  {
			  strcpy(ubuf+i,ubuf+i+1);
			  bytes--;
			  }
		  }
        arg->docptr->CharsIn(ubuf,bytes);
		free(ubuf);
		}
	  }
    }
  return 0;
  }

BOOL CCommDoc::Write(char c)
  {
  unsigned long ct;
  WriteFile(comport,&c,1,&ct,NULL);
  if (ct!=1) return FALSE;
  if (!fullduplex) Echo(c);
  return TRUE;
  }

BOOL CCommDoc::Write(LPCSTR s)
  {
  while (*s) 
    if (!Write(*s++)) 
      return FALSE;
  return TRUE;
  }

void CCommDoc::Echo(char c)
  {
  POSITION pos;
  CView *view;
  pos=GetFirstViewPosition();
  // Send to each view -- note 0 means echo in case you need to distinguish
  do {
    view=GetNextView(pos);
	if (view) view->SendMessage(WM_COMMCHAR,0,(DWORD)&c);
	} while (view);
  }

int CCommDoc::SetProps()
  {
	dcb.DCBlength=sizeof(DCB);
	dcb.fDtrControl=DTR_CONTROL_ENABLE;
	dcb.fRtsControl=RTS_CONTROL_TOGGLE;
	dcb.fBinary=1; // raw -- all other values ng under NT
	dcb.fOutX=1; // XON/XOFF
	dcb.fInX=1;
	dcb.XonLim=BUFSIZ/2;
	dcb.XoffLim=BUFSIZ/2;
	dcb.XonChar='\x11';
	dcb.XoffChar='\x13';
	if (CDcbDlg::GetDCB(this)!=IDOK) return FALSE;
	if (comport) CloseHandle(comport);
	comport=NULL;
	if (iotask) 
	  {
	  TerminateThread(iotask->m_hThread,0);
	  delete iotask;
	  }
	iotask=NULL;
  return TRUE;
  }

// Change properties
void CCommDoc::OnProp() 
{
    if (!SetProps()) return;
	SetModifiedFlag();
	Init(port,&dcb);
}

void CCommDoc::CharsIn(LPSTR buf,unsigned ct)
  {
  POSITION pos;
  CView *view;
  pos=GetFirstViewPosition();
  // Send notice to all views
  do {
	  view=GetNextView(pos);
	  if (view) view->SendMessage(WM_COMMCHAR,ct,(DWORD)buf);
	  } while (view);

  }
