unit MainForm;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Buttons;

type
  TFrmMain = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    DlgOpen: TOpenDialog;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    LblColorsSize: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Panel4: TPanel;
    LblNormal: TLabel;
    Bevel1: TBevel;
    BtnTrim: TButton;
    Panel1: TPanel;
    LblTrim: TLabel;
    Panel2: TPanel;
    LblTrimLeft: TLabel;
    Panel3: TPanel;
    LblTrimRight: TLabel;
    LblDesktopBMP: TLabel;
    BtnWinIniTest: TButton;
    BtnOpen: TButton;
    RichEdit1: TRichEdit;
    BtnUpperCase: TButton;
    RichEdit2: TRichEdit;
    Bevel2: TBevel;
    Label7: TLabel;
    Label8: TLabel;
    TrackBar1: TTrackBar;
    LblIndexPos: TLabel;
    Label11: TLabel;
    LblColorSize: TLabel;
    LblFileName: TLabel;
    Label9: TLabel;
    BtnShowInteger: TButton;
    BtnSetColors: TButton;
    Label5: TLabel;
    PnlColor: TPanel;
    BtnShowReal: TButton;
    BtnShowString: TButton;
    PnlShowMsg: TPanel;
    LblLength: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    procedure BtnUpperCaseClick(Sender: TObject);
    procedure BtnOpenClick(Sender: TObject);
    procedure BtnTrimClick(Sender: TObject);
    procedure BtnWinIniTestClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnShowIntegerClick(Sender: TObject);
    procedure BtnSetColorsClick(Sender: TObject);
    procedure BtnShowRealClick(Sender: TObject);
    procedure BtnShowStringClick(Sender: TObject);
  private
    { Private declarations }
    procedure ShowMsg( V : Variant );
  public
    { Public declarations }
    Colors : array[ 1..100000 ] of TColor;
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.DFM}

uses
  WinIniUnit;


procedure TFrmMain.FormCreate(Sender: TObject);
begin
  PageControl1.ActivePage := TabSheet1;
  Randomize;
  LblColorSize.Caption := FormatFloat( 'Size #,### Bytes',
                                        SizeOf( TColor ) );
  LblColorsSize.Caption := FormatFloat( 'Size #,### Bytes',
                                         SizeOf( Colors ) );
end;


{= No Limits Page Methods =}

procedure TFrmMain.BtnSetColorsClick(Sender: TObject);
var
  I, R, G, B : Integer;
begin
  for I := 1 to 100000 do
  begin
    R := Random( 256 );
    G := Random( 256 );
    B := Random( 256 );
    Colors[ I ] := PaletteRGB( R, G, B );
  end;
end;

procedure TFrmMain.TrackBar1Change(Sender: TObject);
begin
  LblIndexPos.Caption := Format( 'Colors[ %d ]', [ TrackBar1.Position ] );
  PnlColor.Color := Colors[ TrackBar1.Position ];
end;


{= Finalization Page Methods =}

procedure TFrmMain.BtnWinIniTestClick(Sender: TObject);
begin
  LblDesktopBMP.Caption := WinIni.ReadString( 'Desktop',
                                              'WallPaper', '' );
end;


{= Variants Page Methods =}

procedure TFrmMain.ShowMsg( V : Variant );
begin
  PnlShowMsg.Caption := V;
end;

procedure TFrmMain.BtnShowIntegerClick(Sender: TObject);
begin
  ShowMsg( 14 );
end;

procedure TFrmMain.BtnShowRealClick(Sender: TObject);
begin
  ShowMsg( 3.14159 );
end;

procedure TFrmMain.BtnShowStringClick(Sender: TObject);
begin
  ShowMsg( 'Blazing Pascal' );
end;


{= Long Strings Page Methods =}

procedure TFrmMain.BtnOpenClick(Sender: TObject);
begin
  if DlgOpen.Execute then
  begin
    RichEdit1.Lines.LoadFromFile( DlgOpen.FileName );
    LblFileName.Caption := DlgOpen.FileName;
    LblLength.Caption := Format( 'String Length: %d characters',
                                 [ Length( RichEdit1.Text ) ] );
  end;
end;

procedure TFrmMain.BtnUpperCaseClick(Sender: TObject);
begin
  RichEdit2.Text := UpperCase( RichEdit1.Text );
end;


{= Trim Functions Page Methods =}

procedure TFrmMain.BtnTrimClick(Sender: TObject);
begin
  LblNormal.Caption := Edit1.Text;
  LblTrim.Caption := Trim( Edit1.Text );
  LblTrimLeft.Caption := TrimLeft( Edit1.Text );
  LblTrimRight.Caption := TrimRight( Edit1.Text );
end;

end.
