unit Splash;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons;

type
  TSplashScreen = class(TForm)
    Timer1: TTimer;
    Label1: TLabel;
    DoneBtn: TBitBtn;
    procedure FormPaint(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure RedrawComponents;
    procedure FormResize(Sender: TObject);
    procedure DoneBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Done : Boolean;
  MaximumSeconds : Integer;
  SplashScreen: TSplashScreen;

implementation

{$R *.DFM}

uses formfade;

var
    TickCounter : LongInt;

procedure TSplashScreen.FormPaint(Sender: TObject);
var
  iStartingY,iNumberOfLines,y : Integer;
begin
  FadeForm(Self,15,clRed);
  Self.Canvas.Pen.Color := clYellow;
  with Self.Canvas do
    begin
      iStartingY := (Self.Height div 10) * 7;
      iNumberOfLines := (Self.Height div 60);

      for y := iStartingY to (iNumberOfLines + iStartingY) do
        begin
          MoveTo(0,y);
          LineTo(Self.Width,y);
        end;
    end;

  DoneBtn.Visible := TRUE;
  Self.ActiveControl := DoneBtn;

end;

procedure TSplashScreen.Timer1Timer(Sender: TObject);
var
   Seconds : Integer;
begin
     TickCounter := TickCounter + 1;
     Seconds := TickCounter;
     if Seconds >= MaximumSeconds then
        Close;
end;

procedure TSplashScreen.RedrawComponents;
begin
    Label1.Caption := 'Splash Screen Demo';
    Label1.Left := 0;
    Label1.Top := (Height div 5);
    Label1.Height := Height div 8;
    Label1.Font.Pitch := fpVariable;
    Label1.Font.Height := Label1.Height;
    Label1.Font.Color := clWhite;
    Label1.Left :=
      (Width - label1.Width) div 2;
    Label1.Visible := TRUE;

    DoneBtn.Left := Self.ClientWidth - ((DoneBtn.Width  * 3) div 2);
    DoneBtn.Top := Height - ((DoneBtn.Height* 3) div 2);
 end;

procedure TSplashScreen.FormResize(Sender: TObject);
begin
  RedrawComponents;
end;

procedure TSplashScreen.DoneBtnClick(Sender: TObject);
begin
  Done := TRUE;
  Close;
end;

procedure TSplashScreen.FormCreate(Sender: TObject);
begin
  RedrawComponents;
end;

initialization

Done := FALSE;
TickCounter := 0;
MaximumSeconds := 20;

end.
