unit Sender;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, MsgStuf, MessCons, Status;

type
  TSenderForm = class(TForm)
    SetBtn: TButton;
    ClearBtn: TButton;
    SetIndicator: TPanel;
    ClearIndicator: TPanel;
    CreateBtn: TButton;
    DestroyBtn: TButton;
    procedure SetBtnClick(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);
    procedure CreateBtnClick(Sender: TObject);
    procedure DestroyBtnClick(Sender: TObject);
  protected
    procedure CMSet(var Msg : TMessage); message CM_SetCmd;
    procedure CMClear(var Msg : TMessage); message CM_ClearCmd;
    procedure CMHello(var Msg : TMessage); message CM_SenderID;
   procedure DefaultHandler(var Message); override;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SenderForm: TSenderForm;
  s : array[0..79] of char;

implementation

{$R *.DFM}


procedure TSenderForm.SetBtnClick(Sender: TObject);
begin
 StrCopy(s, 'Set Command received.');
 SendMessage(Application.MainForm.Handle, CM_SetRequest, clRed, Longint(@s));
end;

procedure TSenderForm.ClearBtnClick(Sender: TObject);
begin
 StrCopy(s, 'Clear Command received.');
 SendMessage(Application.MainForm.Handle, CM_ClearRequest, clGreen, Longint(@s));
end;

procedure TSenderForm.CreateBtnClick(Sender: TObject);
begin
 if not FormExists(CM_StatusID)
  then begin
        StatusForm := TStatusForm.Create(SenderForm);
        StatusForm.Show;
       end;
end;

procedure TSenderForm.DestroyBtnClick(Sender: TObject);
begin
 if FormExists(CM_StatusID) then StatusForm.Free;
end;


{ Special message event handlers }

procedure TSenderForm.CMSet(var Msg : TMessage);
begin
 SetIndicator.Color := clRed;
 ClearIndicator.Color := clBtnFace;
 BroadcastCommand(Self, Msg);
end;

procedure TSenderForm.CMClear(var Msg : TMessage);
begin
 SetIndicator.Color := clBtnFace;
 ClearIndicator.Color := clGreen;
 BroadcastCommand(Self, Msg);
end;

procedure TSenderForm.CMHello(var Msg : TMessage);
begin
 Msg.Result := Self.Handle;
end;

procedure TSenderForm.DefaultHandler(var Message);
var
 Cmd : TMessage;
begin
 inherited DefaultHandler(Message);
 Cmd := TMessage(Message);
 if     (Word(Cmd.Msg) >= UserBroadcastMin)
    and (Word(Cmd.Msg) <= UserBroadcastMax)
   then if TMessage(Message).Result = 0
    then TMessage(Message).Result := BroadcastCommand(Self, Cmd)
    else BroadcastCommand(Self, Cmd);
end;

end.
