unit MsgStuf;

interface

uses
 Classes, Forms, Messages, WinProcs, WinTypes;

 function BroadcastCommand(Sender : TComponent; Cmd : TMessage) : Longint;
 function AppBroadcastCommand(Cmd : TMessage) : Longint;
 function FormHandle(IDMsg : Word) : THandle;
 function FormExists(IDMsg : Word) : Boolean;


implementation

{
  BroadcastCommand locates all forms owned
  by the specified Sender and sends each one
  the specified message using the SendMessage
  function. This function returns the value
  returned by the first responder to the message.
}
function BroadcastCommand(Sender : TComponent; Cmd : TMessage) : Longint;
var
 i    : Integer;
 RVal : Longint;
begin
 Result := 0;
 for i := 0 to Sender.ComponentCount - 1 do
  if Sender.Components[i] is TForm
   then begin
         RVal := SendMessage(TForm(Sender.Components[i]).Handle,
                   Cmd.Msg, Cmd.WParam, Cmd.LParam);
         if Result = 0 then Result := RVal;
        end;
end;

{
  AppBroadcastCommand is a special version
  of BroadcastCommand, used exclusively in
  the code for the Application's Main Form.
  In addition to broadcasting to all units
  owned directly by the Main Form, it reaches
  out to the Application and broadcasts to all
  forms the Application owns.
}
function AppBroadcastCommand(Cmd : TMessage) : Longint;
var
 i : Integer;
 j : Integer;
 Hnd : THandle;
 RVal : Longint;
begin
 Result := 0;

 { Walk through each form owned by the Application }
 for i := 0 to Application.ComponentCount - 1 do
  if Application.Components[i] is TForm
   then begin
         RVal := 0;
         Hnd := TForm(Application.Components[i]).Handle;
         { If the current form is the Main Form, then
           walk through any forms it owns as well. }
         if Hnd <> Application.MainForm.Handle
          then RVal := SendMessage(Hnd, Cmd.Msg, Cmd.WParam, Cmd.LParam)
          else for j := 0 to Application.MainForm.ComponentCount - 1 do
                if Application.MainForm.Components[j] is TForm
                 then RVal :=
                  SendMessage(TForm(Application.MainForm.Components[j]).Handle,
                                Cmd.Msg, Cmd.WParam, Cmd.LParam)  
                 else RVal := 0;
         if (Result = 0) and (RVal <> 0) then Result := RVal;
        end;
end;

{
  FormHandle returns the handle of the form
  with the specified ID constant. If the form
  doesn't exist, FormHandle returns a zero.
}
function FormHandle(IDMsg : Word) : THandle;
begin
 Result := SendMessage(Application.MainForm.Handle, IDMsg, 0, 0);
end;

{
  FormExists returns a Boolean value which indicates
  whether or not the form with the specified ID constant
  is valid.
}
function FormExists(IDMsg : Word) : Boolean;
begin
 Result := THandle(FormHandle(IDMsg)) <> 0;
end;

{
  DefaultHandler automates the broadcast of special
  messages, and participates in the process by keeping
  only the first response to the broadcast. DefaultHandler
  should be inserted in each form in an application and
  must be modified by changing <MyForm> to the class name
  of the form (e.g., TForm1). When declared in the unit,
  it must be in the protected section, and must be followed
  by an override declaration. It also presumes the declaration
  of global constants UserBroadcastMin and UserBroadcastMax,
  which define the range of message numbers used for
  broadcasting. DefaultHandler is commented out and included
  here for convenience in copying it into the code for
  individual forms.

  Note: requires the use of the $X+ compiler directive
}
(*
procedure <MyForm>.DefaultHandler(var Message);
var
 Cmd : TMessage;
begin
 inherited DefaultHandler(Message);
 Cmd := TMessage(Message);
 if     (Word(Cmd.Msg) >= UserBroadcastMin)
    and (Word(Cmd.Msg) <= UserBroadcastMax)
   then if TMessage(Message).Result <> 0
    then TMessage(Message).Result := BroadcastCommand(Self, Cmd)
    else BroadcastCommand(Self, Cmd);
end;
*)

end.
