unit Messcons;
 { Constants for the Message Demo }
interface

uses
 Messages;

const
 { Message Range and Offset constants }
 { - When sent to Application.MainForm, these messages are not
     broadcast to other forms }
 UserCommandOffset   = 100;  { Offset from WM_USER to first command }
 UserCommandRange    =  40;  { Number of possible command messages }
 UserCommandMin      = WM_USER + UserCommandOffset;
 UserCommandMax      = UserCommandMin + UserCommandRange;

 { Broadcast Range and Offset constants }
 { - When sent to Application.MainForm, these messages are
     automatically broadcast to all other forms }
 UserBroadcastRange  =  50;  { Number of possible broadcast messages }
 UserBroadcastMin    = UserCommandMax + 1;
 UserBroadcastMax    = UserBroadcastMin + UserBroadcastRange;

 { User command request constants }
 CM_SetRequest       = UserCommandMin +  0;
 CM_ClearRequest     = UserCommandMin +  1;

 { Broadcast command constants }
 CM_SetCmd           = UserBroadcastMin +  0;
 CM_ClearCmd         = UserBroadcastMin +  1;

 { Form ID constants }
 CM_SenderID         = UserBroadcastMin + 10;
 CM_ReceiverID       = UserBroadcastMin + 11;
 CM_StatusID         = UserBroadcastMin + 12;


implementation

end.
