void next_move()
{
   int col,card,suit,value,color;
   int x1,x2,y1,y2,col1,col2;
   int card1,card2,value1,suit1,value2,suit2;
   int color1,color2;
   char string[2];
   int first,valid;
   int card_moved,won,vacant,king_waiting;
   int i;
   int col3;

   /* check if a king is waiting for a vacant column */
   no_moves = FALSE;
   vacant = FALSE;
   king_waiting = FALSE;
   for (i = 7; i >= 1; i--)
   {  
      if (top[i] == 0)  
      {
         vacant = TRUE;
      }
      else if (top[i] != 1)  
      {
         card = column[top[i]][i];
         get_card_value(card,&value,&suit,&color);
         if (value == 13) king_waiting = TRUE;
      }
   }
   if (stacktop >= 0)  
   {  
      card = stack[stacktop];
      get_card_value(card,&value,&suit,&color);
      if (value == 13) king_waiting = TRUE;
   }

   /* try to move column to column
      without leaving a vacant column */
   for (col1 = 7; col1 >= 1; col1--)
   {
      if (bottom[col1] != 0 && top[col1] != 1)
      {
         card1 = column[top[col1]][col1];
         get_card_value(card1,&value1,&suit1,&color1);
         for (col2 = 7; col2 >= 1; col2--)
         {
            if (col1 != col2)
            {
               /* move a king to an empty column */

               if (bottom[col2] == 0)
               {
                  if (value1 == 13)
                  {
                     move_column(col1,col2);
                     return;
                  }
               }

               /* move col1 to bottom of col2 */
               else
               {
                  card2 = column[bottom[col2]][col2];
                  get_card_value(card2,&value2,&suit2,&color2);
                  if (color1 != color2 && value2 == value1+1)
                  {
                     move_column(col1,col2);
                     return;
                  }
               }
            }
         }
      }
   }

   /* leave a vacant column only if there is a king
      waiting for it */
   for (col1 = 7; col1 >= 1; col1--)
   {
      if (top[col1] == 1)
      {
         card1 = column[top[col1]][col1];
         get_card_value(card1,&value1,&suit1,&color1);
         if (value1 != 13)
         {  
            for (col2 = 7; col2 >= 1; col2--)
            {
               if (col1 != col2 && bottom[col2] != 0)
               {

                  /* move col1 to bottom of col2 */

                  card2 = column[bottom[col2]][col2];
                  get_card_value(card2,&value2,&suit2,&color2);
                  if (color1 != color2 && value2 == value1+1)
                  {

                     /* only move the top of column
                        if a king is waiting */

                     if (!vacant && king_waiting)  
                     { 
                        move_column(col1,col2);
                        return;
                     }
                  }
               }
            }
         }
      }
   }

   /*  couldn't move column to column, try stack to column */
   if (stacktop >= 0)
   {
      card1 = stack[stacktop];
      get_card_value(card1,&value1,&suit1,&color1);
      for (col2 = 7; col2 >= 1; col2--)
      {
         if (bottom[col2] == 0)  
         {
            if (value1 == 13)  
            {  
               stack_to_column(col2);
               return;
            }
         } 
         else
         {
            card2 = column[bottom[col2]][col2];
            get_card_value(card2,&value2,&suit2,&color2);
            if (color1 != color2 && value2 == value1+1)  
            {
               stack_to_column(col2);
               return;
            }
         }
      }

      /* couldn't move stack to column, try stack to the pile */
      if (value1 == pile[suit1]+1)
      {
         stack_to_pile(card1,suit1);
         return;
      }

      /* couldn't put stack on column or pile,
         put matching card on pile? */
      for (col2 = 7; col2 >= 1; col2--)
      {
         if (bottom[col2] > 1)
         {
            card2 = column[bottom[col2]][col2];
            get_card_value(card2,&value2,&suit2,&color2);
            if (color1 == color2 && value1 == value2)
            {
               if (value2 == pile[suit2]+1)
               {
                  column_to_pile(col2,card2,suit2);
                  return;
               }
            }
         }
      }
   }

   /* if a card is the only card on a column,
      try to move it to a pile */
   for (col1 = 7; col1 >= 1; col1--)
   {
      if (bottom[col1] != 0)
      {
         if (bottom[col1] == 1)
         {
            if (king_waiting)
            {
               card1 = column[bottom[col1]][col1];
               get_card_value(card1,&value1,&suit1,&color1);
               if (value1 == pile[suit1]+1)  
               {
                  column_to_pile(col1,card1,suit1);
                  return;
               }
            }
         }
         else if (top[col1] == bottom[col1])  
         {
            card1 = column[bottom[col1]][col1];
            get_card_value(card1,&value1,&suit1,&color1);
            if (value1 == pile[suit1]+1)  
            {
               column_to_pile(col1,card1,suit1);
               return;
            } 

            /* can't put it on pile, put matching card on pile? */

            else
            {
               for (col2 = 7; col2 >= 1; col2--)
               {
                  if (col1 != col2 && bottom[col2] > 1)
                  {
                     card2 = column[bottom[col2]][col2];
                     get_card_value(card2,&value2,&suit2,&color2);
                     if (color1==color2 && value1== value2)
                     {
                        if (value2 == pile[suit2]+1)
                        {
                           column_to_pile(col2,card2,suit2);
                           return;
                        }
                     }
                  }
               }
            }
         }
      }
   }

   /* couldn't move any cards, take one off deck */
   if (decktop >= 0)
   {
      deck_to_stack();
      return;
   }

   /* no more cards on deck, try to move a card to the pile */
   for (col1 = 7; col1 >= 1; col1--)
   {
      if (bottom[col1] != 0)
      {
         card1 = column[bottom[col1]][col1];
         get_card_value(card1,&value1,&suit1,&color1);
         if (value1 == pile[suit1]+1)
         {
            column_to_pile(col1,card1,suit1);
            return;
         }
      }
   }

   /* give up -- there's nothing we can do */
   no_moves = TRUE;
   return;
}

