//---------------------------------------------------------------------------
//
//	File:			LOGIDPAL.CPP
//	Programmer: 	Bob Provencher
//	Create Date:	1/15/95
//	Last Mod Date:	3/5/95
//	Description:	LogIdPalette class implementation
//
//	Copyright (c) 1994, 1995. Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "logidpal.h"

BOOL LogIdPalette::MakeIdentity( const LogSystemPalette& syspal )
{
	BOOL fReturn = FALSE;
	if ( LogSystemPalette::IsPaletteDevice() )
	{
		if ( ResizeTo( syspal.Size() ) )
		{
			WORD stat =
				(WORD)( LogSystemPalette::GetUse() == SYSPAL_STATIC ? 20 : 2 );
			for ( int i = 0; i < stat / 2; i++ )
			{
				Color( i ) = syspal[ i ];
				Color( Size() - i - 1 ) = syspal[ Size() - i - 1 ];
			}
			SetEntryFlags( 0, (WORD)( stat / 2 ), 0 );
			SetEntryFlags( (WORD)( stat / 2 ), (WORD)( Size() - stat ), PC_RESERVED );
			SetEntryFlags( (WORD)( Size() - ( stat / 2 ) ), (WORD)( stat / 2 ), 0 );
			fReturn = TRUE;
		}
	}
    return fReturn;
}


