//---------------------------------------------------------------------------
//
//	File:			DDSAMP.CPP
//	Programmer:		Bob Provencher
//	Create Date:	6/26/95
//	Last Mod Date:	8/9/95
//	Description:	
//
//	Copyright (c) 1995 Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "ddsamp.h"
#include "ddsurf.h"
#include "dddiag.h"
#include "ball.h"
#include "ddsamp.rh"

HINSTANCE	hInst;
LPCSTR		lpszMainWndClass	= "MainWndClass";
LPCSTR		lpszDirectDraw		= "Direct Draw Sample";
HWND		hWndMain;
BOOL		fActive;

UINT		uWidth, uHeight;
BOOL		bTrace;
DWORD		dwFreq;

LPDIRECTDRAW 			pDirectDraw;		// Direct Draw object

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
					LPSTR, int nCmdShow )
{

	MSG msg;


	randomize();

	if ( !hPrevInstance )
		if ( !InitApplication( hInstance ) )
			return 0;

	if ( !InitInstance( hInstance, nCmdShow ) )
	{
		CleanUp();
		return 0;
	}

	do
	{
		if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
		{
			if ( msg.message != WM_QUIT )
			{
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
		}
		else
		{
			if ( AppIdle() )
				WaitMessage();
		}
	}
	while ( msg.message != WM_QUIT );

	return msg.wParam;

}

void WritePrivateProfileInt( LPSTR section, LPSTR key, int value, LPSTR file )
{
	char buffer[ 20 ];
	wsprintf( buffer, "%d", value );
    WritePrivateProfileString( section, key, buffer, file );
}

BOOL LoadIniSettings( void )
{

	char buffer[ 512 ];

	if ( GetModuleFileName( hInst, buffer, 512 ) == 0 )
		return FALSE;

	strcpy( buffer + strlen( buffer ) - 3, "INI" );

	uWidth       = GetPrivateProfileInt( "Balls", "ScreenWidth",  640, buffer );
	uHeight      = GetPrivateProfileInt( "Balls", "ScreenHeight", 480, buffer );
	numBackBuffs = GetPrivateProfileInt( "Balls", "BackBuffers", 2, buffer );
	desired_fps  = GetPrivateProfileInt( "Balls", "DesiredFrameRate", 60, buffer );
	page_flip    = GetPrivateProfileInt( "Balls", "PageFlip", 1, buffer );
	numBalls     = GetPrivateProfileInt( "Balls", "NumberOfBalls", 10, buffer );
	bTrace       = GetPrivateProfileInt( "Balls", "Trace", 0, buffer );

	//
	//  constrain these variables to min and max
	//

	constrain( uWidth,  320U, 800U );
	constrain( uHeight, 200U, 600U );
	constrain( numBackBuffs, 1, 2 );
	constrain( desired_fps, 5, 87 );
	constrain( page_flip, 0, 1 );
	constrain( numBalls, 1, 100 );
	constrain( bTrace, 0, 1 );

	move_ball_period = ( 1000 / desired_fps ) - 1;

	WritePrivateProfileInt( "Balls", "ScreenWidth", uWidth, buffer );
	WritePrivateProfileInt( "Balls", "ScreenHeight", uHeight, buffer );
	WritePrivateProfileInt( "Balls", "BackBuffers", numBackBuffs, buffer );
	WritePrivateProfileInt( "Balls", "DesiredFrameRate", desired_fps, buffer );
	WritePrivateProfileInt( "Balls", "PageFlip", page_flip, buffer );
	WritePrivateProfileInt( "Balls", "NumberOfBalls", numBalls, buffer );
	WritePrivateProfileInt( "Balls", "Trace", bTrace, buffer );
											   
	return TRUE;

}

static DWORD now = 0, last = timeGetTime();

//
//	AppIdle returns a boolean that specifies whether or not it's ok to yield
//

BOOL AppIdle( void )
{
	now = timeGetTime();
	if ( now - last > (UINT)move_ball_period )
	{
		//
		//	uPendingMoves is to keep us from getting way behind
		//	our desired frame rate and filling up the message queue
		//
		if ( uPendingMoves == 0 && hWndMain )
		{
			last = now;
			PostMessage( hWndMain, WM_MOVEBALL, 0, 0L );
			uPendingMoves++;
			//
			//	go ahead and yield since we now have a message in the queue
			//
			return TRUE;
		}
	}
	//
	//	don't yield here, we'll never get back!
	//
	return FALSE;
}

BOOL InitApplication( HINSTANCE hInstance )
{

	WNDCLASS  wc;

	wc.style			= CS_BYTEALIGNCLIENT;
	wc.lpfnWndProc		= MainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon			= LoadIcon( hInstance, MAKEINTRESOURCE( IDI_DDSAMP ) );
	wc.hCursor			= NULL;
	wc.hbrBackground	= CreateSolidBrush( RGB( 0, 0, 0 ) );
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= lpszMainWndClass;

	return RegisterClass( &wc );

}

BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{

	hInst = hInstance;

	if ( !LoadIniSettings() )
		return FALSE;

	if ( bTrace )
		trace.open( "trace.txt" );

	hWndMain = CreateWindow( lpszMainWndClass, lpszDirectDraw,
							 WS_EX_TOPMOST | WS_POPUP,
							 0, 0,
							 uWidth, uHeight,
							 NULL, NULL, hInstance, NULL );

	if ( !hWndMain )
		return FALSE;

	ShowWindow( hWndMain, nCmdShow );
	UpdateWindow( hWndMain );

	return TRUE;

}

HRESULT CALLBACK EnumDisplayModesCallback( LPDDSURFACEDESC lpDDSurfDesc,
										   LPVOID )
{
	trace << "Display Mode: "
		  << "\n Width:             " << lpDDSurfDesc->dwWidth
		  << "\n Height:            " << lpDDSurfDesc->dwHeight
		  << "\n Bit Depth:         "
		  << lpDDSurfDesc->ddpfPixelFormat.dwRGBBitCount
		  << endl << endl;
	return DDENUMRET_OK;
}

BOOL InitDirectDraw( void )
{

	//
	//	create our main DirectDraw object
	//

	DDTRACE << "DirectDrawCreate()\n";

	sCode = DirectDrawCreate( NULL, &pDirectDraw, NULL );

	CHECK;

	DDTRACE << pDirectDraw << " DirectDraw::SetCooperativeLevel()\n";
    DDTRACE << "hWndMain: " << hWndMain << endl;
	sCode = pDirectDraw->SetCooperativeLevel( hWndMain,
											  DDSCL_EXCLUSIVE |
											  DDSCL_FULLSCREEN |
											  DDSCL_ALLOWMODEX );
	CHECK;

	DDTRACE << pDirectDraw << " DirectDraw::EnumDisplayModes()\n";

	pDirectDraw->EnumDisplayModes( 0, 0, 0, EnumDisplayModesCallback );

	CHECK;

	DDTRACE << pDirectDraw << " DirectDraw::SetDisplayMode()\n";

	sCode = pDirectDraw->SetDisplayMode( uWidth, uHeight, 8 );

	CHECK;

	//
	//	This didn't seem to be supported in beta 1 or 2.
	//

//	sCode = pDirectDraw->GetMonitorFrequency( &dwFreq );
//
//	CHECK;
//
//	DDTRACE << "Monitor frequency is " << dwFreq / 1000 << "Hz.\n";

	DDTRACE << pDirectDraw << " DirectDraw::SetCooperativeLevel()\n";
    DDTRACE << "hWndMain: " << hWndMain << endl;
	sCode = pDirectDraw->SetCooperativeLevel( hWndMain,
											  DDSCL_EXCLUSIVE |
											  DDSCL_FULLSCREEN |
											  DDSCL_ALLOWMODEX );
	CHECK;

	return CreateSurfaces();

}

LPARAM CALLBACK MainWndProc( HWND hWnd, UINT message, WPARAM wParam,
							 LPARAM lParam )
{

	switch ( message )
	{

		case WM_CREATE:

        	hWndMain = hWnd;

			if ( InitDirectDraw() )
			{

				ShowCursor( FALSE );

				return 0;

			}
			else
				return -1;

		case WM_ACTIVATEAPP:

			fActive = wParam;

			return 0;

		case WM_LBUTTONDOWN:
		case WM_KEYDOWN:

			DestroyWindow( hWnd );

			return 0;

		case WM_MOVEBALL:

		//
		//	draw the balls and flip (or blt)
		//

			if ( !ComposeAndShowImage() )
			{
				DestroyWindow( hWnd );
				return 0;
			}

		//
		//	Do the position update for the balls next move now.
		//	Since the flip or blt is still occuring asynchronously, 
		//	it almost makes this a free operation.
		//

			AccelBall();		  
			MoveBall();
			uPendingMoves--;

			break;

		case WM_DESTROY:

			CleanUp();

			ShowCursor( TRUE );

			PostQuitMessage( 0 );

			return 0;

        case WM_NCDESTROY:

			hWndMain = 0;

            return 0;

	}

	return DefWindowProc( hWnd, message, wParam, lParam );

}


