#ifndef __DDDIAG_H__
#define __DDDIAG_H__

//---------------------------------------------------------------------------
//
//	File:			DDDIAG.H
//	Programmer:		Bob Provencher
//	Create Date:	7/15/95
//	Last Mod Date:	8/9/95
//	Description:	
//
//	Copyright (c) 1995 Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

extern ofstream trace;
extern SCODE	sCode;

#define DIAGNOSE_SCODE( s )	Diagnose( __FILE__, __LINE__, ( s ) )
#define DIAGNOSE			DIAGNOSE_SCODE( sCode )

#define CHECK_SCODE( s )	{ if ( FAILED( s ) ) return DIAGNOSE_SCODE( s ); }
#define CHECK				CHECK_SCODE( sCode )

#define DDTRACE   		trace << __FILE__ " line " << __LINE__ << ": " << flush

BOOL Diagnose( char* file, UINT line, SCODE s );
void Message( char* msg, UINT style = MB_OK | MB_ICONINFORMATION );

struct ErrorDesc
{
	SCODE	sCode;
	char*	sCodeStr;
};

#endif

