#ifndef __BALL_H__
#define __BALL_H__

//---------------------------------------------------------------------------
//
//	File:			BALL.H
//	Programmer:		Bob Provencher
//	Create Date:	7/16/95
//	Last Mod Date:	7/16/95
//	Description:	
//
//	Copyright (c) 1995 Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

extern int numBalls;

class Ball
{

private:

	POINT pos;
	POINT speed;

public:

	Ball();

	Ball( const POINT& p, const POINT& s ) :
		pos( p ),
		speed( s )
	{
	}

	const POINT& Pos() const
	{
		return pos;
	}

	const POINT& Speed() const
	{
		return speed;
	}

	void Move()
	{
		pos.x += speed.x;
		pos.y += speed.y;
	}

	void Accel();

	void BounceX()
	{
		speed.x = -speed.x;
	}

	void BounceY()
	{
		speed.y = -speed.y;
	}

	BOOL Draw() const;

};

extern Ball* ball;

#endif

