/* Net Checkers network code */
#include <windows.h>
#include <winsock.h>
#include "checker.h"

/* The socket */
SOCKET sock=INVALID_SOCKET;

/* Port and host name */
DWORD portnr;
char hostname[128];

/* Reports network errors -- could use some work */
static void neterror(LPSTR s)
  {
  int err=WSAGetLastError();
  char title[65];
  sprintf(title,"Network Error %x!",err);
  MessageBox(NULL,s,title,MB_OK|MB_ICONSTOP);
  if (sock!=INVALID_SOCKET) closesocket(sock);
  sock=INVALID_SOCKET;
  WSACleanup();
  PostQuitMessage(-1);
  }


/* Sets the menu state so you can't connect twice */
static void setmenu(HWND w,UINT state)
  {
  HMENU menu=GetMenu(w);
  EnableMenuItem(menu,IDM_CLIENT,MF_BYCOMMAND|state);
  EnableMenuItem(menu,IDM_SERVER,MF_BYCOMMAND|state);
  if (state==MF_ENABLED)
    state=MF_GRAYED;
  else
    state=MF_ENABLED;
  EnableMenuItem(menu,IDM_QUIT,MF_BYCOMMAND|state);
  }

/* Shutdown network operations */
void netclose(HWND w)
  {
  SendMessage(w,WM_SETTEXT,0,(DWORD)"Checkers!");
  if (sock!=INVALID_SOCKET)
    if (closesocket(sock)) neterror("Close");
  sock=INVALID_SOCKET;
  setmenu(w,MF_ENABLED);
  WSACleanup();
  }


/* Send a transaction */
void Send(PLAYCMD c,LONG x1,LONG y1,LONG x0,LONG y0,STATE s)
  {
  PLAYREC play;
  if (sock==INVALID_SOCKET) return;
  play.cmd=c;
  play.x=x1;
  play.y=y1;
  play.x0=x0;
  play.y0=y0;
  play.state=s;
/***** Send PLAYREC over network */
  if (send(sock,(LPSTR)&play,sizeof(PLAYREC),0)==SOCKET_ERROR)
    neterror("Send");
  }

/* Handle a network transaction */
void transact(HWND w,LPARAM lParam)
  {
  PLAYREC play;
/* Check for partner quitting */
  if (WSAGETSELECTEVENT(lParam)==FD_CLOSE)
    {
        netclose(w);
        MessageBox(w,"Your partner quit",
          "Game Over",MB_OK|MB_ICONSTOP);
        return;
        }
/* Otherwise, data is ready, so read the PLAYREC */
  if (recv(sock,(LPSTR)&play,sizeof(PLAYREC),0)==SOCKET_ERROR)
    neterror("Recv");
/* Process command in PLAYREC */
  switch (play.cmd)
    {
        case MOVE:
          move(w,play.x0,play.y0,play.x,play.y,FALSE);
          break;

        case SET:
          setcell(w,play.x,play.y,play.state,FALSE);
          break;

        default:
          MessageBox(w,"Unknown network transaction",
            NULL,MB_OK|MB_ICONSTOP);
        }
  }

/* Start as server */
void server(HWND w)
  {
  SOCKADDR_IN saddr;
  SOCKET sock1;
  WSADATA data;
  new_board(w);      /* make sure game is clean */
  if (WSAStartup(0x101,&data)) /* Start WinSock */
    neterror("Init");
/* Get our host name to show user */
  if (gethostname(hostname,sizeof(hostname)))
    neterror("GetHost");
/* Prompt for port number */
  if (DialogBox(hInst,"SERVERDLG",w,ServerDlg)==IDCANCEL)
    return;
/* Change title */
  SendMessage(w,WM_SETTEXT,0,
    (DWORD)"Checkers! (Waiting for connection)");
/* Create socket */
  sock=socket(PF_INET,SOCK_STREAM,0);
  if (sock==INVALID_SOCKET)
    neterror("Socket");
/* Bind to assigned port number */
  saddr.sin_family=AF_INET;
  saddr.sin_addr.s_addr=INADDR_ANY;
/* Convert port # to canonical format */
  saddr.sin_port=htons(portnr);
  if (bind(sock,(PSOCKADDR)&saddr,sizeof(SOCKADDR_IN)))
    neterror("Bind");
/* Disallow more client/server requests */
  setmenu(w,MF_GRAYED);
/* Might block, so make sure window is OK */
  UpdateWindow(w);
/* Wait for connect */
  if (listen(sock,1))
    neterror("Listen");
  sock1=accept(sock,NULL,0);
  if (sock1==INVALID_SOCKET)
    neterror("Accept");
/* Close original socket (only 1 connect allowed) */
  if (closesocket(sock))
    neterror("close");
/* Use new socket */
  sock=sock1;
/* Change title again */
  SendMessage(w,WM_SETTEXT,0,
    (DWORD)"Checkers! (Server)");
/* Ask for WM_TRANSACT message when data available or
   socket closes */
  if (WSAAsyncSelect(sock,w,WM_TRANSACT,FD_READ|FD_CLOSE))
    neterror("Select");
/* Notify user */
  MessageBox(w,"Connection made.","Success",
    MB_OK|MB_ICONEXCLAMATION);
  }

/* Set up as client */
void client(HWND w)
  {
  PHOSTENT phe;
  SOCKADDR_IN saddr;
  WSADATA data;
  new_board(w);  // Start with clean game
/* Init WinSock */
  if (WSAStartup(0x101,&data))
    neterror("Init");
/* Get my host name (used as default) */
  if (gethostname(hostname,sizeof(hostname)))
    neterror("GetHost");
/* Prompt user for host/port */
  if (DialogBox(hInst,"CLIENTDLG",w,ClientDlg)==IDCANCEL)
    return;
/* Change title */
  SendMessage(w,WM_SETTEXT,0,
    (DWORD)"Checkers! (Connecting to server)");
/* Make new socket */
  sock=socket(PF_INET,SOCK_STREAM,0);
  if (sock==INVALID_SOCKET)
    neterror("Socket");
  saddr.sin_family=AF_INET;
/* Convert hostname to address */
  phe=gethostbyname(hostname);
  memcpy((char FAR *)&(saddr.sin_addr),phe->h_addr,phe->h_length);
/* Convert port # to canonical format */
  saddr.sin_port=htons(portnr);
/* Update menus */
  setmenu(w,MF_GRAYED);
/* Might block, so make sure window is OK */
  UpdateWindow(w);
/* Connect! */
  if (connect(sock,(PSOCKADDR)&saddr,sizeof(saddr)))
    neterror("Connect");
/* Change title again */
  SendMessage(w,WM_SETTEXT,0,(DWORD)"Checkers! (Client)");
/* Ask for WM_TRANSACT when data available or
   partner closes socket */
  if (WSAAsyncSelect(sock,w,WM_TRANSACT,FD_READ|FD_CLOSE))
    neterror("Select");
/* Notify user */
  MessageBox(w,"Connection made.","Success",MB_OK|MB_ICONEXCLAMATION);
  }
