// DROP2dlg.cpp : implementation file
//
 
#include "stdafx.h"
#include "DROP2.h"
#include "DROP2dlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define id_timer 0

/////////////////////////////////////////////////////////////////////////////
// CDROP2Dlg dialog

CDROP2Dlg::CDROP2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDROP2Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDROP2Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDROP2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDROP2Dlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDROP2Dlg, CDialog)
	//{{AFX_MSG_MAP(CDROP2Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_WM_DROPFILES()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDROP2Dlg message handlers

BOOL CDROP2Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	
	SetTimer(id_timer,1500,NULL);

	DragAcceptFiles(TRUE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDROP2Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDROP2Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDROP2Dlg::OnTimer(UINT nIDEvent) 
{
    KillTimer(id_timer);

	PostMessage(WM_SYSCOMMAND,SC_MINIMIZE,0);
	
	CDialog::OnTimer(nIDEvent);
}

void CDROP2Dlg::OnDropFiles(HDROP hDropInfo) 
{
    char file_buffer[MAX_PATH];
	UINT num_files, i;
            
    // See chapter 8 for the amazing story behind the following line....
    SetForegroundWindow();

    // Get the number of dropped files from Windows
	num_files = DragQueryFile(hDropInfo,0xffffffff,file_buffer,sizeof(file_buffer));

    // Now retrieve names and process each one file
	for(i = 0; i < num_files; i++)
	  {
	    DragQueryFile(hDropInfo,i,file_buffer,sizeof(file_buffer));
		ProcessDroppedFile(file_buffer);
	  } 

    // Tell Windows we're done with the DND operation
    DragFinish(hDropInfo); 

    // Move our drop target dlg out of the way
	PostMessage(WM_SYSCOMMAND,SC_MINIMIZE,0);
}

// Do something visible with a filename.  Note the advanced AI algorithm.
void CDROP2Dlg::ProcessDroppedFile(char * fn)
{
  MessageBox(fn,"Dropped file:",MB_OK);
}
