Option Explicit

' Speed Test Routines for Controls Sets package

' by Roy Terry. Version 1.0, 9 July 1995; 

' Compare cache vs simple search performance.

Declare Function GetTickCount Lib "User" () As Long

Sub csetSpdCache (f As Form, prop$)
      'loop for every control which has the prop
   Dim s%, v$
   s = csetfindfirst(f, prop, v)
   Do While s
      s = csetFindNext(f, prop, v)
   Loop
End Sub

Sub csetSpdRaw (f As Form, prop$)
      ' Read every control on form and scan tag for prop
      ' used for perf testing of csetcache code

   Dim i%, v$
   For i = 0 To f.Controls.Count - 1
      v = csetGetEPropValue(f.Controls(i).Tag, prop)
   Next i
End Sub

Function csetSpdRunTest$ (f As Form, p$, tsttype$, cnt%)
   Dim i%, tickStart&, ticks&
   
   Dim junk$:
   junk = f.Caption ' force form loaded before timing starts

   tickStart = GetTickCount()
   If tsttype = "raw" Then
      For i = 1 To cnt
         csetSpdRaw f, p
      Next i
   Else
      For i = 1 To cnt
         csetSpdCache f, p
      Next i
   End If
   ticks = GetTickCount() - tickStart
   csetSpdRunTest = Format$(ticks / 1000, "00.00")
End Function

