{--------------------------------------------------}
{                   SpiroMania                     }
{      SPINNER.PAS : Cycloid Curve Generator       }
{            By Jeff Duntemann KG7JF               }
{                                                  }
{ The cycloid curve generator shown here generates }
{ patterns similarly to the old SpiroGraph toy.    }
{ Written for *The Delphi Programming Explorer*    }
{ Copyright (c) 1995 The Coriolis Group, Inc.      }
{              Last Updated 3/9/95                 }
{--------------------------------------------------}

UNIT Spinner;

INTERFACE

USES SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
Forms, Dialogs, StdCtrls;

PROCEDURE SpinWheels(TargetCanvas : TCanvas;
                     A,B,D,
                     CenterX,CenterY : Integer;
                     DrawColor : TColor);

IMPLEMENTATION

VAR
  A,B,D,I : Integer;
  Quit    : Boolean;


FUNCTION HighestCommonFactor(A,B : Integer) : Integer;

VAR
  I,J,HCF : Integer;

BEGIN                 { Euclid's algorithm for finding the HCF }
  IF A < B THEN       { of two integers A and B. }
    BEGIN
      HCF := A;
      I   := B
    END
  ELSE
    BEGIN
      HCF := B;
      I   := A
    END;
  REPEAT
    J := I MOD HCF;
    IF J <> 0 THEN
      BEGIN
        I := HCF;
        HCF := J
      END
  UNTIL J = 0;
  HighestCommonFactor := HCF
END;


PROCEDURE SpinWheels(TargetCanvas : TCanvas;
                     A,B,D,
                     CenterX,CenterY : Integer;
                     DrawColor : TColor);

VAR
  Rab,Lines,I : Integer;
  Alpha,Beta,ADif,AoverB : Real;
  XPT,YPT : Real;                { Line endpoint coordinates }

BEGIN
  RAB := A-B; Alpha := 0.0;
  { The constants 100 and 200 here control the smoothness of }
  { the displayed or printed curve. The larger value must be }
  { twice the value that divides PI.  Larger values make for }
  { smoother curves but longer draw times since there are    }
  { more line segments in the drawn curve.                   }
  ADif := PI/100.0; AoverB := A/B;
  Lines := 200 * (B DIV HighestCommonFactor(A,B));
  TargetCanvas.Pen.Color := DrawColor;
  TargetCanvas.MoveTo((Round(RAB+D)+CenterX),CenterY);
  FOR I := 1 TO Lines DO
    BEGIN
      Alpha := Alpha + Adif;
      Beta := Alpha * AoverB;
      XPT := RAB * COS(Alpha) + D * COS(Beta);
      YPT := RAB * SIN(Alpha) - D * SIN(Beta);
      TargetCanvas.LineTo((Round(XPT)+CenterX),Round(YPT)+CenterY);
    END
END;

END. {Spinner}
