// partyvw.h : interface of the CPartyView class
//
/////////////////////////////////////////////////////////////////////////////

CString& WinsockErrorMsg(int ErrorCode, const char* StartWith);

class CPartyView : public CFormView
{
protected: // create from serialization only
    CPartyView();
    DECLARE_DYNCREATE(CPartyView)

public:
    //{{AFX_DATA(CPartyView)
    enum { IDD = IDD_PARTY_FORM };
    CString m_Message;
    CString m_TalkTo;
    UINT    m_ReceivePort;
    //}}AFX_DATA

// Attributes
public:
    CPartyDoc* GetDocument();

    // TC:
    // Obtain a pointer to the active view from anywhere.
    static CPartyView* GetView();
private:
    // TC:
    // TRUE if the send (client) socket has been allocated
    // and initialized.
    BOOL m_SendSocketAllocated;

    // TC:
    // TRUE if the receiving (server) socket has been allocated
    // and initialized.
    BOOL m_ReceiveSocketAllocated;

// Operations
public:
    // TC:
    // Try to open send and receive sockets.
    BOOL AllocateSockets();

    // TC:
    // Adds a line to the History list box.
    void AddText(const char* msg);
    
    // TC:
    // Public access function to determine if socket
    // was allocated successfully.
    BOOL GetReceiveSocketAllocated()
        { return m_ReceiveSocketAllocated; }
    
    // TC:
    // Public access function to determine if socket
    // was allocated successfully.
    BOOL GetSendSocketAllocated()
        { return m_SendSocketAllocated; }


    // TC:
    // Public access function to flag whether sockets
    // were allocated successfully.
    void SetReceiveSocketAllocated(BOOL bReceiveSocketAllocated)
        { m_ReceiveSocketAllocated = bReceiveSocketAllocated; }
        
    // TC:
    // Public access function to flag whether sockets
    // were allocated successfully.
    void SetSendSocketAllocated(BOOL bSendSocketAllocated)
        { m_SendSocketAllocated = bSendSocketAllocated; }
        

    // TC:
    // TRUE if both send and receive sockets were allocated
    // and initialized.
    BOOL SocketsAllocated() { return m_SendSocketAllocated && m_ReceiveSocketAllocated; }

// Implementation
public:
    virtual ~CPartyView();

    // TC:
    virtual void OnInitialUpdate();

#ifdef _DEBUG
    virtual void AssertValid() const;
    virtual void Dump(CDumpContext& dc) const;
#endif

protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Generated message map functions
protected:
    //{{AFX_MSG(CPartyView)
    afx_msg void OnBtnSend();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in partyvw.cpp
inline CPartyDoc* CPartyView::GetDocument()
   { return (CPartyDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
