//---------------------------------------------------------------------------
//
//	File:			WINGWND.CPP
//	Programmer: 	Bob Provencher
//	Create Date:	11/6/94
//	Last Mod Date:	3/5/95
//	Description:	Main WinG Window module
//
//	Copyright (c) 1994, 1995. Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "wingwnd.h"
#include "wingdc.h"
#include "wingbmp.h"
#include "palette.h"
#include "logidpal.h"
#include "dibitmap.h"

#include "debug.h"

#include "about.h"
#include "fader.h"
#include "fader.rh"

LPCSTR			lpszWinGWndClass	= "WinGWndClass";

WinGDC			dcWinG;
WinGBitmap		bmpWinG;

LogPalette 		logPalGame;
Palette			palGame;
HPALETTE		hPalOld		= 0;

RGBQUAD			rgbqBlack	= {   0,   0,   0, 0 };
RGBQUAD			rgbqWhite	= { 255, 255, 255, 0 };
RGBQUAD			rgbqRed		= {   0,   0, 255, 0 };
RGBQUAD			rgbqGreen	= {   0, 255,   0, 0 };
RGBQUAD			rgbqBlue	= { 255,   0,   0, 0 };

LogPalette		logPalClear;        // used for clearing the system palette
Palette    		palClear;           //

BitmapInfo		recInfo;

DIBitmap        dibAesir( IDB_AESIR );

HWND			hWndWinG;

int				wnd_width  = 0,
				wnd_height = 0;

BOOL			fDump = FALSE;
BOOL			fEven = FALSE;

LRESULT CALLBACK _export WinGWndProc( HWND hWnd, UINT msg,
									  WPARAM wParam, LPARAM lParam )
{

#ifdef _DEBUG
	static dbugstream debug;
#endif

	switch ( msg )
	{

		case WM_CREATE:
        {

			HDC hDCScreen;
			LogIdPalette logPalBlack( rgbqBlack );

			hDCScreen = GetDC( NULL );

			//
			//	C++ version of ClearSystemPalette()
			//

			logPalClear.ResizeTo( 256 );
			logPalClear.SetEntryFlags( 0, 256, PC_NOCOLLAPSE );
			palClear.Create( logPalClear );

			hPalOld = SelectPalette( hDCScreen, palClear, FALSE );
			RealizePalette( hDCScreen );
			SelectPalette( hDCScreen, hPalOld, FALSE );
			palClear.Delete();

			ReleaseDC( NULL, hDCScreen );

			logPalGame.CopyColors( dibAesir );

#ifdef _DEBUG
			debug << logPalBlack << "\n";
#endif

			palGame.Create( logPalBlack );

			recInfo.ResizeTo( 256 );
			recInfo.WinGRecommendFormat();
			recInfo.CopyColors( logPalBlack );

			recInfo.SetWidth( dibAesir.Width() );
			recInfo.SetHeight( recInfo.Orientation() * dibAesir.Height() );

			bmpWinG.Delete();
			bmpWinG.Create( dcWinG, recInfo );

			dcWinG.Select( bmpWinG );

			bmpWinG.Copy( dibAesir );

			return 0;

		}

		case WM_ACTIVATEAPP:

			return OnActivate( hWnd, wParam, lParam );

		case WM_QUERYNEWPALETTE:

        	HDC hDC;

			hDC = GetDC( hWnd );

			if ( palGame.IsCreated() )
				SelectPalette( hDC, palGame, FALSE );

			RealizePalette( hDC );

			ReleaseDC( hWnd, hDC );

			InvalidateRect( hWnd, NULL, TRUE );

			return TRUE;

		case WM_SIZE:

			wnd_width  = LOWORD( lParam );
			wnd_height = HIWORD( lParam );

			return 0;

		case WM_PAINT:

			PAINTSTRUCT ps;

			hDC = BeginPaint( hWnd, &ps );

			if ( palGame.IsCreated() )
				SelectPalette( hDC, palGame, FALSE );

			RealizePalette( hDC );

			dcWinG.BitBlt( hDC,
						   ( wnd_width  - (int)bmpWinG.Width()  ) / 2,
						   ( wnd_height - (int)bmpWinG.Height() ) / 2,
						   (int)bmpWinG.Width(),
						   (int)bmpWinG.Height(),
						   0, 0 );

			EndPaint( hWnd, &ps );

			return 0;

		case WM_DESTROY:

			return 0;

	}

	return DefWindowProc( hWnd, msg, wParam, lParam );

}

LRESULT OnActivate( HWND hWnd, WPARAM, LPARAM )
{

	HDC hDC;

	hDC = GetDC( hWnd );

	if ( palGame.IsCreated() )
	{
		UnrealizeObject( palGame );
        SelectPalette( hDC, hPalOld, FALSE );
		LogIdPalette logIdPal( palGame.LogPal() );
		palGame.Delete();
		palGame.Create( logIdPal );
		hPalOld = SelectPalette( hDC, palGame, FALSE );
		RealizePalette( hDC );
        InvalidateRect( hWnd, NULL, FALSE );
		UpdateWindow( hWnd );
	}

	ReleaseDC( hWnd, hDC );

	return 0;

}

LRESULT OnInitMenu( HWND, WPARAM wParam, LPARAM )
{
	BOOL fUseStatic = LogSystemPalette::GetUse() == SYSPAL_NOSTATIC;
	CheckMenuItem( (HMENU)wParam, IDM_OPTION_USE_STATIC, MF_BYCOMMAND |
				   ( fUseStatic ? MF_CHECKED : MF_UNCHECKED ) );
	CheckMenuItem( (HMENU)wParam, IDM_OPTION_DUMP, MF_BYCOMMAND |
				   ( fDump ? MF_CHECKED : MF_UNCHECKED ) );
	CheckMenuItem( (HMENU)wParam, IDM_OPTION_EVEN_FADE, MF_BYCOMMAND |
				   ( fEven ? MF_CHECKED : MF_UNCHECKED ) );
	return 0L;
}

LRESULT OnCommand( HWND hWnd, WPARAM wParam, LPARAM lParam )
{

	switch ( wParam )
	{

		case IDM_ABOUT:

			DLGPROC dlgProc;

			dlgProc =
				(DLGPROC)MakeProcInstance( (FARPROC)About, hInst );
			DialogBox( hInst, MAKEINTRESOURCE( IDD_ABOUT ), hWnd, dlgProc );
			FreeProcInstance( (FARPROC)dlgProc );
			return 0;

		case IDM_FADE_IN:

        	FadeTo( logPalGame );

			return 0;

		case IDM_FADE_TO_BLACK:

			FadeTo( rgbqBlack );

			return 0;

		case IDM_FADE_TO_WHITE:

			FadeTo( rgbqWhite );

			return 0;

		case IDM_FADE_TO_RED:

			FadeTo( rgbqRed );

			return 0;

		case IDM_FADE_TO_GREEN:

			FadeTo( rgbqGreen );

			return 0;

		case IDM_FADE_TO_BLUE:

			FadeTo( rgbqBlue );

			return 0;

		case IDM_FADE_TO_NEG:

			FadeTo( ~palGame.LogPal() );

			return 0;

		case IDM_FADE_TO_COLOR:

			FadeToColor();

			return 0;

		case IDM_OPTION_USE_STATIC:
		{

			BOOL fUseStatic = LogSystemPalette::GetUse() != SYSPAL_NOSTATIC;
			LogSystemPalette::SetUse( fUseStatic ? 
									  SYSPAL_NOSTATIC : SYSPAL_STATIC );
			OnActivate( hWnd, 0, 0L );

			return 0;

		}

		case IDM_OPTION_DUMP:

			fDump = !fDump;

			return 0;

		case IDM_OPTION_EVEN_FADE:

			fEven = !fEven;

            return 0;

		default:

			break;

	}

	return DefWindowProc( hWnd, WM_COMMAND, wParam, lParam );

}

void FadeToColor( void )
{

	CHOOSECOLOR	cc;
	COLORREF 	clr;
	COLORREF 	aclrCust[ 16 ];
	RGBQUAD     rgbqColor;
	int i;

	for ( i = 0; i < 16; i++ )
		aclrCust[ i ] = RGB( 255, 255, 255 );

	clr = RGB( 0, 0, 0 );

	memset( &cc, 0, sizeof( CHOOSECOLOR ) );

	cc.lStructSize = sizeof( CHOOSECOLOR );

	cc.hwndOwner 	= hWndWinG;
	cc.rgbResult 	= clr;
	cc.lpCustColors = aclrCust;
	cc.Flags		= CC_FULLOPEN;

	if ( ChooseColor( &cc ) )
	{
		clr = cc.rgbResult;
		rgbqColor.rgbRed	= GetRValue( clr );
		rgbqColor.rgbGreen	= GetGValue( clr );
		rgbqColor.rgbBlue	= GetBValue( clr );
		rgbqColor.rgbReserved = 0;
		LogIdPalette	idPal( rgbqColor );
		FadeTo( idPal );
	}

}

void FadeTo( const RGBQUAD& color )
{
	LogPalette Pal( color );
	FadeTo( Pal );
}

void FadeTo( const LogPalette& pal )
{
	HCURSOR hCur = SetCursor( LoadCursor( NULL, IDC_WAIT ) );
	dbugstream debug;
	if ( fDump )
	{
		debug << "Target Palette.\r\n";
		debug << pal;
	}
	if ( fEven )
		palGame.EvenFadeTo( pal );
	else
		palGame.EasyFadeTo( pal );
	if ( fDump )
	{
		debug << "Result Palette.\r\n";
		debug << palGame;
	}
	recInfo.CopyColors( palGame.LogPal() );
	dcWinG.SetDIBColorTable( recInfo );
	SetCursor( hCur );
}

