//---------------------------------------------------------------------------
//
//	File:			WINGBMP.CPP
//	Programmer: 	Bob Provencher
//	Create Date:	11/9/94
//	Last Mod Date:	3/5/95
//	Description:	WinGBitmap class
//
//	Copyright (c) 1994, 1995. Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#ifndef __WINGBMP_H__
#include "wingbmp.h"
#endif

#ifndef __LOGSPAL_H__
#include "logspal.h"
#endif

//
//	Use TASM for inline assembler
//
#pragma inline

BOOL WinGBitmap::SelectInto( WinGDC& dcWinG )
{
	return dcWinG.Select( *this );
}

BOOL WinGBitmap::Deselect()
{
	return IsSelected() ? pDC->DeselectBmp() : FALSE;
}

BOOL WinGBitmap::Create( const WinGDC& dcWinG, const BITMAPINFO& Header )
{
	BOOL fReturn = FALSE;
	if ( !IsCreated() )
	{
		hBmp = WinGCreateBitmap( dcWinG.hDC, &Header, &(LPVOID)lpBits );
		if ( IsCreated() )
			bmp.Copy( Header );
		fReturn = IsCreated() && bmp.IsCreated();
	}
	return fReturn;
}

BOOL WinGBitmap::Copy( const WinGBitmap& src )
{
	BOOL fReturn = FALSE;
	if ( IsCreated() && src.IsCreated() )
	{
		for ( DWORD y = 0; y < min( Height(), src.Height() ); y++ )
			_hmemcpy( Line( y ), src.Line( y ), min( Width(), src.Width() ) );
		fReturn = TRUE;
	}
	return fReturn;
}

BOOL WinGBitmap::Copy( const DIBitmap& src )
{
	BOOL fReturn = FALSE;
	if ( IsCreated() && src.IsCreated() )
	{
		for ( DWORD y = 0; y < min( Height(), src.Height() ); y++ )
			_hmemcpy( Line( y ), src.Line( y ), min( Width(), src.Width() ) );
		fReturn = TRUE;
	}
	return fReturn;
}

void WinGBitmap::Dump( dbugstream& debug ) const
{
	debug << "Start WinGBitmap"  		 << crlf
		  << " this: "   << (void*)this  << crlf
		  << " hBmp: "   << hBmp 		 << crlf
		  << " pDC: "    << pDC  		 << crlf
		  << bmp;
	Dump( debug, lpBits );
	debug << "End WinGBitmap"    << crlf;
}

void WinGBitmap::Dump( dbugstream& debug, LPBYTE lpBits ) const
{
	debug << " lpBits: " << (LPVOID)lpBits << crlf
		  << " Bits:   ";
	debug << (LPVOID)lpBits      << crlf;
}




