#ifndef __PALETTE_H__
#define __PALETTE_H__

//---------------------------------------------------------------------------
//
//	File:			PALETTE.H
//	Programmer: 	Bob Provencher
//	Create Date:	11/9/94
//	Last Mod Date:	3/5/95
//	Description:	Palette class definition
//
//	Copyright (c) 1994, 1995. Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#ifndef __PRECOMP_H__
#include "precomp.h"
#endif

#ifndef __CLASSDEF_H__
#include "classdef.h"
#endif

#ifndef __LOGSPAL_H__
#include "logspal.h"
#endif

#include "logidpal.h"

class Palette
{

private:

	LogPalette	logPal;
	HPALETTE	hPal;

public:

	Palette() :
		hPal( 0 )
	{
	}

	Palette( const Palette& pal ) :
		hPal( 0 )
	{
		Copy( pal );
	}

	Palette( const LogPalette& pal ) :
		hPal( 0 )
	{
		Create( pal );
	}

	~Palette()
	{
		if ( IsCreated() )
			Delete();
	}

	const LogPalette& LogPal() const
	{
		return logPal;
	}

	Palette& operator = ( const Palette& pal )
	{
		Copy( pal );
		return *this;
	}

	BOOL Copy( const Palette& pal )
	{
		return Create( pal.logPal );
	}

	BOOL IsCreated() const
	{
		return hPal != 0;
	}

	BOOL Create( const LogPalette& pal )
	{
		BOOL fReturn = FALSE;
		if ( !IsCreated() )
		{
			logPal.Copy( pal );
			fReturn = Create();
		}
		return fReturn;
	}

	BOOL Create()
	{
		BOOL fReturn = FALSE;
		if ( !IsCreated() && logPal.IsCreated() )
		{
			hPal = CreatePalette( logPal.Palette() );
			fReturn = IsCreated();
		}
		return fReturn;
	}

	BOOL Delete()
	{
		BOOL fReturn = FALSE;
		if ( IsCreated() && DeletePalette( hPal ) )
		{
			hPal = 0;
			fReturn = TRUE;
		}
		return fReturn;
	}

	HPALETTE Handle() const
	{
		return hPal;
	}

	operator HPALETTE() const
	{
		return Handle();
	}

	BOOL Animate( UINT start, UINT num, const LogPalette& pal )
	{
		BOOL fReturn = FALSE;
		if ( IsCreated() && start + num <= pal.Size() )
		{
			::AnimatePalette( Handle(), start, num, pal.Entries() + start );
			fReturn = TRUE;
		}
		return fReturn;
	}

	BOOL EasyStepTo( const LogPalette& pal, UINT stat = 20 )
	{
		BOOL fReturn = logPal.EasyStepTo( pal );
		fReturn = Animate( stat / 2, pal.Size() - stat, logPal ) && fReturn;
		return fReturn;
	}

	BOOL EasyFadeTo( const LogPalette& pal );
	BOOL EvenFadeTo( const LogPalette& pal );

	void Dump( dbugstream& debug ) const
	{
		logPal.Dump( debug );
	}

};

inline dbugstream& operator << ( dbugstream& debug, const Palette& pal )
{
	pal.Dump( debug );
	return debug;
}

#endif
