//---------------------------------------------------------------------------
//
//	File:			FADER.CPP
//	Programmer: 	Bob Provencher
//	Create Date:	1/15/95
//	Last Mod Date:	3/5/95
//	Description:	Main Fader module
//
//	Copyright (c) 1995. Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "fader.h"
#include "wingwnd.h"
#include "about.h"
#include "gen.h"
#include "logspal.h"

#include "fader.rh"

HINSTANCE	hInst;
LPCSTR		lpszMainWndClass	= "MainWndClass";
LPCSTR		lpszWinGFader		= "FADER";
HWND		hWndMain			= 0;

BOOL		fActive;

void Message( char* msg, UINT style = MB_OK | MB_ICONINFORMATION )
{
	MessageBox( NULL, msg, lpszWinGFader, style );
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
					LPSTR, int nCmdShow )
{

	hInst = hInstance;

	MSG msg;

	if ( !LogSystemPalette::IsPaletteDevice() )
	{
		Message( "FADER requires a palette display device" );
		return 0;
	}

	if ( !hPrevInstance )
		if ( !InitApplication( hInst ) )
			return 0;

	if ( !InitInstance( hInst, nCmdShow ) )
		return 0;

	do		
	{
		if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
		{
			if ( msg.message != WM_QUIT )
			{
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
		}
		else
		{
			if ( AppIdle() )
				WaitMessage();
		}
	}
	while ( msg.message != WM_QUIT );

	if ( LogSystemPalette::GetUse() == SYSPAL_NOSTATIC )
    	LogSystemPalette::SetUse( SYSPAL_STATIC );

	return msg.wParam;

}

BOOL AppIdle()
{
	if ( fActive )
	{
	}
	return TRUE;	
}

BOOL InitApplication( HINSTANCE hInstance )
{

	WNDCLASS  wc;

	wc.style			= CS_BYTEALIGNCLIENT;
	wc.lpfnWndProc		= MainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon			= LoadIcon( hInstance, MAKEINTRESOURCE( IDI_FADER ) );
	wc.hCursor			= LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground	= NULL;
	wc.lpszMenuName		= MAKEINTRESOURCE( IDM_DEMO );
	wc.lpszClassName	= lpszMainWndClass;

	if ( !RegisterClass( &wc ) )
		return FALSE;

	wc.style			= CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNCLIENT;
	wc.lpfnWndProc		= WinGWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon			= LoadIcon( NULL, IDI_APPLICATION );
	wc.hCursor			= LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground	= (HBRUSH)GetStockObject( BLACK_BRUSH );
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= lpszWinGWndClass;

	return RegisterClass( &wc );

}

BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{

	hInst = hInstance;

	UINT x, y, w, h, border_x, border_y, caption, menu;

	x = y = 0;

	w = GetSystemMetrics( SM_CXSCREEN );
	h = GetSystemMetrics( SM_CYSCREEN );
	border_x = GetSystemMetrics( SM_CXFRAME );
	border_y = GetSystemMetrics( SM_CYFRAME );
	caption = GetSystemMetrics( SM_CYCAPTION );
	menu = GetSystemMetrics( SM_CYMENU );

	if ( w > 640 && h > 480 )
	{
		int w1, h1;
		w1 = 640 + ( 2 * border_x );
		h1 = 480 + ( 2 * border_y ) + caption + menu;
		x = ( w - w1 ) / 2;
		y = ( h - h1 ) / 2;
		w = w1;
        h = h1;
	}
	else
	{
		w = 640;
        h = 480;
	}

	hWndMain = CreateWindow( lpszMainWndClass, lpszWinGFader,
							 WS_OVERLAPPEDWINDOW,
							 x, y,
							 w, h,
							 NULL, NULL, hInstance, NULL );

	if ( !hWndMain )
		return FALSE;

	ShowWindow( hWndMain, nCmdShow );
	UpdateWindow( hWndMain );

	return TRUE;

}

LPARAM CALLBACK _export MainWndProc( HWND hWnd, UINT message, WPARAM wParam,
									 LPARAM lParam )
{

	switch ( message )
	{

		case WM_CREATE:

			hWndWinG = CreateWindow( lpszWinGWndClass, "",
									 WS_VISIBLE | WS_CHILD,
									 0, 0, 0, 0,
									 hWnd, NULL, hInst, NULL );

			PostMessage( hWnd, WM_COMMAND, IDM_FADE_IN, 0L );

			return 0;

		case WM_ACTIVATEAPP:

			fActive = wParam;

			return 0;

		case WM_SIZE:

			int w, h;

			w = LOWORD( lParam );
			h = HIWORD( lParam );

			SetWindowPos( hWndWinG, NULL,
						  0, 0, w, h,
						  SWP_NOMOVE | SWP_NOZORDER );

			return 0;

		case WM_INITMENU:

        	return OnInitMenu( hWnd, wParam, lParam );

		case WM_COMMAND:

			return OnCommand( hWnd, wParam, lParam );

		case WM_SETFOCUS:

			SetFocus( hWndWinG );

            return 0;

		case WM_DESTROY:

			PostQuitMessage( 0 );

			return 0;

	}

	return DefWindowProc( hWnd, message, wParam, lParam );

}
