unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,
  WinSock, SockCtv, InitFngr, Help;

type
  TForm1 = class(TForm)
    Edit2: TEdit;
    Information: TLabel;
    Status: TLabel;
    Users: TLabel;
    Hosts: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button11: TButton;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button9: TButton;
    Button10: TButton;
    Button12: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
   RemoteHost,
   User : String;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const

 HostFileName : String[14] = 'FHOSTS.TXT';  { File of host names}
 UserFileName : String[14] = 'FUSERS.TXT';  { File of user names}
 FDFileName   : String[14] = 'SCRAP.TXT';   { File of most recent fingered
                                              user info}


  procedure GetWSADataInfo;
  var
   S1, S2 : String;
  begin
   with Form1 do
   begin
    with WSAData^ do
    begin
     Memo1.Clear;
     Memo1.Lines.Add(StrPas(szDescription));
     Str(Hi(wHighVersion),S1);
     Str(Lo(wHighVersion),S2);
     Memo1.Lines.Add(ConCat('Version ',S1,'.',S2));
     Str(iMaxSockets,S1);
     Memo1.Lines.Add(ConCat('Maximum number of sockets = ',S1));
     Str(iMaxUdpDg,S1);
     Memo1.Lines.Add(ConCat('Maximum number of UDP = ',S1));
    end;
   end;
  end;

  {procedure ResetClient to handle WinSock error messages &
   fix up Client
  }

  procedure ResetClient;
  begin
   With Form1.Edit2 do
   begin
    Color := clRed;
    with Client^ do
    begin
     Text := StrPas(ErrMsg);
     Form1.Button3.Enabled := True;
     CloseWinSock;
     Done;
    end;
    if Client <> NIL then
    begin
     Dispose(Client);
     Client := NIL;
    end;
   end;
  end;

  {Save list of user names to file }
  procedure TForm1.Button1Click(Sender: TObject);
  begin
   ComboBox1.Items.SaveToFile(UserFileName);
  end;

 {Finger client}

 procedure TForm1.Button3Click(Sender: TObject);
 var
   RecvData   : array[0..MaxBufferSize] of char;
   OldCaption : String;
   MemoLine,
   TempStr : String;
   Count, LineLength,
   DataLength : Integer;
  begin
   InitFingerClient; { initializes WINSOCK.DLL and Client }
   Button3.Enabled := False;
   Edit2.Color := clGreen;
   with Client^ do
   begin
    (* This is normally commented out*)
    GetWSADataInfo;      { get winsock information }
    Edit2.Text := 'Winsock is responding';
    if Length(RemoteHost) = 0 then
    begin
     MessageDlg('No host name given!',mtError,[mbOk],0);
     Edit2.Text := '';
     Button3.Enabled := True;
     ResetClient;
     Exit;
    end;
    Edit2.Text := 'Resolving...';
    StrPCopy(HostName, RemoteHost);
    StrPCopy(Data,User);
    StrCat(Data, CRLF);
    GetHost;
    if Status = Failure then
    begin
     ResetClient;
     Exit;
    end
    else Edit2.Text := 'Host located...';
    if Status = Success then
     GetService('finger','tcp');
    if Status = Failure then
    begin
     ResetClient;
     Exit;
    end
    else Edit2.Text := 'Service available...';
    CreateSock;
    if Status = Failure then
    begin
     ResetClient;
     Exit;
    end
    else Edit2.Text := 'Trying to connect...';
    SetUpAddr;                 { set up address of target host}
    ConnectToHost;             {now attempt to connect}
    if Status = Failure then   {connection failed!}
    begin
     ResetClient;
     Exit;
    end
    else
    Edit2.Text := ShowIPAddress;
    SendData;
    if Status = Failure then
    begin
     ResetClient;
     Exit;
    end;
    OldCaption := Form1.Caption;
    if User <> '' then
     Form1.Caption := 'Information on ' + User + ' at ' + RemoteHost
    else
     Form1.Caption := 'Information on users at ' + RemoteHost;
    Memo1.Clear;  {Clears text window of text, if any}
    TempStr := '';{New}
    while GetData(@RecvData) do
    begin
     {New code }
     MemoLine := '';
     DataLength := StrLen(RecvData);
     MemoLine := StrPas(RecvData);
     LineLength := Length(MemoLine);
     Count := 1;
     while Count < LineLength do
     begin
      if (MemoLine[Count] = #13) and (MemoLine[Count+1] = #10) then
      begin
       Memo1.Lines.Add(TempStr);
       TempStr := '';
       Inc(Count,2);
      end
      else
      begin
       TempStr := TempStr + MemoLine[Count];
       Inc(Count);
      end;
      {Must catch the last char}
      if Count = LineLength then
       TempStr := TempStr + MemoLine[Count];
     end;
    end;
    Edit2.Text := 'Connection closed';
    if Status = Failure then
    begin
     ResetClient;
     Exit;
    end;
    Form1.Caption := OldCaption;
    Button3.Enabled := True;
    Client^.CloseWinSock;
    Data := '';
    if Client <> NIL then
    begin
     Dispose(Client);
     Client := NIL;
    end;
    Exit;
   end { with Client}
end;

{Save list of host names to file}

procedure TForm1.Button2Click(Sender: TObject);
begin
  ComboBox2.Items.SaveToFile(HostFileName);
end;

{Add user name to list}

procedure TForm1.Button6Click(Sender: TObject);
begin
  ComboBox1.Items.Add(User);
end;

{Add new host name to list }

procedure TForm1.Button8Click(Sender: TObject);
begin
 ComboBox2.Items.Add(RemoteHost);
end;

{ Copy selected user name to User for the finger client}

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
 User := ComboBox1.Text;
end;

{ Copy selected host name to RemoteHost for the finger client}

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
  RemoteHost := ComboBox2.Text;
end;

{ Load user file }

procedure TForm1.Button9Click(Sender: TObject);
begin
 try
  ComboBox1.Items.LoadFromFile(UserFileName);
 except
  on EFOpenError do
   MessageDlg('No user file found',mtError,[mbOk],0);
 end;
 ComboBox1.Text := ComboBox1.Items.Strings[0];
 User := ComboBox1.Text;
end;

{Load Host file}

procedure TForm1.Button10Click(Sender: TObject);
begin
 try
  ComboBox2.Items.LoadFromFile(HostFileName);
 except
  on EFOpenError do
   MessageDlg('No host file found',mtError,[mbOk],0);
 end;
  ComboBox2.Text := ComboBox2.Items.Strings[0];
  RemoteHost := ComboBox2.Text;
end;

{Save user information to file}

procedure TForm1.Button12Click(Sender: TObject);
begin
 Memo1.Lines.SaveToFile(FDFileName);
end;                              

{Delete user name from combobox list}

procedure TForm1.Button7Click(Sender: TObject);
begin
  ComboBox1.Items.Delete(ComboBox1.ItemIndex);
  User := '';
end;

{Delete host name from combobox list}

procedure TForm1.Button11Click(Sender: TObject);
begin
  ComboBox2.Items.Delete(ComboBox2.ItemIndex);
  RemoteHost := '';
end;

{Close down application}

procedure TForm1.Button4Click(Sender: TObject);
begin
 Close;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 AboutBox.Show;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Memo1.Clear;
end;

end.
