// Illustration of impact on performance of the
// internal cache. This code touches 12K of data,
// enough to overflow the internal cache. Uses
// the Windows Zen timer.

    typedef struct _Node {
        struct _Node *Next;
        int Key;
        int i,j;
        int ChecksumField;
        int k,l,m;
    } Node;

    Node *pNode, *pWorkingNode;
    int i, Checksum;

    // Allocate a node buffer at a paragraph boundary
    pNode = (Node *)
        (((int)malloc(384*sizeof(Node)+16) + 15) & ~0x0F);

    // Initialize the node list
    for (i=0; i<383; i++)
    {
        pNode[i].Next = &pNode[i+1];
    }
    pNode[i].Next = NULL;

    WZTimerOn(TRUE);    // start timing

    // Run through the list, checksumming, 10,000 times
    // so the timing interval is long enough for us to
    // get precise numbers
    for (i=0; i<10000; i++)
    {
        pWorkingNode = pNode;
        Checksum = 0;

        do
        {
            Checksum += pWorkingNode->ChecksumField;
            pWorkingNode = pWorkingNode->Next;
        } while (pWorkingNode);
    }

    WZTimerOff();
    WZTimerReport(hwnd);