// Windows Zen timer.
// Call WZTimerOn() to start timing, WZTimerOff() to stop
// timing, and WZTimerReport() to display the results in
// a message box. Set the parameter to WZTimerOn() to TRUE
// in order to boost priority so that the process being
// timed gets as much CPU time as possible; note that this
// causes everything else in the system, including the
// mouse, to stop. WZTimerOff() lowers the priority again
// if WZTimerOn() boosted it. Requires that winmm.lib be
// linked in.
// Tested with VC++ 2.0 running on Windows NT 3.5.

#include <windows.h>
#include <stdio.h>
#include <mmsystem.h>

static long StartTime;
static long StopTime;
static int  PriorityBoost;
DWORD PriorityClass;
int ThreadPriority;

// Called to start a timing interval.
void WZTimerOn(int BoostPriority)
{
    // Boost the priority to realtime if requested
    if (BoostPriority)
    {
        PriorityClass = GetPriorityClass(GetCurrentProcess());
        ThreadPriority = GetThreadPriority(GetCurrentThread());
        SetPriorityClass(GetCurrentProcess(),
                         REALTIME_PRIORITY_CLASS);
        SetThreadPriority(GetCurrentThread(),
                          THREAD_PRIORITY_TIME_CRITICAL);
        PriorityBoost = 1;
    }
    else
    {
        PriorityBoost = 0;
    }

    StartTime = timeGetTime();
}

// Called to end a timing interval.
void WZTimerOff()
{
    StopTime = timeGetTime();

    // Restore original priority if we boosted it
    if (PriorityBoost)
    {
        SetPriorityClass(GetCurrentProcess(),PriorityClass);
        SetThreadPriority(GetCurrentThread(),ThreadPriority);
    }
}

// Pops up a message box with the timing results
void WZTimerReport(HWND hwnd)
{
    char ReportString[80];

    sprintf(ReportString,
            "Timed interval = %ld milliseconds",
            StopTime - StartTime);
    MessageBox(hwnd, ReportString, "Timing Results", MB_OK);
}
